/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.awt.Color;
import java.io.IOException;

public class FrameBox
extends ControlSequence {
    protected TeXDimension currentWidth = null;
    protected TeXDimension currentHeight = null;
    protected TeXDimension currentBorderWidth = null;
    protected TeXDimension currentInnerMargin = null;
    protected Color currentBorderColor = null;
    protected Color currentFgColor = null;
    protected Color currentBgColor = null;
    protected byte style = 1;
    protected byte halign = 0;
    protected byte valign = 0;
    protected boolean isInline = true;
    protected boolean isMultiLine = true;
    public static final byte BORDER_NONE = 0;
    public static final byte BORDER_SOLID = 1;
    public static final byte BORDER_DOUBLE = 2;
    public static final byte ALIGN_DEFAULT = 0;
    public static final byte ALIGN_LEFT = 1;
    public static final byte ALIGN_CENTER = 2;
    public static final byte ALIGN_RIGHT = 3;
    public static final byte ALIGN_TOP = 1;
    public static final byte ALIGN_MIDDLE = 2;
    public static final byte ALIGN_BOTTOM = 3;
    public static final byte ALIGN_BASE = 4;

    public FrameBox() {
        this("fbox", 1, 0, 0, true);
    }

    public FrameBox(String string) {
        this(string, 1, 0, 0, true);
    }

    public FrameBox(String string, byte by, byte by2, byte by3, boolean bl) {
        this(string, by, by2, by3, bl, null, null);
    }

    public FrameBox(String string, byte by, byte by2, byte by3, boolean bl, TeXDimension teXDimension, TeXDimension teXDimension2) {
        this(string, by, by2, by3, bl, false, teXDimension, teXDimension2);
    }

    public FrameBox(String string, byte by, byte by2, byte by3, boolean bl, boolean bl2, TeXDimension teXDimension, TeXDimension teXDimension2) {
        super(string);
        this.setStyle(by);
        this.setHAlign(by2);
        this.setVAlign(by3);
        this.setIsInLine(bl);
        this.setIsMultiLine(bl2);
        this.currentBorderWidth = teXDimension;
        this.currentInnerMargin = teXDimension2;
    }

    @Override
    public Object clone() {
        return new FrameBox(this.getName(), this.style, this.halign, this.valign, this.isInline, this.isMultiLine, this.currentBorderWidth == null ? null : (TeXDimension)this.currentBorderWidth.clone(), this.currentInnerMargin == null ? null : (TeXDimension)this.currentInnerMargin.clone());
    }

    public boolean isInLine() {
        return this.isInline;
    }

    public void setIsInLine(boolean bl) {
        this.isInline = bl;
    }

    public boolean isMultiLine() {
        return this.isMultiLine;
    }

    public void setIsMultiLine(boolean bl) {
        this.isMultiLine = bl;
    }

    public byte getStyle() {
        return this.style;
    }

    public void setStyle(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this.style = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid style " + by);
            }
        }
    }

    public byte getHAlign() {
        return this.halign;
    }

    public void setHAlign(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.halign = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid horizontal alignment " + by);
            }
        }
    }

    public byte getVAlign() {
        return this.valign;
    }

    public void setVAlign(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.valign = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid vertical alignment " + by);
            }
        }
    }

    public Color getBorderColor(TeXParser teXParser) throws IOException {
        return this.currentBorderColor;
    }

    public Color getForegroundColor(TeXParser teXParser) throws IOException {
        return this.currentFgColor;
    }

    public Color getBackgroundColor(TeXParser teXParser) throws IOException {
        return this.currentBgColor;
    }

    public TeXDimension getBorderWidth(TeXParser teXParser) throws IOException {
        return this.currentBorderWidth == null ? teXParser.getDimenRegister("fboxrule") : this.currentBorderWidth;
    }

    public TeXDimension getInnerMargin(TeXParser teXParser) throws IOException {
        return this.currentInnerMargin == null ? teXParser.getDimenRegister("fboxsep") : this.currentInnerMargin;
    }

    public TeXDimension getWidth(TeXParser teXParser) throws IOException {
        return this.currentWidth;
    }

    public TeXDimension getHeight(TeXParser teXParser) throws IOException {
        return this.currentHeight;
    }

    protected void popSettings(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = null;
        teXObject = teXParser == teXObjectList ? teXParser.popNextArg(91, 93) : teXObjectList.popArg(teXParser, 91, 93);
        if (teXObject != null) {
            Object object;
            if (teXObject instanceof Expandable && (object = teXParser == teXObjectList ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
                teXObject = object;
            }
            if (teXObject instanceof TeXObjectList) {
                teXObject = ((TeXObjectList)teXObject).popDimension(teXParser);
            }
            object = null;
            object = teXParser == teXObjectList ? teXParser.popNextArg(91, 93) : teXObjectList.popArg(teXParser, 91, 93);
            if (object != null) {
                Object object2;
                if (object instanceof Expandable && (object2 = teXParser == teXObjectList ? ((Expandable)object).expandfully(teXParser) : ((Expandable)object).expandfully(teXParser, teXObjectList)) != null) {
                    object = object2;
                }
                if (((String)(object2 = object.toString(teXParser).trim())).equals("c")) {
                    this.halign = (byte)2;
                } else if (((String)object2).equals("l")) {
                    this.halign = 1;
                } else if (((String)object2).equals("r")) {
                    this.halign = (byte)3;
                } else {
                    TeXApp teXApp = teXParser.getListener().getTeXApp();
                    teXApp.warning(teXParser, teXApp.getMessage("latex.illegal.argtype", object2));
                }
            }
        }
        if (teXObject instanceof TeXDimension) {
            this.currentWidth = (TeXDimension)teXObject;
        }
    }

    protected TeXObject popContents(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList) {
            return teXParser.popNextArg();
        }
        return teXObjectList.popArg(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXDimension teXDimension = this.currentWidth;
        TeXDimension teXDimension2 = this.currentHeight;
        byte by = this.halign;
        byte by2 = this.valign;
        Color color = this.currentBorderColor;
        Color color2 = this.currentFgColor;
        Color color3 = this.currentBgColor;
        TeXDimension teXDimension3 = this.currentBorderWidth;
        TeXDimension teXDimension4 = this.currentInnerMargin;
        teXParser.startGroup();
        this.popSettings(teXParser, teXObjectList);
        TeXObject teXObject = this.popContents(teXParser, teXObjectList);
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        laTeXParserListener.startFrameBox(this);
        try {
            teXObject.process(teXParser, teXObjectList);
        }
        finally {
            try {
                laTeXParserListener.endFrameBox(this);
            }
            finally {
                teXParser.endGroup();
                this.currentWidth = teXDimension;
                this.currentHeight = teXDimension2;
                this.currentBorderColor = color;
                this.currentFgColor = color2;
                this.currentBgColor = color3;
                this.currentBorderWidth = teXDimension3;
                this.currentInnerMargin = teXDimension4;
                this.halign = by;
                this.valign = by2;
            }
        }
    }
}

