/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.profiler.v2.features.Bundle;
import org.graalvm.visualvm.lib.profiler.v2.features.FeatureUI;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.locks.LockContentionPanel;
import org.graalvm.visualvm.lib.ui.swing.ActionPopupButton;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;

abstract class LocksFeatureUI
extends FeatureUI {
    private ProfilerToolbar toolbar;
    private LockContentionPanel locksView;
    private JLabel shLabel;
    private ActionPopupButton shAggregation;

    LocksFeatureUI() {
    }

    abstract ProfilerClient getProfilerClient();

    abstract void refreshResults();

    @Override
    ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    JPanel getResultsUI() {
        if (this.locksView == null) {
            this.initUI();
        }
        return this.locksView;
    }

    @Override
    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
        if (sessionState == 1 || sessionState == 128) {
            if (this.locksView != null) {
                this.locksView.profilingSessionFinished();
            }
        } else if (sessionState == 4 && this.locksView != null) {
            this.locksView.profilingSessionStarted();
        }
    }

    void resetPause() {
    }

    void setForceRefresh() {
        if (this.locksView != null) {
            this.locksView.setForceRefresh(true);
        }
    }

    void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.locksView != null) {
            this.locksView.refreshData();
        }
    }

    void resetData() {
        if (this.locksView != null) {
            this.locksView.resetData();
        }
    }

    private void initUI() {
        assert (SwingUtilities.isEventDispatchThread());
        this.locksView = new LockContentionPanel(){

            protected ProfilerClient getProfilerClient() {
                return LocksFeatureUI.this.getProfilerClient();
            }
        };
        this.locksView.lockContentionEnabled();
        this.locksView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileLocks.HelpCtx");
        this.shLabel = new GrayLabel(Bundle.LocksFeatureUI_show());
        AbstractAction aThreads = new AbstractAction(){
            {
                this.putValue("Name", Bundle.LocksFeatureUI_aggregationByThreads());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LocksFeatureUI.this.setAggregation(LockContentionPanel.Aggregation.BY_THREADS);
            }
        };
        AbstractAction aMonitors = new AbstractAction(){
            {
                this.putValue("Name", Bundle.LocksFeatureUI_aggregationByMonitors());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LocksFeatureUI.this.setAggregation(LockContentionPanel.Aggregation.BY_MONITORS);
            }
        };
        this.shAggregation = new ActionPopupButton(new Action[]{aThreads, aMonitors});
        this.shAggregation.setToolTipText(Bundle.LocksFeatureUI_aggregationHint());
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.shLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.shAggregation);
        this.setAggregation(LockContentionPanel.Aggregation.BY_THREADS);
        this.sessionStateChanged(this.getSessionState());
    }

    private void refreshToolbar(int state) {
    }

    private void setAggregation(LockContentionPanel.Aggregation aggregation) {
        this.locksView.setAggregation(aggregation);
        this.shAggregation.selectAction(aggregation.ordinal());
    }
}

