/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.r;

import java.util.List;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RObject;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class RDetailsProvider
extends DetailsProvider.Basic {
    private static final String RVECTOR_MASK = "com.oracle.truffle.r.runtime.data.RVector+";
    private static final String RABSTRACT_VECTOR_MASK = "com.oracle.truffle.r.runtime.data.model.RAbstractVector+";
    private static final String RSCALAR_VECTOR_MASK = "com.oracle.truffle.r.runtime.data.RScalarVector+";
    private static final String RLOGICAL_VECTOR_FQN = "com.oracle.truffle.r.runtime.data.RLogicalVector";
    private static final String RLOGICAL_FQN = "com.oracle.truffle.r.runtime.data.RLogical";
    private static final String RCOMPLEX_VECTOR_FQN = "com.oracle.truffle.r.runtime.data.RComplexVector";
    private static final String RINT_SEQUENCE_FQN = "com.oracle.truffle.r.runtime.data.RIntSequence";
    private static final String RINT_SEQUENCE1_FQN = "com.oracle.truffle.r.runtime.data.RIntSeqVectorData";
    private static final String RDOUBLE_SEQUENCE_FQN = "com.oracle.truffle.r.runtime.data.RDoubleSequence";
    private static final String RDOUBLE_SEQUENCE1_FQN = "com.oracle.truffle.r.runtime.data.RDoubleSeqVectorData";
    private static final String RSTRING_SEQUENCE_FQN = "com.oracle.truffle.r.runtime.data.RStringSequence";
    private static final String RSTRING_SEQUENCE1_FQN = "com.oracle.truffle.r.runtime.data.RStringSeqVectorData";
    private static final String REXPRESSION_FQN = "com.oracle.truffle.r.runtime.data.RExpression";
    private static final String RWRAPPER_MASK = "com.oracle.truffle.r.runtime.data.RForeignWrapper+";
    private static final String RSYMBOL_MASK = "com.oracle.truffle.r.runtime.data.RSymbol";
    private static final String RFUNCTION_MASK = "com.oracle.truffle.r.runtime.data.RFunction";
    private static final String RS4OBJECT_MASK = "com.oracle.truffle.r.runtime.data.RS4Object";
    private static final String RNULL_MASK = "com.oracle.truffle.r.runtime.data.RNull";
    private static final String RENVIRONMENT_MASK = "com.oracle.truffle.r.runtime.env.REnvironment+";
    private static final String CHARSXPWRAPPER_FQN = "com.oracle.truffle.r.runtime.data.CharSXPWrapper";
    private static final byte LOGICAL_TRUE = 1;
    private static final byte LOGICAL_FALSE = 0;
    private static final byte LOGICAL_NA = -1;

    public RDetailsProvider() {
        super(new String[]{RVECTOR_MASK, RABSTRACT_VECTOR_MASK, RSCALAR_VECTOR_MASK, RINT_SEQUENCE_FQN, RINT_SEQUENCE1_FQN, RDOUBLE_SEQUENCE_FQN, RDOUBLE_SEQUENCE1_FQN, RSTRING_SEQUENCE_FQN, RSTRING_SEQUENCE1_FQN, RWRAPPER_MASK, RSYMBOL_MASK, RFUNCTION_MASK, RS4OBJECT_MASK, RNULL_MASK, RENVIRONMENT_MASK, CHARSXPWRAPPER_FQN});
    }

    public String getDetailsString(String className, Instance instance) {
        String name;
        Object rawData;
        Instance proxy;
        Instance delegate;
        String val;
        if (RVECTOR_MASK.equals(className) || RABSTRACT_VECTOR_MASK.equals(className)) {
            Instance rawData2 = RObject.findDataField(instance);
            if (rawData2 != null) {
                String refString;
                int size;
                ObjectArrayInstance data;
                if (rawData2 instanceof ObjectArrayInstance) {
                    data = (ObjectArrayInstance)rawData2;
                    size = data.getLength();
                    if (size == 1) {
                        String str;
                        Instance obj = (Instance)data.getValues().get(0);
                        if (REXPRESSION_FQN.equals(instance.getJavaClass().getName()) && obj != null && (str = DetailsUtils.getInstanceFieldString((Instance)obj, (String)"type")) != null) {
                            return "[" + str + "]";
                        }
                        return RDetailsProvider.getValue(obj, false);
                    }
                } else if (rawData2 instanceof PrimitiveArrayInstance) {
                    data = (PrimitiveArrayInstance)rawData2;
                    size = data.getLength();
                    if (size == 1) {
                        boolean isLogical = RLOGICAL_VECTOR_FQN.equals(instance.getJavaClass().getName());
                        return RDetailsProvider.getValue(data.getValues().get(0), isLogical);
                    }
                    if (RCOMPLEX_VECTOR_FQN.equals(instance.getJavaClass().getName()) && (size /= 2) == 1) {
                        List vals = data.getValues();
                        return "[" + vals.get(0) + "+" + vals.get(1) + "i]";
                    }
                } else {
                    return null;
                }
                Boolean complete = (Boolean)instance.getValueOfField("complete");
                Integer refCount = (Integer)instance.getValueOfField("refCount");
                String rClassName = this.getRClassName(instance);
                switch (refCount) {
                    case 0: {
                        refString = ", temporary";
                        break;
                    }
                    case 1: {
                        refString = "";
                        break;
                    }
                    case 0x7FFFFFFF: {
                        refString = ", shared permanent";
                        break;
                    }
                    default: {
                        refString = ", shared";
                    }
                }
                rClassName = rClassName == null ? "" : rClassName + " ";
                return "Size: " + size + (complete != false && size > 0 ? ", no NAs" : "") + refString;
            }
            String scalar = this.getScalar(instance);
            if (scalar != null) {
                return scalar;
            }
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"data");
        }
        if (RSYMBOL_MASK.equals(className)) {
            Instance name2 = (Instance)instance.getValueOfField("name");
            if (name2 != null) {
                return DetailsSupport.getDetailsString((Instance)name2);
            }
            name2 = (Instance)instance.getValueOfField("nameWrapper");
            return name2 == null ? null : DetailsUtils.getInstanceFieldString((Instance)name2, (String)"contents");
        }
        if (RFUNCTION_MASK.equals(className)) {
            String name3 = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            String packageName = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"packageName");
            if (name3 != null && !name3.isEmpty()) {
                if (packageName != null && !packageName.isEmpty()) {
                    return packageName + ":::" + name3;
                }
                return name3;
            }
            Instance target = (Instance)instance.getValueOfField("target");
            String value = target == null ? null : DetailsSupport.getDetailsString((Instance)target);
            return value == null || value.isEmpty() ? null : value;
        }
        if (RSCALAR_VECTOR_MASK.equals(className)) {
            return this.getScalar(instance);
        }
        if ((RINT_SEQUENCE_FQN.equals(className) || RINT_SEQUENCE1_FQN.equals(className)) && (val = this.logicalValueForIntSeq(instance)) != null) {
            return val;
        }
        if (RDOUBLE_SEQUENCE_FQN.equals(className) || RDOUBLE_SEQUENCE1_FQN.equals(className)) {
            Double stride = (Double)instance.getValueOfField("stride");
            Double start = (Double)instance.getValueOfField("start");
            Integer len = (Integer)instance.getValueOfField("length");
            if (stride != null && start != null & len != null) {
                int length = len;
                if (length == 0) {
                    return "[]";
                }
                double end = start + (double)(length - 1) * stride;
                return "seq(" + start + "," + end + "," + stride + ")";
            }
        }
        if ((RSTRING_SEQUENCE_FQN.equals(className) || RSTRING_SEQUENCE1_FQN.equals(className)) && (val = this.logicalValueForIntSeq(instance)) != null) {
            String prefix = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"prefix");
            String suffix = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"suffix");
            if (prefix != null && suffix != null) {
                return "paste0(\"" + prefix + "\", " + val + ", \"" + suffix + "\")";
            }
        }
        if (RS4OBJECT_MASK.equals(className)) {
            return this.getRClassName(instance);
        }
        if (RNULL_MASK.equals(className)) {
            return "NULL";
        }
        if (RWRAPPER_MASK.equals(className) && (delegate = (Instance)instance.getValueOfField("delegate")) != null && (proxy = (Instance)delegate.getValueOfField("proxy")) != null && (rawData = proxy.getValueOfField("val$values")) instanceof ObjectArrayInstance) {
            ObjectArrayInstance data = (ObjectArrayInstance)rawData;
            int size = data.getLength();
            if (size == 1) {
                return RDetailsProvider.getValue(data.getValues().get(0), false) + ", foreign";
            }
            return "Size: " + size + ", foreign";
        }
        if (RENVIRONMENT_MASK.equals(className) && (name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name")) != null && !name.isEmpty()) {
            return name;
        }
        if (CHARSXPWRAPPER_FQN.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"contents");
        }
        return null;
    }

    private String logicalValueForIntSeq(Instance instance) {
        Integer stride = (Integer)instance.getValueOfField("stride");
        Integer start = (Integer)instance.getValueOfField("start");
        Integer len = (Integer)instance.getValueOfField("length");
        if (stride != null && start != null & len != null) {
            int length = len;
            if (length == 0) {
                return "[]";
            }
            int end = start + (length - 1) * stride;
            if (stride == 1) {
                return "[" + start + ":" + end + "]";
            }
            return "seq(" + start + "," + end + "," + stride + ")";
        }
        return null;
    }

    private String getRClassName(Instance instance) {
        Instance attributesInst = (Instance)instance.getValueOfField("attributes");
        if (attributesInst != null) {
            DynamicObject attributes = new DynamicObject(attributesInst);
            FieldValue classAttr = attributes.getFieldValue("class");
            if (classAttr instanceof ObjectFieldValue) {
                Instance classAttrName = ((ObjectFieldValue)classAttr).getInstance();
                return "Class: " + DetailsSupport.getDetailsString((Instance)classAttrName);
            }
            classAttr = attributes.getFieldValue(".S3Class");
            if (classAttr instanceof ObjectFieldValue) {
                Instance classAttrName = ((ObjectFieldValue)classAttr).getInstance();
                if (RObject.isRObject(classAttrName)) {
                    StringBuilder classes = new StringBuilder("S3Class: [");
                    RObject vector = new RObject(classAttrName);
                    List values = vector.getValues();
                    for (int i = 0; i < values.size(); ++i) {
                        Instance str = (Instance)values.get(i);
                        classes.append(DetailsSupport.getDetailsString((Instance)str));
                        if (i >= values.size() - 1) continue;
                        classes.append(", ");
                    }
                    return classes.append(']').toString();
                }
                return "S3Class: " + DetailsSupport.getDetailsString((Instance)classAttrName);
            }
        }
        return null;
    }

    private static String getValue(Object value, boolean isLogical) {
        String valString = value instanceof Instance ? DetailsSupport.getDetailsString((Instance)((Instance)value)) : value.toString();
        if (isLogical) {
            int val = Integer.parseInt(valString);
            if (val == 0) {
                valString = "FALSE";
            } else if (val == 1) {
                valString = "TRUE";
            } else if (val == -1) {
                valString = "NA";
            }
        }
        return "[" + valString + "]";
    }

    private String getScalar(Instance instance) {
        Object rawData = instance.getValueOfField("value");
        if (rawData != null) {
            boolean isLogical = RLOGICAL_FQN.equals(instance.getJavaClass().getName());
            return RDetailsProvider.getValue(rawData, isLogical);
        }
        Double realPart = (Double)instance.getValueOfField("realPart");
        Double imaginaryPart = (Double)instance.getValueOfField("imaginaryPart");
        if (realPart != null && imaginaryPart != null) {
            return "[" + realPart + "+" + imaginaryPart + "i]";
        }
        return null;
    }
}

