/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.preview;

import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.gephi.io.exporter.preview.PDFExporter;
import org.gephi.lib.validation.ValidationClient;
import org.gephi.ui.exporter.preview.UIExporterPDF;
import org.jdesktop.swingx.JXHyperlink;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class UIExporterPDFPanel
extends JPanel
implements ValidationClient {
    private static final double INCH = 72.0;
    private static final double MM = 2.8346456692895527;
    private final String customSizeString;
    private boolean millimeter = true;
    private NumberFormat sizeFormatter;
    private NumberFormat marginFormatter;
    private JTextField bottomMarginTextField;
    private JTextField heightTextField;
    private JLabel heightUnitLabel;
    private JLabel labelBottom;
    private JLabel labelHeight;
    private JLabel labelLeft;
    private JLabel labelMargins;
    private JLabel labelOrientation;
    private JLabel labelPageSize;
    private JLabel labelRight;
    private JLabel labelTop;
    private JLabel labelUnit;
    private JLabel labelWidth;
    private JRadioButton landscapeRadio;
    private JTextField leftMarginTextField;
    private ButtonGroup orientationButtonGroup;
    private JComboBox pageSizeCombo;
    private JRadioButton portraitRadio;
    private JTextField rightMargintextField;
    private JTextField topMarginTextField;
    private JXHyperlink unitLink;
    private JTextField widthTextField;
    private JLabel widthUnitLabel;

    public UIExporterPDFPanel() {
        this.initComponents();
        this.sizeFormatter = NumberFormat.getNumberInstance();
        this.sizeFormatter.setMaximumFractionDigits(3);
        this.marginFormatter = NumberFormat.getNumberInstance();
        this.marginFormatter.setMaximumFractionDigits(1);
        DefaultComboBoxModel<Object> comboBoxModel = new DefaultComboBoxModel<Object>();
        comboBoxModel.addElement(new PageSizeItem(PageSize.A0, "A0", 841.0, 1189.0, 33.1, 46.8));
        comboBoxModel.addElement(new PageSizeItem(PageSize.A1, "A1", 594.0, 841.0, 23.4, 33.1));
        comboBoxModel.addElement(new PageSizeItem(PageSize.A2, "A2", 420.0, 594.0, 16.5, 23.4));
        comboBoxModel.addElement(new PageSizeItem(PageSize.A3, "A3", 297.0, 420.0, 11.7, 16.5));
        comboBoxModel.addElement(new PageSizeItem(PageSize.A4, "A4", 210.0, 297.0, 8.3, 11.7));
        comboBoxModel.addElement(new PageSizeItem(PageSize.A5, "A5", 148.0, 210.0, 5.8, 8.3));
        comboBoxModel.addElement(new PageSizeItem(PageSize.ARCH_A, "ARCH A", 229.0, 305.0, 9.0, 12.0));
        comboBoxModel.addElement(new PageSizeItem(PageSize.ARCH_B, "ARCH B", 305.0, 457.0, 12.0, 18.0));
        comboBoxModel.addElement(new PageSizeItem(PageSize.ARCH_C, "ARCH C", 457.0, 610.0, 18.0, 24.0));
        comboBoxModel.addElement(new PageSizeItem(PageSize.ARCH_D, "ARCH D", 610.0, 914.0, 24.0, 36.0));
        comboBoxModel.addElement(new PageSizeItem(PageSize.ARCH_E, "ARCH E", 914.0, 1219.0, 36.0, 48.0));
        comboBoxModel.addElement(new PageSizeItem(PageSize.B0, "B0", 1000.0, 1414.0, 39.4, 55.7));
        comboBoxModel.addElement(new PageSizeItem(PageSize.B1, "B1", 707.0, 1000.0, 27.8, 39.4));
        comboBoxModel.addElement(new PageSizeItem(PageSize.B2, "B2", 500.0, 707.0, 19.7, 27.8));
        comboBoxModel.addElement(new PageSizeItem(PageSize.B3, "B3", 353.0, 500.0, 13.9, 19.7));
        comboBoxModel.addElement(new PageSizeItem(PageSize.B4, "B4", 250.0, 353.0, 9.8, 13.9));
        comboBoxModel.addElement(new PageSizeItem(PageSize.B5, "B5", 176.0, 250.0, 6.9, 9.8));
        comboBoxModel.addElement(new PageSizeItem(PageSize.LEDGER, "Ledger", 432.0, 279.0, 17.0, 11.0));
        comboBoxModel.addElement(new PageSizeItem(PageSize.LEGAL, "Legal", 216.0, 356.0, 8.5, 14.0));
        comboBoxModel.addElement(new PageSizeItem(PageSize.LETTER, "Letter", 216.0, 279.0, 8.5, 11.0));
        comboBoxModel.addElement(new PageSizeItem(PageSize.TABLOID, "Tabloid", 279.0, 432.0, 11.0, 17.0));
        this.customSizeString = NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.pageSize.custom");
        comboBoxModel.addElement(this.customSizeString);
        this.pageSizeCombo.setModel(comboBoxModel);
        this.loadPreferences();
        this.initEvents();
        this.refreshUnit(false);
    }

    private void loadPreferences() {
        boolean defaultMM = NbPreferences.forModule(UIExporterPDF.class).getBoolean("Default_Millimeter", false);
        this.millimeter = NbPreferences.forModule(UIExporterPDF.class).getBoolean("Millimeter", defaultMM);
    }

    private void savePreferences() {
        NbPreferences.forModule(UIExporterPDF.class).putBoolean("Millimeter", this.millimeter);
    }

    private void initEvents() {
        this.pageSizeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectedItem = UIExporterPDFPanel.this.pageSizeCombo.getSelectedItem();
                if (selectedItem != UIExporterPDFPanel.this.customSizeString) {
                    PageSizeItem pageSize = (PageSizeItem)selectedItem;
                    UIExporterPDFPanel.this.setPageSize(pageSize);
                }
            }
        });
        this.widthTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIExporterPDFPanel.this.updatePageSize();
            }
        });
        this.heightTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIExporterPDFPanel.this.updatePageSize();
            }
        });
        this.unitLink.setAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIExporterPDFPanel.this.millimeter = !UIExporterPDFPanel.this.millimeter;
                UIExporterPDFPanel.this.refreshUnit(true);
            }
        });
    }

    public static ValidationPanel createValidationPanel(UIExporterPDFPanel innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        innerPanel.validate(group);
        return validationPanel;
    }

    public void validate(ValidationGroup group) {
        group.add((JTextComponent)this.widthTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, new PositiveSizeValidator(this)});
        group.add((JTextComponent)this.heightTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, new PositiveSizeValidator(this)});
        group.add((JTextComponent)this.topMarginTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_NUMBER});
        group.add((JTextComponent)this.bottomMarginTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_NUMBER});
        group.add((JTextComponent)this.leftMarginTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_NUMBER});
        group.add((JTextComponent)this.rightMargintextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_NUMBER});
    }

    public void setup(PDFExporter pdfExporter) {
        DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)this.pageSizeCombo.getModel();
        PageSizeItem pageSize = new PageSizeItem(pdfExporter.getPageSize());
        int index = 0;
        index = comboBoxModel.getIndexOf(pageSize);
        if (index == -1) {
            comboBoxModel.setSelectedItem(this.customSizeString);
        } else {
            pageSize = (PageSizeItem)comboBoxModel.getElementAt(index);
            comboBoxModel.setSelectedItem(pageSize);
        }
        this.setPageSize(pageSize);
        this.setMargins(pdfExporter.getMarginTop(), pdfExporter.getMarginBottom(), pdfExporter.getMarginLeft(), pdfExporter.getMarginRight());
        this.setOrientation(pdfExporter.isLandscape());
    }

    public void unsetup(PDFExporter pdfExporter) {
        if (this.pageSizeCombo.getSelectedItem() == this.customSizeString) {
            double width = pdfExporter.getPageSize().getWidth();
            double height = pdfExporter.getPageSize().getHeight();
            try {
                width = this.sizeFormatter.parse(this.widthTextField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                height = this.sizeFormatter.parse(this.heightTextField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (this.millimeter) {
                width *= 2.8346456692895527;
                height *= 2.8346456692895527;
            } else {
                width *= 72.0;
                height *= 72.0;
            }
            float w = (float)width;
            float h = (float)height;
            Rectangle rect = new Rectangle(w, h);
            pdfExporter.setPageSize(rect);
        } else {
            pdfExporter.setPageSize(((PageSizeItem)this.pageSizeCombo.getSelectedItem()).getPageSize());
        }
        pdfExporter.setLandscape(this.landscapeRadio.isSelected());
        double top = pdfExporter.getMarginTop();
        double bottom = pdfExporter.getMarginBottom();
        double left = pdfExporter.getMarginLeft();
        double right = pdfExporter.getMarginRight();
        try {
            top = this.marginFormatter.parse(this.topMarginTextField.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            bottom = this.marginFormatter.parse(this.bottomMarginTextField.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            left = this.marginFormatter.parse(this.leftMarginTextField.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            right = this.marginFormatter.parse(this.rightMargintextField.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.millimeter) {
            top *= 2.8346456692895527;
            bottom *= 2.8346456692895527;
            left *= 2.8346456692895527;
            right *= 2.8346456692895527;
        } else {
            top *= 72.0;
            bottom *= 72.0;
            left *= 72.0;
            right *= 72.0;
        }
        pdfExporter.setMarginTop((float)top);
        pdfExporter.setMarginBottom((float)bottom);
        pdfExporter.setMarginLeft((float)left);
        pdfExporter.setMarginRight((float)right);
        this.savePreferences();
    }

    private void updatePageSize() {
        if (this.pageSizeCombo.getSelectedItem() != this.customSizeString && !this.widthTextField.getText().isEmpty() && !this.heightTextField.getText().isEmpty()) {
            DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)this.pageSizeCombo.getModel();
            PageSizeItem item = this.getItem(this.widthTextField.getText(), this.heightTextField.getText());
            if (item == null) {
                comboBoxModel.setSelectedItem(this.customSizeString);
            } else {
                comboBoxModel.setSelectedItem(item);
            }
        }
    }

    private void setPageSize(PageSizeItem pageSize) {
        double pageWidth = 0.0;
        double pageHeight = 0.0;
        if (this.millimeter) {
            pageWidth = pageSize.mmWidth;
            pageHeight = pageSize.mmHeight;
        } else {
            pageWidth = pageSize.inWidth;
            pageHeight = pageSize.inHeight;
        }
        this.widthTextField.setText(this.sizeFormatter.format(pageWidth));
        this.heightTextField.setText(this.sizeFormatter.format(pageHeight));
    }

    private void setOrientation(boolean landscape) {
        this.portraitRadio.setSelected(!landscape);
        this.landscapeRadio.setSelected(landscape);
    }

    private void setMargins(float top, float bottom, float left, float right) {
        if (this.millimeter) {
            top = (float)((double)top / 2.8346456692895527);
            bottom = (float)((double)bottom / 2.8346456692895527);
            left = (float)((double)left / 2.8346456692895527);
            right = (float)((double)right / 2.8346456692895527);
        } else {
            top = (float)((double)top / 72.0);
            bottom = (float)((double)bottom / 72.0);
            left = (float)((double)left / 72.0);
            right = (float)((double)right / 72.0);
        }
        this.topMarginTextField.setText(this.marginFormatter.format(top));
        this.bottomMarginTextField.setText(this.marginFormatter.format(bottom));
        this.leftMarginTextField.setText(this.marginFormatter.format(left));
        this.rightMargintextField.setText(this.marginFormatter.format(right));
    }

    private PageSizeItem getItem(String width, String height) {
        DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)this.pageSizeCombo.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            Object o = comboBoxModel.getElementAt(i);
            if (!(o instanceof PageSizeItem)) continue;
            PageSizeItem pageSize = (PageSizeItem)o;
            double pageWidth = 0.0;
            double pageHeight = 0.0;
            if (this.millimeter) {
                pageWidth = pageSize.mmWidth;
                pageHeight = pageSize.mmHeight;
            } else {
                pageWidth = pageSize.inWidth;
                pageHeight = pageSize.inHeight;
            }
            String wStr = this.sizeFormatter.format(pageWidth);
            String hStr = this.sizeFormatter.format(pageHeight);
            if (!wStr.equals(width) || !hStr.equals(height)) continue;
            return (PageSizeItem)o;
        }
        return null;
    }

    private void refreshUnit(boolean convert) {
        this.unitLink.setText(this.millimeter ? NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.unitLink.millimeter") : NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.unitLink.inch"));
        this.widthUnitLabel.setText(this.millimeter ? NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelUnit.millimeter") : NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelUnit.inch"));
        this.heightUnitLabel.setText(this.widthUnitLabel.getText());
        if (convert) {
            if (this.pageSizeCombo.getSelectedItem() != this.customSizeString) {
                this.setPageSize((PageSizeItem)this.pageSizeCombo.getSelectedItem());
            } else {
                double width = 0.0;
                double height = 0.0;
                try {
                    width = this.sizeFormatter.parse(this.widthTextField.getText()).doubleValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                try {
                    height = this.sizeFormatter.parse(this.heightTextField.getText()).doubleValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (!this.millimeter) {
                    width *= 0.03937007874013268;
                    height *= 0.03937007874013268;
                } else {
                    width *= 25.400000000016004;
                    height *= 25.400000000016004;
                }
                this.widthTextField.setText(this.sizeFormatter.format(width));
                this.heightTextField.setText(this.sizeFormatter.format(height));
            }
            this.updatePageSize();
            double top = 0.0;
            double bottom = 0.0;
            double left = 0.0;
            double right = 0.0;
            try {
                top = this.marginFormatter.parse(this.topMarginTextField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                bottom = this.marginFormatter.parse(this.bottomMarginTextField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                left = this.marginFormatter.parse(this.leftMarginTextField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                right = this.marginFormatter.parse(this.rightMargintextField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (!this.millimeter) {
                top *= 0.03937007874013268;
                bottom *= 0.03937007874013268;
                left *= 0.03937007874013268;
                right *= 0.03937007874013268;
            } else {
                top *= 25.400000000016004;
                bottom *= 25.400000000016004;
                left *= 25.400000000016004;
                right *= 25.400000000016004;
            }
            this.topMarginTextField.setText(this.marginFormatter.format(top));
            this.bottomMarginTextField.setText(this.marginFormatter.format(bottom));
            this.leftMarginTextField.setText(this.marginFormatter.format(left));
            this.rightMargintextField.setText(this.marginFormatter.format(right));
        }
    }

    private void initComponents() {
        this.orientationButtonGroup = new ButtonGroup();
        this.labelPageSize = new JLabel();
        this.pageSizeCombo = new JComboBox();
        this.labelWidth = new JLabel();
        this.widthTextField = new JTextField();
        this.labelHeight = new JLabel();
        this.heightTextField = new JTextField();
        this.widthUnitLabel = new JLabel();
        this.heightUnitLabel = new JLabel();
        this.labelOrientation = new JLabel();
        this.portraitRadio = new JRadioButton();
        this.landscapeRadio = new JRadioButton();
        this.labelMargins = new JLabel();
        this.labelTop = new JLabel();
        this.topMarginTextField = new JTextField();
        this.labelBottom = new JLabel();
        this.bottomMarginTextField = new JTextField();
        this.labelLeft = new JLabel();
        this.labelRight = new JLabel();
        this.leftMarginTextField = new JTextField();
        this.rightMargintextField = new JTextField();
        this.labelUnit = new JLabel();
        this.unitLink = new JXHyperlink();
        this.labelPageSize.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelPageSize.text"));
        this.pageSizeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.labelWidth.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelWidth.text"));
        this.widthTextField.setHorizontalAlignment(4);
        this.widthTextField.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.widthTextField.text"));
        this.labelHeight.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelHeight.text"));
        this.heightTextField.setHorizontalAlignment(4);
        this.heightTextField.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.heightTextField.text"));
        this.widthUnitLabel.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.widthUnitLabel.text"));
        this.heightUnitLabel.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.heightUnitLabel.text"));
        this.labelOrientation.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelOrientation.text"));
        this.orientationButtonGroup.add(this.portraitRadio);
        this.portraitRadio.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.portraitRadio.text"));
        this.orientationButtonGroup.add(this.landscapeRadio);
        this.landscapeRadio.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.landscapeRadio.text"));
        this.labelMargins.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelMargins.text"));
        this.labelTop.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelTop.text"));
        this.topMarginTextField.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.topMarginTextField.text"));
        this.labelBottom.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelBottom.text"));
        this.bottomMarginTextField.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.bottomMarginTextField.text"));
        this.labelLeft.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelLeft.text"));
        this.labelRight.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelRight.text"));
        this.leftMarginTextField.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.leftMarginTextField.text"));
        this.rightMargintextField.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.rightMargintextField.text"));
        this.labelUnit.setText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.labelUnit.text"));
        this.unitLink.setText("");
        this.unitLink.setToolTipText(NbBundle.getMessage(UIExporterPDFPanel.class, (String)"UIExporterPDFPanel.unitLink.toolTipText"));
        this.unitLink.setFocusPainted(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelUnit).addGap(62, 62, 62).addComponent((Component)this.unitLink, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPageSize).addComponent(this.labelOrientation).addComponent(this.labelMargins)).addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.landscapeRadio, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.portraitRadio, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelHeight).addComponent(this.labelWidth)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.heightTextField, GroupLayout.Alignment.TRAILING, -2, 95, -2).addComponent(this.widthTextField, -2, 95, -2)))).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthUnitLabel).addComponent(this.heightUnitLabel))).addComponent(this.pageSizeCombo, 0, 224, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelTop).addGap(26, 26, 26).addComponent(this.topMarginTextField, -2, 34, -2).addGap(18, 18, 18).addComponent(this.labelLeft)).addGroup(layout.createSequentialGroup().addComponent(this.labelBottom).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bottomMarginTextField, -2, 34, -2).addGap(18, 18, 18).addComponent(this.labelRight))).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.leftMarginTextField, -2, 34, -2).addComponent(this.rightMargintextField, -2, 34, -2)))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelUnit).addComponent((Component)this.unitLink, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelPageSize).addComponent(this.pageSizeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthUnitLabel).addComponent(this.widthTextField, -2, -1, -2).addComponent(this.labelWidth)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.heightTextField, -2, -1, -2).addComponent(this.heightUnitLabel).addComponent(this.labelHeight)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelOrientation).addComponent(this.portraitRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.landscapeRadio).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelMargins).addComponent(this.labelTop).addComponent(this.topMarginTextField, -2, -1, -2).addComponent(this.labelLeft).addComponent(this.leftMarginTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bottomMarginTextField, -2, -1, -2).addComponent(this.labelBottom).addComponent(this.labelRight).addComponent(this.rightMargintextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private static class PositiveSizeValidator
    implements Validator<String> {
        private UIExporterPDFPanel panel;

        public PositiveSizeValidator(UIExporterPDFPanel panel) {
            this.panel = panel;
        }

        public boolean validate(Problems problems, String compName, String model) {
            boolean result = false;
            try {
                double i = this.panel.sizeFormatter.parse(this.panel.widthTextField.getText()).doubleValue();
                result = i > 0.0;
            }
            catch (ParseException i) {
                // empty catch block
            }
            if (!result) {
                String message = NbBundle.getMessage(this.getClass(), (String)"PositiveSizeValidator.NEGATIVE", (Object)model);
                problems.add(message);
            }
            return result;
        }
    }

    private static class PageSizeItem {
        private final Rectangle pageSize;
        private String name = "";
        private final double inWidth;
        private final double inHeight;
        private final double mmWidth;
        private final double mmHeight;

        public PageSizeItem(Rectangle pageSize) {
            this.pageSize = pageSize;
            this.inHeight = (double)pageSize.getHeight() / 72.0;
            this.inWidth = (double)pageSize.getWidth() / 72.0;
            this.mmHeight = (double)pageSize.getHeight() / 2.8346456692895527;
            this.mmWidth = (double)pageSize.getWidth() / 2.8346456692895527;
        }

        public PageSizeItem(Rectangle pageSize, String name, double mmWidth, double mmHeight, double inWidth, double inHeight) {
            this.pageSize = pageSize;
            this.name = name;
            this.inHeight = inHeight;
            this.inWidth = inWidth;
            this.mmHeight = mmHeight;
            this.mmWidth = mmWidth;
        }

        public Rectangle getPageSize() {
            return this.pageSize;
        }

        public double getInHeight() {
            return this.inHeight;
        }

        public double getInWidth() {
            return this.inWidth;
        }

        public double getMmHeight() {
            return this.mmHeight;
        }

        public double getMmWidth() {
            return this.mmWidth;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PageSizeItem other = (PageSizeItem)obj;
            return this.pageSize == other.pageSize || this.pageSize != null && this.pageSize.equals((Object)other.pageSize);
        }

        public int hashCode() {
            int hash = 3;
            hash = 47 * hash + (this.pageSize != null ? this.pageSize.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.name;
        }
    }
}

