import threading
from types import TracebackType
from typing import Any, Dict, Sequence, Type

from typing_extensions import Protocol  # Py38+: Available in ``typing``

from pykka import ActorRef, Future
from pykka._envelope import Envelope

class ActorInbox(Protocol):
    def put(self, envelope: Envelope) -> None: ...
    def get(self) -> Envelope: ...

class Actor:
    @classmethod
    def start(cls, *args: Any, **kwargs: Any) -> ActorRef: ...
    @staticmethod
    def _create_actor_inbox() -> ActorInbox: ...
    @staticmethod
    def _create_future() -> Future: ...
    def _start_actor_loop(self) -> None: ...
    actor_urn: str
    actor_inbox: ActorInbox
    actor_ref: ActorRef
    actor_stopped: threading.Event
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def __str__(self) -> str: ...
    def stop(self) -> None: ...
    def _stop(self) -> None: ...
    def _actor_loop(self) -> None: ...
    def on_start(self) -> None: ...
    def on_stop(self) -> None: ...
    def _handle_failure(
        self,
        exception_type: Type[BaseException],
        exception_value: BaseException,
        traceback: TracebackType,
    ) -> None: ...
    def on_failure(
        self,
        exception_type: Type[BaseException],
        exception_value: BaseException,
        traceback: TracebackType,
    ) -> None: ...
    def _handle_receive(self, message: Any) -> Any: ...
    def on_receive(self, message: Any) -> Any: ...
    def _get_attribute_from_path(self, attr_path: Sequence[str]) -> Any: ...
    def _introspect_attribute_from_path(
        self, attr_path: Sequence[str]
    ) -> Dict[str, Any]: ...
    def _introspect_attributes(self, obj: Any) -> Dict[str, Any]: ...
