/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;

public final class WakeupOnCollisionEntry
extends WakeupCriterion {
    static final int COND_IN_GS_LIST = 0;
    static final int COLLIDEENTRY_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    public static final int USE_GEOMETRY = 10;
    public static final int USE_BOUNDS = 11;
    static final int GROUP = 23;
    static final int BOUNDINGLEAF = 25;
    static final int SHAPE = 11;
    static final int MORPH = 10;
    static final int ORIENTEDSHAPE3D = 28;
    static final int BOUND = 0;
    int accuracyMode;
    NodeRetained armingNode;
    Bounds vwcBounds = null;
    BoundingLeafRetained boundingLeaf = null;
    UnorderList geometryAtoms = null;
    int nodeType;
    SceneGraphPath armingPath = null;
    Bounds armingBounds = null;
    Bounds collidingBounds = null;
    SceneGraphPath collidingPath = null;

    public WakeupOnCollisionEntry(SceneGraphPath sceneGraphPath) {
        this(sceneGraphPath, 11);
    }

    public WakeupOnCollisionEntry(SceneGraphPath sceneGraphPath, int n) {
        this(new SceneGraphPath(sceneGraphPath), n, null);
    }

    public WakeupOnCollisionEntry(Node node) {
        this(node, 11);
    }

    public WakeupOnCollisionEntry(Node node, int n) {
        this(new SceneGraphPath(null, node), n, null);
    }

    public WakeupOnCollisionEntry(Bounds bounds) {
        this(null, 11, (Bounds)bounds.clone());
    }

    WakeupOnCollisionEntry(SceneGraphPath sceneGraphPath, int n, Bounds bounds) {
        if (sceneGraphPath != null) {
            this.armingNode = (NodeRetained)sceneGraphPath.getObject().retained;
            this.nodeType = WakeupOnCollisionEntry.getNodeType(this.armingNode, sceneGraphPath, "WakeupOnCollisionEntry");
            this.armingPath = sceneGraphPath;
            WakeupOnCollisionEntry.validateSpeedHint(n, "WakeupOnCollisionEntry4");
        } else {
            this.armingBounds = bounds;
            this.nodeType = 0;
        }
        this.accuracyMode = n;
        WakeupIndexedList.init(this, 2);
    }

    public SceneGraphPath getArmingPath() {
        return this.armingPath != null ? new SceneGraphPath(this.armingPath) : null;
    }

    public Bounds getArmingBounds() {
        return this.armingBounds != null ? (Bounds)this.armingBounds.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneGraphPath getTriggeringPath() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry5"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry5"));
            }
        }
        return this.collidingPath != null ? new SceneGraphPath(this.collidingPath) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bounds getTriggeringBounds() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry6"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry6"));
            }
        }
        return this.collidingBounds != null ? (Bounds)this.collidingBounds.clone() : null;
    }

    static int getNodeType(NodeRetained nodeRetained, SceneGraphPath sceneGraphPath, String string) throws IllegalArgumentException {
        if (!sceneGraphPath.validate()) {
            throw new IllegalArgumentException(J3dI18N.getString(string + "7"));
        }
        if (nodeRetained.inBackgroundGroup) {
            throw new IllegalArgumentException(J3dI18N.getString(string + "1"));
        }
        if (nodeRetained instanceof OrientedShape3DRetained) {
            return 28;
        }
        if (nodeRetained instanceof Shape3DRetained) {
            return 11;
        }
        if (nodeRetained instanceof MorphRetained) {
            return 10;
        }
        if (nodeRetained instanceof GroupRetained) {
            return 23;
        }
        if (nodeRetained instanceof BoundingLeafRetained) {
            return 25;
        }
        throw new IllegalArgumentException(J3dI18N.getString(string + "0"));
    }

    static void validateSpeedHint(int n, String string) throws IllegalArgumentException {
        if (n != 10 && n != 11) {
            throw new IllegalArgumentException(J3dI18N.getString(string));
        }
    }

    @Override
    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        switch (this.nodeType) {
            case 11: 
            case 28: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                Shape3DRetained shape3DRetained = (Shape3DRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(shape3DRetained.getMirrorShape(this.armingPath)));
                break;
            }
            case 10: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                MorphRetained morphRetained = (MorphRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(morphRetained.getMirrorShape(this.armingPath)));
                break;
            }
            case 25: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                this.boundingLeaf = ((BoundingLeafRetained)this.armingNode).mirrorBoundingLeaf;
                break;
            }
            case 0: {
                this.vwcBounds = (Bounds)this.armingBounds.clone();
                this.armingNode = this.behav;
                break;
            }
            case 23: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.accuracyMode != 10) break;
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
            }
        }
        this.behav.universe.geometryStructure.addWakeupOnCollision(this);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        this.vwcBounds = null;
        if (this.geometryAtoms != null) {
            this.geometryAtoms.clear();
        }
        this.boundingLeaf = null;
        this.behav.universe.geometryStructure.removeWakeupOnCollision(this);
    }

    void setTarget(BHLeafInterface bHLeafInterface) {
        Bounds bounds;
        SceneGraphPath sceneGraphPath;
        if (bHLeafInterface instanceof GeometryAtom) {
            GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
            Shape3DRetained shape3DRetained = geometryAtom.source;
            sceneGraphPath = WakeupOnCollisionEntry.getSceneGraphPath(shape3DRetained.sourceNode, shape3DRetained.key, shape3DRetained.getCurrentLocalToVworld(0));
            bounds = WakeupOnCollisionEntry.getTriggeringBounds(shape3DRetained);
        } else {
            GroupRetained groupRetained = (GroupRetained)bHLeafInterface;
            sceneGraphPath = WakeupOnCollisionEntry.getSceneGraphPath(groupRetained);
            bounds = WakeupOnCollisionEntry.getTriggeringBounds(groupRetained);
        }
        if (sceneGraphPath != null) {
            this.collidingPath = sceneGraphPath;
            this.collidingBounds = bounds;
        }
    }

    void updateCollisionBounds(boolean bl) {
        if (this.nodeType == 23) {
            GroupRetained groupRetained = (GroupRetained)this.armingNode;
            this.vwcBounds = groupRetained.collisionBound != null ? (Bounds)groupRetained.collisionBound.clone() : groupRetained.getEffectiveBounds();
            groupRetained.transformBounds(this.armingPath, this.vwcBounds);
        } else if (this.nodeType == 0) {
            this.vwcBounds.transform(this.armingBounds, this.behav.getCurrentLocalToVworld());
        }
        if (bl && this.nodeType == 23 && this.accuracyMode == 10) {
            this.geometryAtoms.clear();
            ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
        }
    }

    static Bounds getTriggeringBounds(Shape3DRetained shape3DRetained) {
        NodeRetained nodeRetained = shape3DRetained.sourceNode;
        if (nodeRetained instanceof Shape3DRetained) {
            Shape3DRetained shape3DRetained2 = (Shape3DRetained)nodeRetained;
            if (shape3DRetained2.collisionBound == null) {
                return shape3DRetained2.getEffectiveBounds();
            }
            return shape3DRetained2.collisionBound;
        }
        MorphRetained morphRetained = (MorphRetained)nodeRetained;
        if (morphRetained.collisionBound == null) {
            return morphRetained.getEffectiveBounds();
        }
        return morphRetained.collisionBound;
    }

    static Bounds getTriggeringBounds(GroupRetained groupRetained) {
        if (groupRetained.collisionBound == null) {
            return groupRetained.getEffectiveBounds();
        }
        return groupRetained.collisionBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath getSceneGraphPath(GroupRetained groupRetained) {
        Transform3D transform3D = null;
        GroupRetained groupRetained2 = groupRetained.sourceNode;
        Object object = groupRetained2.universe.sceneGraphLock;
        synchronized (object) {
            if (groupRetained.key == null) {
                transform3D = groupRetained2.getCurrentLocalToVworld();
            } else {
                HashKey[] hashKeyArray = groupRetained2.localToVworldKeys;
                if (hashKeyArray == null) {
                    return null;
                }
                transform3D = groupRetained2.getCurrentLocalToVworld(groupRetained.key);
            }
            return WakeupOnCollisionEntry.getSceneGraphPath(groupRetained2, groupRetained.key, transform3D);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath getSceneGraphPath(NodeRetained nodeRetained, HashKey hashKey, Transform3D transform3D) {
        Object object = nodeRetained.universe.sceneGraphLock;
        synchronized (object) {
            Object object2;
            Node[] nodeArray;
            NodeRetained nodeRetained2 = nodeRetained;
            UnorderList unorderList = new UnorderList(5, Node.class);
            NodeRetained nodeRetained3 = nodeRetained2;
            Locale locale = nodeRetained3.locale;
            if (nodeRetained3.inSharedGroup) {
                hashKey = hashKey != null ? new HashKey(hashKey) : new HashKey(nodeRetained.localToVworldKeys[0]);
            }
            do {
                if (nodeRetained3.source.getCapability(0)) {
                    unorderList.add(nodeRetained3.source);
                }
                if (nodeRetained3 instanceof SharedGroupRetained) {
                    String string = hashKey.getLastNodeId();
                    nodeArray = ((SharedGroupRetained)nodeRetained3).parents;
                    object2 = nodeRetained3;
                    for (int i = nodeArray.size() - 1; i >= 0; --i) {
                        NodeRetained nodeRetained4 = (NodeRetained)nodeArray.get(i);
                        if (!nodeRetained4.nodeId.equals(string)) continue;
                        nodeRetained3 = nodeRetained4;
                        break;
                    }
                    if (nodeRetained3 != object2) continue;
                    return null;
                }
                if (!(nodeRetained3 instanceof GroupRetained) || !((GroupRetained)nodeRetained3).collisionTarget) continue;
                nodeRetained2 = nodeRetained3;
                transform3D = hashKey == null ? nodeRetained3.getCurrentLocalToVworld(null) : nodeRetained3.getCurrentLocalToVworld(hashKey);
            } while ((nodeRetained3 = nodeRetained3.parent) != null);
            nodeArray = nodeRetained2 == nodeRetained ? (Node[])unorderList.toArray(false) : (Node[])unorderList.toArray(nodeRetained2);
            object2 = new SceneGraphPath(locale, nodeArray, (Node)nodeRetained2.source);
            ((SceneGraphPath)object2).setTransform(transform3D);
            return object2;
        }
    }

    @Override
    void setTriggered() {
        if (this.collidingPath != null) {
            super.setTriggered();
        }
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure behaviorStructure) {
    }
}

