/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.network.FileDescriptor;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rdr.TimedOut;
import java.nio.ByteBuffer;

public class FdOutStream
extends OutStream {
    static final int DEFAULT_BUF_SIZE = 16384;
    static final int minBulkSize = 1024;
    protected FileDescriptor fd;
    protected boolean blocking;
    protected int timeoutms;
    protected int start;
    protected int sentUpTo;
    protected int offset;
    protected int bufSize;
    private long lastWrite;

    public FdOutStream(FileDescriptor fileDescriptor, boolean bl, int n, int n2) {
        this.fd = fileDescriptor;
        this.blocking = bl;
        this.timeoutms = n;
        this.bufSize = n2 > 0 ? n2 : 16384;
        this.b = new byte[this.bufSize];
        this.offset = 0;
        this.start = 0;
        this.sentUpTo = 0;
        this.ptr = 0;
        this.end = this.start + this.bufSize;
        this.lastWrite = System.currentTimeMillis();
    }

    public FdOutStream(FileDescriptor fileDescriptor) {
        this(fileDescriptor, true, -1, 0);
    }

    public void setTimeout(int n) {
        this.timeoutms = n;
    }

    public void setBlocking(boolean bl) {
        this.blocking = bl;
    }

    @Override
    public int length() {
        return this.offset + this.ptr - this.sentUpTo;
    }

    int bufferUsage() {
        return this.ptr - this.sentUpTo;
    }

    long getIdleTime() {
        return System.currentTimeMillis() - this.lastWrite;
    }

    @Override
    public void flush() {
        while (this.sentUpTo < this.ptr) {
            int n = this.writeWithTimeout(this.b, this.sentUpTo, this.ptr - this.sentUpTo, this.blocking ? this.timeoutms : 0);
            if (n == 0) {
                if (!this.blocking) break;
                throw new TimedOut();
            }
            this.sentUpTo += n;
            this.offset += n;
        }
        if (this.sentUpTo == this.ptr) {
            this.ptr = this.sentUpTo = this.start;
        }
    }

    @Override
    protected int overrun(int n, int n2) {
        int n3;
        if (n > this.bufSize) {
            throw new Exception("FdOutStream overrun: max itemSize exceeded");
        }
        this.flush();
        if (n > this.end - this.ptr) {
            if (this.sentUpTo - this.start > this.bufSize / 4 && n < this.bufSize - (this.ptr - this.sentUpTo)) {
                System.arraycopy(this.b, this.ptr, this.b, this.start, this.ptr - this.sentUpTo);
                this.ptr = this.start + (this.ptr - this.sentUpTo);
                this.sentUpTo = this.start;
            } else {
                n3 = this.blocking ? 1 : 0;
                this.blocking = true;
                this.flush();
                this.blocking = n3;
            }
        }
        if ((n3 = (this.end - this.ptr) / n) < n2) {
            return n3;
        }
        return n2;
    }

    private int writeWithTimeout(byte[] byArray, int n, int n2, int n3) {
        int n4;
        do {
            Integer n5 = n3 != -1 ? new Integer(n3) : null;
            try {
                n4 = this.fd.select(4, n5);
            }
            catch (java.lang.Exception exception) {
                System.out.println(exception.toString());
                throw new Exception(exception.getMessage());
            }
        } while (n4 < 0);
        if (n4 == 0) {
            return 0;
        }
        try {
            n4 = this.fd.write(ByteBuffer.wrap(byArray, n, n2), n2);
        }
        catch (java.lang.Exception exception) {
            throw new Exception(exception.getMessage());
        }
        this.lastWrite = System.currentTimeMillis();
        return n4;
    }

    public FileDescriptor getFd() {
        return this.fd;
    }

    public void setFd(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    public int getBufSize() {
        return this.bufSize;
    }
}

