/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import com.sun.star.script.framework.provider.beanshell.GlyphGutter;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceModel;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceView;
import com.sun.star.script.framework.provider.beanshell.UnsavedChangesListener;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class PlainSourceView
extends JScrollPane
implements ScriptSourceView,
DocumentListener {
    private final ScriptSourceModel model;
    private JTextArea ta;
    private GlyphGutter gg;
    private int linecount;
    private boolean isModified = false;
    private static final String undoKey = "Undo";
    private static final String redoKey = "Redo";
    private CompoundEdit compoundEdit = null;
    private static final int noLimit = -1;
    UndoManager undoManager;
    private List<UnsavedChangesListener> unsavedListener = new ArrayList<UnsavedChangesListener>();
    private static final Pattern tabPattern = Pattern.compile("^ *(\\t)");
    private static final Pattern indentationPattern = Pattern.compile("^([^\\S\\r\\n]*)(([^\\{])*\\{\\s*)*");

    public PlainSourceView(ScriptSourceModel model) {
        this.model = model;
        this.initUI();
        model.setView(this);
    }

    @Override
    public void undo() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undoManager.addEdit(this.compoundEdit);
            this.compoundEdit = null;
        }
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
        if (!this.undoManager.canUndo()) {
            this.setModified(false);
        }
    }

    @Override
    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    @Override
    public void clear() {
        this.ta.setText("");
    }

    @Override
    public void update() {
        this.ta.getDocument().removeDocumentListener(this);
        if (!this.isModified) {
            int pos = this.ta.getCaretPosition();
            this.ta.setText(this.model.getText());
            try {
                this.ta.setCaretPosition(pos);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            int line = this.ta.getLineStartOffset(this.model.getCurrentPosition());
            Rectangle rect = this.ta.modelToView(line);
            if (rect != null) {
                this.ta.scrollRectToVisible(rect);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.gg.repaint();
        this.ta.getDocument().addDocumentListener(this);
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    private void notifyListeners(boolean isUnsaved) {
        for (UnsavedChangesListener listener : this.unsavedListener) {
            listener.onUnsavedChanges(isUnsaved);
        }
    }

    @Override
    public void setModified(boolean value) {
        if (value != this.isModified) {
            this.notifyListeners(value);
            this.isModified = value;
        }
    }

    private void initUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ta = new JTextArea();
        this.ta.setTabSize(4);
        this.ta.setRows(15);
        this.ta.setColumns(40);
        this.ta.setLineWrap(false);
        this.ta.insert(this.model.getText(), 0);
        this.ta.setFont(new Font("Monospaced", this.ta.getFont().getStyle(), this.ta.getFont().getSize()));
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(-1);
        this.ta.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent editEvent) {
                if (PlainSourceView.this.compoundEdit == null) {
                    PlainSourceView.this.compoundEdit = new CompoundEdit();
                }
                PlainSourceView.this.compoundEdit.addEdit(editEvent.getEdit());
            }
        });
        this.ta.getInputMap().put(KeyStroke.getKeyStroke(90, 2), undoKey);
        this.ta.getInputMap().put(KeyStroke.getKeyStroke(89, 2), redoKey);
        this.ta.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                Matcher matcher;
                int endOffset;
                int startOffset;
                int lineOffset;
                int caretOffset2;
                if (ke.isShiftDown() && ke.getKeyCode() == 9) {
                    try {
                        caretOffset2 = PlainSourceView.this.ta.getCaretPosition();
                        lineOffset = PlainSourceView.this.ta.getLineOfOffset(caretOffset2);
                        startOffset = PlainSourceView.this.ta.getLineStartOffset(lineOffset);
                        endOffset = PlainSourceView.this.ta.getLineEndOffset(lineOffset);
                        matcher = tabPattern.matcher(PlainSourceView.this.ta.getText(startOffset, endOffset - startOffset));
                        if (matcher.find()) {
                            PlainSourceView.this.ta.replaceRange(null, startOffset + matcher.start(1), startOffset + matcher.end(1));
                        }
                    }
                    catch (BadLocationException caretOffset2) {
                        // empty catch block
                    }
                }
                if (ke.getKeyCode() == 10) {
                    try {
                        caretOffset2 = PlainSourceView.this.ta.getCaretPosition();
                        lineOffset = PlainSourceView.this.ta.getLineOfOffset(caretOffset2);
                        startOffset = PlainSourceView.this.ta.getLineStartOffset(lineOffset);
                        endOffset = PlainSourceView.this.ta.getLineEndOffset(lineOffset);
                        matcher = indentationPattern.matcher(PlainSourceView.this.ta.getText(startOffset, endOffset - startOffset));
                        PlainSourceView.this.ta.insert("\n", caretOffset2++);
                        if (matcher.find()) {
                            if (matcher.group(1).length() > 0) {
                                PlainSourceView.this.ta.insert(matcher.group(1), caretOffset2++);
                            }
                            if (matcher.group(3) != null) {
                                PlainSourceView.this.ta.insert("\t", caretOffset2);
                            }
                        }
                        ke.consume();
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 32 || ke.getKeyCode() == 10) {
                    PlainSourceView.this.compoundEdit.end();
                    PlainSourceView.this.undoManager.addEdit(PlainSourceView.this.compoundEdit);
                    PlainSourceView.this.compoundEdit = null;
                }
            }
        });
        this.ta.getActionMap().put(undoKey, new AbstractAction(undoKey){

            @Override
            public void actionPerformed(ActionEvent event) {
                PlainSourceView.this.undo();
            }
        });
        this.ta.getActionMap().put(redoKey, new AbstractAction(redoKey){

            @Override
            public void actionPerformed(ActionEvent event) {
                PlainSourceView.this.redo();
            }
        });
        this.linecount = this.ta.getLineCount();
        this.gg = new GlyphGutter(this);
        this.setViewportView(this.ta);
        this.setRowHeaderView(this.gg);
        this.ta.getDocument().addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.doChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.doChanged();
    }

    private void doChanged() {
        this.setModified(true);
        if (this.linecount != this.ta.getLineCount()) {
            this.gg.update();
            this.linecount = this.ta.getLineCount();
        }
    }

    @Override
    public String getText() {
        return this.ta.getText();
    }

    public JTextArea getTextArea() {
        return this.ta;
    }

    public int getCurrentPosition() {
        return this.model.getCurrentPosition();
    }

    @Override
    public void addListener(UnsavedChangesListener toAdd) {
        this.unsavedListener.add(toAdd);
    }
}

