/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

final class BuildInfo {
    protected static final String BUILD_INFO_FILE = "build_info";
    private static final String[] order = new String[]{"Number", "Date", "Branding", "Branch", "Tag", "Hg ID"};
    private static final Pattern linePattern = Pattern.compile("(.+):\\s+((.+)\\z)");

    BuildInfo() {
    }

    static LogRecord logBuildInfoRec() {
        LogRecord rec = new LogRecord(Level.CONFIG, BUILD_INFO_FILE);
        List<String> buildInfo = BuildInfo.logBuildInfo();
        if (buildInfo != null) {
            rec.setParameters(buildInfo.toArray());
        }
        return rec;
    }

    static List<String> logBuildInfo() {
        List<String> lr = null;
        File f = InstalledFileLocator.getDefault().locate(BUILD_INFO_FILE, null, false);
        if (f != null) {
            lr = BuildInfo.logBuildInfo(f);
        }
        return lr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> logBuildInfo(File f) {
        ArrayList<String> params = null;
        FileReader fr = null;
        try {
            String line;
            fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            Hashtable<String, String> map = new Hashtable<String, String>();
            while ((line = br.readLine()) != null) {
                Matcher m = linePattern.matcher(line);
                if (!m.matches() || m.groupCount() <= 2) continue;
                map.put(m.group(1), m.group(2));
            }
            params = new ArrayList<String>();
            for (int i = 0; i < order.length; ++i) {
                String param = (String)map.get(order[i]);
                if (param != null) {
                    params.add(param);
                    continue;
                }
                params.add("");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return params;
    }
}

