/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import io.netty.channel.unix.Errors;
import java.time.Duration;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.netty.ChannelBindException;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

public class NettyWebServer
implements WebServer {
    private static final int ERROR_NO_EACCES = -13;
    private static final Log logger = LogFactory.getLog(NettyWebServer.class);
    private final HttpServer httpServer;
    private final ReactorHttpHandlerAdapter handlerAdapter;
    private final Duration lifecycleTimeout;
    private DisposableServer disposableServer;

    public NettyWebServer(HttpServer httpServer, ReactorHttpHandlerAdapter handlerAdapter, Duration lifecycleTimeout) {
        Assert.notNull((Object)httpServer, (String)"HttpServer must not be null");
        Assert.notNull((Object)handlerAdapter, (String)"HandlerAdapter must not be null");
        this.httpServer = httpServer;
        this.handlerAdapter = handlerAdapter;
        this.lifecycleTimeout = lifecycleTimeout;
    }

    @Override
    public void start() throws WebServerException {
        if (this.disposableServer == null) {
            try {
                this.disposableServer = this.startHttpServer();
            }
            catch (Exception ex) {
                ChannelBindException bindException = this.findBindException(ex);
                if (bindException != null && !this.isPermissionDenied(bindException.getCause())) {
                    throw new PortInUseException(bindException.localPort(), (Throwable)ex);
                }
                throw new WebServerException("Unable to start Netty", ex);
            }
            logger.info((Object)("Netty started on port(s): " + this.getPort()));
            this.startDaemonAwaitThread(this.disposableServer);
        }
    }

    private boolean isPermissionDenied(Throwable bindExceptionCause) {
        try {
            if (bindExceptionCause instanceof Errors.NativeIoException) {
                return ((Errors.NativeIoException)bindExceptionCause).expectedErr() == -13;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private DisposableServer startHttpServer() {
        if (this.lifecycleTimeout != null) {
            return this.httpServer.handle((BiFunction)this.handlerAdapter).bindNow(this.lifecycleTimeout);
        }
        return this.httpServer.handle((BiFunction)this.handlerAdapter).bindNow();
    }

    private ChannelBindException findBindException(Exception ex) {
        for (Throwable candidate = ex; candidate != null; candidate = candidate.getCause()) {
            if (!(candidate instanceof ChannelBindException)) continue;
            return (ChannelBindException)candidate;
        }
        return null;
    }

    private void startDaemonAwaitThread(final DisposableServer disposableServer) {
        Thread awaitThread = new Thread("server"){

            @Override
            public void run() {
                disposableServer.onDispose().block();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    @Override
    public void stop() throws WebServerException {
        if (this.disposableServer != null) {
            if (this.lifecycleTimeout != null) {
                this.disposableServer.disposeNow(this.lifecycleTimeout);
            } else {
                this.disposableServer.disposeNow();
            }
            this.disposableServer = null;
        }
    }

    @Override
    public int getPort() {
        if (this.disposableServer != null) {
            return this.disposableServer.port();
        }
        return 0;
    }
}

