/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.PostBasedAuthenticationMethodType;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.DefaultNameValuePair;
import org.zaproxy.zap.model.NameValuePair;
import org.zaproxy.zap.users.User;

public class FormBasedAuthenticationMethodType
extends PostBasedAuthenticationMethodType {
    private static final int METHOD_IDENTIFIER = 2;
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.fb.name");
    private static final String API_METHOD_NAME = "formBasedAuthentication";
    private static final Logger LOGGER = LogManager.getLogger(FormBasedAuthenticationMethodType.class);
    private static final UnaryOperator<String> PARAM_ENCODER = value -> {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    };
    private static final UnaryOperator<String> PARAM_DECODER = value -> {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Failed to URL decode: " + value, (Throwable)e);
        }
        return "";
    };

    public FormBasedAuthenticationMethodType() {
        super(METHOD_NAME, 2, API_METHOD_NAME, "authentication.method.fb.popup.login.request", false);
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod method) {
        return method instanceof FormBasedAuthenticationMethod;
    }

    @Override
    public FormBasedAuthenticationMethod createAuthenticationMethod(int contextId) {
        return new FormBasedAuthenticationMethod();
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return new FormBasedAuthenticationMethodOptionsPanel(uiSharedContext);
    }

    private class FormBasedAuthenticationMethodOptionsPanel
    extends PostBasedAuthenticationMethodType.PostBasedAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = 1L;

        public FormBasedAuthenticationMethodOptionsPanel(Context context) {
            super(FormBasedAuthenticationMethodType.this, context, PARAM_DECODER);
        }

        @Override
        protected List<NameValuePair> extractParameters(String postData) {
            ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
            this.getContext().getPostParamParser().parseParameters(postData).forEach(nvp -> parameters.add(new DefaultNameValuePair(nvp.getName(), nvp.getValue())));
            return parameters;
        }

        @Override
        protected String replaceParameterValue(String originalString, NameValuePair parameter, String replaceString) {
            String keyValueSeparator = this.getContext().getPostParamParser().getDefaultKeyValueSeparator();
            String nameAndSeparator = parameter.getName() + keyValueSeparator;
            if (originalString.contains(nameAndSeparator)) {
                return originalString.replace(nameAndSeparator + parameter.getValue(), nameAndSeparator + replaceString);
            }
            return originalString.replace(parameter.getName(), nameAndSeparator + replaceString);
        }
    }

    public class FormBasedAuthenticationMethod
    extends PostBasedAuthenticationMethodType.PostBasedAuthenticationMethod {
        public FormBasedAuthenticationMethod() {
            this(null);
        }

        private FormBasedAuthenticationMethod(FormBasedAuthenticationMethod formBasedAuthenticationMethod) {
            super(FormBasedAuthenticationMethodType.this, "application/x-www-form-urlencoded", PARAM_ENCODER, formBasedAuthenticationMethod);
        }

        @Override
        public AuthenticationMethodType getType() {
            return new FormBasedAuthenticationMethodType();
        }

        @Override
        protected AuthenticationMethod duplicate() {
            return new FormBasedAuthenticationMethod(this);
        }

        @Override
        public void replaceUserDataInPollRequest(HttpMessage msg, User user) {
            PostBasedAuthenticationMethodType.replaceUserCredentialsDataInPollRequest(msg, user, PARAM_ENCODER);
        }
    }
}

