/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr;

import java.io.File;
import java.io.IOException;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotsSupport;
import org.graalvm.visualvm.jfr.JFRSnapshotSupport;
import org.openide.util.NbBundle;

public abstract class JFRSnapshot
extends Snapshot {
    public JFRSnapshot(File file) throws IOException {
        this(file, null);
    }

    public JFRSnapshot(File file, DataSource master) throws IOException {
        super(file, JFRSnapshotSupport.getCategory(), master);
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File " + file.getAbsolutePath() + " does not exist");
        }
    }

    public boolean supportsSaveAs() {
        return this.getFile() != null;
    }

    public void saveAs() {
        SnapshotsSupport.getInstance().saveAs((Snapshot)this, NbBundle.getMessage(JFRSnapshot.class, (String)"LBL_Save_Core_Dump_As"));
    }
}

