/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class MathDetailsProvider
extends DetailsProvider.Basic {
    private static final String BIG_INTEGRER_MASK = "java.math.BigInteger";
    private static final String BIG_DECIMAL_MASK = "java.math.BigDecimal";
    private static final String FD_BIG_INTEGRER_MASK = "jdk.internal.math.FDBigInteger";

    public MathDetailsProvider() {
        super(BIG_INTEGRER_MASK, BIG_DECIMAL_MASK, FD_BIG_INTEGRER_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        if (BIG_INTEGRER_MASK.equals(className)) {
            BigInteger bint = this.getBigInteger(instance);
            if (bint != null) {
                return bint.toString();
            }
        } else if (BIG_DECIMAL_MASK.equals(className)) {
            String val = DetailsUtils.getInstanceFieldString(instance, "stringCache");
            if (val == null) {
                BigInteger bint;
                int scale = DetailsUtils.getIntFieldValue(instance, "scale", 0);
                long intCompact = DetailsUtils.getLongFieldValue(instance, "intCompact", Long.MIN_VALUE);
                if (intCompact != Long.MIN_VALUE) {
                    return BigDecimal.valueOf(intCompact, scale).toString();
                }
                Object bintInstace = instance.getValueOfField("intVal");
                if (bintInstace instanceof Instance && (bint = this.getBigInteger((Instance)bintInstace)) != null) {
                    return new BigDecimal(bint, scale).toString();
                }
            } else {
                return val;
            }
        }
        if (FD_BIG_INTEGRER_MASK.equals(className)) {
            Integer nWords = (Integer)instance.getValueOfField("nWords");
            Integer offset = (Integer)instance.getValueOfField("offset");
            int[] data = DetailsUtils.getIntArray(DetailsUtils.getPrimitiveArrayFieldValues(instance, "data"));
            if (nWords != null && offset != null && data != null) {
                byte[] magnitude = new byte[nWords * 4 + 1];
                for (int i = 0; i < nWords; ++i) {
                    int w = data[i];
                    magnitude[magnitude.length - 4 * i - 1] = (byte)w;
                    magnitude[magnitude.length - 4 * i - 2] = (byte)(w >> 8);
                    magnitude[magnitude.length - 4 * i - 3] = (byte)(w >> 16);
                    magnitude[magnitude.length - 4 * i - 4] = (byte)(w >> 24);
                }
                return new BigInteger(magnitude).shiftLeft(offset * 32).toString();
            }
        }
        return null;
    }

    private BigInteger getBigInteger(Instance instance) {
        int sig = DetailsUtils.getIntFieldValue(instance, "signum", Integer.MAX_VALUE);
        int[] mag = DetailsUtils.getIntArray(DetailsUtils.getPrimitiveArrayFieldValues(instance, "mag"));
        if (mag != null && sig != Integer.MAX_VALUE) {
            ByteBuffer buffer = ByteBuffer.allocate(mag.length * 4);
            IntBuffer intBuffer = buffer.asIntBuffer();
            intBuffer.put(mag);
            return new BigInteger(sig, buffer.array());
        }
        return null;
    }
}

