/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.system;

import bt747.sys.Generic;
import bt747.sys.interfaces.BT747RAFile;
import java.io.File;
import java.io.RandomAccessFile;

public final class J2SERAFile
implements BT747RAFile {
    private String filePath = null;
    private RandomAccessFile raf = null;
    private boolean isopen = false;
    private int lastError = 0;

    public J2SERAFile(String string) {
        this.filePath = string;
    }

    public J2SERAFile(String string, int n) {
        try {
            String string2;
            this.filePath = string;
            switch (n) {
                case 1: {
                    string2 = "r";
                    break;
                }
                case 2: {
                    string2 = "rw";
                    break;
                }
                case 4: {
                    string2 = "rw";
                    try {
                        new File(string).createNewFile();
                    }
                    catch (Exception exception) {
                        Generic.debug("File creation failed:" + string, exception);
                    }
                    break;
                }
                case 3: {
                    string2 = "rw";
                    break;
                }
                default: {
                    string2 = "r";
                }
            }
            if (n != 0) {
                this.raf = new RandomAccessFile(string, string2);
                if (n == 2) {
                    this.raf.seek(this.raf.length());
                }
                if (Generic.isDebug()) {
                    Generic.debug("Opened file " + string + " in mode " + n + " " + string2, null);
                }
                this.isopen = true;
            }
            return;
        }
        catch (Exception exception) {
            Generic.debug("Problem in file open " + string, exception);
            this.filePath = null;
            this.lastError = -1;
            return;
        }
    }

    @Override
    public final int getSize() {
        try {
            if (this.raf == null) {
                return (int)new File(this.filePath).length();
            }
            return (int)this.raf.length();
        }
        catch (Exception exception) {
            Generic.debug("getSize", exception);
            return 0;
        }
    }

    @Override
    public final boolean exists() {
        try {
            return new File(this.filePath).exists();
        }
        catch (Exception exception) {
            Generic.debug("exists", exception);
            return false;
        }
    }

    @Override
    public final boolean delete() {
        try {
            return new File(this.filePath).delete();
        }
        catch (Exception exception) {
            Generic.debug("delete", exception);
            return false;
        }
    }

    @Override
    public final boolean createDir() {
        try {
            return new File(this.filePath).mkdir();
        }
        catch (Exception exception) {
            Generic.debug("createDir", exception);
            return false;
        }
    }

    @Override
    public final boolean close() {
        try {
            if (this.isopen && this.raf != null) {
                this.isopen = false;
                this.raf.close();
            }
            return true;
        }
        catch (Exception exception) {
            Generic.debug("close", exception);
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public final boolean setPos(int n) {
        try {
            if (this.raf != null) {
                this.raf.seek(n);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            Generic.debug("setPos", exception);
            return false;
        }
    }

    @Override
    public final int getLastError() {
        return this.lastError;
    }

    @Override
    public final boolean isOpen() {
        if (this.raf != null) {
            return this.isopen;
        }
        return false;
    }

    @Override
    public final int writeBytes(byte[] byArray, int n, int n2) {
        try {
            this.raf.write(byArray, n, n2);
            return n2;
        }
        catch (Exception exception) {
            Generic.debug("writeBytes", exception);
            return 0;
        }
    }

    @Override
    public final int readBytes(byte[] byArray, int n, int n2) {
        try {
            return this.raf.read(byArray, n, n2);
        }
        catch (Exception exception) {
            Generic.debug("writeBytes", exception);
            return 0;
        }
    }

    @Override
    public final String getPath() {
        return this.filePath;
    }

    @Override
    public final int getModificationTime() {
        return (int)(new File(this.filePath).lastModified() / 1000L);
    }

    @Override
    public final void setModificationTime(int n) {
        new File(this.filePath).setLastModified((long)n * 1000L);
    }
}

