/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.MVTTile;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.MapboxVectorCachedTileLoader;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.MapboxVectorTileSource;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.Source;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.vector.VectorDataSet;
import org.openstreetmap.josm.data.vector.VectorNode;
import org.openstreetmap.josm.data.vector.VectorPrimitive;
import org.openstreetmap.josm.data.vector.VectorRelation;
import org.openstreetmap.josm.data.vector.VectorWay;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.tools.I18n;

public class MVTLayer
extends AbstractCachedTileSourceLayer<MapboxVectorTileSource>
implements MVTTile.TileListener {
    private static final String CACHE_REGION_NAME = "MVT";
    private static final Action[] EMPTY_ACTIONS = new Action[0];
    private final Map<String, Boolean> layerNames = new HashMap<String, Boolean>();
    private final VectorDataSet dataSet = new VectorDataSet();

    public MVTLayer(ImageryInfo info) {
        super(info);
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return MapboxVectorCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    @Override
    public Collection<String> getNativeProjections() {
        return Collections.singleton("EPSG:3857");
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        this.dataSet.setZoom(this.getZoomLevel());
        AbstractMapRenderer painter = MapRendererFactory.getInstance().createActiveRenderer(g, mv, false);
        painter.enableSlowOperations(mv.getMapMover() == null || !mv.getMapMover().movementInProgress() || OsmDataLayer.PROPERTY_HIDE_LABELS_WHILE_DRAGGING.get() == false);
        if (painter instanceof StyledMapRenderer && this.dataSet.getStyles() != null) {
            ((StyledMapRenderer)painter).setStyles(this.dataSet.getStyles());
        }
        painter.render(this.dataSet, false, box);
    }

    @Override
    protected MapboxVectorTileSource getTileSource() {
        MapboxVectorTileSource source = new MapboxVectorTileSource(this.info);
        this.info.setAttribution(source);
        if (source.getStyleSource() != null) {
            List<ElemStyles> styles = source.getStyleSource().getSources().entrySet().stream().filter(entry -> entry.getKey() == null || ((Source)entry.getKey()).getUrls().contains(source.getBaseUrl())).map(Map.Entry::getValue).collect(Collectors.toList());
            styles.stream().map(ElemStyles::getStyleSources).flatMap(Collection::stream).forEach(StyleSource::loadStyleSource);
            this.dataSet.setStyles(styles);
            this.setName(source.getName());
        }
        return source;
    }

    @Override
    public Tile createTile(MapboxVectorTileSource source, int x, int y, int zoom) {
        MVTTile tile = new MVTTile(source, x, y, zoom);
        tile.addTileLoaderFinisher(this);
        return tile;
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(super.getMenuEntries()));
        actions.add(Layer.SeparatorLayerAction.INSTANCE);
        if (ExpertToggleAction.isExpert()) {
            for (Map.Entry<String, Boolean> layerConfig : this.layerNames.entrySet()) {
                actions.add(new EnableLayerAction(layerConfig.getKey(), () -> this.layerNames.computeIfAbsent((String)layerConfig.getKey(), key -> true), layer -> {
                    this.layerNames.compute((String)layer, (key, value) -> Boolean.FALSE.equals(value));
                    this.dataSet.setInvisibleLayers(this.layerNames.entrySet().stream().filter(entry -> Boolean.FALSE.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()));
                    this.invalidate();
                }));
            }
            actions.add(Layer.SeparatorLayerAction.INSTANCE);
            actions.add(new ConvertLayerAction(this));
        }
        return actions.toArray(EMPTY_ACTIONS);
    }

    public VectorDataSet getData() {
        return this.dataSet;
    }

    @Override
    public void finishedLoading(MVTTile tile) {
        for (org.openstreetmap.josm.data.imagery.vectortile.mapbox.Layer layer : tile.getLayers()) {
            this.layerNames.putIfAbsent(layer.getName(), true);
        }
        this.dataSet.addTileData(tile);
    }

    private static class EnableLayerAction
    extends AbstractAction
    implements Layer.LayerAction {
        private final String layer;
        private final Consumer<String> consumer;
        private final BooleanSupplier state;

        EnableLayerAction(String layer, BooleanSupplier state, Consumer<String> consumer) {
            super(I18n.tr("Toggle layer {0}", layer));
            this.layer = layer;
            this.consumer = consumer;
            this.state = state;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.consumer.accept(this.layer);
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return layers.stream().allMatch(MVTLayer.class::isInstance);
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
            item.setSelected(this.state.getAsBoolean());
            return item;
        }
    }

    private static class ConvertLayerAction
    extends AbstractAction
    implements Layer.LayerAction {
        private final MVTLayer layer;

        ConvertLayerAction(MVTLayer layer) {
            this.layer = layer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            MainLayerManager manager = MainApplication.getLayerManager();
            VectorDataSet dataSet = this.layer.getData();
            DataSet osmData = new DataSet();
            HashMap<VectorNode, Node> nodeMap = new HashMap<VectorNode, Node>(dataSet.getNodes().size());
            for (VectorNode vectorNode : dataSet.getNodes()) {
                Node newNode = new Node(vectorNode.getCoor());
                if (vectorNode.isTagged()) {
                    vectorNode.getInterestingTags().forEach(newNode::put);
                    newNode.put("layer", vectorNode.getLayer());
                    newNode.put("id", Long.toString(vectorNode.getId()));
                }
                nodeMap.put(vectorNode, newNode);
            }
            HashMap<VectorWay, Way> wayMap = new HashMap<VectorWay, Way>(dataSet.getWays().size());
            for (VectorWay vectorWay : dataSet.getWays()) {
                Way newWay = new Way();
                List<Node> nodes = vectorWay.getNodes().stream().map(nodeMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                newWay.setNodes(nodes);
                if (vectorWay.isTagged()) {
                    vectorWay.getInterestingTags().forEach(newWay::put);
                    newWay.put("layer", vectorWay.getLayer());
                    newWay.put("id", Long.toString(vectorWay.getId()));
                }
                wayMap.put(vectorWay, newWay);
            }
            HashMap<VectorRelation, Relation> hashMap = new HashMap<VectorRelation, Relation>(dataSet.getRelations().size());
            for (VectorRelation vectorRelation : dataSet.getRelations()) {
                Relation newRelation = new Relation();
                if (vectorRelation.isTagged()) {
                    vectorRelation.getInterestingTags().forEach(newRelation::put);
                    newRelation.put("layer", vectorRelation.getLayer());
                    newRelation.put("id", Long.toString(vectorRelation.getId()));
                }
                List<RelationMember> members = vectorRelation.getMembers().stream().map(member -> {
                    VectorPrimitive vectorPrimitive = member.getMember();
                    OsmPrimitive primitive = vectorPrimitive instanceof VectorNode ? (OsmPrimitive)nodeMap.get(vectorPrimitive) : (vectorPrimitive instanceof VectorWay ? (OsmPrimitive)wayMap.get(vectorPrimitive) : (vectorPrimitive instanceof VectorRelation ? (OsmPrimitive)relationMap.get(vectorPrimitive) : null));
                    if (primitive == null) {
                        return null;
                    }
                    return new RelationMember(member.getRole(), primitive);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                newRelation.setMembers(members);
                hashMap.put(vectorRelation, newRelation);
            }
            try {
                osmData.beginUpdate();
                nodeMap.values().forEach(osmData::addPrimitive);
                wayMap.values().forEach(osmData::addPrimitive);
                hashMap.values().forEach(osmData::addPrimitive);
            }
            finally {
                osmData.endUpdate();
            }
            manager.addLayer(new OsmDataLayer(osmData, this.layer.getName(), null));
            manager.removeLayer(this.layer);
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return layers.stream().allMatch(MVTLayer.class::isInstance);
        }

        @Override
        public Component createMenuComponent() {
            JMenuItem menuItem = new JMenuItem(I18n.tr("Convert to OSM Data", new Object[0]));
            menuItem.addActionListener(this);
            return menuItem;
        }
    }
}

