/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.kotlin.org.apache.ivy.Ivy;
import org.jetbrains.kotlin.org.apache.ivy.core.event.EventManager;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.ResolveData;
import org.jetbrains.kotlin.org.apache.ivy.core.settings.IvySettings;
import org.jetbrains.kotlin.org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.org.apache.ivy.util.MessageLogger;

public class IvyContext {
    private static ThreadLocal<Stack<IvyContext>> current = new ThreadLocal();
    private Ivy defaultIvy;
    private WeakReference<Ivy> ivy = new WeakReference<Object>(null);
    private Map<String, Object> contextMap = new HashMap<String, Object>();
    private Thread operatingThread;
    private ResolveData resolveData;
    private DependencyDescriptor dd;

    public IvyContext() {
    }

    public IvyContext(IvyContext ctx) {
        this.defaultIvy = ctx.defaultIvy;
        this.ivy = ctx.ivy;
        this.contextMap = new HashMap<String, Object>(ctx.contextMap);
        this.operatingThread = ctx.operatingThread;
        this.resolveData = ctx.resolveData;
        this.dd = ctx.dd;
    }

    public static IvyContext getContext() {
        Stack<IvyContext> cur = IvyContext.getCurrentStack();
        if (cur.isEmpty()) {
            cur.push(new IvyContext());
        }
        return cur.peek();
    }

    private static Stack<IvyContext> getCurrentStack() {
        Stack<IvyContext> cur = current.get();
        if (cur == null) {
            cur = new Stack();
            current.set(cur);
        }
        return cur;
    }

    public static IvyContext pushNewContext() {
        return IvyContext.pushContext(new IvyContext());
    }

    public static IvyContext pushNewCopyContext() {
        return IvyContext.pushContext(new IvyContext(IvyContext.getContext()));
    }

    public static IvyContext pushContext(IvyContext context) {
        IvyContext.getCurrentStack().push(context);
        return context;
    }

    public static IvyContext popContext() {
        return IvyContext.getCurrentStack().pop();
    }

    public Ivy getIvy() {
        Ivy ivy = this.peekIvy();
        return ivy == null ? this.getDefaultIvy() : ivy;
    }

    public Ivy peekIvy() {
        return (Ivy)this.ivy.get();
    }

    private Ivy getDefaultIvy() {
        if (this.defaultIvy == null) {
            this.defaultIvy = Ivy.newInstance();
            try {
                this.defaultIvy.configureDefault();
            }
            catch (Exception e) {
                Message.debug(e);
            }
        }
        return this.defaultIvy;
    }

    public void setIvy(Ivy ivy) {
        this.ivy = new WeakReference<Ivy>(ivy);
        this.operatingThread = Thread.currentThread();
    }

    public IvySettings getSettings() {
        return this.getIvy().getSettings();
    }

    public CircularDependencyStrategy getCircularDependencyStrategy() {
        return this.getSettings().getCircularDependencyStrategy();
    }

    public <T> T get(String key) {
        WeakReference ref = (WeakReference)this.contextMap.get(key);
        return ref == null ? null : (T)ref.get();
    }

    public <T> void set(String key, T value) {
        this.contextMap.put(key, new WeakReference<T>(value));
    }

    public MessageLogger getMessageLogger() {
        Ivy ivy = this.peekIvy();
        if (ivy == null) {
            if (this.defaultIvy == null) {
                return Message.getDefaultLogger();
            }
            return this.defaultIvy.getLoggerEngine();
        }
        return ivy.getLoggerEngine();
    }

    public EventManager getEventManager() {
        return this.getIvy().getEventManager();
    }

    public void setResolveData(ResolveData data) {
        this.resolveData = data;
    }

    public ResolveData getResolveData() {
        return this.resolveData;
    }

    public void setDependencyDescriptor(DependencyDescriptor dd) {
        this.dd = dd;
    }

    public DependencyDescriptor getDependencyDescriptor() {
        return this.dd;
    }
}

