/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.ByteBufferWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class DirectBufferWrapper
extends ByteBufferWrapper {
    private static final ExecutorService ourAllocator = SystemInfo.isLinux && SystemProperties.getBooleanProperty("idea.limit.paged.storage.allocators", true) ? ConcurrencyUtil.newSingleThreadExecutor("DirectBufferWrapper allocation thread") : null;
    private volatile ByteBuffer myBuffer;

    DirectBufferWrapper(Path file2, long offset2, long length) {
        super(file2, offset2, length);
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.doCreate();
        }
        return buffer;
    }

    private ByteBuffer doCreate() throws IOException {
        if (ourAllocator != null) {
            try {
                return ourAllocator.submit(this::create).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)cause;
                }
                throw new RuntimeException(e);
            }
        }
        return this.create();
    }

    protected abstract ByteBuffer create() throws IOException;

    @Override
    public void release() {
        if (this.isDirty()) {
            this.flush();
        }
        if (this.myBuffer != null) {
            ByteBufferUtil.cleanBuffer(this.myBuffer);
            this.myBuffer = null;
        }
    }
}

