/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CodeAnalysisMeasurement;
import org.jetbrains.kotlin.cli.common.CodeGenerationMeasurement;
import org.jetbrains.kotlin.cli.common.CompilerInitializationMeasurement;
import org.jetbrains.kotlin.cli.common.GarbageCollectionMeasurement;
import org.jetbrains.kotlin.cli.common.IRMeasurement;
import org.jetbrains.kotlin.cli.common.JitCompilationMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceCounterMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0016\b&\u0018\u00002\u00020\u0001:\u0001EB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020+J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d00J\u0006\u00101\u001a\u00020\u0003J\b\u00102\u001a\u00020+H\u0016J\b\u00103\u001a\u00020+H\u0016J\b\u00104\u001a\u00020+H\u0016J \u00105\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0003H\u0016J\b\u00106\u001a\u00020+H\u0016J\b\u00107\u001a\u00020+H\u0016J\b\u00108\u001a\u00020+H\u0016J\b\u00109\u001a\u00020+H\u0016J\b\u0010:\u001a\u00020+H\u0016J\b\u0010;\u001a\u00020+H\u0016J\b\u0010<\u001a\u00020+H\u0016J\b\u0010=\u001a\u00020+H\u0016J\u0018\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\bH\u0016J\b\u0010A\u001a\u00020+H\u0002J\b\u0010B\u001a\u00020+H\u0002J\b\u0010C\u001a\u00020+H\u0002J\b\u0010D\u001a\u00020+H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\fR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020$0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "", "presentableName", "", "(Ljava/lang/String;)V", "analysisStart", "", "files", "", "getFiles", "()Ljava/lang/Integer;", "setFiles", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "generationStart", "initStartNanos", "irGenerationStart", "irLoweringStart", "irTranslationStart", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "lines", "getLines", "setLines", "measurements", "", "Lorg/jetbrains/kotlin/cli/common/PerformanceMeasurement;", "measurements$annotations", "()V", "getMeasurements", "()Ljava/util/List;", "startGCData", "", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager$GCData;", "targetDescription", "createPerformanceReport", "", "deltaTime", "start", "dumpPerformanceReport", "", "destination", "Ljava/io/File;", "enableCollectingPerformanceStatistics", "getMeasurementResults", "", "getTargetInfo", "notifyAnalysisFinished", "notifyAnalysisStarted", "notifyCompilationFinished", "notifyCompilerInitialized", "notifyGenerationFinished", "notifyGenerationStarted", "notifyIRGenerationFinished", "notifyIRGenerationStarted", "notifyIRLoweringFinished", "notifyIRLoweringStarted", "notifyIRTranslationFinished", "notifyIRTranslationStarted", "notifyRepeat", "total", "number", "recordGcTime", "recordInitializationTime", "recordJitCompilationTime", "recordPerfCountersMeasurements", "GCData", "cli"})
public abstract class CommonCompilerPerformanceManager {
    @NotNull
    private final String presentableName;
    @NotNull
    private final List<PerformanceMeasurement> measurements;
    private boolean isEnabled;
    private long initStartNanos;
    private long analysisStart;
    private long generationStart;
    @NotNull
    private Map<String, GCData> startGCData;
    private long irTranslationStart;
    private long irLoweringStart;
    private long irGenerationStart;
    @Nullable
    private String targetDescription;
    @Nullable
    private Integer files;
    @Nullable
    private Integer lines;

    public CommonCompilerPerformanceManager(@NotNull String presentableName2) {
        Intrinsics.checkParameterIsNotNull(presentableName2, "presentableName");
        this.presentableName = presentableName2;
        boolean bl = false;
        this.measurements = new ArrayList();
        this.initStartNanos = PerformanceCounter.Companion.currentTime();
        bl = false;
        this.startGCData = new LinkedHashMap();
    }

    @NotNull
    protected final List<PerformanceMeasurement> getMeasurements() {
        return this.measurements;
    }

    protected static /* synthetic */ void measurements$annotations() {
    }

    protected final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Nullable
    protected final Integer getFiles() {
        return this.files;
    }

    protected final void setFiles(@Nullable Integer n) {
        this.files = n;
    }

    @Nullable
    protected final Integer getLines() {
        return this.lines;
    }

    protected final void setLines(@Nullable Integer n) {
        this.lines = n;
    }

    @NotNull
    public final String getTargetInfo() {
        return this.targetDescription + ", " + this.files + " files (" + this.lines + " lines)";
    }

    @NotNull
    public final List<PerformanceMeasurement> getMeasurementResults() {
        return this.measurements;
    }

    /*
     * WARNING - void declaration
     */
    public final void enableCollectingPerformanceStatistics() {
        void $this$associateTo$iv;
        this.isEnabled = true;
        PerformanceCounter.Companion.setTimeCounterEnabled(true);
        Iterable<GarbageCollectorMXBean> iterable = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(iterable, "getGarbageCollectorMXBeans()");
        iterable = iterable;
        Map<String, GCData> destination$iv = this.startGCData;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map<String, GCData> map = destination$iv;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull(it, "it");
            Pair<String, GCData> pair = TuplesKt.to(string2, new GCData(it));
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
    }

    private final long deltaTime(long start) {
        return PerformanceCounter.Companion.currentTime() - start;
    }

    public void notifyCompilerInitialized(int files2, int lines, @NotNull String targetDescription) {
        Intrinsics.checkParameterIsNotNull(targetDescription, "targetDescription");
        if (!this.isEnabled) {
            return;
        }
        this.recordInitializationTime();
        this.files = files2;
        this.lines = lines;
        this.targetDescription = targetDescription;
    }

    public void notifyCompilationFinished() {
        if (!this.isEnabled) {
            return;
        }
        this.recordGcTime();
        this.recordJitCompilationTime();
        this.recordPerfCountersMeasurements();
    }

    public void notifyAnalysisStarted() {
        this.analysisStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyAnalysisFinished() {
        long time = PerformanceCounter.Companion.currentTime() - this.analysisStart;
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this;
        Collection collection = commonCompilerPerformanceManager.measurements;
        CodeAnalysisMeasurement codeAnalysisMeasurement = new CodeAnalysisMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time));
        boolean bl = false;
        collection.add(codeAnalysisMeasurement);
    }

    public void notifyGenerationStarted() {
        this.generationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyGenerationFinished() {
        long time = PerformanceCounter.Companion.currentTime() - this.generationStart;
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this;
        Collection collection = commonCompilerPerformanceManager.measurements;
        CodeGenerationMeasurement codeGenerationMeasurement = new CodeGenerationMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time));
        boolean bl = false;
        collection.add(codeGenerationMeasurement);
    }

    public void notifyIRTranslationStarted() {
        this.irTranslationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRTranslationFinished() {
        long time = this.deltaTime(this.irTranslationStart);
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this;
        Collection collection = commonCompilerPerformanceManager.measurements;
        IRMeasurement iRMeasurement = new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.TRANSLATION);
        boolean bl = false;
        collection.add(iRMeasurement);
    }

    public void notifyIRLoweringStarted() {
        this.irLoweringStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRLoweringFinished() {
        long time = this.deltaTime(this.irLoweringStart);
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this;
        Collection collection = commonCompilerPerformanceManager.measurements;
        IRMeasurement iRMeasurement = new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.LOWERING);
        boolean bl = false;
        collection.add(iRMeasurement);
    }

    public void notifyIRGenerationStarted() {
        this.irGenerationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRGenerationFinished() {
        long time = this.deltaTime(this.irGenerationStart);
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this;
        Collection collection = commonCompilerPerformanceManager.measurements;
        IRMeasurement iRMeasurement = new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.GENERATION);
        boolean bl = false;
        collection.add(iRMeasurement);
    }

    public final void dumpPerformanceReport(@NotNull File destination) {
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        FilesKt.writeBytes(destination, this.createPerformanceReport());
    }

    private final void recordGcTime() {
        if (!this.isEnabled) {
            return;
        }
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(list2, "getGarbageCollectorMXBeans()");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            GCData startCounts = this.startGCData.get(it.getName());
            GCData gCData = startCounts;
            long startCollectionTime = gCData == null ? 0L : gCData.getCollectionTime();
            Object object = startCounts;
            long startCollectionCount = object == null ? 0L : ((GCData)object).getCollectionCount();
            object = this;
            Collection collection = ((CommonCompilerPerformanceManager)object).getMeasurements();
            Object object2 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull(object2, "it.name");
            object2 = new GarbageCollectionMeasurement((String)object2, it.getCollectionTime() - startCollectionTime, it.getCollectionCount() - startCollectionCount);
            boolean bl2 = false;
            collection.add(object2);
        }
    }

    private final void recordJitCompilationTime() {
        if (!this.isEnabled) {
            return;
        }
        Object object = ManagementFactory.getCompilationMXBean();
        if (object == null) {
            return;
        }
        CompilationMXBean bean = object;
        object = this;
        Collection collection = ((CommonCompilerPerformanceManager)object).measurements;
        JitCompilationMeasurement jitCompilationMeasurement = new JitCompilationMeasurement(bean.getTotalCompilationTime());
        boolean bl = false;
        collection.add(jitCompilationMeasurement);
    }

    private final void recordInitializationTime() {
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.initStartNanos);
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this;
        Collection collection = commonCompilerPerformanceManager.measurements;
        CompilerInitializationMeasurement compilerInitializationMeasurement = new CompilerInitializationMeasurement(time);
        boolean bl = false;
        collection.add(compilerInitializationMeasurement);
    }

    private final void recordPerfCountersMeasurements() {
        PerformanceCounter.Companion.report((Function1<? super String, Unit>)new Function1<String, Unit>(this){
            final /* synthetic */ CommonCompilerPerformanceManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull(s, "s");
                CommonCompilerPerformanceManager commonCompilerPerformanceManager = this.this$0;
                Collection collection = commonCompilerPerformanceManager.getMeasurements();
                PerformanceCounterMeasurement performanceCounterMeasurement = new PerformanceCounterMeasurement(s);
                boolean bl = false;
                collection.add(performanceCounterMeasurement);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] createPerformanceReport() {
        void $this$mapTo$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        Comparable<StringBuilder> comparable = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$createPerformanceReport_u24lambda_u2d4 = comparable;
        boolean bl5 = false;
        $this$createPerformanceReport_u24lambda_u2d4.append(Intrinsics.stringPlus(this.presentableName, " performance report\n"));
        Iterable $this$map$iv = this.getMeasurements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            String string2 = it.render();
            collection.add(string2);
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((List)destination$iv$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl7 = false;
            $this$createPerformanceReport_u24lambda_u2d4.append(Intrinsics.stringPlus(it, "\n"));
        }
        String string3 = comparable.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        String string4 = string3;
        comparable = Charsets.UTF_8;
        bl3 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string5.getBytes((Charset)comparable);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public void notifyRepeat(int total, int number) {
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager$GCData;", "", "bean", "Ljava/lang/management/GarbageCollectorMXBean;", "(Ljava/lang/management/GarbageCollectorMXBean;)V", "name", "", "collectionTime", "", "collectionCount", "(Ljava/lang/String;JJ)V", "getCollectionCount", "()J", "getCollectionTime", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "cli"})
    private static final class GCData {
        @NotNull
        private final String name;
        private final long collectionTime;
        private final long collectionCount;

        public GCData(@NotNull String name, long collectionTime, long collectionCount) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.name = name;
            this.collectionTime = collectionTime;
            this.collectionCount = collectionCount;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getCollectionTime() {
            return this.collectionTime;
        }

        public final long getCollectionCount() {
            return this.collectionCount;
        }

        public GCData(@NotNull GarbageCollectorMXBean bean) {
            Intrinsics.checkParameterIsNotNull(bean, "bean");
            String string2 = bean.getName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "bean.name");
            this(string2, bean.getCollectionTime(), bean.getCollectionCount());
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.collectionTime;
        }

        public final long component3() {
            return this.collectionCount;
        }

        @NotNull
        public final GCData copy(@NotNull String name, long collectionTime, long collectionCount) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return new GCData(name, collectionTime, collectionCount);
        }

        public static /* synthetic */ GCData copy$default(GCData gCData, String string2, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = gCData.name;
            }
            if ((n & 2) != 0) {
                l = gCData.collectionTime;
            }
            if ((n & 4) != 0) {
                l2 = gCData.collectionCount;
            }
            return gCData.copy(string2, l, l2);
        }

        @NotNull
        public String toString() {
            return "GCData(name=" + this.name + ", collectionTime=" + this.collectionTime + ", collectionCount=" + this.collectionCount + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.collectionTime);
            result2 = result2 * 31 + Long.hashCode(this.collectionCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GCData)) {
                return false;
            }
            GCData gCData = (GCData)other;
            if (!Intrinsics.areEqual(this.name, gCData.name)) {
                return false;
            }
            if (this.collectionTime != gCData.collectionTime) {
                return false;
            }
            return this.collectionCount == gCData.collectionCount;
        }
    }
}

