/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.layout.Region;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Optional<NestedTableColumnHeader> getRootHeaderFrom(TableHeaderRow tableHeaderRow) {
        try {
            Method method = tableHeaderRow.getClass().getDeclaredMethod("getRootHeader", new Class[0]);
            method.setAccessible(true);
            return Optional.of((NestedTableColumnHeader)method.invoke((Object)tableHeaderRow, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<Region> columnReorderLine(NestedTableColumnHeader tableColumnHeader) {
        try {
            Field field = tableColumnHeader.getClass().getDeclaredField("columnReorderLine");
            field.setAccessible(true);
            return Optional.of((Region)field.get(tableColumnHeader));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static void recreateCells(VirtualFlow flow) {
        Class<?> clazz = flow.getClass();
        try {
            Method method = clazz.getDeclaredMethod("recreateCells", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)flow, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot recreate cells on VirtualFlow");
        }
    }

    public static void rebuildCells(VirtualFlow flow) {
        Class<?> clazz = flow.getClass();
        try {
            Method method = clazz.getDeclaredMethod("rebuildCells", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)flow, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot rebuild cells on VirtualFlow");
        }
    }

    public static void reconfigureCells(VirtualFlow flow) {
        Class<?> clazz = flow.getClass();
        try {
            Method method = clazz.getDeclaredMethod("reconfigureCells", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)flow, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot reconfigure cells on VirtualFlow");
        }
    }

    public static void resizeCellSize(VirtualFlow flow, IndexedCell cell) {
        Class<?> clazz = flow.getClass();
        try {
            Method method = clazz.getDeclaredMethod("resizeCellSize", cell.getClass());
            method.setAccessible(true);
            method.invoke((Object)flow, cell);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot resize cell size on VirtualFlow");
        }
    }

    public static List getCells(VirtualFlow flow) {
        Class<?> clazz = flow.getClass();
        try {
            Method method = clazz.getDeclaredMethod("getCells", new Class[0]);
            method.setAccessible(true);
            return (List)method.invoke((Object)flow, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static Optional<IndexedCell<?>> getCellWithinViewPort(VirtualFlow flow, String methodName) {
        Class<?> clazz = flow.getClass();
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return Optional.of((IndexedCell)method.invoke((Object)flow, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<ScrollBar> getBar(VirtualFlow flow, String methodName) {
        Class<?> clazz = flow.getClass();
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return Optional.of((ScrollBar)method.invoke((Object)flow, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static VirtualFlow getVirtualFlow(VirtualContainerBase virtualContainerBase) {
        Class<?> clazz = virtualContainerBase.getClass();
        try {
            Field field = clazz.getSuperclass().getDeclaredField("flow");
            field.setAccessible(true);
            return (VirtualFlow)field.get(virtualContainerBase);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Could not fetch VirtualFlow from VirtualContainerBase");
        }
    }

    public static Optional<TableHeaderRow> getTableHeaderRowFrom(TableViewSkin<?> skin) {
        try {
            Method method = skin.getClass().getSuperclass().getDeclaredMethod("getTableHeaderRow", new Class[0]);
            method.setAccessible(true);
            return Optional.of((TableHeaderRow)method.invoke(skin, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<TableViewSkinBase<?, ?, ?, ?, TableColumnBase<?, ?>>> getTableSkin(NestedTableColumnHeader tableColumnHeader) {
        try {
            Method method = tableColumnHeader.getClass().getDeclaredMethod("getTableSkin", new Class[0]);
            method.setAccessible(true);
            return Optional.of((TableViewSkinBase)method.invoke((Object)tableColumnHeader, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static VirtualFlow getVirtualFlow(TableViewSkinBase tableViewSkinBase) {
        Class<?> clazz = tableViewSkinBase.getClass();
        try {
            Field field = clazz.getDeclaredField("flow");
            field.setAccessible(true);
            return (VirtualFlow)field.get(tableViewSkinBase);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Cannot fetch VirtualFlow from TableViewSkinBase");
        }
    }

    public static Integer onScroll(TableViewSkinBase tableViewSkinBase, String methodName, Boolean bool) {
        Class<?> clazz = tableViewSkinBase.getClass();
        try {
            Method method = clazz.getDeclaredMethod(methodName, Boolean.class);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)tableViewSkinBase, bool);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void setTraversalEngine(Control control, Object engine) {
        try {
            Class<?> parentHelper = Class.forName("com.sun.javafx.scene.ParentHelper");
            Method method = parentHelper.getMethod("setTraversalEngine", Parent.class, engine.getClass());
            method.setAccessible(true);
            method.invoke(parentHelper, control, engine);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot set Traversal Engine");
        }
    }

    public static void callMethod(Object object, String methodName, Object ... params) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getDeclaredMethod(methodName, (Class[])Arrays.stream(params).map(Object::getClass).toArray(Class[]::new));
            method.setAccessible(true);
            method.invoke(object, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot call method " + methodName + " on " + object.getClass());
        }
    }
}

