/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.ScaleSimple;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.WithSprite;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandFactorySprite;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.DataSourceImpl;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;
import net.sourceforge.plantuml.salt.factory.ElementFactory;
import net.sourceforge.plantuml.salt.factory.ElementFactoryBorder;
import net.sourceforge.plantuml.salt.factory.ElementFactoryButton;
import net.sourceforge.plantuml.salt.factory.ElementFactoryCheckboxOff;
import net.sourceforge.plantuml.salt.factory.ElementFactoryCheckboxOn;
import net.sourceforge.plantuml.salt.factory.ElementFactoryDroplist;
import net.sourceforge.plantuml.salt.factory.ElementFactoryImage;
import net.sourceforge.plantuml.salt.factory.ElementFactoryLine;
import net.sourceforge.plantuml.salt.factory.ElementFactoryMenu;
import net.sourceforge.plantuml.salt.factory.ElementFactoryPyramid;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRadioOff;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRadioOn;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRetrieveFromDictonnary;
import net.sourceforge.plantuml.salt.factory.ElementFactoryScroll;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTab;
import net.sourceforge.plantuml.salt.factory.ElementFactoryText;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTextField;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTree;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class PSystemSalt
extends TitledDiagram
implements WithSprite {
    private final List<String> data;
    private final Dictionary dictionary = new Dictionary();
    private boolean iamSalt;

    @Deprecated
    public PSystemSalt(UmlSource source, List<String> data) {
        super(source, UmlDiagramType.SALT);
        this.data = data;
    }

    public PSystemSalt(UmlSource source) {
        this(source, new ArrayList<String>());
    }

    public void add(String s) {
        this.data.add(s);
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        try {
            Element salt = this.createElement(this.manageSprite());
            StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.getSkinParam());
            Dimension2D size = salt.getPreferredDimension(stringBounder, 0.0, 0.0);
            return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock(salt, size)).write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
            UmlDiagram.exportDiagramError(os, e, fileFormatOption, this.seed(), this.getMetadata(), "none", new ArrayList<String>());
            return ImageDataSimple.error();
        }
    }

    private TextBlockBackcolored getTextBlock(final Element salt, final Dimension2D size) {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(HColorUtils.BLACK);
                salt.drawU(ug, 0, new Dimension2DDouble(size.getWidth(), size.getHeight()));
                salt.drawU(ug, 1, new Dimension2DDouble(size.getWidth(), size.getHeight()));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return size;
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public HColor getBackcolor() {
                return PSystemSalt.this.getSkinParam().getBackgroundColor(false);
            }
        };
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Salt)");
    }

    @Override
    public void addSprite(String name, Sprite sprite) {
        this.dictionary.addSprite(name, sprite);
    }

    private List<String> manageSprite() {
        Command<WithSprite> cmd = new CommandFactorySprite().createMultiLine(false);
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> it = this.data.iterator();
        while (it.hasNext()) {
            String s = it.next();
            if (s.equals("hide stereotype") || s.startsWith("skinparam ")) continue;
            if (s.startsWith("scale ")) {
                double scale = Double.parseDouble(s.substring("scale ".length()));
                this.setScale(new ScaleSimple(scale));
                continue;
            }
            if (s.startsWith("sprite $")) {
                BlocLines bloc = BlocLines.singleString(s);
                do {
                    s = it.next();
                    bloc = bloc.addString(s);
                } while (!s.equals("}"));
                try {
                    CommandExecutionResult commandExecutionResult = cmd.execute(this, bloc);
                }
                catch (NoSuchColorException noSuchColorException) {}
                continue;
            }
            result.add(s);
        }
        return result;
    }

    private Element createElement(List<String> data) {
        DataSourceImpl source = new DataSourceImpl(data);
        ArrayList<AbstractElementFactoryComplex> cpx = new ArrayList<AbstractElementFactoryComplex>();
        cpx.add(new ElementFactoryPyramid(source, this.dictionary));
        cpx.add(new ElementFactoryScroll(source, this.dictionary));
        cpx.add(new ElementFactoryBorder(source, this.dictionary));
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : cpx) {
            PSystemSalt.addSimpleFactory(abstractElementFactoryComplex, source, this.dictionary);
        }
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : cpx) {
            for (AbstractElementFactoryComplex f2 : cpx) {
                abstractElementFactoryComplex.addFactory(f2);
            }
        }
        for (ElementFactory elementFactory : cpx) {
            if (!elementFactory.ready()) continue;
            Log.info("Using " + elementFactory);
            return elementFactory.create().getElement();
        }
        Log.println("data=" + data);
        throw new IllegalArgumentException();
    }

    private static void addSimpleFactory(AbstractElementFactoryComplex cpxFactory, DataSource source, Dictionary dictionary) {
        cpxFactory.addFactory(new ElementFactoryMenu(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryTree(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryTab(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryLine(source));
        cpxFactory.addFactory(new ElementFactoryTextField(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryButton(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryDroplist(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryRadioOn(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryRadioOff(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryCheckboxOn(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryCheckboxOff(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryImage(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryRetrieveFromDictonnary(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryText(source, dictionary));
    }

    public void setIamSalt(boolean iamSalt) {
        this.iamSalt = true;
    }

    public final boolean isIamSalt() {
        return this.iamSalt;
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.same(5.0);
    }
}

