/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.TimingStyle;
import net.sourceforge.plantuml.timingdiagram.graphic.Histogram;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.PDrawing;
import net.sourceforge.plantuml.timingdiagram.graphic.PlayerFrame;
import net.sourceforge.plantuml.timingdiagram.graphic.Ribbon;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class PlayerRobustConcise
extends Player {
    private final Set<ChangeState> changes = new TreeSet<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final List<TimingNote> notes = new ArrayList<TimingNote>();
    private final Map<String, String> statesLabel = new LinkedHashMap<String, String>();
    private final TimingStyle type;
    private String initialState;
    private PDrawing cached;
    private Colors initialColors;

    public PlayerRobustConcise(TimingStyle type, String full, ISkinParam skinParam, TimingRuler ruler, boolean compact) {
        super(full, skinParam, ruler, compact);
        this.type = type;
        this.suggestedHeight = 0;
    }

    private PDrawing buildPDrawing() {
        if (this.type == TimingStyle.CONCISE) {
            return new Ribbon(this.ruler, this.skinParam, this.notes, this.isCompact(), this.getTitle(), this.suggestedHeight);
        }
        if (this.type == TimingStyle.ROBUST) {
            return new Histogram(this.ruler, this.skinParam, this.statesLabel.values(), this.isCompact(), this.getTitle(), this.suggestedHeight);
        }
        throw new IllegalStateException();
    }

    @Override
    public final TextBlock getPart1(final double fullAvailableWidth, final double specialVSpace) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                if (!PlayerRobustConcise.this.isCompact()) {
                    new PlayerFrame(PlayerRobustConcise.this.getTitle()).drawFrameTitle(ug);
                }
                ug = ug.apply(PlayerRobustConcise.this.getTranslateForTimeDrawing(ug.getStringBounder())).apply(UTranslate.dy(specialVSpace));
                PlayerRobustConcise.this.getTimeDrawing().getPart1(fullAvailableWidth).drawU(ug);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return PlayerRobustConcise.this.getTimeDrawing().getPart1(fullAvailableWidth).calculateDimension(stringBounder);
            }
        };
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(PlayerRobustConcise.this.getTranslateForTimeDrawing(ug.getStringBounder()));
                PlayerRobustConcise.this.getTimeDrawing().getPart2().drawU(ug);
            }
        };
    }

    private UTranslate getTranslateForTimeDrawing(StringBounder stringBounder) {
        return UTranslate.dy(this.getTitleHeight(stringBounder));
    }

    @Override
    public final double getFullHeight(StringBounder stringBounder) {
        return this.getTitleHeight(stringBounder) + this.getZoneHeight(stringBounder);
    }

    private double getTitleHeight(StringBounder stringBounder) {
        if (this.isCompact()) {
            return 6.0;
        }
        return this.getTitle().calculateDimension(stringBounder).getHeight() + 6.0;
    }

    private PDrawing getTimeDrawing() {
        if (this.cached == null) {
            this.cached = this.computeTimeDrawing();
        }
        return this.cached;
    }

    private PDrawing computeTimeDrawing() {
        PDrawing result = this.buildPDrawing();
        result.setInitialState(this.initialState, this.initialColors);
        for (ChangeState change : this.changes) {
            result.addChange(change);
        }
        for (TimeConstraint constraint : this.constraints) {
            result.addConstraint(constraint);
        }
        return result;
    }

    private double getZoneHeight(StringBounder stringBounder) {
        return this.getTimeDrawing().getFullHeight(stringBounder);
    }

    @Override
    public final void setState(TimeTick now, String comment, Colors color, String ... states) {
        for (int i = 0; i < states.length; ++i) {
            states[i] = this.decodeState(states[i]);
        }
        if (now == null) {
            this.initialState = states[0];
            this.initialColors = color;
        } else {
            this.changes.add(new ChangeState(now, comment, color, states));
        }
    }

    private String decodeState(String code) {
        String label = this.statesLabel.get(code);
        if (label == null) {
            return code;
        }
        return label;
    }

    @Override
    public final IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        IntricatedPoint point = this.getTimeDrawing().getTimeProjection(stringBounder, tick);
        if (point == null) {
            return null;
        }
        UTranslate translation = this.getTranslateForTimeDrawing(stringBounder);
        return point.translated(translation);
    }

    @Override
    public final void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        this.constraints.add(new TimeConstraint(tick1, tick2, message, this.skinParam));
    }

    @Override
    public final void addNote(TimeTick now, Display note, Position position) {
        this.notes.add(new TimingNote(now, this, note, position, this.skinParam));
    }

    @Override
    public final void defineState(String stateCode, String label) {
        this.statesLabel.put(stateCode, label);
    }
}

