/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.awt.SunToolkit;
import sun.font.GlyphList;
import sun.font.XRGlyphCache;
import sun.font.XRGlyphCacheEntry;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.GlyphListPipe;
import sun.java2d.xr.GrowableEltArray;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;

public class XRTextRenderer
extends GlyphListPipe {
    XRGlyphCache glyphCache;
    XRCompositeManager maskBuffer;
    XRBackend backend;
    GrowableEltArray eltList;

    public XRTextRenderer(XRCompositeManager buffer) {
        this.glyphCache = new XRGlyphCache(buffer);
        this.maskBuffer = buffer;
        this.backend = buffer.getBackend();
        this.eltList = new GrowableEltArray(64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawGlyphList(SunGraphics2D sg2d, GlyphList gl) {
        if (gl.getNumGlyphs() == 0) {
            return;
        }
        try {
            SunToolkit.awtLock();
            XRSurfaceData x11sd = (XRSurfaceData)sg2d.surfaceData;
            x11sd.validateAsDestination(null, sg2d.getCompClip());
            x11sd.maskBuffer.validateCompositeState(sg2d.composite, sg2d.transform, sg2d.paint, sg2d);
            float advX = gl.getX();
            float advY = gl.getY();
            int oldPosX = 0;
            int oldPosY = 0;
            if (gl.isSubPixPos()) {
                advX += 0.1666667f;
                advY += 0.1666667f;
            } else {
                advX += 0.5f;
                advY += 0.5f;
            }
            XRGlyphCacheEntry[] cachedGlyphs = this.glyphCache.cacheGlyphs(gl);
            boolean containsLCDGlyphs = false;
            int activeGlyphSet = cachedGlyphs[0].getGlyphSet();
            int eltIndex = -1;
            gl.getBounds();
            float[] positions = gl.getPositions();
            for (int i = 0; i < gl.getNumGlyphs(); ++i) {
                gl.setGlyphIndex(i);
                XRGlyphCacheEntry cacheEntry = cachedGlyphs[i];
                if (cacheEntry == null) continue;
                this.eltList.getGlyphs().addInt(cacheEntry.getGlyphID());
                int glyphSet = cacheEntry.getGlyphSet();
                containsLCDGlyphs |= glyphSet == this.glyphCache.lcdGlyphSet;
                int posX = 0;
                int posY = 0;
                if (gl.usePositions() || cacheEntry.getXAdvance() != (float)cacheEntry.getXOff() || cacheEntry.getYAdvance() != (float)cacheEntry.getYOff() || eltIndex < 0 || glyphSet != activeGlyphSet) {
                    eltIndex = this.eltList.getNextIndex();
                    this.eltList.setCharCnt(eltIndex, 1);
                    activeGlyphSet = glyphSet;
                    this.eltList.setGlyphSet(eltIndex, glyphSet);
                    if (gl.usePositions()) {
                        float x = positions[i * 2] + advX;
                        float y = positions[i * 2 + 1] + advY;
                        posX = (int)Math.floor(x);
                        posY = (int)Math.floor(y);
                        advX -= (float)cacheEntry.getXOff();
                        advY -= (float)cacheEntry.getYOff();
                    } else {
                        posX = (int)Math.floor(advX);
                        posY = (int)Math.floor(advY);
                        advX += cacheEntry.getXAdvance() - (float)cacheEntry.getXOff();
                        advY += cacheEntry.getYAdvance() - (float)cacheEntry.getYOff();
                    }
                    this.eltList.setXOff(eltIndex, posX - oldPosX);
                    this.eltList.setYOff(eltIndex, posY - oldPosY);
                    oldPosX = posX;
                    oldPosY = posY;
                    continue;
                }
                this.eltList.setCharCnt(eltIndex, this.eltList.getCharCnt(eltIndex) + 1);
            }
            int maskFormat = containsLCDGlyphs ? 0 : 2;
            this.maskBuffer.compositeText(x11sd.picture, 0, maskFormat, this.eltList);
            this.eltList.clear();
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }
}

