/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.filters.CsrfPreventionFilterBase;

public class CsrfPreventionFilter
extends CsrfPreventionFilterBase {
    private final Set<String> entryPoints = new HashSet<String>();
    private int nonceCacheSize = 5;

    public void setEntryPoints(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            this.entryPoints.add(string2.trim());
        }
    }

    public void setNonceCacheSize(int n) {
        this.nonceCacheSize = n;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object object = null;
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            String string;
            HttpSession httpSession;
            LruCache<String> lruCache;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            boolean bl = false;
            if ("GET".equals(httpServletRequest.getMethod()) && this.entryPoints.contains(this.getRequestedPath(httpServletRequest))) {
                bl = true;
            }
            LruCache<String> lruCache2 = lruCache = (httpSession = httpServletRequest.getSession(false)) == null ? null : (LruCache<String>)httpSession.getAttribute("org.apache.catalina.filters.CSRF_NONCE");
            if (!bl) {
                string = httpServletRequest.getParameter("org.apache.catalina.filters.CSRF_NONCE");
                if (lruCache == null || string == null || !lruCache.contains(string)) {
                    httpServletResponse.sendError(this.getDenyStatus());
                    return;
                }
            }
            if (lruCache == null) {
                lruCache = new LruCache<String>(this.nonceCacheSize);
                if (httpSession == null) {
                    httpSession = httpServletRequest.getSession(true);
                }
                httpSession.setAttribute("org.apache.catalina.filters.CSRF_NONCE", lruCache);
            }
            string = this.generateNonce();
            lruCache.add(string);
            servletRequest.setAttribute("org.apache.catalina.filters.CSRF_REQUEST_NONCE", (Object)string);
            object = new CsrfResponseWrapper(httpServletResponse, string);
        } else {
            object = servletResponse;
        }
        filterChain.doFilter(servletRequest, object);
    }

    protected static class LruCache<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<T, T> cache;

        public LruCache(final int n) {
            this.cache = new LinkedHashMap<T, T>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<T, T> entry) {
                    return this.size() > n;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(T t) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                this.cache.put(t, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(T t) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                return this.cache.containsKey(t);
            }
        }
    }

    protected static class CsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private final String nonce;

        public CsrfResponseWrapper(HttpServletResponse httpServletResponse, String string) {
            super(httpServletResponse);
            this.nonce = string;
        }

        @Deprecated
        public String encodeRedirectUrl(String string) {
            return this.encodeRedirectURL(string);
        }

        public String encodeRedirectURL(String string) {
            return this.addNonce(super.encodeRedirectURL(string));
        }

        @Deprecated
        public String encodeUrl(String string) {
            return this.encodeURL(string);
        }

        public String encodeURL(String string) {
            return this.addNonce(super.encodeURL(string));
        }

        private String addNonce(String string) {
            int n;
            if (string == null || this.nonce == null) {
                return string;
            }
            String string2 = string;
            String string3 = "";
            String string4 = "";
            int n2 = string2.indexOf(35);
            if (n2 >= 0) {
                string4 = string2.substring(n2);
                string2 = string2.substring(0, n2);
            }
            if ((n = string2.indexOf(63)) >= 0) {
                string3 = string2.substring(n);
                string2 = string2.substring(0, n);
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (string3.length() > 0) {
                stringBuilder.append(string3);
                stringBuilder.append('&');
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append("org.apache.catalina.filters.CSRF_NONCE");
            stringBuilder.append('=');
            stringBuilder.append(this.nonce);
            stringBuilder.append(string4);
            return stringBuilder.toString();
        }
    }
}

