/* THIS FILE IS GENERATED - DO NOT EDIT (scripts/vk_validation_stats.py) */
/* Vulkan specification version: 1.2.184 */
/*
 * Vulkan
 *
 * Copyright (c) 2016-2021 Google Inc.
 * Copyright (c) 2016-2021 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Tobin Ehlis <tobine@google.com>
 * Author: Dave Houlton <daveh@lunarg.com>
 */

#pragma once

// Disable auto-formatting for generated file
// clang-format off

// Mapping from VUID string to the corresponding spec text
typedef struct _vuid_spec_text_pair {
    const char * vuid;
    const char * spec_text;
    const char * url_id;
} vuid_spec_text_pair;

static const vuid_spec_text_pair vuid_spec_text[] = {
    {"VUID-BaryCoordNV-BaryCoordNV-04154", "The BaryCoordNV decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordNV-BaryCoordNV-04155", "The variable decorated with BaryCoordNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordNV-BaryCoordNV-04156", "The variable decorated with BaryCoordNV must be declared as a three-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04157", "The BaryCoordNoPerspAMD decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04158", "The variable decorated with BaryCoordNoPerspAMD must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04159", "The variable decorated with BaryCoordNoPerspAMD must be declared as a two-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04163", "The BaryCoordNoPerspCentroidAMD decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04164", "The variable decorated with BaryCoordNoPerspCentroidAMD must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04165", "The variable decorated with BaryCoordNoPerspCentroidAMD must be declared as a three-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspNV-BaryCoordNoPerspNV-04160", "The BaryCoordNoPerspNV decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspNV-BaryCoordNoPerspNV-04161", "The variable decorated with BaryCoordNoPerspNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspNV-BaryCoordNoPerspNV-04162", "The variable decorated with BaryCoordNoPerspNV must be declared as a three-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04166", "The BaryCoordNoPerspSampleAMD decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04167", "The variable decorated with BaryCoordNoPerspSampleAMD must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04168", "The variable decorated with BaryCoordNoPerspSampleAMD must be declared as a two-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04169", "The BaryCoordPullModelAMD decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04170", "The variable decorated with BaryCoordPullModelAMD must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04171", "The variable decorated with BaryCoordPullModelAMD must be declared as a three-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04172", "The BaryCoordSmoothAMD decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04173", "The variable decorated with BaryCoordSmoothAMD must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04174", "The variable decorated with BaryCoordSmoothAMD must be declared as a two-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04175", "The BaryCoordSmoothCentroidAMD decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04176", "The variable decorated with BaryCoordSmoothCentroidAMD must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04177", "The variable decorated with BaryCoordSmoothCentroidAMD must be declared as a two-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04178", "The BaryCoordSmoothSampleAMD decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04179", "The variable decorated with BaryCoordSmoothSampleAMD must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04180", "The variable decorated with BaryCoordSmoothSampleAMD must be declared as a two-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-BaseInstance-BaseInstance-04181", "The BaseInstance decoration must be used only within the Vertex {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaseInstance-BaseInstance-04182", "The variable decorated with BaseInstance must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaseInstance-BaseInstance-04183", "The variable decorated with BaseInstance must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-BaseVertex-BaseVertex-04184", "The BaseVertex decoration must be used only within the Vertex {ExecutionModel}", "1.2-extensions"},
    {"VUID-BaseVertex-BaseVertex-04185", "The variable decorated with BaseVertex must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-BaseVertex-BaseVertex-04186", "The variable decorated with BaseVertex must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-ClipDistance-ClipDistance-04187", "The ClipDistance decoration must be used only within the MeshNV, Vertex, Fragment, TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-ClipDistance-ClipDistance-04188", "The variable decorated with ClipDistance within the MeshNV or Vertex {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-ClipDistance-ClipDistance-04189", "The variable decorated with ClipDistance within the Fragment {ExecutionModel} must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-ClipDistance-ClipDistance-04190", "The variable decorated with ClipDistance within the TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel} must not be declared in a {StorageClass} other than Input or Output", "1.2-extensions"},
    {"VUID-ClipDistance-ClipDistance-04191", "The variable decorated with ClipDistance must be declared as an array of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04192", "The ClipDistancePerViewNV decoration must be used only within the MeshNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04193", "The variable decorated with ClipDistancePerViewNV must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04194", "The variable decorated with ClipDistancePerViewNV must also be decorated with the PerViewNV decoration.", "1.2-extensions"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04195", "The variable decorated with ClipDistancePerViewNV must be declared as a two-dimensional array of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-CullDistance-CullDistance-04196", "The CullDistance decoration must be used only within the MeshNV, Vertex, Fragment, TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-CullDistance-CullDistance-04197", "The variable decorated with CullDistance within the MeshNV or Vertex {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-CullDistance-CullDistance-04198", "The variable decorated with CullDistance within the Fragment {ExecutionModel} must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-CullDistance-CullDistance-04199", "The variable decorated with CullDistance within the TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel} must not be declared using a {StorageClass} other than Input or Output", "1.2-extensions"},
    {"VUID-CullDistance-CullDistance-04200", "The variable decorated with CullDistance must be declared as an array of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04201", "The CullDistancePerViewNV decoration must be used only within the MeshNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04202", "The variable decorated with CullDistancePerViewNV must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04203", "The variable decorated with CullDistancePerViewNV must also be decorated with the PerViewNV decoration.", "1.2-extensions"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04204", "The variable decorated with CullDistancePerViewNV must be declared as a two-dimensional array of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04942", "The CurrentRayTimeNV decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04943", "The variable decorated with CurrentRayTimeNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04944", "The variable decorated with CurrentRayTimeNV must be declared as a scalar 32-bit floating-point value", "1.2-extensions"},
    {"VUID-DeviceIndex-DeviceIndex-04205", "The variable decorated with DeviceIndex must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-DeviceIndex-DeviceIndex-04206", "The variable decorated with DeviceIndex must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-DrawIndex-DrawIndex-04207", "The DrawIndex decoration must be used only within the Vertex, MeshNV, or TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-DrawIndex-DrawIndex-04208", "The variable decorated with DrawIndex must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-DrawIndex-DrawIndex-04209", "The variable decorated with DrawIndex must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-FragCoord-FragCoord-04210", "The FragCoord decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-FragCoord-FragCoord-04211", "The variable decorated with FragCoord must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-FragCoord-FragCoord-04212", "The variable decorated with FragCoord must be declared as a four-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-FragDepth-FragDepth-04213", "The FragDepth decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-FragDepth-FragDepth-04214", "The variable decorated with FragDepth must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-FragDepth-FragDepth-04215", "The variable decorated with FragDepth must be declared as a scalar 32-bit floating-point value", "1.2-extensions"},
    {"VUID-FragDepth-FragDepth-04216", "If the shader dynamically writes to the variable decorated with FragDepth, the DepthReplacing {ExecutionMode} must be declared", "1.2-extensions"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04217", "The FragInvocationCountEXT decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04218", "The variable decorated with FragInvocationCountEXT must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04219", "The variable decorated with FragInvocationCountEXT must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-FragSizeEXT-FragSizeEXT-04220", "The FragSizeEXT decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-FragSizeEXT-FragSizeEXT-04221", "The variable decorated with FragSizeEXT must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-FragSizeEXT-FragSizeEXT-04222", "The variable decorated with FragSizeEXT must be declared as a two-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04223", "The FragStencilRefEXT decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04224", "The variable decorated with FragStencilRefEXT must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04225", "The variable decorated with FragStencilRefEXT must be declared as a scalar integer value", "1.2-extensions"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04226", "The FragmentSizeNV decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04227", "The variable decorated with FragmentSizeNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04228", "The variable decorated with FragmentSizeNV must be declared as a two-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-FrontFacing-FrontFacing-04229", "The FrontFacing decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-FrontFacing-FrontFacing-04230", "The variable decorated with FrontFacing must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-FrontFacing-FrontFacing-04231", "The variable decorated with FrontFacing must be declared as a boolean value", "1.2-extensions"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04232", "The FullyCoveredEXT decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04233", "The variable decorated with FullyCoveredEXT must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04234", "The variable decorated with FullyCoveredEXT must be declared as a boolean value", "1.2-extensions"},
    {"VUID-FullyCoveredEXT-conservativeRasterizationPostDepthCoverage-04235", "If VkPhysicalDeviceConservativeRasterizationPropertiesEXT::conservativeRasterizationPostDepthCoverage is not supported the PostDepthCoverage {ExecutionMode} must not be declared, when a variable with the FullyCoveredEXT decoration is declared", "1.2-extensions"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04236", "The GlobalInvocationId decoration must be used only within the GLCompute, MeshNV, or TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04237", "The variable decorated with GlobalInvocationId must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04238", "The variable decorated with GlobalInvocationId must be declared as a three-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-HelperInvocation-HelperInvocation-04239", "The HelperInvocation decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-HelperInvocation-HelperInvocation-04240", "The variable decorated with HelperInvocation must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-HelperInvocation-HelperInvocation-04241", "The variable decorated with HelperInvocation must be declared as a boolean value", "1.2-extensions"},
    {"VUID-HitKindKHR-HitKindKHR-04242", "The HitKindKHR decoration must be used only within the AnyHitKHR or ClosestHitKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-HitKindKHR-HitKindKHR-04243", "The variable decorated with HitKindKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-HitKindKHR-HitKindKHR-04244", "The variable decorated with HitKindKHR must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-HitTNV-HitTNV-04245", "The HitTNV decoration must be used only within the AnyHitNV or ClosestHitNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-HitTNV-HitTNV-04246", "The variable decorated with HitTNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-HitTNV-HitTNV-04247", "The variable decorated with HitTNV must be declared as a scalar 32-bit floating-point value", "1.2-extensions"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04248", "The IncomingRayFlagsKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04249", "The variable decorated with IncomingRayFlagsKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04250", "The variable decorated with IncomingRayFlagsKHR must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04251", "The InstanceCustomIndexKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04252", "The variable decorated with InstanceCustomIndexKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04253", "The variable decorated with InstanceCustomIndexKHR must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-InstanceId-InstanceId-04254", "The InstanceId decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-InstanceId-InstanceId-04255", "The variable decorated with InstanceId must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-InstanceId-InstanceId-04256", "The variable decorated with InstanceId must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-InstanceIndex-InstanceIndex-04263", "The InstanceIndex decoration must be used only within the Vertex {ExecutionModel}", "1.2-extensions"},
    {"VUID-InstanceIndex-InstanceIndex-04264", "The variable decorated with InstanceIndex must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-InstanceIndex-InstanceIndex-04265", "The variable decorated with InstanceIndex must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-InvocationId-InvocationId-04257", "The InvocationId decoration must be used only within the TessellationControl or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-InvocationId-InvocationId-04258", "The variable decorated with InvocationId must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-InvocationId-InvocationId-04259", "The variable decorated with InvocationId must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04260", "The InvocationsPerPixelNV decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04261", "The variable decorated with InvocationsPerPixelNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04262", "The variable decorated with InvocationsPerPixelNV must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04266", "The LaunchIdKHR decoration must be used only within the RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04267", "The variable decorated with LaunchIdKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04268", "The variable decorated with LaunchIdKHR must be declared as a three-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04269", "The LaunchSizeKHR decoration must be used only within the RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04270", "The variable decorated with LaunchSizeKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04271", "The variable decorated with LaunchSizeKHR must be declared as a three-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-Layer-Layer-04272", "The Layer decoration must be used only within the MeshNV, Vertex, TessellationEvaluation, Geometry, or Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-Layer-Layer-04273", "If the shaderOutputLayer feature is not enabled then the Layer decoration must be used only within the Geometry or Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-Layer-Layer-04274", "The variable decorated with Layer within the MeshNV, Vertex, TessellationEvaluation, or Geometry {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-Layer-Layer-04275", "The variable decorated with Layer within the Fragment {ExecutionModel} must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-Layer-Layer-04276", "The variable decorated with Layer must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04277", "The LayerPerViewNV decoration must be used only within the MeshNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04278", "The variable decorated with LayerPerViewNV must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04279", "The variable decorated with LayerPerViewNV must also be decorated with the PerViewNV decoration.", "1.2-extensions"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04280", "The variable decorated with LayerPerViewNV must be declared as an array of scalar 32-bit integer values", "1.2-extensions"},
    {"VUID-LocalInvocationId-LocalInvocationId-04281", "The LocalInvocationId decoration must be used only within the GLCompute, MeshNV, or TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-LocalInvocationId-LocalInvocationId-04282", "The variable decorated with LocalInvocationId must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-LocalInvocationId-LocalInvocationId-04283", "The variable decorated with LocalInvocationId must be declared as a three-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04284", "The LocalInvocationIndex decoration must be used only within the GLCompute, MeshNV, or TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04285", "The variable decorated with LocalInvocationIndex must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04286", "The variable decorated with LocalInvocationIndex must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04287", "The MeshViewCountNV decoration must be used only within the MeshNV or TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04288", "The variable decorated with MeshViewCountNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04289", "The variable decorated with MeshViewCountNV must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04290", "The MeshViewIndicesNV decoration must be used only within the MeshNV or TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04291", "The variable decorated with MeshViewIndicesNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04292", "The variable decorated with MeshViewIndicesNV must be declared as an array of scalar 32-bit integer values", "1.2-extensions"},
    {"VUID-NumSubgroups-NumSubgroups-04293", "The NumSubgroups decoration must be used only within the GLCompute, MeshNV, or TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-NumSubgroups-NumSubgroups-04294", "The variable decorated with NumSubgroups must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-NumSubgroups-NumSubgroups-04295", "The variable decorated with NumSubgroups must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-NumWorkgroups-NumWorkgroups-04296", "The NumWorkgroups decoration must be used only within the GLCompute {ExecutionModel}", "1.2-extensions"},
    {"VUID-NumWorkgroups-NumWorkgroups-04297", "The variable decorated with NumWorkgroups must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-NumWorkgroups-NumWorkgroups-04298", "The variable decorated with NumWorkgroups must be declared as a three-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04299", "The ObjectRayDirectionKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04300", "The variable decorated with ObjectRayDirectionKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04301", "The variable decorated with ObjectRayDirectionKHR must be declared as a three-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04302", "The ObjectRayOriginKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04303", "The variable decorated with ObjectRayOriginKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04304", "The variable decorated with ObjectRayOriginKHR must be declared as a three-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04305", "The ObjectToWorldKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04306", "The variable decorated with ObjectToWorldKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04307", "The variable decorated with ObjectToWorldKHR must be declared as a matrix with four columns of three-component vectors of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-PFN_vkDebugUtilsMessengerCallbackEXT-None-04769", "The callback must not make calls to any Vulkan commands.", "1.2-extensions"},
    {"VUID-PatchVertices-PatchVertices-04308", "The PatchVertices decoration must be used only within the TessellationControl or TessellationEvaluation {ExecutionModel}", "1.2-extensions"},
    {"VUID-PatchVertices-PatchVertices-04309", "The variable decorated with PatchVertices must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-PatchVertices-PatchVertices-04310", "The variable decorated with PatchVertices must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-PointCoord-PointCoord-04311", "The PointCoord decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-PointCoord-PointCoord-04312", "The variable decorated with PointCoord must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-PointCoord-PointCoord-04313", "The variable decorated with PointCoord must be declared as a two-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-PointSize-PointSize-04314", "The PointSize decoration must be used only within the MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-PointSize-PointSize-04315", "The variable decorated with PointSize within the MeshNV or Vertex {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-PointSize-PointSize-04316", "The variable decorated with PointSize within the TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel} must not be declared using a {StorageClass} other than Input or Output", "1.2-extensions"},
    {"VUID-PointSize-PointSize-04317", "The variable decorated with PointSize must be declared as a scalar 32-bit floating-point value", "1.2-extensions"},
    {"VUID-Position-Position-04318", "The Position decoration must be used only within the MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-Position-Position-04319", "The variable decorated with Position within MeshNV or Vertex {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-Position-Position-04320", "The variable decorated with Position within TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel} must not be declared using a {StorageClass} other than Input or Output", "1.2-extensions"},
    {"VUID-Position-Position-04321", "The variable decorated with Position must be declared as a four-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04322", "The PositionPerViewNV decoration must be used only within the MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04323", "The variable decorated with PositionPerViewNV within the Vertex, or MeshNV {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04324", "The variable decorated with PositionPerViewNV within the TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel} must not be declared using a {StorageClass} other than Input or Output", "1.2-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04325", "The variable decorated with PositionPerViewNV must be declared as an array of four-component vector of 32-bit floating-point values with at least as many elements as the maximum view in the subpass's view mask plus one", "1.2-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04326", "The array variable decorated with PositionPerViewNV must only be indexed by a constant or specialization constant", "1.2-extensions"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04327", "The PrimitiveCountNV decoration must be used only within the MeshNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04328", "The variable decorated with PrimitiveCountNV must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04329", "The variable decorated with PrimitiveCountNV must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-PrimitiveId-Fragment-04331", "If pipeline contains both the Fragment and Geometry {ExecutionModel} and a variable decorated with PrimitiveId is read from Fragment shader, then the Geometry shader must write to the output variables decorated with PrimitiveId in all execution paths", "1.2-extensions"},
    {"VUID-PrimitiveId-Fragment-04332", "If pipeline contains both the Fragment and MeshNV {ExecutionModel} and a variable decorated with PrimitiveId is read from Fragment shader, then the MeshNV shader must write to the output variables decorated with PrimitiveId in all execution paths", "1.2-extensions"},
    {"VUID-PrimitiveId-Fragment-04333", "If Fragment {ExecutionModel} contains a variable decorated with PrimitiveId either the Geometry or Tessellation capability must also be declared", "1.2-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04330", "The PrimitiveId decoration must be used only within the MeshNV, IntersectionKHR, AnyHitKHR, ClosestHitKHR, TessellationControl, TessellationEvaluation, Geometry, or Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04334", "The variable decorated with PrimitiveId within the TessellationControl, TessellationEvaluation, Fragment, IntersectionKHR, AnyHitKHR, or ClosestHitKHR {ExecutionModel} must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04335", "The variable decorated with PrimitiveId within the Geometry {ExecutionModel} must be declared using the Input or Output {StorageClass}", "1.2-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04336", "The variable decorated with PrimitiveId within the MeshNV {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04337", "The variable decorated with PrimitiveId must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-PrimitiveIndicesNV-OutputLinesNV-04343", "If the {ExecutionMode} is OutputLinesNV, then the array decorated with PrimitiveIndicesNV must be the size of two times the value specified by OutputPrimitivesNV", "1.2-extensions"},
    {"VUID-PrimitiveIndicesNV-OutputPoints-04342", "If the {ExecutionMode} is OutputPoints, then the array decorated with PrimitiveIndicesNV must be the size of the value specified by OutputPrimitivesNV", "1.2-extensions"},
    {"VUID-PrimitiveIndicesNV-OutputTrianglesNV-04344", "If the {ExecutionMode} is OutputTrianglesNV, then the array decorated with PrimitiveIndicesNV must be the size of three times the value specified by OutputPrimitivesNV", "1.2-extensions"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04338", "The PrimitiveIndicesNV decoration must be used only within the MeshNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04339", "The variable decorated with PrimitiveIndicesNV must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04340", "The variable decorated with PrimitiveIndicesNV must be declared as an array of scalar 32-bit integer values", "1.2-extensions"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04341", "All index values of the array decorated with PrimitiveIndicesNV must be in the range [0, N-1], where N is the value specified by the OutputVertices {ExecutionMode}", "1.2-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04484", "The PrimitiveShadingRateKHR decoration must be used only within the MeshNV, Vertex, or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04485", "The variable decorated with PrimitiveShadingRateKHR must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04486", "The variable decorated with PrimitiveShadingRateKHR must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04487", "The value written to PrimitiveShadingRateKHR must include no more than one of Vertical2Pixels and Vertical4Pixels", "1.2-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04488", "The value written to PrimitiveShadingRateKHR must include no more than one of Horizontal2Pixels and Horizontal4Pixels", "1.2-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04489", "The value written to PrimitiveShadingRateKHR must not have any bits set other than those defined by Fragment Shading Rate Flags enumerants in the SPIR-V specification", "1.2-extensions"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04345", "The RayGeometryIndexKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04346", "The variable decorated with RayGeometryIndexKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04347", "The variable decorated with RayGeometryIndexKHR must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04348", "The RayTmaxKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04349", "The variable decorated with RayTmaxKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04350", "The variable decorated with RayTmaxKHR must be declared as a scalar 32-bit floating-point value", "1.2-extensions"},
    {"VUID-RayTminKHR-RayTminKHR-04351", "The RayTminKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR {ExecutionModel}", "1.2-extensions"},
    {"VUID-RayTminKHR-RayTminKHR-04352", "The variable decorated with RayTminKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-RayTminKHR-RayTminKHR-04353", "The variable decorated with RayTminKHR must be declared as a scalar 32-bit floating-point value", "1.2-extensions"},
    {"VUID-SMCountNV-SMCountNV-04363", "The variable decorated with SMCountNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SMCountNV-SMCountNV-04364", "The variable decorated with SMCountNV must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-SMIDNV-SMIDNV-04365", "The variable decorated with SMIDNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SMIDNV-SMIDNV-04366", "The variable decorated with SMIDNV must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-SampleId-SampleId-04354", "The SampleId decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-SampleId-SampleId-04355", "The variable decorated with SampleId must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SampleId-SampleId-04356", "The variable decorated with SampleId must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-SampleMask-SampleMask-04357", "The SampleMask decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-SampleMask-SampleMask-04358", "The variable decorated with SampleMask must be declared using the Input or Output {StorageClass}", "1.2-extensions"},
    {"VUID-SampleMask-SampleMask-04359", "The variable decorated with SampleMask must be declared as an array of 32-bit integer values", "1.2-extensions"},
    {"VUID-SamplePosition-SamplePosition-04360", "The SamplePosition decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-SamplePosition-SamplePosition-04361", "The variable decorated with SamplePosition must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SamplePosition-SamplePosition-04362", "The variable decorated with SamplePosition must be declared as a two-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04490", "The ShadingRateKHR decoration must be used only within the Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04491", "The variable decorated with ShadingRateKHR must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04492", "The variable decorated with ShadingRateKHR must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Base-04707", "The Base operand of OpPtrAccessChain must point to one of the following: Workgroup, if VariablePointers is enabled; StorageBuffer, if VariablePointers or VariablePointersStorageBuffer is enabled; PhysicalStorageBuffer, if the PhysicalStorageBuffer64 addressing model is enabled", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Base-04781", "The Base operand of any OpBitCount, OpBitReverse, OpBitFieldInsert, OpBitFieldSExtract, or OpBitFieldUExtract instruction must be a 32-bit integer scalar or a vector of 32-bit integers", "1.2-extensions"},
    {"VUID-StandaloneSpirv-BuiltIn-04668", "Any BuiltIn decoration not listed in Built-In Variables must not be used", "1.2-extensions"},
    {"VUID-StandaloneSpirv-CallableDataKHR-04704", "CallableDataKHR storage class must only be used in ray generation, closest hit, miss, and callable shaders", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Component-04920", "The Component decoration value must not be greater than 3", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Component-04921", "If the Component decoration is used on an OpVariable that has a OpTypeVector type with a Component Type with a Width that is less than or equal to 32, the sum of its Component Count and the Component decoration value must be less than 4", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Component-04922", "If the Component decoration is used on an OpVariable that has a OpTypeVector type with a Component Type with a Width that is equal to 64, the sum of two times its Component Count and the Component decoration value must be less than 4", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Component-04923", "The Component decorations value must not be 1 or 3 for scalar or two-component 64-bit data types", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Component-04924", "The Component decorations must not used with any type that is not a scalar or vector", "1.2-extensions"},
    {"VUID-StandaloneSpirv-DerivativeGroupLinearNV-04778", "For compute shaders using the DerivativeGroupLinearNV execution mode, the product of the dimensions of the local workgroup size must be a multiple of four", "1.2-extensions"},
    {"VUID-StandaloneSpirv-DerivativeGroupQuadsNV-04684", "For compute shaders using the DerivativeGroupQuadsNV execution mode, the first two dimensions of the local workgroup size must be a multiple of two", "1.2-extensions"},
    {"VUID-StandaloneSpirv-FPRoundingMode-04675", "Rounding modes other than round-to-nearest-even and round-towards-zero must not be used for the FPRoundingMode decoration", "1.2-extensions"},
    {"VUID-StandaloneSpirv-FPRoundingMode-04676", "The FPRoundingMode decoration must only be used for a width-only conversion instruction whose only uses are Object operands of OpStore instructions storing through a pointer to a 16-bit floating-point object in the StorageBuffer, PhysicalStorageBuffer, Uniform, or Output storage class", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Flat-04670", "The Flat, NoPerspective, Sample, and Centroid decorations must not be used on variables with storage class other than Input or on variables used in the interface of non-fragment shader entry points", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Flat-04744", "The Flat decorations must be used on variables with storage class of Input in a fragment shader stage that are a scalar integer, vector of integer, or any double-precision floating-point type", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Function-04681", "A type T that is an array sized with a specialization constant must neither be, nor be contained in, the type T2 of a variable V, unless either: a) T is equal to T2, b) V is declared in the Function, or Private storage classes, c) V is a non-Block variable in the Workgroup storage class, or d) V is an interface variable with an additional level of arrayness, as described in interface matching, and T is the member type of the array type T2.", "1.2-extensions"},
    {"VUID-StandaloneSpirv-GLSLShared-04669", "The GLSLShared and GLSLPacked decorations must not be used", "1.2-extensions"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04701", "HitAttributeKHR storage class must only be used in intersection, any-hit, or closest hit shaders", "1.2-extensions"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04702", "There must be at most one variable with the HitAttributeKHR storage class in the input interface of an entry point", "1.2-extensions"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04703", "A variable with HitAttributeKHR storage class must only be written to in an intersection shader", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Image-04965", "The converted bit width, signedness, and numeric type of the Image Format operand of an OpTypeImage must match the Sampled Type, as defined in Image Format and Type Matching.", "1.2-extensions"},
    {"VUID-StandaloneSpirv-IncomingCallableDataKHR-04705", "IncomingCallableDataKHR storage class must only be used in callable shaders", "1.2-extensions"},
    {"VUID-StandaloneSpirv-IncomingCallableDataKHR-04706", "There must be at most one variable with the IncomingCallableDataKHR storage class in the input interface of an entry point", "1.2-extensions"},
    {"VUID-StandaloneSpirv-IncomingRayPayloadKHR-04699", "IncomingRayPayloadKHR storage class must only be used in closest hit, any-hit, or miss shaders", "1.2-extensions"},
    {"VUID-StandaloneSpirv-IncomingRayPayloadKHR-04700", "There must be at most one variable with the IncomingRayPayloadKHR storage class in the input interface of an entry point", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Invariant-04677", "Variables decorated with Invariant and variables with structure types that have any members decorated with Invariant must be in the Output or Input storage class, Invariant used on an Input storage class variable or structure member has no effect", "1.2-extensions"},
    {"VUID-StandaloneSpirv-LocalSize-04683", "For each compute shader entry point, either a LocalSize execution mode or an object decorated with the WorkgroupSize decoration must be specified", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Location-04915", "The Location or Component decorations must not be used with BuiltIn", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Location-04916", "The Location decorations must be used on user-defined variables", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Location-04917", "The Location decorations must be used on an OpVariable with a structure type that is not a block", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Location-04918", "The Location decorations must not be used on the members of OpVariable with a structure type that is a block decorated with Location", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Location-04919", "The Location decorations must be used on each member of OpVariable with a structure type that is a block not decorated with Location", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04633", "Every entry point must have no return value and accept no arguments", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04634", "The static function-call graph for an entry point must not contain cycles; that is, static recursion is not allowed", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04635", "The Logical or PhysicalStorageBuffer64 addressing model must be selected", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04636", "Scope for execution must be limited to Workgroup or Subgroup", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04637", "If the Scope for execution is Workgroup, then it must only be used in the task, mesh, tessellation control, or compute execution models", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04638", "Scope for memory must be limited to Device, QueueFamily, Workgroup, ShaderCallKHR, Subgroup, or Invocation", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04639", "If the Scope for memory is Workgroup, then it must only be used in the task, mesh, or compute execution models", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04640", "If the Scope for memory is ShaderCallKHR, then it must only be used in ray generation, intersection, closest hit, any-hit, miss, and callable execution models", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04641", "If the Scope for memory is Invocation, then memory semantics must be None", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04642", "Scope for Non Uniform Group Operations must be limited to Subgroup", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04643", "Storage Class must be limited to UniformConstant, Input, Uniform, Output, Workgroup, Private, Function, PushConstant, Image, StorageBuffer, RayPayloadKHR, IncomingRayPayloadKHR, HitAttributeKHR, CallableDataKHR, IncomingCallableDataKHR, ShaderRecordBufferKHR, or PhysicalStorageBuffer", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04644", "If the Storage Class is Output, then it must not be used in the GlCompute, RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR execution models", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04645", "If the Storage Class is Workgroup, then it must only be used in the task, mesh, or compute execution models", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04667", "Structure types must not contain opaque types", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04686", "The Pointer operand of all atomic instructions must have a Storage Class limited to Uniform, Workgroup, Image, StorageBuffer, or PhysicalStorageBuffer", "1.2-extensions"},
    {"VUID-StandaloneSpirv-None-04745", "All variables with a storage class of PushConstant declared as an array must only be accessed by dynamically uniform indices", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04662", "Any image operation must use at most one of the Offset, ConstOffset, and ConstOffsets image operands", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04663", "Image operand Offset must only be used with OpImage*Gather instructions", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04687", "Output variables or block members decorated with Offset that have a 64-bit type, or a composite type containing a 64-bit type, must specify an Offset value aligned to a 8 byte boundary", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04689", "The size of any output block containing any member decorated with Offset that is a 64-bit type must be a multiple of 8", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04690", "The first member of an output block that specifies a Offset decoration must specify a Offset value that is aligned to an 8 byte boundary if that block contains any member decorated with Offset and is a 64-bit type", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04691", "Output variables or block members decorated with Offset that have a 32-bit type, or a composite type contains a 32-bit type, must specify an Offset value aligned to a 4 byte boundary", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04692", "Output variables, blocks or block members decorated with Offset must only contain base types that have components that are either 32-bit or 64-bit in size", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04716", "Only variables or block members in the output interface decorated with Offset can be captured for transform feedback, and those variables or block members must also be decorated with XfbBuffer and XfbStride, or inherit XfbBuffer and XfbStride decorations from a block containing them", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Offset-04865", "Any image instruction which uses an Offset, ConstOffset, or ConstOffsets image operand, must only consume a \"Sampled Image\" operand whose type has its \"Sampled\" operand set to 1", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpAtomicLoad-04731", "OpAtomicLoad must not use Release, AcquireRelease, or SequentiallyConsistent memory semantics", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpAtomicStore-04730", "OpAtomicStore must not use Acquire, AcquireRelease, or SequentiallyConsistent memory semantics", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpControlBarrier-04650", "If the semantics for OpControlBarrier includes one of Acquire, Release, AcquireRelease, or SequentiallyConsistent memory semantics, then it must include at least one storage class", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpControlBarrier-04682", "If OpControlBarrier is used in ray generation, intersection, any-hit, closest hit, miss, fragment, vertex, tessellation evaluation, or geometry shaders, the execution Scope must be Subgroup", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpGroupNonUniformBallotBitCount-04685", "If OpGroupNonUniformBallotBitCount is used, the group operation must be limited to Reduce, InclusiveScan, or ExclusiveScan", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpImage-04777", "OpImage*Dref must not consume an image whose Dim is 3D.", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpImageGather-04664", "The \"Component\" operand of OpImageGather, and OpImageSparseGather must be the <id> of a constant instruction", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpImageQuerySizeLod-04659", "OpImageQuerySizeLod, OpImageQueryLod, and OpImageQueryLevels must only consume an \"Image\" operand whose type has its \"Sampled\" operand set to 1", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpImageTexelPointer-04658", "If an OpImageTexelPointer is used in an atomic operation, the image type of the image parameter to OpImageTexelPointer must have an image format of R64i, R64ui, R32f, R32i, or R32ui", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpMemoryBarrier-04732", "OpMemoryBarrier must use one of Acquire, Release, AcquireRelease, or SequentiallyConsistent memory semantics", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpMemoryBarrier-04733", "OpMemoryBarrier must include at least one storage class", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpReadClockKHR-04652", "Scope for OpReadClockKHR must be limited to Subgroup or Device", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpReportIntersectionKHR-04666", "The value of the \"Hit Kind\" operand of OpReportIntersectionKHR must be in the range [0,127]", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpTypeAccelerationStructureKHR-04665", "Objects of types OpTypeAccelerationStructureKHR and arrays of this type must not be stored to or modified", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpTypeForwardPointer-04711", "OpTypeForwardPointer must have a storage class of PhysicalStorageBuffer", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpTypeImage-04656", "OpTypeImage must declare a scalar 32-bit float, 64-bit integer, or 32-bit integer type for the \"Sampled Type\" (RelaxedPrecision can be applied to a sampling instruction and to the variable holding the result of a sampling instruction)", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpTypeImage-04657", "OpTypeImage must have a \"Sampled\" operand of 1 (sampled image) or 2 (storage image)", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpTypeImage-04661", "Objects of types OpTypeImage, OpTypeSampler, OpTypeSampledImage, and arrays of these types must not be stored to or modified", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpTypeRuntimeArray-04680", "OpTypeRuntimeArray must only be used for the last member of an OpTypeStruct that is in the StorageBuffer or PhysicalStorageBuffer storage class decorated as Block, or that is in the Uniform storage class decorated as BufferBlock", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpVariable-04651", "Any OpVariable with an Initializer operand must have Output, Private, Function, or Workgroup as its Storage Class operand", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OpVariable-04734", "Any OpVariable with an Initializer operand and Workgroup as its Storage Class operand must use OpConstantNull as the initializer.", "1.2-extensions"},
    {"VUID-StandaloneSpirv-OriginLowerLeft-04653", "The OriginLowerLeft execution mode must not be used; fragment entry points must declare OriginUpperLeft", "1.2-extensions"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04708", "If the PhysicalStorageBuffer64 addressing model is enabled, all instructions that support memory access operands and that use a physical pointer must include the Aligned operand", "1.2-extensions"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04709", "If the PhysicalStorageBuffer64 addressing model is enabled, any access chain instruction that accesses into a RowMajor matrix must only be used as the Pointer operand to OpLoad or OpStore", "1.2-extensions"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04710", "If the PhysicalStorageBuffer64 addressing model is enabled, OpConvertUToPtr and OpConvertPtrToU must use an integer type whose Width is 64", "1.2-extensions"},
    {"VUID-StandaloneSpirv-PixelCenterInteger-04654", "The PixelCenterInteger execution mode must not be used (pixels are always centered at half-integer coordinates)", "1.2-extensions"},
    {"VUID-StandaloneSpirv-RayPayloadKHR-04698", "RayPayloadKHR storage class must only be used in ray generation, closest hit or miss shaders", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Result-04780", "The Result Type operand of any OpImageRead or OpImageSparseRead instruction must be a vector of four components", "1.2-extensions"},
    {"VUID-StandaloneSpirv-Stream-04694", "If any variables or block members in the output interface of the entry point being compiled are decorated with Stream, then all variables belonging to the same XfbBuffer must specify the same Stream value", "1.2-extensions"},
    {"VUID-StandaloneSpirv-SubpassData-04660", "The (u,v) coordinates used for a SubpassData must be the <id> of a constant vector (0,0), or if a layer coordinate is used, must be a vector that was formed with constant 0 for the u and v components", "1.2-extensions"},
    {"VUID-StandaloneSpirv-UniformConstant-04655", "Any variable in the UniformConstant storage class must be typed as either OpTypeImage, OpTypeSampler, OpTypeSampledImage, OpTypeAccelerationStructureKHR, or an array of one of these types", "1.2-extensions"},
    {"VUID-StandaloneSpirv-ViewportMaskNV-04674", "The ViewportMaskNV and ViewportIndex decorations must not both be statically used by one or more OpEntryPoint's that form the pre-rasterization shader stages of a graphics pipeline", "1.2-extensions"},
    {"VUID-StandaloneSpirv-ViewportRelativeNV-04672", "The ViewportRelativeNV decoration must only be used on a variable decorated with Layer in the vertex, tessellation evaluation, or geometry shader stages", "1.2-extensions"},
    {"VUID-StandaloneSpirv-ViewportRelativeNV-04673", "The ViewportRelativeNV decoration must not be used unless a variable decorated with one of ViewportIndex or ViewportMaskNV is also statically used by the same OpEntryPoint", "1.2-extensions"},
    {"VUID-StandaloneSpirv-VulkanMemoryModel-04678", " If the VulkanMemoryModel capability is not declared, the Volatile decoration must be used on any variable declaration that includes one of the SMIDNV, WarpIDNV, SubgroupSize, SubgroupLocalInvocationId, SubgroupEqMask, SubgroupGeMask, SubgroupGtMask, SubgroupLeMask, or SubgroupLtMask BuiltIn decorations when used in the ray generation, closest hit, miss, intersection, or callable shaders, or with the RayTmaxKHR Builtin decoration when used in an intersection shader", "1.2-extensions"},
    {"VUID-StandaloneSpirv-VulkanMemoryModel-04679", "If the VulkanMemoryModel capability is declared, the OpLoad instruction must use the Volatile memory semantics when it accesses into any variable that includes one of the SMIDNV, WarpIDNV, SubgroupSize, SubgroupLocalInvocationId, SubgroupEqMask, SubgroupGeMask, SubgroupGtMask, SubgroupLeMask, or SubgroupLtMask BuiltIn decorations when used in the ray generation, closest hit, miss, intersection, or callable shaders, or with the RayTmaxKHR Builtin decoration when used in an intersection shader", "1.2-extensions"},
    {"VUID-StandaloneSpirv-XfbBuffer-04693", "All variables or block members in the output interface of the entry point being compiled decorated with a specific XfbBuffer value must all be decorated with identical XfbStride values", "1.2-extensions"},
    {"VUID-StandaloneSpirv-XfbBuffer-04696", "For any two variables or block members in the output interface of the entry point being compiled with the same XfbBuffer value, the ranges determined by the Offset decoration and the size of the type must not overlap", "1.2-extensions"},
    {"VUID-StandaloneSpirv-XfbBuffer-04697", "All block members in the output interface of the entry point being compiled that are in the same block and have a declared or inherited XfbBuffer decoration must specify the same XfbBuffer value", "1.2-extensions"},
    {"VUID-SubgroupEqMask-SubgroupEqMask-04370", "The variable decorated with SubgroupEqMask must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SubgroupEqMask-SubgroupEqMask-04371", "The variable decorated with SubgroupEqMask must be declared as a four-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-SubgroupGeMask-SubgroupGeMask-04372", "The variable decorated with SubgroupGeMask must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SubgroupGeMask-SubgroupGeMask-04373", "The variable decorated with SubgroupGeMask must be declared as a four-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-SubgroupGtMask-SubgroupGtMask-04374", "The variable decorated with SubgroupGtMask must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SubgroupGtMask-SubgroupGtMask-04375", "The variable decorated with SubgroupGtMask must be declared as a four-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-SubgroupId-SubgroupId-04367", "The SubgroupId decoration must be used only within the GLCompute, MeshNV, or TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-SubgroupId-SubgroupId-04368", "The variable decorated with SubgroupId must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SubgroupId-SubgroupId-04369", "The variable decorated with SubgroupId must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-SubgroupLeMask-SubgroupLeMask-04376", "The variable decorated with SubgroupLeMask must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SubgroupLeMask-SubgroupLeMask-04377", "The variable decorated with SubgroupLeMask must be declared as a four-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-SubgroupLocalInvocationId-SubgroupLocalInvocationId-04380", "The variable decorated with SubgroupLocalInvocationId must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SubgroupLocalInvocationId-SubgroupLocalInvocationId-04381", "The variable decorated with SubgroupLocalInvocationId must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-SubgroupLtMask-SubgroupLtMask-04378", "The variable decorated with SubgroupLtMask must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SubgroupLtMask-SubgroupLtMask-04379", "The variable decorated with SubgroupLtMask must be declared as a four-component vector of 32-bit integer values", "1.2-extensions"},
    {"VUID-SubgroupSize-SubgroupSize-04382", "The variable decorated with SubgroupSize must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-SubgroupSize-SubgroupSize-04383", "The variable decorated with SubgroupSize must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-TaskCountNV-TaskCountNV-04384", "The TaskCountNV decoration must be used only within the TaskNV {ExecutionModel}", "1.2-extensions"},
    {"VUID-TaskCountNV-TaskCountNV-04385", "The variable decorated with TaskCountNV must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-TaskCountNV-TaskCountNV-04386", "The variable decorated with TaskCountNV must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-TessCoord-TessCoord-04387", "The TessCoord decoration must be used only within the TessellationEvaluation {ExecutionModel}", "1.2-extensions"},
    {"VUID-TessCoord-TessCoord-04388", "The variable decorated with TessCoord must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-TessCoord-TessCoord-04389", "The variable decorated with TessCoord must be declared as a three-component vector of 32-bit floating-point values", "1.2-extensions"},
    {"VUID-TessLevelInner-TessLevelInner-04394", "The TessLevelInner decoration must be used only within the TessellationControl or TessellationEvaluation {ExecutionModel}", "1.2-extensions"},
    {"VUID-TessLevelInner-TessLevelInner-04395", "The variable decorated with TessLevelInner within the TessellationControl {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-TessLevelInner-TessLevelInner-04396", "The variable decorated with TessLevelInner within the TessellationEvaluation {ExecutionModel} must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-TessLevelInner-TessLevelInner-04397", "The variable decorated with TessLevelInner must be declared as an array of size two, containing 32-bit floating-point values", "1.2-extensions"},
    {"VUID-TessLevelOuter-TessLevelOuter-04390", "The TessLevelOuter decoration must be used only within the TessellationControl or TessellationEvaluation {ExecutionModel}", "1.2-extensions"},
    {"VUID-TessLevelOuter-TessLevelOuter-04391", "The variable decorated with TessLevelOuter within the TessellationControl {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-TessLevelOuter-TessLevelOuter-04392", "The variable decorated with TessLevelOuter within the TessellationEvaluation {ExecutionModel} must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-TessLevelOuter-TessLevelOuter-04393", "The variable decorated with TessLevelOuter must be declared as an array of size four, containing 32-bit floating-point values", "1.2-extensions"},
    {"VUID-VertexIndex-VertexIndex-04398", "The VertexIndex decoration must be used only within the Vertex {ExecutionModel}", "1.2-extensions"},
    {"VUID-VertexIndex-VertexIndex-04399", "The variable decorated with VertexIndex must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-VertexIndex-VertexIndex-04400", "The variable decorated with VertexIndex must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-ViewIndex-ViewIndex-04401", "The ViewIndex decoration must not be used within the GLCompute {ExecutionModel}", "1.2-extensions"},
    {"VUID-ViewIndex-ViewIndex-04402", "The variable decorated with ViewIndex must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-ViewIndex-ViewIndex-04403", "The variable decorated with ViewIndex must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04404", "The ViewportIndex decoration must be used only within the MeshNV, Vertex, TessellationEvaluation, Geometry, or Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04405", "If the shaderOutputViewportIndex feature is not enabled then the ViewportIndex decoration must be used only within the Geometry or Fragment {ExecutionModel}", "1.2-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04406", "The variable decorated with ViewportIndex within the MeshNV, Vertex, TessellationEvaluation, or Geometry {ExecutionModel} must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04407", "The variable decorated with ViewportIndex within the Fragment {ExecutionModel} must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04408", "The variable decorated with ViewportIndex must be declared as a scalar 32-bit integer value", "1.2-extensions"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04409", "The ViewportMaskNV decoration must be used only within the Vertex, MeshNV, TessellationEvaluation, or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04410", "The variable decorated with ViewportMaskNV must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04411", "The variable decorated with ViewportMaskNV must be declared as an array of 32-bit integer values", "1.2-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04412", "The ViewportMaskPerViewNV decoration must be used only within the Vertex, MeshNV, TessellationControl, TessellationEvaluation, or Geometry {ExecutionModel}", "1.2-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04413", "The variable decorated with ViewportMaskPerViewNV must be declared using the Output {StorageClass}", "1.2-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04414", "The variable decorated with ViewportMaskPerViewNV must be declared as an array of 32-bit integer values", "1.2-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04415", "The array decorated with ViewportMaskPerViewNV must be a size less than or equal to 32", "1.2-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04416", "The array decorated with ViewportMaskPerViewNV must be a size greater than the maximum view in the subpass's view mask", "1.2-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04417", "The array variable decorated with ViewportMaskPerViewNV must only be indexed by a constant or specialization constant.", "1.2-extensions"},
    {"VUID-VkAabbPositionsKHR-minX-03546", "minX must be less than or equal to maxX", "1.2-extensions"},
    {"VUID-VkAabbPositionsKHR-minY-03547", "minY must be less than or equal to maxY", "1.2-extensions"},
    {"VUID-VkAabbPositionsKHR-minZ-03548", "minZ must be less than or equal to maxZ", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-commonparent", "Both of dstAccelerationStructure, and srcAccelerationStructure that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-dstAccelerationStructure-04927", "If dstAccelerationStructure was created with VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in VkAccelerationStructureCreateInfoKHR::flags, VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV must be set in flags", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-03796", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR bit set", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-04928", "If VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in flags, dstAccelerationStructure must have been created with VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in VkAccelerationStructureCreateInfoKHR::flags", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-04929", "If VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in flags, type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-parameter", "flags must be a valid combination of VkBuildAccelerationStructureFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pGeometries-03788", "Only one of pGeometries or ppGeometries can be a valid pointer, the other must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pGeometries-parameter", "If geometryCount is not 0, and pGeometries is not NULL, pGeometries must be a valid pointer to an array of geometryCount valid VkAccelerationStructureGeometryKHR structures", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-ppGeometries-parameter", "If geometryCount is not 0, and ppGeometries is not NULL, ppGeometries must be a valid pointer to an array of geometryCount valid pointers to valid VkAccelerationStructureGeometryKHR structures", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03654", "type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03789", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, the geometryType member of elements of either pGeometries or ppGeometries must be VK_GEOMETRY_TYPE_INSTANCES_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03790", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, geometryCount must be 1", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03791", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR the geometryType member of elements of either pGeometries or ppGeometries must not be VK_GEOMETRY_TYPE_INSTANCES_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03792", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then the geometryType member of each geometry in either pGeometries or ppGeometries must be the same", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03793", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then geometryCount must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxGeometryCount", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03794", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_AABBS_KHR, the total number of AABBs in all geometries must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPrimitiveCount", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03795", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_TRIANGLES_KHR, the total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPrimitiveCount", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-parameter", "type must be a valid VkAccelerationStructureTypeKHR value", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03656", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry uses indices, the offset primitiveOffset from VkAccelerationStructureGeometryTrianglesDataKHR::indexData must be a multiple of the element size of VkAccelerationStructureGeometryTrianglesDataKHR::indexType", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03657", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry does not use indices, the offset primitiveOffset from VkAccelerationStructureGeometryTrianglesDataKHR::vertexData must be a multiple of the component size of VkAccelerationStructureGeometryTrianglesDataKHR::vertexFormat", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03659", "For geometries of type VK_GEOMETRY_TYPE_AABBS_KHR, the offset primitiveOffset from VkAccelerationStructureGeometryAabbsDataKHR::data must be a multiple of 8", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03660", "For geometries of type VK_GEOMETRY_TYPE_INSTANCES_KHR, the offset primitiveOffset from VkAccelerationStructureGeometryInstancesDataKHR::data must be a multiple of 16", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-transformOffset-03658", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, the offset transformOffset from VkAccelerationStructureGeometryTrianglesDataKHR::transformData must be a multiple of 16", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildSizesInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureBuildSizesInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-03614", "buffer must have been created with a usage value containing VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-03615", "buffer must not have been created with VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-03613", "If createFlags includes VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR, VkPhysicalDeviceAccelerationStructureFeaturesKHR::accelerationStructureCaptureReplay must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-parameter", "createFlags must be a valid combination of VkAccelerationStructureCreateFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-03612", "If deviceAddress is not zero, createFlags must include VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-flags-04954", "If VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV is set in    flags and type is    VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, one member of the pNext chain must be a pointer to a valid instance of VkAccelerationStructureMotionInfoNV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-flags-04955", "If any geometry includes VkAccelerationStructureGeometryMotionTrianglesDataNV then flags must contain VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-offset-03616", "The sum of offset and size must be less than the size of buffer", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-offset-03734", "offset must be a multiple of 256 bytes", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkAccelerationStructureMotionInfoNV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-type-parameter", "type must be a valid VkAccelerationStructureTypeKHR value", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-compactedSize-02421", "If compactedSize is not 0 then both info.geometryCount and info.instanceCount must be 0", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-info-parameter", "info must be a valid VkAccelerationStructureInfoNV structure", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureKHR handle", "1.2-extensions"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-stride-03545", "stride must be a multiple of 8", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-stride-03820", "stride must be less than or equal to 232-1", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryInstancesDataKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryInstancesDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-aabbs-parameter", "If geometryType is VK_GEOMETRY_TYPE_AABBS_KHR, the aabbs member of geometry must be a valid VkAccelerationStructureGeometryAabbsDataKHR structure", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-flags-parameter", "flags must be a valid combination of VkGeometryFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-geometryType-parameter", "geometryType must be a valid VkGeometryTypeKHR value", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-instances-parameter", "If geometryType is VK_GEOMETRY_TYPE_INSTANCES_KHR, the instances member of geometry must be a valid VkAccelerationStructureGeometryInstancesDataKHR structure", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-triangles-parameter", "If geometryType is VK_GEOMETRY_TYPE_TRIANGLES_KHR, the triangles member of geometry must be a valid VkAccelerationStructureGeometryTrianglesDataKHR structure", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryMotionTrianglesDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-indexType-03798", "indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-indexType-parameter", "indexType must be a valid VkIndexType value", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkAccelerationStructureGeometryMotionTrianglesDataNV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat-03797", "vertexFormat must support the VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR in VkFormatProperties::bufferFeatures as returned by vkGetPhysicalDeviceFormatProperties2", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexStride-03735", "vertexStride must be a multiple of the size in bytes of the smallest component of vertexFormat", "1.2-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexStride-03819", "vertexStride must be less than or equal to 232-1", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-flags-02592", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV bit set", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-flags-parameter", "flags must be a valid combination of VkBuildAccelerationStructureFlagBitsNV values", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-geometryCount-02422", "geometryCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxGeometryCount", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-instanceCount-02423", "instanceCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxInstanceCount", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-instanceData-02782", "If instanceData is not VK_NULL_HANDLE, instanceData must have been created with VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-maxTriangleCount-02424", "The total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxTriangleCount", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-pGeometries-parameter", "If geometryCount is not 0, pGeometries must be a valid pointer to an array of geometryCount valid VkGeometryNV structures", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-scratch-02781", "scratch must have been created with VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-02425", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV then geometryCount must be 0", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-02426", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then instanceCount must be 0", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-02786", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then the geometryType member of each geometry in pGeometries must be the same", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-04623", "type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-parameter", "type must be a valid VkAccelerationStructureTypeNV value", "1.2-extensions"},
    {"VUID-VkAccelerationStructureInstanceKHR-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMatrixMotionInstanceNV-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureNV handle", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-type-parameter", "type must be a valid VkAccelerationStructureMemoryRequirementsTypeNV value", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMotionInfoNV-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMotionInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-matrixMotionInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV, the matrixMotionInstance member of data must be a valid VkAccelerationStructureMatrixMotionInstanceNV structure", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-srtMotionInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV, the srtMotionInstance member of data must be a valid VkAccelerationStructureSRTMotionInstanceNV structure", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-staticInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV, the staticInstance member of data must be a valid VkAccelerationStructureInstanceKHR structure", "1.2-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-type-parameter", "type must be a valid VkAccelerationStructureMotionInstanceTypeNV value", "1.2-extensions"},
    {"VUID-VkAccelerationStructureSRTMotionInstanceNV-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-pVersionData-parameter", "pVersionData must be a valid pointer to an array of 2*VK_UUID_SIZE uint8_t values", "1.2-extensions"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-commonparent", "Each of fence, semaphore, and swapchain that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkInstance", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01290", "deviceMask must be a valid device mask", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01291", "deviceMask must not be zero", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-01289", "If fence is not VK_NULL_HANDLE it must be unsignaled and must not be associated with any other queue command that has not yet completed execution on that queue", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-parameter", "If fence is not VK_NULL_HANDLE, fence must be a valid VkFence handle", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01288", "If semaphore is not VK_NULL_HANDLE it must be unsignaled", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01781", "If semaphore is not VK_NULL_HANDLE it must not have any uncompleted signal or wait operations pending", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01782", "semaphore and fence must not both be equal to VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-03266", "semaphore must have a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-parameter", "If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-swapchain-01675", "swapchain must not be in the retired state", "1.2-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle", "1.2-extensions"},
    {"VUID-VkAcquireProfilingLockInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkAcquireProfilingLockInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAcquireProfilingLockInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR", "1.2-extensions"},
    {"VUID-VkAllocationCallbacks-pfnAllocation-00632", "pfnAllocation must be a valid pointer to a valid user-defined PFN_vkAllocationFunction", "1.2-extensions"},
    {"VUID-VkAllocationCallbacks-pfnFree-00634", "pfnFree must be a valid pointer to a valid user-defined PFN_vkFreeFunction", "1.2-extensions"},
    {"VUID-VkAllocationCallbacks-pfnInternalAllocation-00635", "If either of pfnInternalAllocation or pfnInternalFree is not NULL, both must be valid callbacks", "1.2-extensions"},
    {"VUID-VkAllocationCallbacks-pfnReallocation-00633", "pfnReallocation must be a valid pointer to a valid user-defined PFN_vkReallocationFunction", "1.2-extensions"},
    {"VUID-VkAndroidHardwareBufferFormatPropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID", "1.2-extensions"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkAndroidHardwareBufferFormatPropertiesANDROID", "1.2-extensions"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID", "1.2-extensions"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkAndroidHardwareBufferUsageANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID", "1.2-extensions"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-window-01248", "window must point to a valid Android ANativeWindow", "1.2-extensions"},
    {"VUID-VkApplicationInfo-apiVersion-04010", "If apiVersion is not 0, then it must be greater than or equal to VK_API_VERSION_1_0", "1.2-extensions"},
    {"VUID-VkApplicationInfo-pApplicationName-parameter", "If pApplicationName is not NULL, pApplicationName must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkApplicationInfo-pEngineName-parameter", "If pEngineName is not NULL, pEngineName must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkApplicationInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkApplicationInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_APPLICATION_INFO", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-finalLayout-00843", "finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-finalLayout-parameter", "finalLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-flags-parameter", "flags must be a valid combination of VkAttachmentDescriptionFlagBits values", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03280", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03281", "If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03282", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03283", "If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03286", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03287", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03288", "If format is a depth/stencil format which includes both depth and stencil aspects, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03289", "If format is a depth/stencil format which includes both depth and stencil aspects, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03290", "If format is a depth/stencil format which includes only the depth aspect, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03291", "If format is a depth/stencil format which includes only the depth aspect, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03292", "If format is a depth/stencil format which includes only the stencil aspect, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-03293", "If format is a depth/stencil format which includes only the stencil aspect, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-loadOp-parameter", "loadOp must be a valid VkAttachmentLoadOp value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03284", "If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03285", "If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-stencilLoadOp-parameter", "stencilLoadOp must be a valid VkAttachmentLoadOp value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-stencilStoreOp-parameter", "stencilStoreOp must be a valid VkAttachmentStoreOp value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription-storeOp-parameter", "storeOp must be a valid VkAttachmentStoreOp value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-finalLayout-03061", "finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-finalLayout-parameter", "finalLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-flags-parameter", "flags must be a valid combination of VkAttachmentDescriptionFlagBits values", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03294", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03295", "If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03296", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03297", "If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03300", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03301", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03302", "If format is a depth/stencil format which includes both depth and stencil aspects, and initialLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03303", "If format is a depth/stencil format which includes both depth and stencil aspects, and finalLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03304", "If format is a depth/stencil format which includes only the depth aspect, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03305", "If format is a depth/stencil format which includes only the depth aspect, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03306", "If format is a depth/stencil format which includes only the stencil aspect, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-03307", "If format is a depth/stencil format which includes only the stencil aspect, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-loadOp-parameter", "loadOp must be a valid VkAttachmentLoadOp value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkAttachmentDescriptionStencilLayout", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03298", "If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03299", "If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-stencilLoadOp-parameter", "stencilLoadOp must be a valid VkAttachmentLoadOp value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-stencilStoreOp-parameter", "stencilStoreOp must be a valid VkAttachmentStoreOp value", "1.2-extensions"},
    {"VUID-VkAttachmentDescription2-storeOp-parameter", "storeOp must be a valid VkAttachmentStoreOp value", "1.2-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT", "1.2-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03309", "stencilFinalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03310", "stencilFinalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.2-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-parameter", "stencilFinalLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-03308", "stencilInitialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-parameter", "stencilInitialLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentReference-layout-00857", "If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_PRESENT_SRC_KHR, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentReference-layout-parameter", "layout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-attachment-04754", "If attachment is not VK_ATTACHMENT_UNUSED, and the format of the referenced attachment is a color format, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-attachment-04755", "If attachment is not VK_ATTACHMENT_UNUSED, and the format of the referenced attachment is a depth/stencil format which includes both depth and stencil aspects, and layout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentReferenceStencilLayout structure", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-attachment-04756", "If attachment is not VK_ATTACHMENT_UNUSED, and the format of the referenced attachment is a depth/stencil format which includes only the depth aspect, layout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-attachment-04757", "If attachment is not VK_ATTACHMENT_UNUSED, and the format of the referenced attachment is a depth/stencil format which includes only the stencil aspect, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-layout-03077", "If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-layout-parameter", "layout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkAttachmentReferenceStencilLayout", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkAttachmentReference2-separateDepthStencilLayouts-03313", "If the separateDepthStencilLayouts feature is not enabled, and attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "1.2-extensions"},
    {"VUID-VkAttachmentReferenceStencilLayout-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT", "1.2-extensions"},
    {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-03318", "stencilLayout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", "1.2-extensions"},
    {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-parameter", "stencilLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkAttachmentSampleLocationsEXT-attachmentIndex-01531", "attachmentIndex must be less than the attachmentCount specified in VkRenderPassCreateInfo the render pass specified by VkRenderPassBeginInfo::renderPass was created with", "1.2-extensions"},
    {"VUID-VkAttachmentSampleLocationsEXT-sampleLocationsInfo-parameter", "sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-03620", "accelerationStructure must not already be backed by a memory object", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureNV handle", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-commonparent", "Both of accelerationStructure, and memory must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-03622", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-03621", "memoryOffset must be less than the size of memory", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-03623", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV", "1.2-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-size-03624", "The size member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV must be less than or equal to the size of memory minus memoryOffset", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-deviceIndexCount-01606", "deviceIndexCount must either be zero or equal to the number of physical devices in the logical device", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-01607", "All elements of pDeviceIndices must be valid device indices", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-None-01898", "If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit set, the buffer must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-None-01899", "If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit not set, the buffer must not be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01029", "buffer must not already be backed by a memory object", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01030", "buffer must not have been created with any sparse memory binding flags", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01038", "If buffer was created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been allocated with VkDedicatedAllocationMemoryAllocateInfoNV::buffer equal to a buffer handle created with identical creation parameters to buffer and memoryOffset must be zero", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01039", "If buffer was not created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image", "default"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01444", "If buffer requires a dedicated allocation (as reported by vkGetBufferMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for buffer), memory must have been allocated with VkMemoryDedicatedAllocateInfo::buffer equal to buffer", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-bufferDeviceAddress-03339", "If the VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddress feature is enabled and buffer was created with the VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-commonparent", "Both of buffer, and memory must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-01035", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-01508", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::buffer was not VK_NULL_HANDLE, then buffer must equal VkMemoryDedicatedAllocateInfo::buffer, and memoryOffset must be zero", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-02726", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-02727", "If memory was allocated by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "1.2-khr-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-02985", "If memory was allocated by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-02986", "If memory was allocated with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memoryOffset-01031", "memoryOffset must be less than the size of memory", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memoryOffset-01036", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-pNext-01605", "If the pNext chain includes a VkBindBufferMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindBufferMemoryDeviceGroupInfo::pDeviceIndices must have been allocated", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkBindBufferMemoryDeviceGroupInfo", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkBindBufferMemoryInfo-size-01037", "The size member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer must be less than or equal to the size of memory minus memoryOffset", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01633", "At least one of deviceIndexCount and splitInstanceBindRegionCount must be zero", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01634", "deviceIndexCount must either be zero or equal to the number of physical devices in the logical device", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01640", "The extent.width member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block width of all non-metadata aspects of the image, or else extent.width + offset.x must equal the width of the image subresource", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01641", "The extent.height member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block height of all non-metadata aspects of the image, or else extent.height + offset.y must equal the height of the image subresource", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01638", "The offset.x member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block width (VkSparseImageFormatProperties::imageGranularity.width) of all non-metadata aspects of the image", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01639", "The offset.y member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block height (VkSparseImageFormatProperties::imageGranularity.height) of all non-metadata aspects of the image", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-01635", "All elements of pDeviceIndices must be valid device indices", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-01637", "Elements of pSplitInstanceBindRegions that correspond to the same instance of an image must not overlap", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-parameter", "If splitInstanceBindRegionCount is not 0, pSplitInstanceBindRegions must be a valid pointer to an array of splitInstanceBindRegionCount VkRect2D structures", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO", "1.2-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-splitInstanceBindRegionCount-01636", "splitInstanceBindRegionCount must either be zero or equal to the number of physical devices in the logical device squared", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-None-01901", "If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit set, the image must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-None-01902", "If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit not set, the image must not be bound to a memory object created with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-commonparent", "Both of image, and memory that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01044", "image must not already be backed by a memory object", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01045", "image must not have been created with any sparse memory binding flags", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01050", "If image was created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been created with VkDedicatedAllocationMemoryAllocateInfoNV::image equal to an image handle created with identical creation parameters to image and memoryOffset must be zero", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01051", "If image was not created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image", "default"},
    {"VUID-VkBindImageMemoryInfo-image-01445", "If image requires a dedicated allocation (as reported by vkGetImageMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for image), memory must have been created with VkMemoryDedicatedAllocateInfo::image equal to image", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01630", "If image was created with a valid swapchain handle in VkImageSwapchainCreateInfoKHR::swapchain, then the pNext chain must include a VkBindImageMemorySwapchainInfoKHR structure containing the same swapchain handle", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-parameter", "image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-01509", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero", "1.2-khr-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-01612", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with image", "default"},
    {"VUID-VkBindImageMemoryInfo-memory-01614", "The difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with the same image", "default"},
    {"VUID-VkBindImageMemoryInfo-memory-01625", "memory must be a valid VkDeviceMemory handle", "1.2"},
    {"VUID-VkBindImageMemoryInfo-memory-02628", "If the dedicated allocation image aliasing feature is not enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02629", "If the dedicated allocation image aliasing feature is enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then memoryOffset must be zero, and image must be either equal to VkMemoryDedicatedAllocateInfo::image or an image that was created using the same parameters in VkImageCreateInfo, with the exception that extent and arrayLayers may differ subject to the following restrictions: every dimension in the extent parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created; and the arrayLayers parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02728", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02729", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "1.2-khr-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02989", "If memory was created by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02990", "If memory was created with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-memoryOffset-01046", "memoryOffset must be less than the size of memory", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-memoryOffset-01613", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with image", "default"},
    {"VUID-VkBindImageMemoryInfo-pNext-01615", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01616", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01617", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01618", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, image must have been created with the VK_IMAGE_CREATE_DISJOINT_BIT bit set", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01619", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01620", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01621", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01626", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindImageMemoryDeviceGroupInfo::pDeviceIndices must have been allocated", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01627", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, and VkBindImageMemoryDeviceGroupInfo::splitInstanceBindRegionCount is not zero, then image must have been created with the VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT bit set", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01628", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions must be valid rectangles contained within the dimensions of image", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01629", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, the union of the areas of all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions that correspond to the same instance of image must cover the entire image", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01631", "If the pNext chain includes a VkBindImageMemorySwapchainInfoKHR structure, memory must be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01632", "If the pNext chain does not include a VkBindImageMemorySwapchainInfoKHR structure, memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBindImageMemoryDeviceGroupInfo, VkBindImageMemorySwapchainInfoKHR, or VkBindImagePlaneMemoryInfo", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO", "1.2-extensions"},
    {"VUID-VkBindImageMemoryInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-imageIndex-01644", "imageIndex must be less than the number of images in swapchain", "1.2-extensions"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR", "1.2-extensions"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle", "1.2-extensions"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02283", "If the image's tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid format plane for the image (that is, for a two-plane image planeAspect must be VK_IMAGE_ASPECT_PLANE_0_BIT or VK_IMAGE_ASPECT_PLANE_1_BIT, and for a three-plane image planeAspect must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT or VK_IMAGE_ASPECT_PLANE_2_BIT)", "1.2-extensions"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02284", "If the image's tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", "1.2-extensions"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter", "planeAspect must be a valid VkImageAspectFlagBits value", "1.2-extensions"},
    {"VUID-VkBindImagePlaneMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO", "1.2-extensions"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-None-02946", "The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_INDEX_BUFFER_BIT bit set", "1.2-extensions"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-None-02948", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-bufferAddress-02947", "The bufferAddress must be aligned to the indexType used", "1.2-extensions"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-indexType-parameter", "indexType must be a valid VkIndexType value", "1.2-extensions"},
    {"VUID-VkBindShaderGroupIndirectCommandNV-None-02944", "The current bound graphics pipeline, as well as the pipelines it may reference, must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.2-extensions"},
    {"VUID-VkBindShaderGroupIndirectCommandNV-index-02945", "The index must be within range of the accessible shader groups of the current bound graphics pipeline. See vkCmdBindPipelineShaderGroupNV for further details", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-commonparent", "Both of the elements of pSignalSemaphores, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pBufferBinds-parameter", "If bufferBindCount is not 0, pBufferBinds must be a valid pointer to an array of bufferBindCount valid VkSparseBufferMemoryBindInfo structures", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pImageBinds-parameter", "If imageBindCount is not 0, pImageBinds must be a valid pointer to an array of imageBindCount valid VkSparseImageMemoryBindInfo structures", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pImageOpaqueBinds-parameter", "If imageOpaqueBindCount is not 0, pImageOpaqueBinds must be a valid pointer to an array of imageOpaqueBindCount valid VkSparseImageOpaqueMemoryBindInfo structures", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pNext-03247", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pWaitSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its waitSemaphoreValueCount member must equal waitSemaphoreCount", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pNext-03248", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its signalSemaphoreValueCount member must equal signalSemaphoreCount", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupBindSparseInfo or VkTimelineSemaphoreSubmitInfo", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-03249", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value greater than the current value of the semaphore when the semaphore signal operation is executed", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-03251", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphores must be a valid pointer to an array of signalSemaphoreCount valid VkSemaphore handles", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-03246", "If any element of pWaitSemaphores or pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then the pNext chain must include a VkTimelineSemaphoreSubmitInfo structure", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-03250", "For each element of pWaitSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pWaitSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_SPARSE_INFO", "1.2-extensions"},
    {"VUID-VkBindSparseInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkBindVertexBufferIndirectCommandNV-None-02949", "The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_VERTEX_BUFFER_BIT bit set", "1.2-extensions"},
    {"VUID-VkBindVertexBufferIndirectCommandNV-None-02950", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-aspectMask-00241", "For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-aspectMask-00242", "For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-00224", "dstImage must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-00225", "If dstImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-00234", "dstImage must have been created with a samples value of VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-00250", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffsets[0].y must be 0 and dstOffsets[1].y must be 1", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-00252", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffsets[0].z must be 0 and dstOffsets[1].z must be 1", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-01562", "dstImage must not use a format listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-02000", "The format features of dstImage must contain VK_FORMAT_FEATURE_BLIT_DST_BIT", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-02545", "dstImage and srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImageLayout-00226", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImageLayout-00227", "dstImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "default"},
    {"VUID-VkBlitImageInfo2KHR-dstImageLayout-01399", "dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstOffset-00248", "For each element of pRegions, dstOffsets[0].x and dstOffsets[1].x must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstOffset-00249", "For each element of pRegions, dstOffsets[0].y and dstOffsets[1].y must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstOffset-00251", "For each element of pRegions, dstOffsets[0].z and dstOffsets[1].z must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstSubresource-01706", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-dstSubresource-01708", "The dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-filter-00237", "If filter is VK_FILTER_CUBIC_EXT, srcImage must be of type VK_IMAGE_TYPE_2D", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-filter-02001", "If filter is VK_FILTER_LINEAR, then the format features of srcImage must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-filter-02002", "If filter is VK_FILTER_CUBIC_EXT, then the format features of srcImage must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-filter-parameter", "filter must be a valid VkFilter value", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-00215", "The source region specified by each element of pRegions must be a region that is contained within srcImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-00216", "The destination region specified by each element of pRegions must be a region that is contained within dstImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-00217", "The union of all destination regions, specified by the elements of pRegions, must not overlap in memory with any texel that may be sampled during the blit operation", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-04561", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage and dstImage must not be a block-compressed image.", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-04562", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then the srcImage must be of type VK_IMAGE_TYPE_2D and must not be a multi-planar format.", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageBlit2KHR structures", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-regionCount-arraylength", "regionCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00219", "srcImage must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00220", "If srcImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00229", "If either of srcImage or dstImage was created with a signed integer VkFormat, the other must also have been created with a signed integer VkFormat", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00230", "If either of srcImage or dstImage was created with an unsigned integer VkFormat, the other must also have been created with an unsigned integer VkFormat", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00231", "If either of srcImage or dstImage was created with a depth/stencil format, the other must have exactly the same format", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00232", "If srcImage was created with a depth/stencil format, filter must be VK_FILTER_NEAREST", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00233", "srcImage must have been created with a samples value of VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00240", "If either srcImage or dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer and dstSubresource.baseArrayLayer must each be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1.", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00245", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffsets[0].y must be 0 and srcOffsets[1].y must be 1", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-00247", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffsets[0].z must be 0 and srcOffsets[1].z must be 1", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-01561", "srcImage must not use a format listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-01999", "The format features of srcImage must contain VK_FORMAT_FEATURE_BLIT_SRC_BIT", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImageLayout-00221", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImageLayout-00222", "srcImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "default"},
    {"VUID-VkBlitImageInfo2KHR-srcImageLayout-01398", "srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcOffset-00243", "For each element of pRegions, srcOffsets[0].x and srcOffsets[1].x must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcOffset-00244", "For each element of pRegions, srcOffsets[0].y and srcOffsets[1].y must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcOffset-00246", "For each element of pRegions, srcOffsets[0].z and srcOffsets[1].z must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcSubresource-01705", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.2-extensions"},
    {"VUID-VkBlitImageInfo2KHR-srcSubresource-01707", "The srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.2-extensions"},
    {"VUID-VkBufferCopy-size-01988", "The size must be greater than 0", "1.2-extensions"},
    {"VUID-VkBufferCopy2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkBufferCopy2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COPY_2_KHR", "1.2-extensions"},
    {"VUID-VkBufferCopy2KHR-size-01988", "The size must be greater than 0", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-None-01888", "If any of the bits VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT are set, VK_BUFFER_CREATE_PROTECTED_BIT must not also be set", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-deviceAddress-02604", "If VkBufferDeviceAddressCreateInfoEXT::deviceAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-flags-00915", "If the sparse bindings feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-flags-00916", "If the sparse buffer residency feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-flags-00917", "If the sparse aliased residency feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_ALIASED_BIT", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-flags-00918", "If flags contains VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-flags-01887", "If the protected memory feature is not enabled, flags must not contain VK_BUFFER_CREATE_PROTECTED_BIT", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-flags-03338", "If flags includes VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the bufferDeviceAddressCaptureReplay or VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::bufferDeviceAddressCaptureReplay feature must be enabled", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-flags-parameter", "flags must be a valid combination of VkBufferCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-opaqueCaptureAddress-03337", "If VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-pNext-00920", "If the pNext chain includes a VkExternalMemoryBufferCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalBufferProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalBufferProperties with pExternalBufferInfo->handleType equal to any one of the handle types specified in VkExternalMemoryBufferCreateInfo::handleTypes", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-pNext-01571", "If the pNext chain includes a VkDedicatedAllocationBufferCreateInfoNV structure, and the dedicatedAllocation member of the chained structure is VK_TRUE, then flags must not include VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferDeviceAddressCreateInfoEXT, VkBufferOpaqueCaptureAddressCreateInfo, VkDedicatedAllocationBufferCreateInfoNV, VkExternalMemoryBufferCreateInfo, VkVideoProfileKHR, or VkVideoProfilesKHR", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-sharingMode-00913", "If sharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-sharingMode-00914", "If sharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-sharingMode-01391", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device", "1.0"},
    {"VUID-VkBufferCreateInfo-sharingMode-01419", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties or vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-size-00912", "size must be greater than 0", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-usage-04813", "If usage includes VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR, VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR, then the pNext chain must include a valid VkVideoProfilesKHR structure which includes at least one VkVideoProfileKHR with a decode codec-operation.", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-usage-04814", "If usage includes VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR, then the pNext chain must include a valid VkVideoProfilesKHR structure which includes at least one VkVideoProfileKHR with a encode codec-operation.", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-usage-parameter", "usage must be a valid combination of VkBufferUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkBufferCreateInfo-usage-requiredbitmask", "usage must not be 0", "1.2-extensions"},
    {"VUID-VkBufferDeviceAddressCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-02600", "If buffer is non-sparse and was not created with the VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT flag, then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-02601", "buffer must have been created with VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT", "1.2-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", "1.2-extensions"},
    {"VUID-VkBufferImageCopy-aspectMask-00212", "The aspectMask member of imageSubresource must only have a single bit set", "1.2-extensions"},
    {"VUID-VkBufferImageCopy-bufferImageHeight-00196", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", "1.2-extensions"},
    {"VUID-VkBufferImageCopy-bufferRowLength-00195", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", "1.2-extensions"},
    {"VUID-VkBufferImageCopy-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkBufferImageCopy2KHR-aspectMask-00212", "The aspectMask member of imageSubresource must only have a single bit set", "1.2-extensions"},
    {"VUID-VkBufferImageCopy2KHR-bufferImageHeight-00196", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", "1.2-extensions"},
    {"VUID-VkBufferImageCopy2KHR-bufferRowLength-00195", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", "1.2-extensions"},
    {"VUID-VkBufferImageCopy2KHR-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkBufferImageCopy2KHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkCopyCommandTransformInfoQCOM", "1.2-extensions"},
    {"VUID-VkBufferImageCopy2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR", "1.2-extensions"},
    {"VUID-VkBufferImageCopy2KHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-buffer-01931", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-buffer-04086", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex and dstQueueFamilyIndex must be valid queue families", "1.0"},
    {"VUID-VkBufferMemoryBarrier-buffer-04088", "If buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, and one of srcQueueFamilyIndex and dstQueueFamilyIndex is one of the special queue family values reserved for external memory transfers, the other must be VK_QUEUE_FAMILY_IGNORED", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-buffer-04089", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex and dstQueueFamilyIndex must both be valid queue families, or one of the special queue family values reserved for external memory transfers, as described in Queue Family Ownership Transfer", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-offset-01187", "offset must be less than the size of buffer", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-size-01188", "If size is not equal to VK_WHOLE_SIZE, size must be greater than 0", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-size-01189", "If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-srcQueueFamilyIndex-04087", "If srcQueueFamilyIndex is not equal to dstQueueFamilyIndex, at least one must not be a special queue family reserved for external memory ownership transfers, as described in Queue Family Ownership Transfer", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier-synchronization2-03852", "If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex and dstQueueFamilyIndex must both be VK_QUEUE_FAMILY_IGNORED", "1.0"},
    {"VUID-VkBufferMemoryBarrier-synchronization2-03853", "If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, at least one of srcQueueFamilyIndex and dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-buffer-01931", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-buffer-04086", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex and dstQueueFamilyIndex must be valid queue families", "default"},
    {"VUID-VkBufferMemoryBarrier2KHR-buffer-04088", "If buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, and one of srcQueueFamilyIndex and dstQueueFamilyIndex is one of the special queue family values reserved for external memory transfers, the other must be VK_QUEUE_FAMILY_IGNORED", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-buffer-04089", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex and dstQueueFamilyIndex must both be valid queue families, or one of the special queue family values reserved for external memory transfers, as described in Queue Family Ownership Transfer", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03900", "If pname:dstAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03901", "If pname:dstAccessMask includes VK_ACCESS_2_INDEX_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03902", "If pname:dstAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03903", "If pname:dstAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT_KHR, VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03904", "If pname:dstAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03905", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03906", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03907", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03908", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03909", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03910", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03911", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03912", "If pname:dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03913", "If pname:dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03914", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03915", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_CLEAR_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03916", "If pname:dstAccessMask includes VK_ACCESS_2_HOST_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03917", "If pname:dstAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03918", "If pname:dstAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03919", "If pname:dstAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03920", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03922", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03923", "If pname:dstAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03924", "If pname:dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03925", "If pname:dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03926", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03927", "If pname:dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-03928", "If pname:dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-04747", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-04858", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-04859", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-04860", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-04861", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-03929", "If the geometry shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-03930", "If the tessellation shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-03931", "If the conditional rendering feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-03932", "If the fragment density map feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-03933", "If the transform feedback feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-03934", "If the mesh shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-03935", "If the task shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-04956", "If the shading rate image feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-04957", "If the subpass shading feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-offset-01187", "offset must be less than the size of buffer", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-size-01188", "If size is not equal to VK_WHOLE_SIZE, size must be greater than 0", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-size-01189", "If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03900", "If pname:srcAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03901", "If pname:srcAccessMask includes VK_ACCESS_2_INDEX_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03902", "If pname:srcAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03903", "If pname:srcAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT_KHR, VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03904", "If pname:srcAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03905", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03906", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03907", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03908", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03909", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03910", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03911", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03912", "If pname:srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03913", "If pname:srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03914", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03915", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_CLEAR_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03916", "If pname:srcAccessMask includes VK_ACCESS_2_HOST_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03917", "If pname:srcAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03918", "If pname:srcAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03919", "If pname:srcAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03920", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03922", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03923", "If pname:srcAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03924", "If pname:srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03925", "If pname:srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03926", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03927", "If pname:srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-03928", "If pname:srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-04747", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-04858", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-04859", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-04860", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-04861", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcQueueFamilyIndex-04087", "If srcQueueFamilyIndex is not equal to dstQueueFamilyIndex, at least one must not be a special queue family reserved for external memory ownership transfers, as described in Queue Family Ownership Transfer", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-03851", "If either srcStageMask or dstStageMask includes VK_PIPELINE_STAGE_2_HOST_BIT_KHR, srcQueueFamilyIndex and dstQueueFamilyIndex must be equal", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-03929", "If the geometry shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-03930", "If the tessellation shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-03931", "If the conditional rendering feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-03932", "If the fragment density map feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-03933", "If the transform feedback feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-03934", "If the mesh shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-03935", "If the task shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-04956", "If the shading rate image feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-04957", "If the subpass shading feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI", "1.2-extensions"},
    {"VUID-VkBufferMemoryBarrier2KHR-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkBufferMemoryRequirementsInfo2-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkBufferMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkBufferMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2", "1.2-extensions"},
    {"VUID-VkBufferOpaqueCaptureAddressCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-00932", "buffer must have been created with a usage value containing at least one of VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT or VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-00933", "If buffer was created with usage containing VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, format must be supported for uniform texel buffers, as specified by the VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT flag in VkFormatProperties::bufferFeatures returned by vkGetPhysicalDeviceFormatProperties", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-00934", "If buffer was created with usage containing VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, format must be supported for storage texel buffers, as specified by the VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT flag in VkFormatProperties::bufferFeatures returned by vkGetPhysicalDeviceFormatProperties", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-00935", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-02750", "If the texelBufferAlignment feature is enabled and if buffer was created with usage containing VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT::storageTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT::storageTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-02751", "If the texelBufferAlignment feature is enabled and if buffer was created with usage containing VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT::uniformTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT::uniformTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-offset-00925", "offset must be less than the size of buffer", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-offset-00926", "offset must be a multiple of VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment", "1.2-khr-extensions"},
    {"VUID-VkBufferViewCreateInfo-offset-00931", "If range is not equal to VK_WHOLE_SIZE, the sum of offset and range must be less than or equal to the size of buffer", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-offset-02749", "If the texelBufferAlignment feature is not enabled, offset must be a multiple of VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-range-00928", "If range is not equal to VK_WHOLE_SIZE, range must be greater than 0", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-range-00929", "If range is not equal to VK_WHOLE_SIZE, range must be an integer multiple of the texel block size of format", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-range-00930", "If range is not equal to VK_WHOLE_SIZE, the number of texel buffer elements given by ({lfloor}range / (texel block size){rfloor} {times} (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-range-04059", "If range is equal to VK_WHOLE_SIZE, the number of texel buffer elements given by ({lfloor}(size - offset) / (texel block size){rfloor} {times} (texels per block)) where size is the size of buffer, and texel block size and texels per block are as defined in the Compatible Formats table for format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "1.2-extensions"},
    {"VUID-VkBufferViewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkCalibratedTimestampInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCalibratedTimestampInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT", "1.2-extensions"},
    {"VUID-VkCalibratedTimestampInfoEXT-timeDomain-02354", "timeDomain must be one of the VkTimeDomainEXT values returned by vkGetPhysicalDeviceCalibrateableTimeDomainsEXT", "1.2-extensions"},
    {"VUID-VkCalibratedTimestampInfoEXT-timeDomain-parameter", "timeDomain must be a valid VkTimeDomainEXT value", "1.2-extensions"},
    {"VUID-VkCheckpointData2NV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCheckpointData2NV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV", "1.2-extensions"},
    {"VUID-VkCheckpointDataNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCheckpointDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV", "1.2-extensions"},
    {"VUID-VkClearAttachment-aspectMask-00019", "If aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, it must not include VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "1.2-extensions"},
    {"VUID-VkClearAttachment-aspectMask-00020", "aspectMask must not include VK_IMAGE_ASPECT_METADATA_BIT", "1.2-extensions"},
    {"VUID-VkClearAttachment-aspectMask-02246", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.2-extensions"},
    {"VUID-VkClearAttachment-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.2-extensions"},
    {"VUID-VkClearAttachment-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.2-extensions"},
    {"VUID-VkClearAttachment-clearValue-00021", "clearValue must be a valid VkClearValue union", "1.2-extensions"},
    {"VUID-VkClearDepthStencilValue-depth-00022", "Unless the VK_EXT_depth_range_unrestricted extension is enabled depth must be between 0.0 and 1.0, inclusive", "1.2-extensions"},
    {"VUID-VkClearDepthStencilValue-depth-02506", "depth must be between 0.0 and 1.0, inclusive", "1.2-khr-extensions"},
    {"VUID-VkCoarseSampleLocationNV-pixelX-02078", "pixelX must be less than the width (in pixels) of the fragment", "1.2-extensions"},
    {"VUID-VkCoarseSampleLocationNV-pixelY-02079", "pixelY must be less than the height (in pixels) of the fragment", "1.2-extensions"},
    {"VUID-VkCoarseSampleLocationNV-sample-02080", "sample must be less than the number of coverage samples in each pixel belonging to the fragment", "1.2-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-02077", "The array pSampleLocations must contain exactly one entry for every combination of valid values for pixelX, pixelY, and sample in the structure VkCoarseSampleOrderCustomNV", "1.2-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-parameter", "pSampleLocations must be a valid pointer to an array of sampleLocationCount VkCoarseSampleLocationNV structures", "1.2-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleCount-02074", "sampleCount must correspond to a sample count enumerated in VkSampleCountFlags whose corresponding bit is set in VkPhysicalDeviceLimits::framebufferNoAttachmentsSampleCounts", "1.2-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02075", "sampleLocationCount must be equal to the product of sampleCount, the fragment width for shadingRate, and the fragment height for shadingRate", "1.2-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02076", "sampleLocationCount must be less than or equal to the value of VkPhysicalDeviceShadingRateImagePropertiesNV::shadingRateMaxCoarseSamples", "1.2-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-arraylength", "sampleLocationCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-02073", "shadingRate must be a shading rate that generates fragments with more than one pixel", "1.2-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-parameter", "shadingRate must be a valid VkShadingRatePaletteEntryNV value", "1.2-extensions"},
    {"VUID-VkCommandBufferAllocateInfo-commandPool-parameter", "commandPool must be a valid VkCommandPool handle", "1.2-extensions"},
    {"VUID-VkCommandBufferAllocateInfo-level-parameter", "level must be a valid VkCommandBufferLevel value", "1.2-extensions"},
    {"VUID-VkCommandBufferAllocateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCommandBufferAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO", "1.2-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-00053", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the renderPass member of pInheritanceInfo must be a valid VkRenderPass", "1.2-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-00054", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the subpass member of pInheritanceInfo must be a valid subpass index within the renderPass member of pInheritanceInfo", "1.2-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-00055", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the framebuffer member of pInheritanceInfo must be either VK_NULL_HANDLE, or a valid VkFramebuffer that is compatible with the renderPass member of pInheritanceInfo", "1.2-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-parameter", "flags must be a valid combination of VkCommandBufferUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkCommandBufferBeginInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDeviceGroupCommandBufferBeginInfo", "1.2-extensions"},
    {"VUID-VkCommandBufferBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO", "1.2-extensions"},
    {"VUID-VkCommandBufferBeginInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-conditionalRenderingEnable-01977", "If the inherited conditional rendering feature is not enabled, conditionalRenderingEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-commonparent", "Both of framebuffer, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-occlusionQueryEnable-00056", "If the inherited queries feature is not enabled, occlusionQueryEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkCommandBufferInheritanceConditionalRenderingInfoEXT, VkCommandBufferInheritanceRenderPassTransformInfoQCOM, or VkCommandBufferInheritanceViewportScissorInfoNV", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-00058", "If the pipeline statistics queries feature is not enabled, pipelineStatistics must be 0", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-02789", "If the pipeline statistics queries feature is enabled, pipelineStatistics must be a valid combination of VkQueryPipelineStatisticFlagBits values", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-queryFlags-00057", "If the inherited queries feature is enabled, queryFlags must be a valid combination of VkQueryControlFlagBits values", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-queryFlags-02788", "If the inherited queries feature is not enabled, queryFlags must be 0", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-transform-02864", "transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04782", "If the inherited viewport scissor feature is not enabled, viewportScissor2D must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04783", "If the multiple viewports feature is not enabled and viewportScissor2D is VK_TRUE, then viewportDepthCount must be 1", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04784", "If viewportScissor2D is VK_TRUE, then viewportDepthCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04785", "If viewportScissor2D is VK_TRUE, then pViewportDepths must be a valid pointer to an array of viewportDepthCount valid VkViewport structures, except any requirements on x, y, width, and height do not apply.", "1.2-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04786", "If viewportScissor2D is VK_TRUE, then the command buffer must be recorded with the VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT.", "1.2-extensions"},
    {"VUID-VkCommandBufferSubmitInfoKHR-commandBuffer-03890", "commandBuffer must not have been allocated with VK_COMMAND_BUFFER_LEVEL_SECONDARY", "1.2-extensions"},
    {"VUID-VkCommandBufferSubmitInfoKHR-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle", "1.2-extensions"},
    {"VUID-VkCommandBufferSubmitInfoKHR-deviceMask-03891", "If deviceMask is not 0, it must be a valid device mask", "1.2-extensions"},
    {"VUID-VkCommandBufferSubmitInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCommandBufferSubmitInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkCommandPoolCreateInfo-flags-02860", "If the protected memory feature is not enabled, the VK_COMMAND_POOL_CREATE_PROTECTED_BIT bit of flags must not be set", "1.2-extensions"},
    {"VUID-VkCommandPoolCreateInfo-flags-parameter", "flags must be a valid combination of VkCommandPoolCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkCommandPoolCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCommandPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkComponentMapping-a-parameter", "a must be a valid VkComponentSwizzle value", "1.2-extensions"},
    {"VUID-VkComponentMapping-b-parameter", "b must be a valid VkComponentSwizzle value", "1.2-extensions"},
    {"VUID-VkComponentMapping-g-parameter", "g must be a valid VkComponentSwizzle value", "1.2-extensions"},
    {"VUID-VkComponentMapping-r-parameter", "r must be a valid VkComponentSwizzle value", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-00697", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid handle to a compute VkPipeline", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-00698", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-00699", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is not -1, basePipelineHandle must be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-00700", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is not VK_NULL_HANDLE, basePipelineIndex must be -1", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-02874", "flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03364", "flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03365", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03366", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03367", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03368", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03369", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03370", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03576", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-04945", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-parameter", "flags must be a valid combination of VkPipelineCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-00703", "layout must be consistent with the layout of the compute shader specified in stage", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-01687", "The number of resources in layout accessible to the compute shader stage must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-parameter", "layout must be a valid VkPipelineLayout handle", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreationFeedbackCreateInfoEXT, or VkSubpassShadingPipelineCreateInfoHUAWEI", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-pipelineCreationCacheControl-02875", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-stage-00701", "The stage member of stage must be VK_SHADER_STAGE_COMPUTE_BIT", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-stage-00702", "The shader code for the entry point identified by stage and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.2-extensions"},
    {"VUID-VkComputePipelineCreateInfo-stage-parameter", "stage must be a valid VkPipelineShaderStageCreateInfo structure", "1.2-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01981", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01982", "buffer must have been created with the VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT bit set", "1.2-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-flags-parameter", "flags must be a valid combination of VkConditionalRenderingFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01983", "offset must be less than the size of buffer by at least 32 bits", "1.2-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01984", "offset must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT", "1.2-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-AType-parameter", "AType must be a valid VkComponentTypeNV value", "1.2-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-BType-parameter", "BType must be a valid VkComponentTypeNV value", "1.2-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-CType-parameter", "CType must be a valid VkComponentTypeNV value", "1.2-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-DType-parameter", "DType must be a valid VkComponentTypeNV value", "1.2-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-scope-parameter", "scope must be a valid VkScopeNV value", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-buffer-03718", "The buffer used to create src must be bound to device memory", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-buffer-03719", "The buffer used to create dst must be bound to device memory", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-commonparent", "Both of dst, and src must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-dst-parameter", "dst must be a valid VkAccelerationStructureKHR handle", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-mode-03410", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR or VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-03411", "If mode is VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR, src must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-04963", "The source acceleration structure src must have been built prior to the execution of this command", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-parameter", "src must be a valid VkAccelerationStructureKHR handle", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-dst-03561", "The memory pointed to by dst must be at least as large as the serialization size of src, as reported by vkWriteAccelerationStructuresPropertiesKHR or vkCmdWriteAccelerationStructuresPropertiesKHR with a query type of VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-mode-03412", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-src-04959", "The source acceleration structure src must have been built prior to the execution of this command", "1.2-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-src-parameter", "src must be a valid VkAccelerationStructureKHR handle", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-commonparent", "Both of dstBuffer, and srcBuffer must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-dstBuffer-00120", "dstBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-dstBuffer-00121", "If dstBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-dstBuffer-parameter", "dstBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-dstOffset-00114", "The dstOffset member of each element of pRegions must be less than the size of dstBuffer", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-pRegions-00117", "The union of the source regions, and the union of the destination regions, specified by the elements of pRegions, must not overlap in memory", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferCopy2KHR structures", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-regionCount-arraylength", "regionCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-size-00115", "The size member of each element of pRegions must be less than or equal to the size of srcBuffer minus srcOffset", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-size-00116", "The size member of each element of pRegions must be less than or equal to the size of dstBuffer minus dstOffset", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-srcBuffer-00118", "srcBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-srcBuffer-00119", "If srcBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-srcBuffer-parameter", "srcBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkCopyBufferInfo2KHR-srcOffset-00113", "The srcOffset member of each element of pRegions must be less than the size of srcBuffer", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-None-00214", "For each element of pRegions whose imageSubresource contains a depth aspect, the data in srcBuffer must be in the range [0,1]", "1.2-khr-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-aspectMask-00211", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-aspectMask-01560", "If {imageparam} has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT (with VK_IMAGE_ASPECT_PLANE_2_BIT valid only for image formats with three planes)", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-baseArrayLayer-00213", "If {imageparam} is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-bufferImageHeight-00204", "If {imageparam} is a blocked image, for each element of pRegions, bufferImageHeight must be a multiple of the compressed texel block height", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-bufferOffset-00193", "If {imageparam} does not have a depth/stencil format, then for each element of pRegions, bufferOffset must be a multiple of the format's texel block size", "default"},
    {"VUID-VkCopyBufferToImageInfo2KHR-bufferOffset-00206", "If {imageparam} is a blocked image, for each element of pRegions, bufferOffset must be a multiple of the compressed texel block size in bytes", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-bufferOffset-01558", "If {imageparam} does not have either a depth/stencil or a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the format's texel block size", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-bufferOffset-01559", "If {imageparam} has a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible formats of planes of multi-planar formats", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-bufferRowLength-00203", "If {imageparam} is a blocked image, for each element of pRegions, bufferRowLength must be a multiple of the compressed texel block width", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-commandBuffer-04052", "If the queue family used to create the VkCommandPool which commandBuffer was allocated from does not support VK_QUEUE_GRAPHICS_BIT or VK_QUEUE_COMPUTE_BIT, the bufferOffset member of any element of pRegions must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-commandBuffer-04477", "If the queue family used to create the VkCommandPool which commandBuffer was allocated from does not support VK_QUEUE_GRAPHICS_BIT, for each element of pRegions, the aspectMask member of imageSubresource must not be VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT.", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-commonparent", "Both of dstImage, and srcBuffer must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImage-00177", "dstImage must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImage-00178", "If dstImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImage-00179", "dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImage-01997", "The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImage-02543", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImageLayout-00180", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImageLayout-00181", "dstImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "default"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImageLayout-01396", "dstImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, VK_IMAGE_LAYOUT_GENERAL, or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageExtent-00207", "If {imageparam} is a blocked image, for each element of pRegions, imageExtent.width must be a multiple of the compressed texel block width or (imageExtent.width + imageOffset.x) must equal the width of the specified imageSubresource of {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageExtent-00208", "If {imageparam} is a blocked image, for each element of pRegions, imageExtent.height must be a multiple of the compressed texel block height or (imageExtent.height + imageOffset.y) must equal the height of the specified imageSubresource of {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageExtent-00209", "If {imageparam} is a blocked image, for each element of pRegions, imageExtent.depth must be a multiple of the compressed texel block depth or (imageExtent.depth + imageOffset.z) must equal the depth of the specified imageSubresource of {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageOffset-00197", "For each element of pRegions", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageOffset-00198", "For each element of pRegions", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageOffset-00200", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageOffset-00205", "If {imageparam} is a blocked image, for each element of pRegions, all members of imageOffset must be a multiple of the corresponding dimensions of the compressed texel block", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageOffset-01793", "The imageOffset and imageExtent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageSubresource-01701", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-imageSubresource-01702", "The imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-00171", "srcBuffer must be large enough to contain all buffer locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-00172", "The image region specified by each element of pRegions must be a region that is contained within dstImage", "1.2-khr-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-00173", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04554", "If the image region specified by each element of pRegions does contain VkCopyCommandTransformInfoQCOM in its pNext chain, the rotated destination region as described in Buffer and Image Addressing with Rotation must be contained within dstImage.", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04555", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then the dstImage must not be a blocked image.", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04556", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then the dstImage must be of type VK_IMAGE_TYPE_2D and must not be a multi-planar format.", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04565", "If the image region specified by each element of pRegions does not contain VkCopyCommandTransformInfoQCOM in its pNext chain, it must be a region that is contained within dstImage", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04725", "If {imageparam} is not a blocked image, for each element of pRegions, bufferRowLength multiplied by the texel block size of {imageparam} must be less than or equal to 231-1", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04726", "If {imageparam} is a blocked image, for each element of pRegions, bufferRowLength divided by the compressed texel block width and then multiplied by the texel block size of {imageparam} must be less than or equal to 231-1", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferImageCopy2KHR structures", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-regionCount-arraylength", "regionCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-srcBuffer-00174", "srcBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-srcBuffer-00176", "If srcBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-srcBuffer-parameter", "srcBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-srcImage-00199", "If {imageparam} is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-srcImage-00201", "If {imageparam} is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "1.2-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-srcImage-04053", "If {imageparam} has a depth/stencil format, the bufferOffset member of any element of pRegions must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkCopyCommandTransformInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM", "1.2-extensions"},
    {"VUID-VkCopyCommandTransformInfoQCOM-transform-04560", "transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-commonparent", "Both of dstSet, and srcSet must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-dstArrayElement-00348", "The sum of dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by dstBinding, and all applicable consecutive bindings, as described by consecutive binding updates", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-dstBinding-00347", "dstBinding must be a valid binding within dstSet", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02224", "If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, dstArrayElement must be an integer multiple of 4", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02632", "The type of dstBinding within dstSet must be equal to the type of srcBinding within srcSet", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02753", "If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_SAMPLER, then dstSet must not have been allocated with a layout that included immutable samplers for dstBinding", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-dstSet-04612", "If VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, the new active descriptor type must exist in the corresponding pMutableDescriptorTypeLists list for dstBinding if the new active descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_VALVE", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-dstSet-04614", "If VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, and the new active descriptor type is VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, the pMutableDescriptorTypeLists for srcBinding and dstBinding must match exactly", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-dstSet-parameter", "dstSet must be a valid VkDescriptorSet handle", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcArrayElement-00346", "The sum of srcArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by srcBinding, and all applicable consecutive bindings, as described by consecutive binding updates", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcBinding-00345", "srcBinding must be a valid binding within srcSet", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcBinding-02223", "If the descriptor type of the descriptor set binding specified by srcBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, srcArrayElement must be an integer multiple of 4", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcBinding-02225", "If the descriptor type of the descriptor set binding specified by either srcBinding or dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, descriptorCount must be an integer multiple of 4", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-00349", "If srcSet is equal to dstSet, then the source and destination ranges of descriptors must not overlap, where the ranges may include array elements from consecutive bindings as described by consecutive binding updates", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-01918", "If srcSet's layout was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must also have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-01920", "If the descriptor pool from which srcSet was allocated was created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must also have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-04613", "If VkDescriptorSetLayoutBinding for srcSet at srcBinding is VK_DESCRIPTOR_TYPE_MUTABLE_VALVE and the VkDescriptorSetLayoutBinding for dstSet at dstBinding is not VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, the active descriptor type for the source descriptor must match the descriptor type of dstBinding", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-04885", "If srcSet's layout was created with neither VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT nor VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE flags set, then dstSet's layout must have been created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-04886", "If srcSet's layout was created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must also have been created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", "1.2-khr-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-04887", "If the descriptor pool from which srcSet was allocated was created with neither VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT nor VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE flags set, then the descriptor pool from which dstSet was allocated must have been created without the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "1.2-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-04888", "If the descriptor pool from which srcSet was allocated was created without the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must also have been created without the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "1.2-khr-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-parameter", "srcSet must be a valid VkDescriptorSet handle", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-None-01549", "In a copy to or from a plane of a multi-planar image, the VkFormat of the image and plane must be compatible according to the description of compatible planes for the plane being copied", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-aspectMask-00142", "For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-aspectMask-00143", "For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-00131", "dstImage must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-00132", "If dstImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "default"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-00152", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.y must be 0 and extent.height must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01547", "If dstImage is non-sparse then the image or disjoint plane that is the destination of the copy must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01554", "If dstImage has a VkFormat with two planes then for each element of pRegions, dstSubresource.aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT or VK_IMAGE_ASPECT_PLANE_1_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01555", "If dstImage has a VkFormat with three planes then for each element of pRegions, dstSubresource.aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01557", "If dstImage has a multi-planar image format and the srcImage does not have a multi-planar image format, then for each element of pRegions, srcSubresource.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01731", "If dstImage is a blocked image, then for each element of pRegions, all members of dstOffset must be a multiple of the corresponding dimensions of the compressed texel block", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01732", "If dstImage is a blocked image, then for each element of pRegions, extent.width must be a multiple of the compressed texel block width or (extent.width + dstOffset.x) must equal the width of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01733", "If dstImage is a blocked image, then for each element of pRegions, extent.height must be a multiple of the compressed texel block height or (extent.height + dstOffset.y) must equal the height of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01734", "If dstImage is a blocked image, then for each element of pRegions, extent.depth must be a multiple of the compressed texel block depth or (extent.depth + dstOffset.z) must equal the depth of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01786", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.z must be 0 and extent.depth must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01788", "If dstImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffset.z must be 0", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01792", "If dstImage is of type VK_IMAGE_TYPE_2D, and srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, extent.depth must equal dstSubresource.layerCount", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-01996", "The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-02542", "dstImage and srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-04444", "If dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstSubresource.baseArrayLayer must be 0 and dstSubresource.layerCount must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImageLayout-00133", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImageLayout-00134", "dstImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "default"},
    {"VUID-VkCopyImageInfo2KHR-dstImageLayout-01395", "dstImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, VK_IMAGE_LAYOUT_GENERAL, or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstOffset-00150", "For each element of pRegions, dstOffset.x and (extent.width + dstOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstOffset-00151", "For each element of pRegions, dstOffset.y and (extent.height + dstOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstOffset-00153", "For each element of pRegions, dstOffset.z and (extent.depth + dstOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstOffset-01784", "The dstOffset and extent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstSubresource-01697", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-dstSubresource-01699", "The dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-pRegions-00124", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageCopy2KHR structures", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-regionCount-arraylength", "regionCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-00126", "srcImage must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-00127", "If srcImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "default"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-00135", "The VkFormat of each of srcImage and dstImage must be compatible, as defined above", "default"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-00136", "The sample count of srcImage and dstImage must match", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-00139", "If either srcImage or dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer and dstSubresource.baseArrayLayer must each be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1", "default"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-00146", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.y must be 0 and extent.height must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01546", "If srcImage is non-sparse then the image or disjoint plane to be copied must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01548", "If the VkFormat of each of srcImage and dstImage is not a multi-planar format, the VkFormat of each of srcImage and dstImage must be compatible, as defined above", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01551", "If neither srcImage nor dstImage has a multi-planar image format then for each element of pRegions, srcSubresource.aspectMask and dstSubresource.aspectMask must match", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01552", "If srcImage has a VkFormat with two planes then for each element of pRegions, srcSubresource.aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT or VK_IMAGE_ASPECT_PLANE_1_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01553", "If srcImage has a VkFormat with three planes then for each element of pRegions, srcSubresource.aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01556", "If srcImage has a multi-planar image format and the dstImage does not have a multi-planar image format, then for each element of pRegions, dstSubresource.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01727", "If srcImage is a blocked image, then for each element of pRegions, all members of srcOffset must be a multiple of the corresponding dimensions of the compressed texel block", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01728", "If srcImage is a blocked image, then for each element of pRegions, extent.width must be a multiple of the compressed texel block width or (extent.width + srcOffset.x) must equal the width of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01729", "If srcImage is a blocked image, then for each element of pRegions, extent.height must be a multiple of the compressed texel block height or (extent.height + srcOffset.y) must equal the height of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01730", "If srcImage is a blocked image, then for each element of pRegions, extent.depth must be a multiple of the compressed texel block depth or (extent.depth + srcOffset.z) must equal the depth of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01785", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.z must be 0 and extent.depth must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01787", "If srcImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffset.z must be 0", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01789", "If srcImage or dstImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, extent.depth must be 1", "default"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01790", "If srcImage and dstImage are both of type VK_IMAGE_TYPE_2D, then for each element of pRegions, extent.depth must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01791", "If srcImage is of type VK_IMAGE_TYPE_2D, and dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, extent.depth must equal srcSubresource.layerCount", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-01995", "The format features of srcImage must contain VK_FORMAT_FEATURE_TRANSFER_SRC_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-04443", "If srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer must be 0 and srcSubresource.layerCount must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImageLayout-00128", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImageLayout-00129", "srcImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "default"},
    {"VUID-VkCopyImageInfo2KHR-srcImageLayout-01917", "srcImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, VK_IMAGE_LAYOUT_GENERAL, or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcOffset-00144", "For each element of pRegions, srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcOffset-00145", "For each element of pRegions, srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcOffset-00147", "For each element of pRegions, srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcOffset-01783", "The srcOffset and extent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcSubresource-01696", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.2-extensions"},
    {"VUID-VkCopyImageInfo2KHR-srcSubresource-01698", "The srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-aspectMask-00211", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-aspectMask-01560", "If {imageparam} has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT (with VK_IMAGE_ASPECT_PLANE_2_BIT valid only for image formats with three planes)", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-baseArrayLayer-00213", "If {imageparam} is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-bufferImageHeight-00204", "If {imageparam} is a blocked image, for each element of pRegions, bufferImageHeight must be a multiple of the compressed texel block height", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-bufferOffset-00193", "If {imageparam} does not have a depth/stencil format, then for each element of pRegions, bufferOffset must be a multiple of the format's texel block size", "default"},
    {"VUID-VkCopyImageToBufferInfo2KHR-bufferOffset-00206", "If {imageparam} is a blocked image, for each element of pRegions, bufferOffset must be a multiple of the compressed texel block size in bytes", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-bufferOffset-01558", "If {imageparam} does not have either a depth/stencil or a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the format's texel block size", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-bufferOffset-01559", "If {imageparam} has a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible formats of planes of multi-planar formats", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-bufferRowLength-00203", "If {imageparam} is a blocked image, for each element of pRegions, bufferRowLength must be a multiple of the compressed texel block width", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-commandBuffer-04052", "If the queue family used to create the VkCommandPool which commandBuffer was allocated from does not support VK_QUEUE_GRAPHICS_BIT or VK_QUEUE_COMPUTE_BIT, the bufferOffset member of any element of pRegions must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-commonparent", "Both of dstBuffer, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-dstBuffer-00191", "dstBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-dstBuffer-00192", "If dstBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-dstBuffer-parameter", "dstBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageExtent-00207", "If {imageparam} is a blocked image, for each element of pRegions, imageExtent.width must be a multiple of the compressed texel block width or (imageExtent.width + imageOffset.x) must equal the width of the specified imageSubresource of {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageExtent-00208", "If {imageparam} is a blocked image, for each element of pRegions, imageExtent.height must be a multiple of the compressed texel block height or (imageExtent.height + imageOffset.y) must equal the height of the specified imageSubresource of {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageExtent-00209", "If {imageparam} is a blocked image, for each element of pRegions, imageExtent.depth must be a multiple of the compressed texel block depth or (imageExtent.depth + imageOffset.z) must equal the depth of the specified imageSubresource of {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageOffset-00197", "For each element of pRegions", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageOffset-00198", "For each element of pRegions", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageOffset-00200", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of {imageparam}", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageOffset-00205", "If {imageparam} is a blocked image, for each element of pRegions, all members of imageOffset must be a multiple of the corresponding dimensions of the compressed texel block", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageOffset-01794", "The imageOffset and imageExtent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageSubresource-01703", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-imageSubresource-01704", "The imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-00182", "The image region specified by each element of pRegions must be a region that is contained within srcImage", "1.2-khr-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-00183", "dstBuffer must be large enough to contain all buffer locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-00184", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04557", "If the image region specified by each element of pRegions does contain VkCopyCommandTransformInfoQCOM in its pNext chain, the rotated source region as described in Buffer and Image Addressing with Rotation must be contained within srcImage.", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04558", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then the srcImage must not be a blocked image", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04559", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then the srcImage must be of type VK_IMAGE_TYPE_2D, and must not be a multi-planar format.", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04566", "If the image region specified by each element of pRegions does not contain VkCopyCommandTransformInfoQCOM in its pNext chain, it must be a region that is contained within srcImage", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04725", "If {imageparam} is not a blocked image, for each element of pRegions, bufferRowLength multiplied by the texel block size of {imageparam} must be less than or equal to 231-1", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04726", "If {imageparam} is a blocked image, for each element of pRegions, bufferRowLength divided by the compressed texel block width and then multiplied by the texel block size of {imageparam} must be less than or equal to 231-1", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferImageCopy2KHR structures", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-regionCount-arraylength", "regionCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-00186", "srcImage must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-00187", "If srcImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-00188", "srcImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-00199", "If {imageparam} is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-00201", "If {imageparam} is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-01998", "The format features of srcImage must contain VK_FORMAT_FEATURE_TRANSFER_SRC_BIT", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-02544", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-04053", "If {imageparam} has a depth/stencil format, the bufferOffset member of any element of pRegions must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImageLayout-00189", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImageLayout-00190", "srcImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "default"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImageLayout-01397", "srcImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, VK_IMAGE_LAYOUT_GENERAL, or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", "1.2-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-dst-03746", "dst must have been created with a size greater than or equal to that used to serialize the data in src", "1.2-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-dst-parameter", "dst must be a valid VkAccelerationStructureKHR handle", "1.2-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-mode-03413", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR", "1.2-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "1.2-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-pInfo-03414", "The data in src must have a format compatible with the destination physical device as returned by vkGetDeviceAccelerationStructureCompatibilityKHR", "1.2-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-src-04960", "The source memory pointed to by src must contain data previously serialized using vkCmdCopyAccelerationStructureToMemoryKHR, potentially modified to relocate acceleration structure references as described in that command", "1.2-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-pSignalSemaphoreValues-parameter", "If signalSemaphoreValuesCount is not 0, and pSignalSemaphoreValues is not NULL, pSignalSemaphoreValues must be a valid pointer to an array of signalSemaphoreValuesCount uint64_t values", "1.2-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-pWaitSemaphoreValues-parameter", "If waitSemaphoreValuesCount is not 0, and pWaitSemaphoreValues is not NULL, pWaitSemaphoreValues must be a valid pointer to an array of waitSemaphoreValuesCount uint64_t values", "1.2-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-signalSemaphoreValuesCount-00080", "signalSemaphoreValuesCount must be the same value as VkSubmitInfo::signalSemaphoreCount, where VkSubmitInfo is in the pNext chain of this VkD3D12FenceSubmitInfoKHR structure.", "1.2-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-waitSemaphoreValuesCount-00079", "waitSemaphoreValuesCount must be the same value as VkSubmitInfo::waitSemaphoreCount, where VkSubmitInfo is in the pNext chain of this VkD3D12FenceSubmitInfoKHR structure.", "1.2-extensions"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-pMarkerName-parameter", "pMarkerName must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01491", "object must not be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01492", "object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-01490", "objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-parameter", "objectType must be a valid VkDebugReportObjectTypeEXT value", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-pObjectName-parameter", "pObjectName must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01494", "object must not be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01495", "object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-01493", "objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-parameter", "objectType must be a valid VkDebugReportObjectTypeEXT value", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-pTag-parameter", "pTag must be a valid pointer to an array of tagSize bytes", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-tagSize-arraylength", "tagSize must be greater than 0", "1.2-extensions"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-flags-parameter", "flags must be a valid combination of VkDebugReportFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-pfnCallback-parameter", "pfnCallback must be a valid PFN_vkDebugReportCallbackEXT value", "1.2-extensions"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDebugUtilsLabelEXT-pLabelName-parameter", "pLabelName must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkDebugUtilsLabelEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDebugUtilsLabelEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pCmdBufLabels-parameter", "If cmdBufLabelCount is not 0, pCmdBufLabels must be a valid pointer to an array of cmdBufLabelCount valid VkDebugUtilsLabelEXT structures", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessage-parameter", "pMessage must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessageIdName-parameter", "If pMessageIdName is not NULL, pMessageIdName must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pObjects-parameter", "If objectCount is not 0, pObjects must be a valid pointer to an array of objectCount valid VkDebugUtilsObjectNameInfoEXT structures", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pQueueLabels-parameter", "If queueLabelCount is not 0, pQueueLabels must be a valid pointer to an array of queueLabelCount valid VkDebugUtilsLabelEXT structures", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-parameter", "messageSeverity must be a valid combination of VkDebugUtilsMessageSeverityFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-requiredbitmask", "messageSeverity must not be 0", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-parameter", "messageType must be a valid combination of VkDebugUtilsMessageTypeFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-requiredbitmask", "messageType must not be 0", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-01914", "pfnUserCallback must be a valid PFN_vkDebugUtilsMessengerCallbackEXT", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-parameter", "pfnUserCallback must be a valid PFN_vkDebugUtilsMessengerCallbackEXT value", "1.2-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02589", "If objectType is VK_OBJECT_TYPE_UNKNOWN, objectHandle must not be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02590", "If objectType is not VK_OBJECT_TYPE_UNKNOWN, objectHandle must be VK_NULL_HANDLE or a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-parameter", "objectType must be a valid VkObjectType value", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-pObjectName-parameter", "If pObjectName is not NULL, pObjectName must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectHandle-01910", "objectHandle must be a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-01908", "objectType must not be VK_OBJECT_TYPE_UNKNOWN", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-parameter", "objectType must be a valid VkObjectType value", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-pTag-parameter", "pTag must be a valid pointer to an array of tagSize bytes", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-tagSize-arraylength", "tagSize must be greater than 0", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationBufferCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationImageCreateInfoNV-dedicatedAllocation-00994", "If dedicatedAllocation is VK_TRUE, VkImageCreateInfo::flags must not include VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationImageCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00651", "If buffer is not VK_NULL_HANDLE, the buffer must have been created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00653", "If buffer is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the buffer", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00655", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-commonparent", "Both of buffer, and image that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00649", "At least one of image and buffer must be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00650", "If image is not VK_NULL_HANDLE, the image must have been created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00652", "If image is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the image", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00654", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-parameter", "If image is not VK_NULL_HANDLE, image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkDependencyInfoKHR-dependencyFlags-parameter", "dependencyFlags must be a valid combination of VkDependencyFlagBits values", "1.2-extensions"},
    {"VUID-VkDependencyInfoKHR-pBufferMemoryBarriers-parameter", "If bufferMemoryBarrierCount is not 0, pBufferMemoryBarriers must be a valid pointer to an array of bufferMemoryBarrierCount valid VkBufferMemoryBarrier2KHR structures", "1.2-extensions"},
    {"VUID-VkDependencyInfoKHR-pImageMemoryBarriers-parameter", "If imageMemoryBarrierCount is not 0, pImageMemoryBarriers must be a valid pointer to an array of imageMemoryBarrierCount valid VkImageMemoryBarrier2KHR structures", "1.2-extensions"},
    {"VUID-VkDependencyInfoKHR-pMemoryBarriers-parameter", "If memoryBarrierCount is not 0, pMemoryBarriers must be a valid pointer to an array of memoryBarrierCount valid VkMemoryBarrier2KHR structures", "1.2-extensions"},
    {"VUID-VkDependencyInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDependencyInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEPENDENCY_INFO_KHR", "1.2-extensions"},
    {"VUID-VkDescriptorBufferInfo-buffer-02998", "If the nullDescriptor feature is not enabled, buffer must not be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkDescriptorBufferInfo-buffer-02999", "If buffer is VK_NULL_HANDLE, offset must be zero and range must be VK_WHOLE_SIZE", "1.2-extensions"},
    {"VUID-VkDescriptorBufferInfo-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkDescriptorBufferInfo-offset-00340", "offset must be less than the size of buffer", "1.2-extensions"},
    {"VUID-VkDescriptorBufferInfo-range-00341", "If range is not equal to VK_WHOLE_SIZE, range must be greater than 0", "1.2-extensions"},
    {"VUID-VkDescriptorBufferInfo-range-00342", "If range is not equal to VK_WHOLE_SIZE, range must be less than or equal to the size of buffer minus offset", "1.2-extensions"},
    {"VUID-VkDescriptorImageInfo-commonparent", "Both of imageView, and sampler that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkDescriptorImageInfo-imageLayout-00344", "imageLayout must match the actual VkImageLayout of each subresource accessible from imageView at the time this descriptor is accessed as defined by the image layout matching rules", "1.2-extensions"},
    {"VUID-VkDescriptorImageInfo-imageView-00343", "imageView must not be 2D or 2D array image view created from a 3D image", "1.2-extensions"},
    {"VUID-VkDescriptorImageInfo-imageView-01976", "If imageView is created from a depth/stencil image, the aspectMask used to create the imageView must include either VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT but not both", "1.2-extensions"},
    {"VUID-VkDescriptorImageInfo-mutableComparisonSamplers-04450", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::mutableComparisonSamplers is VK_FALSE, then sampler must have been created with VkSamplerCreateInfo::compareEnable set to VK_FALSE.", "1.2-extensions"},
    {"VUID-VkDescriptorImageInfo-sampler-01564", "If sampler is used and the VkFormat of the image is a multi-planar format, the image must have been created with VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, and the aspectMask of the imageView must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT or (for three-plane formats only) VK_IMAGE_ASPECT_PLANE_2_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-04607", "If flags has the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE bit set, then the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT bit must not be set", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-04609", "If flags has the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE bit set, VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE::mutableDescriptorType must be enabled", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-parameter", "flags must be a valid combination of VkDescriptorPoolCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-maxSets-00301", "maxSets must be greater than 0", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-mutableDescriptorType-04608", "If VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE::mutableDescriptorType is not enabled, pPoolSizes must not contain a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDescriptorPoolInlineUniformBlockCreateInfoEXT or VkMutableDescriptorTypeCreateInfoVALVE", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-04787", "If pPoolSizes contains a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, any other VK_DESCRIPTOR_TYPE_MUTABLE_VALVE element in pPoolSizes must not have sets of supported descriptor types which partially overlap", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-parameter", "pPoolSizes must be a valid pointer to an array of poolSizeCount valid VkDescriptorPoolSize structures", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-poolSizeCount-arraylength", "poolSizeCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkDescriptorPoolInlineUniformBlockCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDescriptorPoolSize-descriptorCount-00302", "descriptorCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkDescriptorPoolSize-type-02218", "If type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT then descriptorCount must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkDescriptorPoolSize-type-parameter", "type must be a valid VkDescriptorType value", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-commonparent", "Both of descriptorPool, and the elements of pSetLayouts must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorPool-00307", "descriptorPool must have enough free descriptor capacity remaining to allocate the descriptor sets of the specified layouts", "1.0"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorPool-parameter", "descriptorPool must be a valid VkDescriptorPool handle", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-00306", "descriptorSetCount must not be greater than the number of sets that are currently available for allocation in descriptorPool", "1.0"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-arraylength", "descriptorSetCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountAllocateInfo", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-00308", "Each element of pSetLayouts must not have been created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR set", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-03044", "If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-04610", "If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE flag set", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-parameter", "pSetLayouts must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSetLayout handles", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO", "1.2-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorCount-00283", "If descriptorCount is not 0, stageFlags must be a valid combination of VkShaderStageFlagBits values", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-00282", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and descriptorCount is not 0 and pImmutableSamplers is not NULL, pImmutableSamplers must be a valid pointer to an array of descriptorCount valid VkSampler handles", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-01510", "If descriptorType is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT and descriptorCount is not 0, then stageFlags must be 0 or VK_SHADER_STAGE_FRAGMENT_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-02209", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT then descriptorCount must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-02210", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT then descriptorCount must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxInlineUniformBlockSize", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-04604", "If the inlineUniformBlock feature is not enabled, descriptorType must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-04605", "If descriptorType is VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, then pImmutableSamplers must be NULL.", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-pImmutableSamplers-04009", "The sampler objects indicated by pImmutableSamplers must not have a borderColor with one of the values VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-None-03011", "All bindings with descriptor type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-bindingCount-03002", "If bindingCount is not zero, bindingCount must equal VkDescriptorSetLayoutCreateInfo::bindingCount", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingAccelerationStructureUpdateAfterBind-03570", "If VkPhysicalDeviceAccelerationStructureFeaturesKHR::descriptorBindingAccelerationStructureUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR or VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingInlineUniformBlockUpdateAfterBind-02211", "If VkPhysicalDeviceInlineUniformBlockFeaturesEXT::descriptorBindingInlineUniformBlockUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingPartiallyBound-03013", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingPartiallyBound is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingSampledImageUpdateAfterBind-03006", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingSampledImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_SAMPLER, VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, or VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageBufferUpdateAfterBind-03008", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageImageUpdateAfterBind-03007", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageTexelBufferUpdateAfterBind-03010", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformBufferUpdateAfterBind-03005", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformTexelBufferUpdateAfterBind-03009", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUpdateUnusedWhilePending-03012", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUpdateUnusedWhilePending is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingVariableDescriptorCount-03014", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingVariableDescriptorCount is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-flags-03003", "If VkDescriptorSetLayoutCreateInfo::flags includes VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT, VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT, or VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03004", "If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, then all other elements of VkDescriptorSetLayoutCreateInfo::pBindings must have a smaller value of binding", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03015", "If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, that element's descriptorType must not be VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-parameter", "If bindingCount is not 0, pBindingFlags must be a valid pointer to an array of bindingCount valid combinations of VkDescriptorBindingFlagBits values", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-binding-00279", "The VkDescriptorSetLayoutBinding::binding members of the elements of the pBindings array must each have different values", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-03001", "If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, then all bindings must not have descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-04593", "If any binding has a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, then a VkMutableDescriptorTypeCreateInfoVALVE must be present in the pNext chain", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-04594", "If a binding has a descriptorType value of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, then pImmutableSamplers must be NULL", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00280", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00281", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then the total number of elements of all bindings must be less than or equal to VkPhysicalDevicePushDescriptorPropertiesKHR::maxPushDescriptors", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-02208", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-03000", "If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, flags must include VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04590", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04591", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04592", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT, flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04596", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE, VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE::mutableDescriptorType must be enabled", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter", "flags must be a valid combination of VkDescriptorSetLayoutCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-mutableDescriptorType-04595", "If VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE::mutableDescriptorType is not enabled, pBindings must not contain a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter", "If bindingCount is not 0, pBindings must be a valid pointer to an array of bindingCount valid VkDescriptorSetLayoutBinding structures", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDescriptorSetLayoutBindingFlagsCreateInfo or VkMutableDescriptorTypeCreateInfoVALVE", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutSupport-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountLayoutSupport", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutSupport-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT", "1.2-extensions"},
    {"VUID-VkDescriptorSetLayoutSupport-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-descriptorSetCount-03045", "If descriptorSetCount is not zero, descriptorSetCount must equal VkDescriptorSetAllocateInfo::descriptorSetCount", "1.2-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts-parameter", "If descriptorSetCount is not 0, pDescriptorCounts must be a valid pointer to an array of descriptorSetCount uint32_t values", "1.2-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pSetLayouts-03046", "If VkDescriptorSetAllocateInfo::pSetLayouts[i] has a variable descriptor count binding, then pDescriptorCounts[i] must be less than or equal to the descriptor count specified for that binding when the descriptor set layout was created", "1.2-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO", "1.2-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountLayoutSupport-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-commonparent", "Both of descriptorSetLayout, and pipelineLayout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount-arraylength", "descriptorUpdateEntryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries-parameter", "pDescriptorUpdateEntries must be a valid pointer to an array of descriptorUpdateEntryCount valid VkDescriptorUpdateTemplateEntry structures", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00350", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must be a valid VkDescriptorSetLayout handle", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00351", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00352", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, pipelineLayout must be a valid VkPipelineLayout handle", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00353", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, set must be the unique set number in the pipeline layout that uses a descriptor set layout that was created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-04615", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must not contain a binding with type VK_DESCRIPTOR_TYPE_MUTABLE_VALVE", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-parameter", "templateType must be a valid VkDescriptorUpdateTemplateType value", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02226", "If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, dstArrayElement must be an integer multiple of 4", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02227", "If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, descriptorCount must be an integer multiple of 4", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-dstArrayElement-00355", "dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding implicitly specified when using a descriptor update template to update descriptors, and all applicable consecutive bindings, as described by consecutive binding updates", "1.2-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-dstBinding-00354", "dstBinding must be a valid binding in the descriptor set layout implicitly specified when using a descriptor update template to update descriptors", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-None-04896", "If sparseImageInt64Atomics is enabled, shaderImageInt64Atomics must be enabled", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-None-04897", "If sparseImageFloat32Atomics is enabled, shaderImageFloat32Atomics must be enabled", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-None-04898", "If sparseImageFloat32AtomicAdd is enabled, shaderImageFloat32AtomicAdd must be enabled", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04481", "If fragmentDensityMap is enabled, pipelineFragmentShadingRate must not be enabled", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04482", "If fragmentDensityMap is enabled, primitiveFragmentShadingRate must not be enabled", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04483", "If fragmentDensityMap is enabled, attachmentFragmentShadingRate must not be enabled", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-pEnabledFeatures-parameter", "If pEnabledFeatures is not NULL, pEnabledFeatures must be a valid pointer to a valid VkPhysicalDeviceFeatures structure", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-00373", "If the pNext chain includes a VkPhysicalDeviceFeatures2 structure, then pEnabledFeatures must be NULL", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-02829", "If the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then it must not include a VkPhysicalDevice16BitStorageFeatures, VkPhysicalDeviceMultiviewFeatures, VkPhysicalDeviceVariablePointersFeatures, VkPhysicalDeviceProtectedMemoryFeatures, VkPhysicalDeviceSamplerYcbcrConversionFeatures, or VkPhysicalDeviceShaderDrawParametersFeatures structure", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-02830", "If the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then it must not include a VkPhysicalDevice8BitStorageFeatures, VkPhysicalDeviceShaderAtomicInt64Features, VkPhysicalDeviceShaderFloat16Int8Features, VkPhysicalDeviceDescriptorIndexingFeatures, VkPhysicalDeviceScalarBlockLayoutFeatures, VkPhysicalDeviceImagelessFramebufferFeatures, VkPhysicalDeviceUniformBufferStandardLayoutFeatures, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, VkPhysicalDeviceHostQueryResetFeatures, VkPhysicalDeviceTimelineSemaphoreFeatures, VkPhysicalDeviceBufferDeviceAddressFeatures, or VkPhysicalDeviceVulkanMemoryModelFeatures structure", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-04748", "if the pNext chain includes a VkPhysicalDeviceVulkan12Features structure and VkPhysicalDeviceVulkan12Features::bufferDeviceAddress is VK_TRUE, ppEnabledExtensionNames must not contain VK_EXT_buffer_device_address", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceDeviceMemoryReportCreateInfoEXT, VkDeviceDiagnosticsConfigCreateInfoNV, VkDeviceGroupDeviceCreateInfo, VkDeviceMemoryOverallocationCreateInfoAMD, VkDevicePrivateDataCreateInfoEXT, VkPhysicalDevice16BitStorageFeatures, VkPhysicalDevice4444FormatsFeaturesEXT, VkPhysicalDevice8BitStorageFeatures, VkPhysicalDeviceASTCDecodeFeaturesEXT, VkPhysicalDeviceAccelerationStructureFeaturesKHR, VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, VkPhysicalDeviceBufferDeviceAddressFeatures, VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, VkPhysicalDeviceCoherentMemoryFeaturesAMD, VkPhysicalDeviceColorWriteEnableFeaturesEXT, VkPhysicalDeviceComputeShaderDerivativesFeaturesNV, VkPhysicalDeviceConditionalRenderingFeaturesEXT, VkPhysicalDeviceCooperativeMatrixFeaturesNV, VkPhysicalDeviceCornerSampledImageFeaturesNV, VkPhysicalDeviceCoverageReductionModeFeaturesNV, VkPhysicalDeviceCustomBorderColorFeaturesEXT, VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV, VkPhysicalDeviceDepthClipEnableFeaturesEXT, VkPhysicalDeviceDescriptorIndexingFeatures, VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV, VkPhysicalDeviceDeviceMemoryReportFeaturesEXT, VkPhysicalDeviceDiagnosticsConfigFeaturesNV, VkPhysicalDeviceExclusiveScissorFeaturesNV, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT, VkPhysicalDeviceExternalMemoryRDMAFeaturesNV, VkPhysicalDeviceFeatures2, VkPhysicalDeviceFragmentDensityMap2FeaturesEXT, VkPhysicalDeviceFragmentDensityMapFeaturesEXT, VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV, VkPhysicalDeviceFragmentShadingRateFeaturesKHR, VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT, VkPhysicalDeviceHostQueryResetFeatures, VkPhysicalDeviceImageRobustnessFeaturesEXT, VkPhysicalDeviceImagelessFramebufferFeatures, VkPhysicalDeviceIndexTypeUint8FeaturesEXT, VkPhysicalDeviceInheritedViewportScissorFeaturesNV, VkPhysicalDeviceInlineUniformBlockFeaturesEXT, VkPhysicalDeviceLineRasterizationFeaturesEXT, VkPhysicalDeviceMemoryPriorityFeaturesEXT, VkPhysicalDeviceMeshShaderFeaturesNV, VkPhysicalDeviceMultiDrawFeaturesEXT, VkPhysicalDeviceMultiviewFeatures, VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE, VkPhysicalDevicePerformanceQueryFeaturesKHR, VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT, VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR, VkPhysicalDevicePortabilitySubsetFeaturesKHR, VkPhysicalDevicePrivateDataFeaturesEXT, VkPhysicalDeviceProtectedMemoryFeatures, VkPhysicalDeviceProvokingVertexFeaturesEXT, VkPhysicalDeviceRayQueryFeaturesKHR, VkPhysicalDeviceRayTracingMotionBlurFeaturesNV, VkPhysicalDeviceRayTracingPipelineFeaturesKHR, VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV, VkPhysicalDeviceRobustness2FeaturesEXT, VkPhysicalDeviceSamplerYcbcrConversionFeatures, VkPhysicalDeviceScalarBlockLayoutFeatures, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, VkPhysicalDeviceShaderAtomicInt64Features, VkPhysicalDeviceShaderClockFeaturesKHR, VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT, VkPhysicalDeviceShaderDrawParametersFeatures, VkPhysicalDeviceShaderFloat16Int8Features, VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT, VkPhysicalDeviceShaderImageFootprintFeaturesNV, VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL, VkPhysicalDeviceShaderSMBuiltinsFeaturesNV, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR, VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR, VkPhysicalDeviceShadingRateImageFeaturesNV, VkPhysicalDeviceSubgroupSizeControlFeaturesEXT, VkPhysicalDeviceSubpassShadingFeaturesHUAWEI, VkPhysicalDeviceSynchronization2FeaturesKHR, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT, VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT, VkPhysicalDeviceTimelineSemaphoreFeatures, VkPhysicalDeviceTransformFeedbackFeaturesEXT, VkPhysicalDeviceUniformBufferStandardLayoutFeatures, VkPhysicalDeviceVariablePointersFeatures, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT, VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT, VkPhysicalDeviceVulkan11Features, VkPhysicalDeviceVulkan12Features, VkPhysicalDeviceVulkanMemoryModelFeatures, VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT, VkPhysicalDeviceYcbcrImageArraysFeaturesEXT, or VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-pProperties-04451", "If the [VK_KHR_portability_subset] extension is included in pProperties of vkEnumerateDeviceExtensionProperties, ppEnabledExtensions must include \"VK_KHR_portability_subset\".", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-parameter", "pQueueCreateInfos must be a valid pointer to an array of queueCreateInfoCount valid VkDeviceQueueCreateInfo structures", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-00374", "ppEnabledExtensionNames must not contain both VK_KHR_maintenance1 and VK_AMD_negative_viewport_height", "1.0-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-01840", "ppEnabledExtensionNames must not contain VK_AMD_negative_viewport_height", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-03328", "ppEnabledExtensionNames must not contain both VK_KHR_buffer_device_address and VK_EXT_buffer_device_address", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-parameter", "If enabledExtensionCount is not 0, ppEnabledExtensionNames must be a valid pointer to an array of enabledExtensionCount null-terminated UTF-8 strings", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02831", "If ppEnabledExtensions contains \"VK_KHR_draw_indirect_count\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::drawIndirectCount must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02832", "If ppEnabledExtensions contains \"VK_KHR_sampler_mirror_clamp_to_edge\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerMirrorClampToEdge must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02833", "If ppEnabledExtensions contains \"VK_EXT_descriptor_indexing\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::descriptorIndexing must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02834", "If ppEnabledExtensions contains \"VK_EXT_sampler_filter_minmax\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerFilterMinmax must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02835", "If ppEnabledExtensions contains \"VK_EXT_shader_viewport_index_layer\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::shaderOutputViewportIndex and VkPhysicalDeviceVulkan12Features::shaderOutputLayer must both be VK_TRUE", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-04476", "If ppEnabledExtensions contains \"VK_KHR_shader_draw_parameters\" and the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then VkPhysicalDeviceVulkan11Features::shaderDrawParameters must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledLayerNames-parameter", "If enabledLayerCount is not 0, ppEnabledLayerNames must be a valid pointer to an array of enabledLayerCount null-terminated UTF-8 strings", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-queueCreateInfoCount-arraylength", "queueCreateInfoCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-queueFamilyIndex-00372", "The queueFamilyIndex member of each element of pQueueCreateInfos must be unique within pQueueCreateInfos", "1.0-extensions"},
    {"VUID-VkDeviceCreateInfo-queueFamilyIndex-02802", "The queueFamilyIndex member of each element of pQueueCreateInfos must be unique within pQueueCreateInfos, except that two members can share the same queueFamilyIndex if one is a protected-capable queue and one is not a protected-capable queue", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkDeviceDeviceMemoryReportCreateInfoEXT or VkDevicePrivateDataCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04478", "If shadingRateImage is enabled, pipelineFragmentShadingRate must not be enabled", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04479", "If shadingRateImage is enabled, primitiveFragmentShadingRate must not be enabled", "1.2-extensions"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04480", "If shadingRateImage is enabled, attachmentFragmentShadingRate must not be enabled", "1.2-extensions"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pUserData-parameter", "pUserData must be a pointer value", "1.2-extensions"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pfnUserCallback-parameter", "pfnUserCallback must be a valid PFN_vkDeviceMemoryReportCallbackEXT value", "1.2-extensions"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDeviceDiagnosticsConfigCreateInfoNV-flags-parameter", "flags must be a valid combination of VkDeviceDiagnosticsConfigFlagBitsNV values", "1.2-extensions"},
    {"VUID-VkDeviceDiagnosticsConfigCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkDeviceEventInfoEXT-deviceEvent-parameter", "deviceEvent must be a valid VkDeviceEventTypeEXT value", "1.2-extensions"},
    {"VUID-VkDeviceEventInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDeviceEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDeviceGroupBindSparseInfo-memoryDeviceIndex-01119", "Each memory allocation bound in this batch must have allocated an instance for memoryDeviceIndex", "1.2-extensions"},
    {"VUID-VkDeviceGroupBindSparseInfo-resourceDeviceIndex-01118", "resourceDeviceIndex and memoryDeviceIndex must both be valid device indices", "1.2-extensions"},
    {"VUID-VkDeviceGroupBindSparseInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO", "1.2-extensions"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00106", "deviceMask must be a valid device mask value", "1.2-extensions"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00107", "deviceMask must not be zero", "1.2-extensions"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO", "1.2-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00375", "Each element of pPhysicalDevices must be unique", "1.2-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00376", "All elements of pPhysicalDevices must be in the same device group as enumerated by vkEnumeratePhysicalDeviceGroups", "1.2-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-parameter", "If physicalDeviceCount is not 0, pPhysicalDevices must be a valid pointer to an array of physicalDeviceCount valid VkPhysicalDevice handles", "1.2-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-physicalDeviceCount-00377", "If physicalDeviceCount is not 0, the physicalDevice parameter of vkCreateDevice must be an element of pPhysicalDevices", "1.2-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentCapabilitiesKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01298", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01299", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and some physical device in the logical device must include that bit in its VkDeviceGroupPresentCapabilitiesKHR::presentMask", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01300", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR, then each element of pDeviceMasks must have a value for which all set bits are set in one of the elements of VkDeviceGroupPresentCapabilitiesKHR::presentMask", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01301", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR, then for each bit set in each element of pDeviceMasks, the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01303", "mode must have exactly one bit set, and that bit must have been included in VkDeviceGroupSwapchainCreateInfoKHR::modes", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-parameter", "mode must be a valid VkDeviceGroupPresentModeFlagBitsKHR value", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-01302", "The value of each element of pDeviceMasks must be equal to the device mask passed in VkAcquireNextImageInfoKHR::deviceMask when the image index was last acquired", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-parameter", "If swapchainCount is not 0, pDeviceMasks must be a valid pointer to an array of swapchainCount uint32_t values", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-swapchainCount-01297", "swapchainCount must equal 0 or VkPresentInfoKHR::swapchainCount", "1.2-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00905", "deviceMask must be a valid device mask value", "1.2-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00906", "deviceMask must not be zero", "1.2-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00907", "deviceMask must be a subset of the command buffer's initial device mask", "1.2-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceRenderAreaCount-00908", "deviceRenderAreaCount must either be zero or equal to the number of physical devices in the logical device", "1.2-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas-parameter", "If deviceRenderAreaCount is not 0, pDeviceRenderAreas must be a valid pointer to an array of deviceRenderAreaCount VkRect2D structures", "1.2-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-commandBufferCount-00083", "commandBufferCount must equal VkSubmitInfo::commandBufferCount", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-00086", "All elements of pCommandBufferDeviceMasks must be valid device masks", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-parameter", "If commandBufferCount is not 0, pCommandBufferDeviceMasks must be a valid pointer to an array of commandBufferCount uint32_t values", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphoreDeviceIndices must be a valid pointer to an array of signalSemaphoreCount uint32_t values", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-00085", "All elements of pWaitSemaphoreDeviceIndices and pSignalSemaphoreDeviceIndices must be valid device indices", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphoreDeviceIndices must be a valid pointer to an array of waitSemaphoreCount uint32_t values", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-signalSemaphoreCount-00084", "signalSemaphoreCount must equal VkSubmitInfo::signalSemaphoreCount", "1.2-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-waitSemaphoreCount-00082", "waitSemaphoreCount must equal VkSubmitInfo::waitSemaphoreCount", "1.2-extensions"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-parameter", "modes must be a valid combination of VkDeviceGroupPresentModeFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-requiredbitmask", "modes must not be 0", "1.2-extensions"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-03336", "memory must have been allocated with VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT", "1.2-extensions"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO", "1.2-extensions"},
    {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior-parameter", "overallocationBehavior must be a valid VkMemoryOverallocationBehaviorAMD value", "1.2-extensions"},
    {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD", "1.2-extensions"},
    {"VUID-VkDeviceMemoryReportCallbackDataEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDeviceMemoryReportCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT", "1.2-extensions"},
    {"VUID-VkDevicePrivateDataCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-flags-02861", "If the protected memory feature is not enabled, the VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT bit of flags must not be set", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-flags-parameter", "flags must be a valid combination of VkDeviceQueueCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDeviceQueueGlobalPriorityCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-00383", "Each element of pQueuePriorities must be between 0.0 and 1.0 inclusive", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-parameter", "pQueuePriorities must be a valid pointer to an array of queueCount float values", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-queueCount-00382", "queueCount must be less than or equal to the queueCount member of the VkQueueFamilyProperties structure, as returned by vkGetPhysicalDeviceQueueFamilyProperties in the pQueueFamilyProperties[queueFamilyIndex]", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-queueCount-arraylength", "queueCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-queueFamilyIndex-00381", "queueFamilyIndex must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkDeviceQueueGlobalPriorityCreateInfoEXT-globalPriority-parameter", "globalPriority must be a valid VkQueueGlobalPriorityEXT value", "1.2-extensions"},
    {"VUID-VkDeviceQueueGlobalPriorityCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDeviceQueueInfo2-flags-parameter", "flags must be a valid combination of VkDeviceQueueCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkDeviceQueueInfo2-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDeviceQueueInfo2-queueFamilyIndex-01842", "queueFamilyIndex must be one of the queue family indices specified when device was created, via the VkDeviceQueueCreateInfo structure", "1.2-extensions"},
    {"VUID-VkDeviceQueueInfo2-queueIndex-01843", "queueIndex must be less than the number of queues created for the specified queue family index and VkDeviceQueueCreateFlags member flags equal to this flags value when device was created, via the queueCount member of the VkDeviceQueueCreateInfo structure", "1.2-extensions"},
    {"VUID-VkDeviceQueueInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2", "1.2-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-dfb-04117", "dfb must point to a valid DirectFB IDirectFB", "1.2-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-surface-04118", "surface must point to a valid DirectFB IDirectFBSurface", "1.2-extensions"},
    {"VUID-VkDispatchIndirectCommand-x-00417", "x must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0]", "1.2-extensions"},
    {"VUID-VkDispatchIndirectCommand-y-00418", "y must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1]", "1.2-extensions"},
    {"VUID-VkDispatchIndirectCommand-z-00419", "z must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2]", "1.2-extensions"},
    {"VUID-VkDisplayEventInfoEXT-displayEvent-parameter", "displayEvent must be a valid VkDisplayEventTypeEXT value", "1.2-extensions"},
    {"VUID-VkDisplayEventInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplayEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDisplayModeCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkDisplayModeCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplayModeCreateInfoKHR-parameters-parameter", "parameters must be a valid VkDisplayModeParametersKHR structure", "1.2-extensions"},
    {"VUID-VkDisplayModeCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkDisplayModeParametersKHR-height-01991", "The height member of visibleRegion must be greater than 0", "1.2-extensions"},
    {"VUID-VkDisplayModeParametersKHR-refreshRate-01992", "refreshRate must be greater than 0", "1.2-extensions"},
    {"VUID-VkDisplayModeParametersKHR-width-01990", "The width member of visibleRegion must be greater than 0", "1.2-extensions"},
    {"VUID-VkDisplayModeProperties2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplayModeProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR", "1.2-extensions"},
    {"VUID-VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD", "1.2-extensions"},
    {"VUID-VkDisplayPlaneCapabilities2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplayPlaneCapabilities2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR", "1.2-extensions"},
    {"VUID-VkDisplayPlaneInfo2KHR-mode-parameter", "mode must be a valid VkDisplayModeKHR handle", "1.2-extensions"},
    {"VUID-VkDisplayPlaneInfo2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplayPlaneInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkDisplayPlaneProperties2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplayPlaneProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR", "1.2-extensions"},
    {"VUID-VkDisplayPowerInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplayPowerInfoEXT-powerState-parameter", "powerState must be a valid VkDisplayPowerStateEXT value", "1.2-extensions"},
    {"VUID-VkDisplayPowerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT", "1.2-extensions"},
    {"VUID-VkDisplayPresentInfoKHR-dstRect-01258", "dstRect must specify a rectangular region that is a subset of the visibleRegion parameter of the display mode the swapchain being presented uses", "1.2-extensions"},
    {"VUID-VkDisplayPresentInfoKHR-persistentContent-01259", "If the persistentContent member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display the present operation targets is VK_FALSE, then persistent must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkDisplayPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkDisplayPresentInfoKHR-srcRect-01257", "srcRect must specify a rectangular region that is a subset of the image being presented", "1.2-extensions"},
    {"VUID-VkDisplayProperties2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplayProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01254", "If alphaMode is VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR then globalAlpha must be between 0 and 1, inclusive", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01255", "alphaMode must be one of the bits present in the supportedAlpha member of VkDisplayPlaneCapabilitiesKHR for the display plane corresponding to displayMode", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-parameter", "alphaMode must be a valid VkDisplayPlaneAlphaFlagBitsKHR value", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-displayMode-parameter", "displayMode must be a valid VkDisplayModeKHR handle", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-planeIndex-01252", "planeIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-planeReorderPossible-01253", "If the planeReorderPossible member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display corresponding to displayMode is VK_TRUE then planeStackIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR; otherwise planeStackIndex must equal the currentStackIndex member of VkDisplayPlanePropertiesKHR returned by vkGetPhysicalDeviceDisplayPlanePropertiesKHR for the display plane corresponding to displayMode", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-transform-parameter", "transform must be a valid VkSurfaceTransformFlagBitsKHR value", "1.2-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-width-01256", "The width and height members of imageExtent must be less than or equal to VkPhysicalDeviceLimits::maxImageDimension2D", "1.2-extensions"},
    {"VUID-VkDrawIndexedIndirectCommand-None-00552", "For a given vertex buffer binding, any attribute data fetched must be entirely contained within the corresponding vertex buffer binding, as described in Vertex Input Description", "1.2-extensions"},
    {"VUID-VkDrawIndexedIndirectCommand-firstInstance-00554", "If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0", "1.2-extensions"},
    {"VUID-VkDrawIndexedIndirectCommand-indexSize-00553", "(indexSize {times} (firstIndex + indexCount) + offset) must be less than or equal to the size of the bound index buffer, with indexSize being based on the type specified by indexType, where the index buffer, indexType, and offset are specified via vkCmdBindIndexBuffer", "1.2-extensions"},
    {"VUID-VkDrawIndirectCommand-None-00500", "For a given vertex buffer binding, any attribute data fetched must be entirely contained within the corresponding vertex buffer binding, as described in Vertex Input Description", "1.2-extensions"},
    {"VUID-VkDrawIndirectCommand-firstInstance-00501", "If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0", "1.2-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandNV-taskCount-02175", "taskCount must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxDrawMeshTasksCount", "1.2-extensions"},
    {"VUID-VkDrmFormatModifierPropertiesListEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT", "1.2-extensions"},
    {"VUID-VkEventCreateInfo-flags-parameter", "flags must be a valid combination of VkEventCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkEventCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkEventCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EVENT_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkExportFenceCreateInfo-handleTypes-01446", "The bits in handleTypes must be supported and compatible, as reported by VkExternalFenceProperties", "1.2-extensions"},
    {"VUID-VkExportFenceCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalFenceHandleTypeFlagBits values", "1.2-extensions"},
    {"VUID-VkExportFenceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-handleTypes-01447", "If VkExportFenceCreateInfo::handleTypes does not include VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, a VkExportFenceWin32HandleInfoKHR structure must not be included in the pNext chain of VkFenceCreateInfo", "1.2-extensions"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "1.2-extensions"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkExportMemoryAllocateInfo-handleTypes-00656", "The bits in handleTypes must be supported and compatible, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.2-extensions"},
    {"VUID-VkExportMemoryAllocateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "1.2-extensions"},
    {"VUID-VkExportMemoryAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO", "1.2-extensions"},
    {"VUID-VkExportMemoryAllocateInfoNV-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", "1.2-extensions"},
    {"VUID-VkExportMemoryAllocateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-handleTypes-00657", "If VkExportMemoryAllocateInfo::handleTypes does not include VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, a VkExportMemoryWin32HandleInfoKHR structure must not be included in the pNext chain of VkMemoryAllocateInfo", "1.2-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "1.2-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoNV-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "1.2-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV", "1.2-extensions"},
    {"VUID-VkExportSemaphoreCreateInfo-handleTypes-01124", "The bits in handleTypes must be supported and compatible, as reported by VkExternalSemaphoreProperties", "1.2-extensions"},
    {"VUID-VkExportSemaphoreCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalSemaphoreHandleTypeFlagBits values", "1.2-extensions"},
    {"VUID-VkExportSemaphoreCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-handleTypes-01125", "If VkExportSemaphoreCreateInfo::handleTypes does not include VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, VkExportSemaphoreWin32HandleInfoKHR must not be included in the pNext chain of VkSemaphoreCreateInfo", "1.2-extensions"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "1.2-extensions"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkExternalBufferProperties-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkExternalBufferProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES", "1.2-extensions"},
    {"VUID-VkExternalFenceProperties-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkExternalFenceProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES", "1.2-extensions"},
    {"VUID-VkExternalFormatANDROID-externalFormat-01894", "externalFormat must be 0 or a value returned in the externalFormat member of VkAndroidHardwareBufferFormatPropertiesANDROID by an earlier call to vkGetAndroidHardwareBufferPropertiesANDROID", "1.2-extensions"},
    {"VUID-VkExternalFormatANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID", "1.2-extensions"},
    {"VUID-VkExternalImageFormatProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES", "1.2-extensions"},
    {"VUID-VkExternalMemoryBufferCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "1.2-extensions"},
    {"VUID-VkExternalMemoryBufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkExternalMemoryImageCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "1.2-extensions"},
    {"VUID-VkExternalMemoryImageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkExternalMemoryImageCreateInfoNV-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", "1.2-extensions"},
    {"VUID-VkExternalMemoryImageCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkExternalSemaphoreProperties-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkExternalSemaphoreProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES", "1.2-extensions"},
    {"VUID-VkFenceCreateInfo-flags-parameter", "flags must be a valid combination of VkFenceCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkFenceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportFenceCreateInfo or VkExportFenceWin32HandleInfoKHR", "1.2-extensions"},
    {"VUID-VkFenceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkFenceCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-fence-01455", "fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType", "1.2-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "1.2-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01453", "handleType must have been included in VkExportFenceCreateInfo::handleTypes when fence's current payload was created", "1.2-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01454", "If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution", "1.2-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01456", "handleType must be defined as a POSIX file descriptor handle", "1.2-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-fence-01450", "fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01448", "handleType must have been included in VkExportFenceCreateInfo::handleTypes when the fence's current payload was created", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01449", "If handleType is defined as an NT handle, vkGetFenceWin32HandleKHR must be called no more than once for each valid unique combination of fence and handleType", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01451", "If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01452", "handleType must be defined as an NT handle or a global share handle", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-pNext-02627", "If the pNext chain of the VkImageFormatProperties2 structure includes a VkFilterCubicImageViewImageFormatPropertiesEXT structure, the pNext chain of the VkPhysicalDeviceImageFormatInfo2 structure must include a VkPhysicalDeviceImageViewImageFormatInfoEXT structure with an imageViewType that is compatible with imageType", "1.2-extensions"},
    {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkFormatProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDrmFormatModifierPropertiesListEXT, VkVideoProfileKHR, or VkVideoProfilesKHR", "1.2-extensions"},
    {"VUID-VkFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2", "1.2-extensions"},
    {"VUID-VkFormatProperties2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04524", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, its layout member must be equal to VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04525", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be a power of two value", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04526", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be less than or equal to maxFragmentShadingRateAttachmentTexelSize.width", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04527", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be greater than or equal to minFragmentShadingRateAttachmentTexelSize.width", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04528", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be a power of two value", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04529", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be less than or equal to maxFragmentShadingRateAttachmentTexelSize.height", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04530", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be greater than or equal to minFragmentShadingRateAttachmentTexelSize.height", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04531", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, the quotient of shadingRateAttachmentTexelSize.width and shadingRateAttachmentTexelSize.height must be less than or equal to maxFragmentShadingRateAttachmentTexelSizeAspectRatio", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04532", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, the quotient of shadingRateAttachmentTexelSize.height and shadingRateAttachmentTexelSize.width must be less than or equal to maxFragmentShadingRateAttachmentTexelSizeAspectRatio", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-parameter", "If pFragmentShadingRateAttachment is not NULL, pFragmentShadingRateAttachment must be a valid pointer to a valid VkAttachmentReference2 structure", "1.2-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-pViewFormats-parameter", "If viewFormatCount is not 0, pViewFormats must be a valid pointer to an array of viewFormatCount valid VkFormat values", "1.2-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO", "1.2-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-usage-requiredbitmask", "usage must not be 0", "1.2-extensions"},
    {"VUID-VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos-parameter", "If attachmentImageInfoCount is not 0, pAttachmentImageInfos must be a valid pointer to an array of attachmentImageInfoCount valid VkFramebufferAttachmentImageInfo structures", "1.2-extensions"},
    {"VUID-VkFramebufferAttachmentsCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-attachmentCount-00876", "attachmentCount must be equal to the attachment count specified in renderPass", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-commonparent", "Both of renderPass, and the elements of pAttachments that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-02778", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkImageView handles", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03189", "If the imageless framebuffer feature is not enabled, flags must not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03190", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the pNext chain must include an instance of VkFramebufferAttachmentsCreateInfo", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03191", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the attachmentImageInfoCount member of an instance of VkFramebufferAttachmentsCreateInfo in the pNext chain must be equal to either zero or attachmentCount", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03196", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of an instance of VkFramebufferAttachmentsCreateInfo in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of width/maxFragmentDensityTexelSize.width", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03197", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of height/maxFragmentDensityTexelSize.height", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03201", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a color attachment or resolve attachment by renderPass must include VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03202", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03203", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil resolve attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03204", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as an input attachment by renderPass must include VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03205", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, at least one element of the pViewFormats member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be equal to the corresponding value of VkAttachmentDescription::format used to create renderPass", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04113", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with VkImageViewCreateInfo::viewType not equal to VK_IMAGE_VIEW_TYPE_3D", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04533", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageCreateInfo::width greater than or equal to width", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04534", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageCreateInfo::height greater than or equal to height", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04535", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageViewCreateInfo::subresourceRange.layerCount greater than or equal to layers", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04537", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than the index of the most significant bit set in any of those view masks", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04538", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was not specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than layers", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04539", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is used as a fragment shading rate attachment must have a width at least as large as {lceil}width / texelWidth{rceil}, where texelWidth is the largest value of shadingRateAttachmentTexelSize.width in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04540", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is used as a fragment shading rate attachment must have a height at least as large as {lceil}height / texelHeight{rceil}, where texelHeight is the largest value of shadingRateAttachmentTexelSize.height in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04541", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of an instance of VkFramebufferAttachmentsCreateInfo in the pNext chain that is used as an input, color, resolve or depth/stencil attachment in renderPass must be greater than or equal to width", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04542", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of an instance of VkFramebufferAttachmentsCreateInfo in the pNext chain that is used as an input, color, resolve or depth/stencil attachment in renderPass must be greater than or equal to height", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04543", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of an instance of VkFramebufferAttachmentsCreateInfo in the pNext chain that is used as a fragment shading rate attachment must be greater than or equal to {lceil}width / texelWidth{rceil}, where texelWidth is the largest value of shadingRateAttachmentTexelSize.width in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04544", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of an instance of VkFramebufferAttachmentsCreateInfo in the pNext chain that is used as a fragment shading rate attachment must be greater than or equal to {lceil}height / texelHeight{rceil}, where texelHeight is the largest value of shadingRateAttachmentTexelSize.height in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04545", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of an instance of VkFramebufferAttachmentsCreateInfo in the pNext chain that is used as a fragment shading rate attachment must be either 1, or greater than or equal to layers", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04547", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain used as an input, color, resolve, or depth/stencil attachment in pRenderPass must be greater than or equal to layers", "1.2"},
    {"VUID-VkFramebufferCreateInfo-flags-04548", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04549", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a fragment shading rate attachment by renderPass must include VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04587", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than the index of the most significant bit set in any of those view masks", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-parameter", "flags must be a valid combination of VkFramebufferCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-height-00887", "height must be greater than 0", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-height-00888", "height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-layers-00889", "layers must be greater than 0", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-layers-00890", "layers must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferLayers", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00877", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a color attachment or resolve attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00879", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00880", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a VkFormat value that matches the VkFormat specified by the corresponding VkAttachmentDescription in renderPass", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00881", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a samples value that matches the samples value specified by the corresponding VkAttachmentDescription in renderPass", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00883", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must only specify a single mip level", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00884", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with the identity swizzle", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00891", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is a 2D or 2D array image view taken from a 3D image must not be a depth/stencil format", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02552", "Each element of pAttachments that is used as a fragment density map attachment by renderPass must not have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02555", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a width at least as large as the ceiling of width/maxFragmentDensityTexelSize.width", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02556", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a height at least as large as the ceiling of height/maxFragmentDensityTexelSize.height", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02633", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02634", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil resolve attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02744", "An element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1", "default"},
    {"VUID-VkFramebufferCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkFramebufferAttachmentsCreateInfo", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02531", "If renderPass was specified with non-zero view masks, layers must be 1", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02553", "If renderPass has a fragment density map attachment and non-subsample image feature is not enabled, each element of pAttachments must have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT unless that element is the fragment density map attachment", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02746", "If renderPass was specified with non-zero view masks, each element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1 or greater than the index of the most significant bit set in any of those view masks", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02747", "If renderPass was not specified with non-zero view masks, each element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-03198", "If multiview is enabled for renderPass, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain used as an input, color, resolve, or depth/stencil attachment in renderPass must be greater than the maximum bit index set in the view mask in the subpasses in which it is used in renderPass", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-04536", "If renderPass was specified with non-zero view masks, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have a layerCount greater than the index of the most significant bit set in any of those view masks", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-04546", "If multiview is not enabled for renderPass, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain used as an input, color, resolve, or depth/stencil attachment in renderPass must be greater than or equal to layers", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-parameter", "renderPass must be a valid VkRenderPass handle", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-width-00885", "width must be greater than 0", "1.2-extensions"},
    {"VUID-VkFramebufferCreateInfo-width-00886", "width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth", "1.2-extensions"},
    {"VUID-VkFramebufferMixedSamplesCombinationNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkFramebufferMixedSamplesCombinationNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-commonparent", "Each of indirectCommandsLayout, pipeline, preprocessBuffer, sequencesCountBuffer, and sequencesIndexBuffer that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02913", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV, then the pipeline must have been created with multiple shader groups", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02914", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV, then the pipeline must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV set in VkGraphicsPipelineCreateInfo::flags", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02915", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, then the pipeline`s VkPipelineLayout must match the VkIndirectCommandsLayoutTokenNV::pushconstantPipelineLayout", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutNV handle", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pStreams-parameter", "pStreams must be a valid pointer to an array of streamCount valid VkIndirectCommandsStreamNV structures", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipeline-02912", "The provided pipeline must match the pipeline bound at execution time", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipeline-parameter", "pipeline must be a valid VkPipeline handle", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-02918", "preprocessBuffer must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set in its usage flag", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-02971", "If preprocessBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-parameter", "preprocessBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessOffset-02919", "preprocessOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minIndirectCommandsBufferOffsetAlignment", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessSize-02920", "preprocessSize must be at least equal to the memory requirement`s size returned by vkGetGeneratedCommandsMemoryRequirementsNV using the matching inputs (indirectCommandsLayout, ...) as within this structure", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCount-02917", "sequencesCount must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectSequenceCount and VkGeneratedCommandsMemoryRequirementsInfoNV::maxSequencesCount that was used to determine the preprocessSize", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02921", "sequencesCountBuffer can be set if the actual used count of sequences is sourced from the provided buffer. In that case the sequencesCount serves as upper bound", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02922", "If sequencesCountBuffer is not VK_NULL_HANDLE, its usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02923", "If sequencesCountBuffer is not VK_NULL_HANDLE, sequencesCountOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minSequencesCountBufferOffsetAlignment", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02972", "If sequencesCountBuffer is not VK_NULL_HANDLE and is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-parameter", "If sequencesCountBuffer is not VK_NULL_HANDLE, sequencesCountBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02924", "If indirectCommandsLayout's VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV is set, sequencesIndexBuffer must be set otherwise it must be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02925", "If sequencesIndexBuffer is not VK_NULL_HANDLE, its usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02926", "If sequencesIndexBuffer is not VK_NULL_HANDLE, sequencesIndexOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minSequencesIndexBufferOffsetAlignment", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02973", "If sequencesIndexBuffer is not VK_NULL_HANDLE and is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-parameter", "If sequencesIndexBuffer is not VK_NULL_HANDLE, sequencesIndexBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-streamCount-02916", "streamCount must match the indirectCommandsLayout's streamCount", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-streamCount-arraylength", "streamCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-commonparent", "Both of indirectCommandsLayout, and pipeline must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutNV handle", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-maxSequencesCount-02907", "maxSequencesCount must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectSequenceCount", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipeline-parameter", "pipeline must be a valid VkPipeline handle", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.2-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV", "1.2-extensions"},
    {"VUID-VkGeometryAABBNV-aabbData-parameter", "If aabbData is not VK_NULL_HANDLE, aabbData must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkGeometryAABBNV-offset-02439", "offset must be less than the size of aabbData", "1.2-extensions"},
    {"VUID-VkGeometryAABBNV-offset-02440", "offset must be a multiple of 8", "1.2-extensions"},
    {"VUID-VkGeometryAABBNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkGeometryAABBNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV", "1.2-extensions"},
    {"VUID-VkGeometryAABBNV-stride-02441", "stride must be a multiple of 8", "1.2-extensions"},
    {"VUID-VkGeometryDataNV-aabbs-parameter", "aabbs must be a valid VkGeometryAABBNV structure", "1.2-extensions"},
    {"VUID-VkGeometryDataNV-triangles-parameter", "triangles must be a valid VkGeometryTrianglesNV structure", "1.2-extensions"},
    {"VUID-VkGeometryNV-flags-parameter", "flags must be a valid combination of VkGeometryFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkGeometryNV-geometry-parameter", "geometry must be a valid VkGeometryDataNV structure", "1.2-extensions"},
    {"VUID-VkGeometryNV-geometryType-03503", "geometryType must be VK_GEOMETRY_TYPE_TRIANGLES_NV or VK_GEOMETRY_TYPE_AABBS_NV", "1.2-extensions"},
    {"VUID-VkGeometryNV-geometryType-parameter", "geometryType must be a valid VkGeometryTypeKHR value", "1.2-extensions"},
    {"VUID-VkGeometryNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkGeometryNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_NV", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-commonparent", "Each of indexData, transformData, and vertexData that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexCount-02436", "indexCount must be 0 if indexType is VK_INDEX_TYPE_NONE_NV", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexData-02434", "indexData must be VK_NULL_HANDLE if indexType is VK_INDEX_TYPE_NONE_NV", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexData-02435", "indexData must be a valid VkBuffer handle if indexType is not VK_INDEX_TYPE_NONE_NV", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexData-parameter", "If indexData is not VK_NULL_HANDLE, indexData must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexOffset-02431", "indexOffset must be less than the size of indexData", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexOffset-02432", "indexOffset must be a multiple of the element size of indexType", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexType-02433", "indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_NV", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexType-parameter", "indexType must be a valid VkIndexType value", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-transformData-parameter", "If transformData is not VK_NULL_HANDLE, transformData must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-transformOffset-02437", "transformOffset must be less than the size of transformData", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-transformOffset-02438", "transformOffset must be a multiple of 16", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexData-parameter", "If vertexData is not VK_NULL_HANDLE, vertexData must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexFormat-02430", "vertexFormat must be one of VK_FORMAT_R32G32B32_SFLOAT, VK_FORMAT_R32G32_SFLOAT, VK_FORMAT_R16G16B16_SFLOAT, VK_FORMAT_R16G16_SFLOAT, VK_FORMAT_R16G16_SNORM, or VK_FORMAT_R16G16B16_SNORM", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexOffset-02428", "vertexOffset must be less than the size of vertexData", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexOffset-02429", "vertexOffset must be a multiple of the component size of vertexFormat", "1.2-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexStride-03818", "vertexStride must be less than or equal to 232-1", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-02322", "If the pipeline is being created with pre-rasterization shader state, and there are any mesh shader stages in the pipeline there must not be any shader stage in the pipeline with a Xfb execution mode", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04574", "If the pipeline is being created with pre-rasterization shader state or fragment shader state, and the supersampleFragmentShadingRates feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must not be equal to VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV, VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV, VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV, or VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV.", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04575", "If the pipeline is being created with pre-rasterization shader state or fragment shader state, and the noInvocationFragmentShadingRates feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must not be equal to VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV.", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04889", "If the pipeline is being created with pre-rasterization shader state and fragment shader state, the fragment shader and last pre-rasterization shader stage and any relevant state must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04893", "The pipeline must be created with a complete set of state", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-attachmentCount-00746", "If the pipeline is being created with fragment output interface state, and the subpass uses color attachments, the attachmentCount member of pColorBlendState must be equal to the colorAttachmentCount used to create subpass", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-blendEnable-04717", "If the pipeline is being created with fragment output interface state, then for each color attachment in the subpass, if the potential format features of the format of the corresponding attachment description do not contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, then the blendEnable member of the corresponding element of the pAttachments member of pColorBlendState must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-commonparent", "Each of basePipelineHandle, layout, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-coverageReductionMode-02722", "If the pipeline is being created with fragment shader state, and the VK_NV_coverage_reduction_mode extension is enabled, the coverage reduction mode specified by VkPipelineCoverageReductionStateCreateInfoNV::coverageReductionMode, the rasterizationSamples member of pMultisampleState and the sample counts for the color and depth/stencil attachments (if the subpass has them) must be a valid combination returned by vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00722", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid handle to a graphics VkPipeline", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00723", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00724", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is not -1, basePipelineHandle must be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00725", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is not VK_NULL_HANDLE, basePipelineIndex must be -1", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00764", "flags must not contain the VK_PIPELINE_CREATE_DISPATCH_BASE flag", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-02877", "If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV::deviceGeneratedCommands feature must be enabled", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-02966", "If the pipeline is being created with pre-rasterization shader state and flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then all stages must not specify Xfb execution mode", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03371", "flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03372", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03373", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03374", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03375", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03376", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03377", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03577", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-04901", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, then the subpass must be the last subpass in a subpass dependency chain", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-04902", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if pResolveAttachments is not NULL, then each resolve attachment must be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-04947", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-parameter", "flags must be a valid combination of VkPipelineCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-fragmentShadingRateNonTrivialCombinerOps-04506", "If the pipeline is being created with pre-rasterization shader state or fragment shader state, the fragmentShadingRateNonTrivialCombinerOps limit is not supported, and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, elements of VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-fragmentShadingRateNonTrivialCombinerOps-04573", "If the pipeline is being created with pre-rasterization shader state or fragment shader state, and the fragmentShadingRateNonTrivialCombinerOps limit is not supported and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, elements of VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-geometryStreams-02321", "If the pipeline is being created with pre-rasterization shader state, and the last pre-rasterization shader stage is a geometry shader, and that geometry shader uses the GeometryStreams capability, then VkPhysicalDeviceTransformFeedbackFeaturesEXT::geometryStreams feature must be enabled", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-00756", "layout must be consistent with all shaders specified in pStages", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-01688", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-parameter", "layout must be a valid VkPipelineLayout handle", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-lineRasterizationMode-02766", "If the pipeline is being created with pre-rasterization shader state and at least one of fragment output interface state or fragment shader state, the lineRasterizationMode member of a VkPipelineRasterizationLineStateCreateInfoEXT structure included in the pNext chain of pRasterizationState is VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT or VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT, then the alphaToCoverageEnable, alphaToOneEnable, and sampleShadingEnable members of pMultisampleState must all be VK_FALSE", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04494", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be greater than or equal to 1", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04495", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be greater than or equal to 1", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04496", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be a power-of-two value", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04497", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be a power-of-two value", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04498", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be less than or equal to 4", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04499", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be less than or equal to 4", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04500", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the pipelineFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width and VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must both be equal to 1", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04501", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the primitiveFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[0] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04502", "If the pipeline is being created with pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the attachmentFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[1] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04569", "If the pipeline is being created with pre-rasterization shader state or fragment shader state, and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the fragmentShadingRateEnums feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRateType must be equal to VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV.", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04570", "If the pipeline is being created with pre-rasterization shader state or fragment shader state, and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the pipelineFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must be equal to VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV.", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04571", "If the pipeline is being created with pre-rasterization shader state or fragment shader state, and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the primitiveFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[0] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04572", "If the pipeline is being created with pre-rasterization shader state or fragment shader state, and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the attachmentFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[1] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-parameter", "If pDynamicState is not NULL, pDynamicState must be a valid pointer to a valid VkPipelineDynamicStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00747", "If the pipeline is being created with pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT, the pViewports member of pViewportState must be a valid pointer to an array of pViewportState->viewportCount valid VkViewport structures", "1.2-khr-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00748", "If the pipeline is being created with pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SCISSOR, the pScissors member of pViewportState must be a valid pointer to an array of pViewportState->scissorCount VkRect2D structures", "1.2-khr-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00749", "If the pipeline is being created with pre-rasterization shader state, and the wide lines feature is not enabled, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_LINE_WIDTH, the lineWidth member of pRasterizationState must be 1.0", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00754", "If the pipeline is being created with pre-rasterization shader state, the depth bias clamping feature is not enabled, no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BIAS, and the depthBiasEnable member of pRasterizationState is VK_TRUE, the depthBiasClamp member of pRasterizationState must be 0.0", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00755", "If the pipeline is being created with fragment shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BOUNDS, and the depthBoundsTestEnable member of pDepthStencilState is VK_TRUE, the minDepthBounds and maxDepthBounds members of pDepthStencilState must be between 0.0 and 1.0, inclusive", "1.2-khr-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01521", "If the pipeline is being created with fragment shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, sampleLocationsInfo.sampleLocationGridSize.width must evenly divide VkMultisamplePropertiesEXT::sampleLocationGridSize.width as returned by vkGetPhysicalDeviceMultisamplePropertiesEXT with a samples parameter equaling rasterizationSamples", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01522", "If the pipeline is being created with fragment shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, sampleLocationsInfo.sampleLocationGridSize.height must evenly divide VkMultisamplePropertiesEXT::sampleLocationGridSize.height as returned by vkGetPhysicalDeviceMultisamplePropertiesEXT with a samples parameter equaling rasterizationSamples", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01523", "If the pipeline is being created with fragment shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, sampleLocationsInfo.sampleLocationsPerPixel must equal rasterizationSamples", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01715", "If the pipeline is being created with pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV, and the viewportWScalingEnable member of a VkPipelineViewportWScalingStateCreateInfoNV structure, included in the pNext chain of pViewportState, is VK_TRUE, the pViewportWScalings member of the VkPipelineViewportWScalingStateCreateInfoNV must be a pointer to an array of VkPipelineViewportWScalingStateCreateInfoNV::viewportCount valid VkViewportWScalingNV structures", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-02510", "If the pipeline is being created with fragment shader state, and the VK_EXT_depth_range_unrestricted extension is not enabled and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BOUNDS, and the depthBoundsTestEnable member of pDepthStencilState is VK_TRUE, the minDepthBounds and maxDepthBounds members of pDepthStencilState must be between 0.0 and 1.0, inclusive", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03378", "If the extendedDynamicState feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_CULL_MODE_EXT, VK_DYNAMIC_STATE_FRONT_FACE_EXT, VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT, VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT, VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT, VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT, VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT, VK_DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT, VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT, VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT, or VK_DYNAMIC_STATE_STENCIL_OP_EXT", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03379", "If the pipeline is being created with pre-rasterization shader state, and VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT is included in the pDynamicStates array then viewportCount must be zero", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03380", "If the pipeline is being created with pre-rasterization shader state, and VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT is included in the pDynamicStates array then scissorCount must be zero", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03578", "All elements of the pDynamicStates member of pDynamicState must not be VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04056", "If the pipeline is being created with pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV, and if pViewportState->pNext chain includes a VkPipelineViewportExclusiveScissorStateCreateInfoNV structure, and if its exclusiveScissorCount member is not 0, then its pExclusiveScissors member must be a valid pointer to an array of exclusiveScissorCount VkRect2D structures", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04057", "If the pipeline is being created with pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV, and if pViewportState->pNext chain includes a VkPipelineViewportShadingRateImageStateCreateInfoNV structure, then its pShadingRatePalettes member must be a valid pointer to an array of viewportCount valid VkShadingRatePaletteNV structures", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04058", "If the pipeline is being created with pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT, and if pNext chain includes a VkPipelineDiscardRectangleStateCreateInfoEXT structure, and if its discardRectangleCount member is not 0, then its pDiscardRectangles member must be a valid pointer to an array of discardRectangleCount VkRect2D structures", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04130", "If the pipeline is being created with pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT or VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT, the pViewports member of pViewportState must be a valid pointer to an array of pViewportState->viewportCount valid VkViewport structures", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04131", "If the pipeline is being created with pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SCISSOR or VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT, the pScissors member of pViewportState must be a valid pointer to an array of pViewportState->scissorCount VkRect2D structures", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04132", "If the pipeline is being created with pre-rasterization shader state, and VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT is included in the pDynamicStates array then VK_DYNAMIC_STATE_VIEWPORT must not be present", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04133", "If the pipeline is being created with pre-rasterization shader state, and VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT is included in the pDynamicStates array then VK_DYNAMIC_STATE_SCISSOR must not be present", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04800", "If the colorWriteEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04807", "If the pipeline is being created with pre-rasterization shader state and the vertexInputDynamicState feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VERTEX_INPUT_EXT", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04868", "If the extendedDynamicState2 feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE_EXT, VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE_EXT, or VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04869", "If the extendedDynamicState2LogicOp feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LOGIC_OP_EXT", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04870", "If the extendedDynamicState2PatchControlPoints feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkGraphicsPipelineShaderGroupsCreateInfoNV, VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreationFeedbackCreateInfoEXT, VkPipelineDiscardRectangleStateCreateInfoEXT, VkPipelineFragmentShadingRateEnumStateCreateInfoNV, VkPipelineFragmentShadingRateStateCreateInfoKHR, or VkPipelineRepresentativeFragmentTestStateCreateInfoNV", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-parameter", "pRasterizationState must be a valid pointer to a valid VkPipelineRasterizationStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00729", "If the pipeline is being created with pre-rasterization shader state and pStages includes a tessellation control shader stage, it must include a tessellation evaluation shader stage", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00730", "If the pipeline is being created with pre-rasterization shader state and pStages includes a tessellation evaluation shader stage, it must include a tessellation control shader stage", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00731", "If the pipeline is being created with pre-rasterization shader state and pStages includes a tessellation control shader stage and a tessellation evaluation shader stage, pTessellationState must be a valid pointer to a valid VkPipelineTessellationStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00732", "If the pipeline is being created with pre-rasterization shader state and pStages includes tessellation shader stages, the shader code of at least one stage must contain an OpExecutionMode instruction that specifies the type of subdivision in the pipeline", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00733", "If the pipeline is being created with pre-rasterization shader state and pStages includes tessellation shader stages, and the shader code of both stages contain an OpExecutionMode instruction that specifies the type of subdivision in the pipeline, they must both specify the same subdivision mode", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00734", "If the pipeline is being created with pre-rasterization shader state and pStages includes tessellation shader stages, the shader code of at least one stage must contain an OpExecutionMode instruction that specifies the output patch size in the pipeline", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00735", "If the pipeline is being created with pre-rasterization shader state and pStages includes tessellation shader stages, and the shader code of both contain an OpExecutionMode instruction that specifies the out patch size in the pipeline, they must both specify the same patch size", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00736", "If the pipeline is being created with pre-rasterization shader state and pStages includes tessellation shader stages, the topology member of pInputAssembly must be VK_PRIMITIVE_TOPOLOGY_PATCH_LIST", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00738", "If the pipeline is being created with pre-rasterization shader state and pStages includes a geometry shader stage, and does not include any tessellation shader stages, its shader code must contain an OpExecutionMode instruction that specifies an input primitive type that is compatible with the primitive topology specified in pInputAssembly", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00739", "If the pipeline is being created with pre-rasterization shader state and pStages includes a geometry shader stage, and also includes tessellation shader stages, its shader code must contain an OpExecutionMode instruction that specifies an input primitive type that is compatible with the primitive topology that is output by the tessellation stages", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00740", "If the pipeline is being created with pre-rasterization shader state and fragment shader state, it includes both a fragment shader and a geometry shader, and the fragment shader code reads from an input variable that is decorated with PrimitiveID, then the geometry shader code must write to a matching output variable, decorated with PrimitiveID, in all execution paths", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00741", "If the pipeline is being created with fragment shader state the fragment shader must not read from any input attachment that is defined as VK_ATTACHMENT_UNUSED in subpass", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00742", "If the pipeline is being created with pre-rasterization shader state and multiple pre-rasterization shader stages are included in pStages, the shader code for the entry points identified by those pStages and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-01565", "If the pipeline is being created with fragment shader state and an input attachment was referenced by an aspectMask at renderPass creation time, the fragment shader must only read from the aspects that were specified for that input attachment", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02095", "If the pipeline is being created with pre-rasterization shader state the geometric shader stages provided in pStages must be either from the mesh shading pipeline (stage is VK_SHADER_STAGE_TASK_BIT_NV or VK_SHADER_STAGE_MESH_BIT_NV) or from the primitive shading pipeline (stage is VK_SHADER_STAGE_VERTEX_BIT, VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, or VK_SHADER_STAGE_GEOMETRY_BIT)", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02097", "If the pipeline is being created with vertex input state, pVertexInputState must be a valid pointer to a valid VkPipelineVertexInputStateCreateInfo structure", "1.2-khr-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02098", "If the pipeline is being created with vertex input state, pInputAssemblyState must be a valid pointer to a valid VkPipelineInputAssemblyStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02317", "If the pipeline is being created with pre-rasterization shader state, the Xfb execution mode can be specified by no more than one shader stage in pStages", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02318", "If the pipeline is being created with pre-rasterization shader state, and any shader stage in pStages specifies Xfb execution mode it must be the last pre-rasterization shader stage", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-parameter", "pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pVertexInputState-04910", "If the pipeline is being created with vertex input state, and VK_DYNAMIC_STATE_VERTEX_INPUT_EXT is not set, pVertexInputState must be a valid pointer to a valid VkPipelineVertexInputStateCreateInfo structure", "1.2-khr-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pViewportState-04892", "If the pipeline is being created with pre-rasterization shader state, and the graphics pipeline state was created with the VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT dynamic state enabled, pViewportState must be a valid pointer to a valid VkPipelineViewportStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pipelineCreationCacheControl-02878", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04503", "If the pipeline is being created with pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT is not included in pDynamicState->pDynamicStates, and VkPipelineViewportStateCreateInfo::viewportCount is greater than 1, entry points specified in pStages must not write to the PrimitiveShadingRateKHR built-in", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04504", "If the pipeline is being created with pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, and entry points specified in pStages write to the ViewportIndex built-in, they must not also write to the PrimitiveShadingRateKHR built-in", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04505", "If the pipeline is being created with pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, and entry points specified in pStages write to the ViewportMaskNV built-in, they must not also write to the PrimitiveShadingRateKHR built-in", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationSamples-04899", "If the pipeline is being created with fragment shader state, and the VK_QCOM_render_pass_shader_resolve extension is enabled, and if subpass has any input attachments, and if the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then the sample count of the input attachments must equal rasterizationSamples", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02319", "If the pipeline is being created with pre-rasterization shader state, and a VkPipelineRasterizationStateStreamCreateInfoEXT::rasterizationStream value other than zero is specified, all variables in the output interface of the entry point being compiled decorated with Position, PointSize, ClipDistance, or CullDistance must be decorated with identical Stream values that match the rasterizationStream", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02320", "If the pipeline is being created with pre-rasterization shader state, and VkPipelineRasterizationStateStreamCreateInfoEXT::rasterizationStream is zero, or not specified, all variables in the output interface of the entry point being compiled decorated with Position, PointSize, ClipDistance, or CullDistance must be decorated with a Stream value of zero, or must not specify the Stream decoration", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00750", "If the pipeline is being created with pre-rasterization shader state, and the rasterizerDiscardEnable member of pRasterizationState is VK_FALSE, pViewportState must be a valid pointer to a valid VkPipelineViewportStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00751", "If the pipeline is being created with fragment shader state, pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00752", "If the pipeline is being created with fragment shader state, and subpass uses a depth/stencil attachment, pDepthStencilState must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00753", "If the pipeline is being created with fragment output interface state, and subpass uses color attachments, pColorBlendState must be a valid pointer to a valid VkPipelineColorBlendStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-04493", "If the pipeline is being created with fragment output interface state, pColorBlendState->attachmentCount must be greater than the index of all color attachments that are not VK_ATTACHMENT_UNUSED for the subpass index in renderPass", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-00760", "If the pipeline is being created with pre-rasterization shader state, and the renderPass has multiview enabled and subpass has more than one bit set in the view mask and multiviewTessellationShader is not enabled, then pStages must not include tessellation shaders", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-00761", "If the pipeline is being created with pre-rasterization shader state, and the renderPass has multiview enabled and subpass has more than one bit set in the view mask and multiviewGeometryShader is not enabled, then pStages must not include a geometry shader", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-00762", "If the pipeline is being created with pre-rasterization shader state, and the renderPass has multiview enabled and subpass has more than one bit set in the view mask, shaders in the pipeline must not write to the Layer built-in output", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-00763", "If the pipeline is being created with pre-rasterization shader state, and the renderPass has multiview enabled, then all shaders must not include variables decorated with the Layer built-in decoration in their interfaces", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-parameter", "renderPass must be a valid VkRenderPass handle", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-sampleLocationsEnable-01524", "If the pipeline is being created with fragment shader state, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, the fragment shader code must not statically use the extended instruction InterpolateAtSample", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-sampleShadingEnable-04900", "If the pipeline is being created with fragment shader state, and the VK_QCOM_render_pass_shader_resolve extension is enabled, and if the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then sampleShadingEnable must be false", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-00726", "The stage member of each element of pStages must be unique", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-00727", "If the pipeline is being created with pre-rasterization shader state the stage member of one element of pStages must be VK_SHADER_STAGE_VERTEX_BIT", "1.2-khr-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-00728", "The stage member of each element of pStages must not be VK_SHADER_STAGE_COMPUTE_BIT", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-02096", "If the pipeline is being created with pre-rasterization shader state the stage member of one element of pStages must be either VK_SHADER_STAGE_VERTEX_BIT or VK_SHADER_STAGE_MESH_BIT_NV", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stageCount-arraylength", "stageCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stippledLineEnable-02767", "If the pipeline is being created with pre-rasterization shader state, the stippledLineEnable member of VkPipelineRasterizationLineStateCreateInfoEXT is VK_TRUE, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_LINE_STIPPLE_EXT, then the lineStippleFactor member of VkPipelineRasterizationLineStateCreateInfoEXT must be in the range [1,256]", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00757", "If the pipeline is being created with fragment shader state, and neither the VK_AMD_mixed_attachment_samples nor the VK_NV_framebuffer_mixed_samples extensions are enabled, and if subpass uses color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must be the same as the sample count for those subpass attachments", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00758", "If the pipeline is being created with fragment shader state and subpass does not use any color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must follow the rules for a zero-attachment subpass", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00759", "subpass must be a valid subpass within renderPass", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01411", "If the pipeline is being created with fragment shader state, and the VK_NV_framebuffer_mixed_samples extension is enabled, and if subpass has a depth/stencil attachment and depth test, stencil test, or depth bounds test are enabled, then the rasterizationSamples member of pMultisampleState must be the same as the sample count of the depth/stencil attachment", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01412", "If the pipeline is being created with fragment shader state, and the VK_NV_framebuffer_mixed_samples extension is enabled, and if subpass has any color attachments, then the rasterizationSamples member of pMultisampleState must be greater than or equal to the sample count for those subpass attachments", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01505", "If the pipeline is being created with fragment shader state, and the VK_AMD_mixed_attachment_samples extension is enabled, and if subpass uses color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must equal the maximum of the sample counts of those subpass attachments", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-04890", "If the pipeline is being created with fragment shader state, and subpass uses a depth/stencil attachment in renderPass with a read-only layout for the depth aspect in the VkAttachmentReference defined by subpass, the depthWriteEnable member of pDepthStencilState must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-04891", "If the pipeline is being created with fragment shader state, and subpass uses a depth/stencil attachment in renderPass with a read-only layout for the stencil aspect in the VkAttachmentReference defined by subpass, the failOp, passOp and depthFailOp members of each of the front and back members of pDepthStencilState must be VK_STENCIL_OP_KEEP", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-topology-00737", "If the pipeline is being created with pre-rasterization shader state and the topology member of pInputAssembly is VK_PRIMITIVE_TOPOLOGY_PATCH_LIST, pStages must include tessellation shader stages", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-deviceGeneratedCommands-02887", "The VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV::deviceGeneratedCommands feature must be enabled", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-groupCount-02879", "groupCount must be at least 1 and as maximum VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxGraphicsShaderGroupCount", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-groupCount-02880", "The sum of groupCount including those groups added from referenced pPipelines must also be as maximum VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxGraphicsShaderGroupCount", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-groupCount-arraylength", "groupCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02881", "The state of the first element of pGroups must match its equivalent within the parent's VkGraphicsPipelineCreateInfo", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02882", "Each element of pGroups must in combination with the rest of the pipeline state yield a valid state configuration", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02883", "All elements of pGroups must use the same shader stage combinations", "default"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02884", "All elements of pGroups must use the same shader stage combinations unless any mesh shader stage is used, then either combination of task and mesh or just mesh shader is valid", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02885", "Mesh and regular primitive shading stages cannot be mixed across pGroups", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-parameter", "pGroups must be a valid pointer to an array of groupCount valid VkGraphicsShaderGroupCreateInfoNV structures", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines-02886", "Each element of pPipelines must have been created with identical state to the pipeline currently created except the state that can be overridden by VkGraphicsShaderGroupCreateInfoNV", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines-parameter", "If pipelineCount is not 0, pPipelines must be a valid pointer to an array of pipelineCount valid VkPipeline handles", "1.2-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pStages-02889", "For pStages, the same restrictions as in VkGraphicsPipelineCreateInfo::pStages apply", "1.2-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pStages-parameter", "pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "1.2-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pTessellationState-02891", "For pTessellationState, the same restrictions as in VkGraphicsPipelineCreateInfo::pTessellationState apply", "1.2-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pVertexInputState-02890", "For pVertexInputState, the same restrictions as in VkGraphicsPipelineCreateInfo::pVertexInputState apply", "1.2-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-stageCount-02888", "For stageCount, the same restrictions as in VkGraphicsPipelineCreateInfo::stageCount apply", "1.2-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-stageCount-arraylength", "stageCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkHdrMetadataEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkHdrMetadataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HDR_METADATA_EXT", "1.2-extensions"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pView-01316", "If pView is a UIView object, it must be a valid UIView, must be backed by a CALayer object of type CAMetalLayer, and vkCreateIOSSurfaceMVK must be called on the main thread.", "1.2-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pView-04143", "If pView is a CAMetalLayer object, it must be a valid CAMetalLayer.", "1.2-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-sType-sType", "sType must be VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK", "1.2-extensions"},
    {"VUID-VkImageBlit-aspectMask-00238", "The aspectMask member of srcSubresource and dstSubresource must match", "1.2-extensions"},
    {"VUID-VkImageBlit-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageBlit-layerCount-00239", "The layerCount member of srcSubresource and dstSubresource must match", "1.2-extensions"},
    {"VUID-VkImageBlit-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageBlit2KHR-aspectMask-00238", "The aspectMask member of srcSubresource and dstSubresource must match", "1.2-extensions"},
    {"VUID-VkImageBlit2KHR-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageBlit2KHR-layerCount-00239", "The layerCount member of srcSubresource and dstSubresource must match", "1.2-extensions"},
    {"VUID-VkImageBlit2KHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkCopyCommandTransformInfoQCOM", "1.2-extensions"},
    {"VUID-VkImageBlit2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_BLIT_2_KHR", "1.2-extensions"},
    {"VUID-VkImageBlit2KHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkImageBlit2KHR-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageCopy-aspectMask-00137", "The aspectMask member of srcSubresource and dstSubresource must match", "1.0"},
    {"VUID-VkImageCopy-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageCopy-extent-00140", "The number of slices of the extent (for 3D) or layers of the srcSubresource (for non-3D) must match the number of slices of the extent (for 3D) or layers of the dstSubresource (for non-3D)", "1.2-extensions"},
    {"VUID-VkImageCopy-layerCount-00138", "The layerCount member of srcSubresource and dstSubresource must match", "1.0"},
    {"VUID-VkImageCopy-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageCopy2KHR-aspectMask-00137", "The aspectMask member of srcSubresource and dstSubresource must match", "default"},
    {"VUID-VkImageCopy2KHR-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageCopy2KHR-extent-00140", "The number of slices of the extent (for 3D) or layers of the srcSubresource (for non-3D) must match the number of slices of the extent (for 3D) or layers of the dstSubresource (for non-3D)", "1.2-extensions"},
    {"VUID-VkImageCopy2KHR-layerCount-00138", "The layerCount member of srcSubresource and dstSubresource must match", "default"},
    {"VUID-VkImageCopy2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImageCopy2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_COPY_2_KHR", "1.2-extensions"},
    {"VUID-VkImageCopy2KHR-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-Format-02536", "If Format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage member including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-None-01891", "If any of the bits VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT are set, VK_IMAGE_CREATE_PROTECTED_BIT must not also be set", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-None-01925", "If any of the bits VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT are set, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT must not also be set", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-arrayLayers-00948", "arrayLayers must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-arrayLayers-02256", "arrayLayers must be less than or equal to imageCreateMaxArrayLayers (as defined in Image Creation Limits)", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-extent-00944", "extent.width must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-extent-00945", "extent.height must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-extent-00946", "extent.depth must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-extent-02252", "extent.width must be less than or equal to imageCreateMaxExtent.width (as defined in Image Creation Limits)", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-extent-02253", "extent.height must be less than or equal to imageCreateMaxExtent.height (as defined in Image Creation Limits)", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-extent-02254", "extent.depth must be less than or equal to imageCreateMaxExtent.depth (as defined in Image Creation Limits)", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-00949", "If flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, imageType must be VK_IMAGE_TYPE_2D", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-00950", "If flags contains VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, imageType must be VK_IMAGE_TYPE_3D", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-00969", "If the sparse bindings feature is not enabled, flags must not contain VK_IMAGE_CREATE_SPARSE_BINDING_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-00987", "If flags contains VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_IMAGE_CREATE_SPARSE_BINDING_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-01533", "If flags contains VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT format must be a depth or depth/stencil format", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-01572", "If flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then format must be a block-compressed image format, an ETC compressed image format, or an ASTC compressed image format", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-01573", "If flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then flags must also contain VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-01890", "If the protected memory feature is not enabled, flags must not contain VK_IMAGE_CREATE_PROTECTED_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-01924", "If the sparse aliased residency feature is not enabled, flags must not contain VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02050", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, imageType must be VK_IMAGE_TYPE_2D or VK_IMAGE_TYPE_3D", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02051", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, it must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT and the format must not be a depth/stencil format", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02052", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and imageType is VK_IMAGE_TYPE_2D, extent.width and extent.height must be greater than 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02053", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and imageType is VK_IMAGE_TYPE_3D, extent.width, extent.height, and extent.depth must be greater than 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02259", "If flags contains VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT, then mipLevels must be one, arrayLayers must be one, imageType must be VK_IMAGE_TYPE_2D. and imageCreateMaybeLinear (as defined in Image Creation Limits) must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02557", "If flags contains VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, imageType must be VK_IMAGE_TYPE_2D", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02565", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, tiling must be VK_IMAGE_TILING_OPTIMAL", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02566", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, imageType must be VK_IMAGE_TYPE_2D", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02567", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, flags must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-02568", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, mipLevels must be 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-04738", "If flags does not contain VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT and the pNext chain includes a VkImageFormatListCreateInfo structure, then VkImageFormatListCreateInfo::viewFormatCount must be 0 or 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-00943", "format must not be VK_FORMAT_UNDEFINED", "1.2-khr-extensions"},
    {"VUID-VkImageCreateInfo-format-01577", "If format is not a multi-planar format, and flags does not include VK_IMAGE_CREATE_ALIAS_BIT, flags must not contain VK_IMAGE_CREATE_DISJOINT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02537", "If format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage member including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02538", "If the multisampled storage images feature is not enabled, format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage including VK_IMAGE_USAGE_STORAGE_BIT, samples must be VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02561", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, then mipLevels must be 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02562", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, samples must be VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02563", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, imageType must be VK_IMAGE_TYPE_2D", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02564", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, arrayLayers must be 1", "1.2-khr-extensions"},
    {"VUID-VkImageCreateInfo-format-02653", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, and the ycbcrImageArrays feature is not enabled, arrayLayers must be 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02795", "If format is a depth-stencil format, usage includes VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02796", "If format is a depth-stencil format, usage does not include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also not include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02797", "If format is a depth-stencil format, usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-02798", "If format is a depth-stencil format, usage does not include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also not include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-04712", "If format has a _422 or _420 suffix, width must be a multiple of 2", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-04713", "If format has a _420 suffix, height must be a multiple of 2", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageCreateFormatFeatures-02260", "If format is a multi-planar format, and if imageCreateFormatFeatures (as defined in Image Creation Limits) does not contain VK_FORMAT_FEATURE_DISJOINT_BIT, then flags must not contain VK_IMAGE_CREATE_DISJOINT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageCreateMaxMipLevels-02251", "Each of the following values (as described in Image Creation Limits) must not be undefined : imageCreateMaxMipLevels, imageCreateMaxArrayLayers, imageCreateMaxExtent, and imageCreateSampleCounts", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00954", "If imageType is VK_IMAGE_TYPE_2D and flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, extent.width and extent.height must be equal and arrayLayers must be greater than or equal to 6", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00956", "If imageType is VK_IMAGE_TYPE_1D, both extent.height and extent.depth must be 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00957", "If imageType is VK_IMAGE_TYPE_2D, extent.depth must be 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00961", "If imageType is VK_IMAGE_TYPE_3D, arrayLayers must be 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00970", "If imageType is VK_IMAGE_TYPE_1D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00971", "If the sparse residency for 2D images feature is not enabled, and imageType is VK_IMAGE_TYPE_2D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00972", "If the sparse residency for 3D images feature is not enabled, and imageType is VK_IMAGE_TYPE_3D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00973", "If the sparse residency for images with 2 samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_2_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00974", "If the sparse residency for images with 4 samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_4_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00975", "If the sparse residency for images with 8 samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_8_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00976", "If the sparse residency for images with 16 samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_16_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-02082", "If usage includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, imageType must be VK_IMAGE_TYPE_2D", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageType-parameter", "imageType must be a valid VkImageType value", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-imageView2DOn3DImage-04459", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::imageView2DOn3DImage is VK_FALSE, flags must not contain VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT.", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-initialLayout-00993", "initialLayout must be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-mipLevels-00947", "mipLevels must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-mipLevels-00958", "mipLevels must be less than or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-mipLevels-02255", "mipLevels must be less than or equal to imageCreateMaxMipLevels (as defined in Image Creation Limits)", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-multisampleArrayImage-04460", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::multisampleArrayImage is VK_FALSE, and samples is not VK_SAMPLE_COUNT_1_BIT, then arrayLayers must be 1.", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-00988", "If the pNext chain includes a VkExternalMemoryImageCreateInfoNV structure, it must not contain a VkExternalMemoryImageCreateInfo structure", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-00990", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalImageFormatProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceImageFormatProperties2 with format, imageType, tiling, usage, and flags equal to those in this structure, and with a VkPhysicalDeviceExternalImageFormatInfo structure included in the pNext chain, with a handleType equal to any one of the handle types specified in VkExternalMemoryImageCreateInfo::handleTypes", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-00991", "If the pNext chain includes a VkExternalMemoryImageCreateInfoNV structure, its handleTypes member must only contain bits that are also in VkExternalImageFormatPropertiesNV::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalImageFormatPropertiesNV with format, imageType, tiling, usage, and flags equal to those in this structure, and with externalHandleType equal to any one of the handle types specified in VkExternalMemoryImageCreateInfoNV::handleTypes", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-01443", "If the pNext chain includes a ifdef::VK_VERSION_1_1,VK_KHR_external_memory[VkExternalMemoryImageCreateInfo]", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-01974", "If the pNext chain includes a VkExternalFormatANDROID structure, and its externalFormat member is non-zero the format must be VK_FORMAT_UNDEFINED", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-01975", "If the pNext chain does not include a VkExternalFormatANDROID structure, or does and its externalFormat member is 0, the format must not be VK_FORMAT_UNDEFINED", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02262", "If the pNext chain includes a VkImageDrmFormatModifierListCreateInfoEXT or VkImageDrmFormatModifierExplicitCreateInfoEXT structure, then tiling must be VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02393", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, imageType must be VK_IMAGE_TYPE_2D", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02394", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, mipLevels must either be 1 or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02396", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, flags must not include VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02397", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, usage must not include any usages except VK_IMAGE_USAGE_SAMPLED_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02398", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, tiling must be VK_IMAGE_TILING_OPTIMAL", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-04737", "If a VkImageFormatListCreateInfo structure was included in the pNext chain and VkImageFormatListCreateInfo::viewFormatCount is not zero, then all of the formats in VkImageFormatListCreateInfo::pViewFormats must be compatible with the format as described in the compatibility table", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDedicatedAllocationImageCreateInfoNV, VkExternalFormatANDROID, VkExternalMemoryImageCreateInfo, VkExternalMemoryImageCreateInfoNV, VkImageDrmFormatModifierExplicitCreateInfoEXT, VkImageDrmFormatModifierListCreateInfoEXT, VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, VkImageSwapchainCreateInfoKHR, VkVideoProfileKHR, or VkVideoProfilesKHR", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-physicalDeviceCount-01421", "If the logical device was created with VkDeviceGroupDeviceCreateInfo::physicalDeviceCount equal to 1, flags must not contain VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-samples-02083", "If usage includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, samples must be VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-samples-02257", "If samples is not VK_SAMPLE_COUNT_1_BIT, then imageType must be VK_IMAGE_TYPE_2D, flags must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, mipLevels must be equal to 1, and imageCreateMaybeLinear (as defined in Image Creation Limits) must be VK_FALSE,", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-samples-02258", "samples must be a bit value that is set in imageCreateSampleCounts (as defined in Image Creation Limits)", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-samples-02558", "If samples is not VK_SAMPLE_COUNT_1_BIT, usage must not contain VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-sharingMode-00941", "If sharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-sharingMode-00942", "If sharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-sharingMode-01392", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device", "1.0"},
    {"VUID-VkImageCreateInfo-sharingMode-01420", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties or vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-tiling-02084", "If usage includes VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, tiling must be VK_IMAGE_TILING_OPTIMAL", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-tiling-02261", "If tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then the pNext chain must include exactly one of VkImageDrmFormatModifierListCreateInfoEXT or VkImageDrmFormatModifierExplicitCreateInfoEXT structures", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-tiling-02353", "If tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT and flags contains VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, then the pNext chain must include a VkImageFormatListCreateInfo structure with non-zero viewFormatCount", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-tiling-04121", "If tiling is VK_IMAGE_TILING_LINEAR, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-tiling-parameter", "tiling must be a valid VkImageTiling value", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-00963", "If usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, then bits other than VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT must not be set", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-00964", "If usage includes VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-00965", "If usage includes VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-00966", "If usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, usage must also contain at least one of VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-00968", "If the multisampled storage images feature is not enabled, and usage contains VK_IMAGE_USAGE_STORAGE_BIT, samples must be VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-02559", "If usage includes VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, extent.width must be less than or equal to the ceiling of maxFramebufferWidth/minFragmentDensityTexelSize.width", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-02560", "If usage includes VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, extent.height must be less than or equal to the ceiling of maxFramebufferHeight/minFragmentDensityTexelSize.height", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-04815", "If usage includes VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR, VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, then the pNext chain must include a valid VkVideoProfilesKHR structure which includes at least one VkVideoProfileKHR with a decode codec-operation.", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-04816", "If usage includes VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR, VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, then the pNext chain must include a valid VkVideoProfilesKHR structure which includes at least one VkVideoProfileKHR with a encode codec-operation.", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkImageCreateInfo-usage-requiredbitmask", "usage must not be 0", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-arrayPitch-02268", "For each element of pPlaneLayouts, arrayPitch must be 0 if VkImageCreateInfo::arrayLayers is 1", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-depthPitch-02269", "For each element of pPlaneLayouts, depthPitch must be 0 if VkImageCreateInfo::extent.depth is 1", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifier-02264", "drmFormatModifier must be compatible with the parameters in VkImageCreateInfo and its pNext chain, as determined by querying VkPhysicalDeviceImageFormatInfo2 extended with VkPhysicalDeviceImageDrmFormatModifierInfoEXT", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifierPlaneCount-02265", "drmFormatModifierPlaneCount must be equal to the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with VkImageCreateInfo::format and drmFormatModifier, as found by querying VkDrmFormatModifierPropertiesListEXT", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-pPlaneLayouts-parameter", "If drmFormatModifierPlaneCount is not 0, pPlaneLayouts must be a valid pointer to an array of drmFormatModifierPlaneCount VkSubresourceLayout structures", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-size-02267", "For each element of pPlaneLayouts, size must be 0", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-drmFormatModifierCount-arraylength", "drmFormatModifierCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-02263", "Each modifier in pDrmFormatModifiers must be compatible with the parameters in VkImageCreateInfo and its pNext chain, as determined by querying VkPhysicalDeviceImageFormatInfo2 extended with VkPhysicalDeviceImageDrmFormatModifierInfoEXT", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-parameter", "pDrmFormatModifiers must be a valid pointer to an array of drmFormatModifierCount uint64_t values", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierPropertiesEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImageDrmFormatModifierPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkImageFormatListCreateInfo-pViewFormats-parameter", "If viewFormatCount is not 0, pViewFormats must be a valid pointer to an array of viewFormatCount valid VkFormat values", "1.2-extensions"},
    {"VUID-VkImageFormatListCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkImageFormatProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAndroidHardwareBufferUsageANDROID, VkExternalImageFormatProperties, VkFilterCubicImageViewImageFormatPropertiesEXT, VkSamplerYcbcrConversionImageFormatProperties, or VkTextureLODGatherFormatPropertiesAMD", "1.2-extensions"},
    {"VUID-VkImageFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2", "1.2-extensions"},
    {"VUID-VkImageFormatProperties2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-01207", "If image has a depth/stencil format with both depth and stencil components, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.1"},
    {"VUID-VkImageMemoryBarrier-image-01671", "If image has a single-plane color format or is not disjoint, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-01672", "If image has a multi-planar format and the image is disjoint, then the aspectMask member of subresourceRange must include either at least one of VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, and VK_IMAGE_ASPECT_PLANE_2_BIT; or must include VK_IMAGE_ASPECT_COLOR_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-01673", "If image has a multi-planar format with only two planes, then the aspectMask member of subresourceRange must not include VK_IMAGE_ASPECT_PLANE_2_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-01932", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-02902", "If image has a color format, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.0"},
    {"VUID-VkImageMemoryBarrier-image-03319", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is enabled, then the aspectMask member of subresourceRange must include either or both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-03320", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is not enabled, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-04069", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex and dstQueueFamilyIndex must be valid queue families", "1.0"},
    {"VUID-VkImageMemoryBarrier-image-04071", "If image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, and one of srcQueueFamilyIndex and dstQueueFamilyIndex is one of the special queue family values reserved for external memory transfers, the other must be VK_QUEUE_FAMILY_IGNORED", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-04072", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex and dstQueueFamilyIndex must both be valid queue families, or one of the special queue family values reserved for external memory transfers, as described in Queue Family Ownership Transfer", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-image-parameter", "image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-newLayout-01198", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, newLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-newLayout-parameter", "newLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01197", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, oldLayout must be VK_IMAGE_LAYOUT_UNDEFINED or the current layout of the image subresources affected by the barrier", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01208", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01209", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01210", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01211", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_SAMPLED_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01212", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01213", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01658", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01659", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-02088", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR then image must have been created with VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR set", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-parameter", "oldLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkSampleLocationsInfoEXT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-03938", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR, image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT or VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-03939", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR, image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04065", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL then image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04066", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04067", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04068", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04070", "If srcQueueFamilyIndex is not equal to dstQueueFamilyIndex, at least one must not be a special queue family reserved for external memory ownership transfers, as described in Queue Family Ownership Transfer", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01486", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01488", "subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01724", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier-synchronization2-03856", "If the synchronization2 feature is not enabled, and image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex and dstQueueFamilyIndex must both be VK_QUEUE_FAMILY_IGNORED", "1.0"},
    {"VUID-VkImageMemoryBarrier-synchronization2-03857", "If the synchronization2 feature is not enabled, and image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, at least one of srcQueueFamilyIndex and dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03900", "If pname:dstAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03901", "If pname:dstAccessMask includes VK_ACCESS_2_INDEX_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03902", "If pname:dstAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03903", "If pname:dstAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT_KHR, VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03904", "If pname:dstAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03905", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03906", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03907", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03908", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03909", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03910", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03911", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03912", "If pname:dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03913", "If pname:dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03914", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03915", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_CLEAR_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03916", "If pname:dstAccessMask includes VK_ACCESS_2_HOST_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03917", "If pname:dstAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03918", "If pname:dstAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03919", "If pname:dstAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03920", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03922", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03923", "If pname:dstAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03924", "If pname:dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03925", "If pname:dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03926", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03927", "If pname:dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-03928", "If pname:dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-04747", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-04858", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-04859", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-04860", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-04861", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-03929", "If the geometry shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-03930", "If the tessellation shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-03931", "If the conditional rendering feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-03932", "If the fragment density map feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-03933", "If the transform feedback feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-03934", "If the mesh shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-03935", "If the task shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-04956", "If the shading rate image feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-04957", "If the subpass shading feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-01207", "If image has a depth/stencil format with both depth and stencil components, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "default"},
    {"VUID-VkImageMemoryBarrier2KHR-image-01671", "If image has a single-plane color format or is not disjoint, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-01672", "If image has a multi-planar format and the image is disjoint, then the aspectMask member of subresourceRange must include either at least one of VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, and VK_IMAGE_ASPECT_PLANE_2_BIT; or must include VK_IMAGE_ASPECT_COLOR_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-01673", "If image has a multi-planar format with only two planes, then the aspectMask member of subresourceRange must not include VK_IMAGE_ASPECT_PLANE_2_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-01932", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-02902", "If image has a color format, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "default"},
    {"VUID-VkImageMemoryBarrier2KHR-image-03319", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is enabled, then the aspectMask member of subresourceRange must include either or both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-03320", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is not enabled, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-04069", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex and dstQueueFamilyIndex must be valid queue families", "default"},
    {"VUID-VkImageMemoryBarrier2KHR-image-04071", "If image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, and one of srcQueueFamilyIndex and dstQueueFamilyIndex is one of the special queue family values reserved for external memory transfers, the other must be VK_QUEUE_FAMILY_IGNORED", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-04072", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex and dstQueueFamilyIndex must both be valid queue families, or one of the special queue family values reserved for external memory transfers, as described in Queue Family Ownership Transfer", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-image-parameter", "image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-newLayout-01198", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, newLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-newLayout-parameter", "newLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01197", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, oldLayout must be VK_IMAGE_LAYOUT_UNDEFINED or the current layout of the image subresources affected by the barrier", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01208", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01209", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01210", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01211", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_SAMPLED_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01212", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01213", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01658", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-01659", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-02088", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR then image must have been created with VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR set", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-oldLayout-parameter", "oldLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkSampleLocationsInfoEXT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03900", "If pname:srcAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03901", "If pname:srcAccessMask includes VK_ACCESS_2_INDEX_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03902", "If pname:srcAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03903", "If pname:srcAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT_KHR, VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03904", "If pname:srcAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03905", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03906", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03907", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03908", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03909", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03910", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03911", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03912", "If pname:srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03913", "If pname:srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03914", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03915", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_CLEAR_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03916", "If pname:srcAccessMask includes VK_ACCESS_2_HOST_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03917", "If pname:srcAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03918", "If pname:srcAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03919", "If pname:srcAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03920", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03922", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03923", "If pname:srcAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03924", "If pname:srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03925", "If pname:srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03926", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03927", "If pname:srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-03928", "If pname:srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-04747", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-04858", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-04859", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-04860", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-04861", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcQueueFamilyIndex-03938", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR, image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT or VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcQueueFamilyIndex-03939", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR, image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcQueueFamilyIndex-04065", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL then image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcQueueFamilyIndex-04066", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcQueueFamilyIndex-04067", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcQueueFamilyIndex-04068", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcQueueFamilyIndex-04070", "If srcQueueFamilyIndex is not equal to dstQueueFamilyIndex, at least one must not be a special queue family reserved for external memory ownership transfers, as described in Queue Family Ownership Transfer", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03854", "If either srcStageMask or dstStageMask includes VK_PIPELINE_STAGE_2_HOST_BIT_KHR, srcQueueFamilyIndex and dstQueueFamilyIndex must be equal", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03855", "If srcStageMask includes VK_PIPELINE_STAGE_2_HOST_BIT_KHR, and srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, oldLayout must be one of VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_UNDEFINED, or VK_IMAGE_LAYOUT_GENERAL", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03929", "If the geometry shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03930", "If the tessellation shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03931", "If the conditional rendering feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03932", "If the fragment density map feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03933", "If the transform feedback feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03934", "If the mesh shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-03935", "If the task shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-04956", "If the shading rate image feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-04957", "If the subpass shading feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-subresourceRange-01486", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-subresourceRange-01488", "subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-subresourceRange-01724", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-subresourceRange-01725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageMemoryBarrier2KHR-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01589", "If image was created with a multi-planar format and the VK_IMAGE_CREATE_DISJOINT_BIT flag, there must be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01590", "If image was not created with the VK_IMAGE_CREATE_DISJOINT_BIT flag, there must not be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01591", "If image was created with a single-plane format, there must not be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.2-khr-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01897", "If image was created with the VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID external memory handle type, then image must be bound to memory", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-02279", "If image was created with VK_IMAGE_CREATE_DISJOINT_BIT and with VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then there must be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-02280", "If image was created with a single-plane format and with any tiling other than VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then there must not be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-parameter", "image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkImagePlaneMemoryRequirementsInfo", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2", "1.2-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-imagePipeHandle-04863", "imagePipeHandle must be a valid zx_handle_t", "1.2-extensions"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA", "1.2-extensions"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-02281", "If the image's tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid format plane for the image (that is, for a two-plane image planeAspect must be VK_IMAGE_ASPECT_PLANE_0_BIT or VK_IMAGE_ASPECT_PLANE_1_BIT, and for a three-plane image planeAspect must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT or VK_IMAGE_ASPECT_PLANE_2_BIT)", "1.2-extensions"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-02282", "If the image's tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", "1.2-extensions"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-parameter", "planeAspect must be a valid VkImageAspectFlagBits value", "1.2-extensions"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO", "1.2-extensions"},
    {"VUID-VkImageResolve-aspectMask-00266", "The aspectMask member of srcSubresource and dstSubresource must only contain VK_IMAGE_ASPECT_COLOR_BIT", "1.2-extensions"},
    {"VUID-VkImageResolve-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageResolve-layerCount-00267", "The layerCount member of srcSubresource and dstSubresource must match", "1.2-extensions"},
    {"VUID-VkImageResolve-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageResolve2KHR-aspectMask-00266", "The aspectMask member of srcSubresource and dstSubresource must only contain VK_IMAGE_ASPECT_COLOR_BIT", "1.2-extensions"},
    {"VUID-VkImageResolve2KHR-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageResolve2KHR-layerCount-00267", "The layerCount member of srcSubresource and dstSubresource must match", "1.2-extensions"},
    {"VUID-VkImageResolve2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImageResolve2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR", "1.2-extensions"},
    {"VUID-VkImageResolve2KHR-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.2-extensions"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-image-parameter", "image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2", "1.2-extensions"},
    {"VUID-VkImageStencilUsageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-02539", "If stencilUsage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, it must not include bits other than VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-parameter", "stencilUsage must be a valid combination of VkImageUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-requiredbitmask", "stencilUsage must not be 0", "1.2-extensions"},
    {"VUID-VkImageSubresource-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.2-extensions"},
    {"VUID-VkImageSubresource-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.2-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-00167", "If aspectMask contains VK_IMAGE_ASPECT_COLOR_BIT, it must not contain either of VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "1.2-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-00168", "aspectMask must not contain VK_IMAGE_ASPECT_METADATA_BIT", "1.2-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-02247", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.2-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.2-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.2-extensions"},
    {"VUID-VkImageSubresourceLayers-layerCount-01700", "layerCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageSubresourceRange-aspectMask-01670", "If aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, then it must not include any of VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT", "1.2-extensions"},
    {"VUID-VkImageSubresourceRange-aspectMask-02278", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.2-extensions"},
    {"VUID-VkImageSubresourceRange-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.2-extensions"},
    {"VUID-VkImageSubresourceRange-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.2-extensions"},
    {"VUID-VkImageSubresourceRange-layerCount-01721", "If layerCount is not VK_REMAINING_ARRAY_LAYERS, it must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageSubresourceRange-levelCount-01720", "If levelCount is not VK_REMAINING_MIP_LEVELS, it must be greater than 0", "1.2-extensions"},
    {"VUID-VkImageSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkImageSwapchainCreateInfoKHR-swapchain-00995", "If swapchain is not VK_NULL_HANDLE, the fields of VkImageCreateInfo must match the implied image creation parameters of the swapchain", "1.2-extensions"},
    {"VUID-VkImageSwapchainCreateInfoKHR-swapchain-parameter", "If swapchain is not VK_NULL_HANDLE, swapchain must be a valid VkSwapchainKHR handle", "1.2-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02230", "decodeMode must be one of VK_FORMAT_R16G16B16A16_SFLOAT, VK_FORMAT_R8G8B8A8_UNORM, or VK_FORMAT_E5B9G9R9_UFLOAT_PACK32", "1.2-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02231", "If the decodeModeSharedExponent feature is not enabled, decodeMode must not be VK_FORMAT_E5B9G9R9_UFLOAT_PACK32", "1.2-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02232", "If decodeMode is VK_FORMAT_R8G8B8A8_UNORM the image view must not include blocks using any of the ASTC HDR modes", "1.2-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-parameter", "decodeMode must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-format-04084", "format of the image view must be one of the ASTC Compressed Image Formats", "1.2-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT", "1.2-extensions"},
    {"VUID-VkImageViewAddressPropertiesNVX-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImageViewAddressPropertiesNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-None-02273", "The format features of the resultant image view must contain at least one bit", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-components-parameter", "components must be a valid VkComponentMapping structure", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-02572", "If dynamic fragment density map feature is not enabled, flags must not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-03567", "If deferred fragment density map feature is not enabled, flags must not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-03568", "If flags contains VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT, flags must not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-04116", "If flags does not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT and image was created with usage containing VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, its flags must not contain any of VK_IMAGE_CREATE_PROTECTED_BIT, VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-parameter", "flags must be a valid combination of VkImageViewCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-format-04714", "If format has a _422 or _420 suffix then image must have been created with a width that is a multiple of 2", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-format-04715", "If format has a _420 suffix then image must have been created with a height that is a multiple of 2", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-format-04724", "If format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, then the pNext chain must include a VkSamplerYcbcrConversionInfo structure with a conversion value other than VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01003", "If image was not created with VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT then viewType must not be VK_IMAGE_VIEW_TYPE_CUBE or VK_IMAGE_VIEW_TYPE_CUBE_ARRAY", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01005", "If image was created with VK_IMAGE_TYPE_3D but without VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set then viewType must not be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01018", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, format must be compatible with the format used to create image, as defined in Format Compatibility Classes", "1.0"},
    {"VUID-VkImageViewCreateInfo-image-01019", "If image was not created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, format must be identical to the format used to create image", "1.0"},
    {"VUID-VkImageViewCreateInfo-image-01020", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01482", "If image is not a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, or viewType is not VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01583", "If image was created with the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, format must be compatible with, or must be an uncompressed format that is size-compatible with, the format used to create image", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01584", "If image was created with the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, the levelCount and layerCount members of subresourceRange must both be 1", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01586", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, if the format of the image is a multi-planar format, and if subresourceRange.aspectMask is one of VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT, then format must be compatible with the VkFormat for the plane of the image format indicated by subresourceRange.aspectMask, as defined in Compatible formats of planes of multi-planar formats", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01759", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, but without the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, format must be compatible with the format used to create image, as defined in Format Compatibility Classes", "default"},
    {"VUID-VkImageViewCreateInfo-image-01760", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, and if the format of the image is not a multi-planar format, format must be compatible with the format used to create image, as defined in Format Compatibility Classes", "default"},
    {"VUID-VkImageViewCreateInfo-image-01761", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, but without the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, and if the format of the image is not a multi-planar format, format must be compatible with the format used to create image, as defined in Format Compatibility Classes", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01762", "If image was not created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, or if the format of the image is a multi-planar format and if subresourceRange.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, format must be identical to the format used to create image", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02086", "If image was created with usage containing VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, viewType must be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02087", "If the shadingRateImage feature is enabled, and If image was created with usage containing VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, format must be VK_FORMAT_R8_UINT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02399", "If image has an external format, format must be VK_FORMAT_UNDEFINED", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02400", "If image has an external format, the pNext chain must include a VkSamplerYcbcrConversionInfo structure with a conversion object created with the same external format as image", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02401", "If image has an external format, all members of components must be the identity swizzle", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02571", "If image was created with usage containing VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, subresourceRange.levelCount must be 1", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02724", "If image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, and viewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.baseArrayLayer must be less than the depth computed from baseMipLevel and extent.depth specified in VkImageCreateInfo when image was created, according to the formula defined in Image Miplevel Sizing", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-03569", "If image was created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT and usage containing VK_IMAGE_USAGE_SAMPLED_BIT, subresourceRange.layerCount must be less than or equal to VkPhysicalDeviceFragmentDensityMap2PropertiesEXT::maxSubsampledArrayLayers", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04441", "image must have been created with a usage value containing at least one of the usages defined in the valid image usage list for image views", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04739", "If image was created with the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag and format is a non-compressed format, viewType must not be VK_IMAGE_VIEW_TYPE_3D", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04817", "If image was created with usage containing VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR, VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, then the viewType must be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY and all members of components must have the identity swizzle", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04818", "If image was created with usage containing VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR, VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, then the viewType must be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY and all members of components must have the identity swizzle", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04970", "If image was created with VK_IMAGE_TYPE_3D and imageViewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY then subresourceRange.levelCount must be 1", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04971", "If image was created with VK_IMAGE_TYPE_3D and imageViewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY then flags must not contain any of VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, and VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04972", "If image was created with a samples value not equal to VK_SAMPLE_COUNT_1_BIT then imageViewType must be either VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-image-parameter", "image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewFormatReinterpretation-04466", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::imageViewFormatReinterpretation is VK_FALSE, the VkFormat in format must not contain a different number of components, or a different number of bits in each component, than the format of the VkImage in image.", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewFormatSwizzle-04465", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::imageViewFormatSwizzle is VK_FALSE, all elements of components must be VK_COMPONENT_SWIZZLE_IDENTITY.", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewType-04969", "imageViewType must be compatible with the type of image as shown in the view type compatibility table", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewType-04973", "If imageViewType is VK_IMAGE_VIEW_TYPE_1D, VK_IMAGE_VIEW_TYPE_2D, or VK_IMAGE_VIEW_TYPE_3D; and subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, then subresourceRange.layerCount must be 1", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewType-04974", "If imageViewType is VK_IMAGE_VIEW_TYPE_1D, VK_IMAGE_VIEW_TYPE_2D, or VK_IMAGE_VIEW_TYPE_3D; and subresourceRange.layerCount is VK_REMAINING_ARRAY_LAYERS, then the remaining number of layers must be 1", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-01585", "If a VkImageFormatListCreateInfo structure was included in the pNext chain of the VkImageCreateInfo structure used when creating image and VkImageFormatListCreateInfo::viewFormatCount is not zero then format must be one of the formats in VkImageFormatListCreateInfo::pViewFormats", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-01970", "If the pNext chain includes a VkSamplerYcbcrConversionInfo structure with a conversion value other than VK_NULL_HANDLE, all members of components must have the identity swizzle", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-02661", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, its usage member must not include any bits that were not set in the usage member of the VkImageCreateInfo structure used to create image", "1.2-khr-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-02662", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, and image was not created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, its usage member must not include any bits that were not set in the usage member of the VkImageCreateInfo structure used to create image", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-02663", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, image was created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, and subResourceRange.aspectMask includes VK_IMAGE_ASPECT_STENCIL_BIT, the usage member of the VkImageViewUsageCreateInfo instance must not include any bits that were not set in the usage member of the VkImageStencilUsageCreateInfo structure used to create image", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-02664", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, image was created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, and subResourceRange.aspectMask includes bits other than VK_IMAGE_ASPECT_STENCIL_BIT, the usage member of the VkImageViewUsageCreateInfo structure must not include any bits that were not set in the usage member of the VkImageCreateInfo structure used to create image", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkImageViewASTCDecodeModeEXT, VkImageViewUsageCreateInfo, VkSamplerYcbcrConversionInfo, VkVideoProfileKHR, or VkVideoProfilesKHR", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-subResourceRange-01021", "subresourceRange and viewType must be compatible with the image, as described in the compatibility table", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01478", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01480", "subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.0"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01483", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, image is not a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, or viewType is not VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.layerCount must be non-zero and subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01718", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01719", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "1.0"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-02725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, and viewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.layerCount must be non-zero and subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the depth computed from baseMipLevel and extent.depth specified in VkImageCreateInfo when image was created, according to the formula defined in Image Miplevel Sizing", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-02274", "If usage contains VK_IMAGE_USAGE_SAMPLED_BIT, then the format features of the resultant image view must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-02275", "If usage contains VK_IMAGE_USAGE_STORAGE_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-02276", "If usage contains VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-02277", "If usage contains VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-02652", "If usage contains VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, then the image view's format features must contain at least one of VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-04550", "If the attachmentFragmentShadingRate feature is enabled, and the usage for the image view includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, then the image view's format features must contain VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-04551", "If the attachmentFragmentShadingRate feature is enabled, the usage for the image view includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, and layeredShadingRateAttachments is VK_FALSE, subresourceRange.layerCount must be 1", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-01004", "If the image cubemap arrays feature is not enabled, viewType must not be VK_IMAGE_VIEW_TYPE_CUBE_ARRAY", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-02960", "If viewType is VK_IMAGE_VIEW_TYPE_CUBE and subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.layerCount must be 6", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-02961", "If viewType is VK_IMAGE_VIEW_TYPE_CUBE_ARRAY and subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.layerCount must be a multiple of 6", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-02962", "If viewType is VK_IMAGE_VIEW_TYPE_CUBE and subresourceRange.layerCount is VK_REMAINING_ARRAY_LAYERS, the remaining number of layers must be 6", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-02963", "If viewType is VK_IMAGE_VIEW_TYPE_CUBE_ARRAY and subresourceRange.layerCount is VK_REMAINING_ARRAY_LAYERS, the remaining number of layers must be a multiple of 6", "1.2-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-parameter", "viewType must be a valid VkImageViewType value", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-commonparent", "Both of imageView, and sampler that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-descriptorType-02654", "descriptorType must be VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-02656", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the image that imageView was created from must have been created with the VK_IMAGE_USAGE_SAMPLED_BIT usage bit set", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-02657", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, the image that imageView was created from must have been created with the VK_IMAGE_USAGE_STORAGE_BIT usage bit set", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-parameter", "imageView must be a valid VkImageView handle", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-sampler-02655", "sampler must be a valid VkSampler if descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER", "1.2-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-sampler-parameter", "If sampler is not VK_NULL_HANDLE, sampler must be a valid VkSampler handle", "1.2-extensions"},
    {"VUID-VkImageViewUsageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkImageViewUsageCreateInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkImageViewUsageCreateInfo-usage-requiredbitmask", "usage must not be 0", "1.2-extensions"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-01880", "If buffer is not NULL, Android hardware buffers must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.2-extensions"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-01881", "If buffer is not NULL, it must be a valid Android hardware buffer object with AHardwareBuffer_Desc::usage compatible with Vulkan as described in Android Hardware Buffers", "1.2-extensions"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-parameter", "buffer must be a valid pointer to an AHardwareBuffer value", "1.2-extensions"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID", "1.2-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-fd-01541", "fd must obey any requirements listed for handleType in external fence handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "1.2-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-flags-parameter", "flags must be a valid combination of VkFenceImportFlagBits values", "1.2-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-handleType-01464", "handleType must be a value included in the Handle Types Supported by VkImportFenceFdInfoKHR table", "1.2-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-flags-parameter", "flags must be a valid combination of VkFenceImportFlagBits values", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handle-01462", "If handle is not NULL, name must be NULL", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handle-01539", "If handle is not NULL, it must obey any requirements listed for handleType in external fence handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01457", "handleType must be a value included in the Handle Types Supported by VkImportFenceWin32HandleInfoKHR table", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01459", "If handleType is not VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, name must be NULL", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01460", "If handle is NULL, name must name a valid synchronization primitive of the type specified by handleType", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01461", "If name is NULL, handle must be a valid handle of the type specified by handleType", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-name-01540", "If name is not NULL, it must obey any requirements listed for handleType in external fence handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-00668", "The memory from which fd was exported must have been created on the same underlying physical device as device", "1.2-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-01520", "fd must obey any requirements listed for handleType in external memory handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-01746", "The memory represented by fd must have been created from a physical device and driver that is compatible with device and handleType, as described in External memory handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00667", "If handleType is not 0, it must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.2-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00669", "If handleType is not 0, it must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT", "1.2-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00670", "If handleType is not 0, fd must be a valid handle of the type specified by handleType", "1.2-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR", "1.2-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01747", "If handleType is not 0, it must be supported for import, as reported in VkExternalMemoryProperties", "1.2-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01748", "If handleType is not 0, it must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT or VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT", "1.2-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01750", "If handleType is VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT, pHostPointer must be a pointer to allocationSize number of bytes of host memory, where allocationSize is the member of the VkMemoryAllocateInfo structure this structure is chained to", "1.2-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01751", "If handleType is VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT, pHostPointer must be a pointer to allocationSize number of bytes of host mapped foreign memory, where allocationSize is the member of the VkMemoryAllocateInfo structure this structure is chained to", "1.2-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-pHostPointer-01749", "pHostPointer must be a pointer aligned to an integer multiple of VkPhysicalDeviceExternalMemoryHostPropertiesEXT::minImportedHostPointerAlignment", "1.2-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-00659", "The memory from which handle was exported, or the memory named by name must have been created on the same underlying physical device as device", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-01441", "if handle is not NULL, name must be NULL", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-01518", "If handle is not NULL, it must obey any requirements listed for handleType in external memory handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00658", "If handleType is not 0, it must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00660", "If handleType is not 0, it must be defined as an NT handle or a global share handle", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00661", "If handleType is not 0 and name is NULL, handle must be a valid handle of the type specified by handleType", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-01439", "If handleType is not VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, name must be NULL", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-01440", "If handleType is not 0 and handle is NULL, name must name a valid memory resource of the type specified by handleType", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-name-01519", "If name is not NULL, it must obey any requirements listed for handleType in external memory handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handle-01328", "handle must be a valid handle to memory, obtained as specified by handleType", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handleType-01327", "handleType must not have more than one bit set", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handleType-parameter", "handleType must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", "1.2-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV", "1.2-extensions"},
    {"VUID-VkImportMemoryZirconHandleInfoFUCHSIA-handle-04772", "handle must be a valid VMO handle.", "1.2-extensions"},
    {"VUID-VkImportMemoryZirconHandleInfoFUCHSIA-handleType-04771", "handleType must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA.", "1.2-extensions"},
    {"VUID-VkImportMemoryZirconHandleInfoFUCHSIA-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkImportMemoryZirconHandleInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-fd-01544", "fd must obey any requirements listed for handleType in external semaphore handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-flags-03323", "If flags contains VK_SEMAPHORE_IMPORT_TEMPORARY_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field of the semaphore from which fd was exported must not be VK_SEMAPHORE_TYPE_TIMELINE", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-flags-parameter", "flags must be a valid combination of VkSemaphoreImportFlagBits values", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-01143", "handleType must be a value included in the Handle Types Supported by VkImportSemaphoreFdInfoKHR table", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-03263", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, the VkSemaphoreCreateInfo::flags field must match that of the semaphore from which fd was exported", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-03264", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field must match that of the semaphore from which fd was exported", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR", "1.2-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-flags-03322", "If flags contains VK_SEMAPHORE_IMPORT_TEMPORARY_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field of the semaphore from which handle or name was exported must not be VK_SEMAPHORE_TYPE_TIMELINE", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-flags-parameter", "flags must be a valid combination of VkSemaphoreImportFlagBits values", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handle-01469", "If handle is not NULL, name must be NULL", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handle-01542", "If handle is not NULL, it must obey any requirements listed for handleType in external semaphore handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01140", "handleType must be a value included in the Handle Types Supported by VkImportSemaphoreWin32HandleInfoKHR table", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01466", "If handleType is not VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, name must be NULL", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01467", "If handle is NULL, name must name a valid synchronization primitive of the type specified by handleType", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01468", "If name is NULL, handle must be a valid handle of the type specified by handleType", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-03261", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, the VkSemaphoreCreateInfo::flags field must match that of the semaphore from which handle or name was exported", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-03262", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field must match that of the semaphore from which handle or name was exported", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-name-01543", "If name is not NULL, it must obey any requirements listed for handleType in external semaphore handle types compatibility", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-flags-parameter", "flags must be a valid combination of VkSemaphoreImportFlagBits values", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-handleType-04765", "handleType must be a value included in the Handle Types Supported by VkImportSemaphoreZirconHandleInfoFUCHSIA table.", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-semaphoreType-04768", "The VkSemaphoreTypeCreateInfo::semaphoreType field must not be VK_SEMAPHORE_TYPE_TIMELINE.", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-zirconHandle-04766", "zirconHandle must obey any requirements listed for handleType in external semaphore handle types compatibility.", "1.2-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-zirconHandle-04767", "zirconHandle must have ZX_RIGHTS_BASIC and ZX_RIGHTS_SIGNAL rights.", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-flags-parameter", "flags must be a valid combination of VkIndirectCommandsLayoutUsageFlagBitsNV values", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pStreamStrides-02937", "each element of pStreamStrides must be greater than `0`and less than or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectCommandsStreamStride. Furthermore the alignment of each token input must be ensured", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pStreamStrides-parameter", "pStreamStrides must be a valid pointer to an array of streamCount uint32_t values", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-02932", "If pTokens contains an entry of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV it must be the first element of the array and there must be only a single element of such token type", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-02933", "If pTokens contains an entry of VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV there must be only a single element of such token type", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-02934", "All state tokens in pTokens must occur prior work provoking tokens (VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV, VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV, VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV)", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-02935", "The content of pTokens must include one single work provoking token that is compatible with the pipelineBindPoint", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-parameter", "pTokens must be a valid pointer to an array of tokenCount valid VkIndirectCommandsLayoutTokenNV structures", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pipelineBindPoint-02930", "The pipelineBindPoint must be VK_PIPELINE_BIND_POINT_GRAPHICS", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-streamCount-02936", "streamCount must be greater than 0 and less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectCommandsStreamCount", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-streamCount-arraylength", "streamCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-tokenCount-02931", "tokenCount must be greater than 0 and less than or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectCommandsTokenCount", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-tokenCount-arraylength", "tokenCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-indirectStateFlags-parameter", "indirectStateFlags must be a valid combination of VkIndirectStateFlagBitsNV values", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-offset-02952", "offset must be less than or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectCommandsTokenOffset", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pIndexTypeValues-parameter", "If indexTypeCount is not 0, pIndexTypeValues must be a valid pointer to an array of indexTypeCount uint32_t values", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pIndexTypes-parameter", "If indexTypeCount is not 0, pIndexTypes must be a valid pointer to an array of indexTypeCount valid VkIndexType values", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pushconstantPipelineLayout-parameter", "If pushconstantPipelineLayout is not VK_NULL_HANDLE, pushconstantPipelineLayout must be a valid VkPipelineLayout handle", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pushconstantShaderStageFlags-parameter", "pushconstantShaderStageFlags must be a valid combination of VkShaderStageFlagBits values", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-stream-02951", "stream must be smaller than VkIndirectCommandsLayoutCreateInfoNV::streamCount", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02976", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV, vertexBindingUnit must stay within device supported limits for the appropriate commands", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02977", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantPipelineLayout must be valid", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02978", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantOffset must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02979", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantSize must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02980", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantOffset must be less than VkPhysicalDeviceLimits::maxPushConstantsSize", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02981", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantSize must be less than or equal to VkPhysicalDeviceLimits::maxPushConstantsSize minus pushconstantOffset", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02982", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, for each byte in the range specified by pushconstantOffset and pushconstantSize and for each shader stage in pushconstantShaderStageFlags, there must be a push constant range in pushconstantPipelineLayout that includes that byte and that stage", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02983", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, for each byte in the range specified by pushconstantOffset and pushconstantSize and for each push constant range that overlaps that byte, pushconstantShaderStageFlags must include all stages in that push constant range's VkPushConstantRange::stageFlags", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02984", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV, indirectStateFlags must not be 0", "1.2-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-parameter", "tokenType must be a valid VkIndirectCommandsTokenTypeNV value", "1.2-extensions"},
    {"VUID-VkIndirectCommandsStreamNV-buffer-02942", "The buffer's usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "1.2-extensions"},
    {"VUID-VkIndirectCommandsStreamNV-buffer-02975", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkIndirectCommandsStreamNV-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkIndirectCommandsStreamNV-offset-02943", "The offset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minIndirectCommandsBufferOffsetAlignment", "1.2-extensions"},
    {"VUID-VkInitializePerformanceApiInfoINTEL-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkInitializePerformanceApiInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL", "1.2-extensions"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-01964", "aspectMask must not include VK_IMAGE_ASPECT_METADATA_BIT", "1.2-extensions"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-02250", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.2-extensions"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.2-extensions"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-pApplicationInfo-parameter", "If pApplicationInfo is not NULL, pApplicationInfo must be a valid pointer to a valid VkApplicationInfo structure", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-pNext-04925", "If the pNext chain of VkInstanceCreateInfo includes a VkDebugReportCallbackCreateInfoEXT structure, the list of enabled extensions in ppEnabledExtensionNames must contain VK_EXT_debug_report.", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-pNext-04926", "If the pNext chain of VkInstanceCreateInfo includes a VkDebugUtilsMessengerCreateInfoEXT structure, the list of enabled extensions in ppEnabledExtensionNames must contain VK_EXT_debug_utils.", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDebugReportCallbackCreateInfoEXT, VkDebugUtilsMessengerCreateInfoEXT, VkValidationFeaturesEXT, or VkValidationFlagsEXT", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-ppEnabledExtensionNames-parameter", "If enabledExtensionCount is not 0, ppEnabledExtensionNames must be a valid pointer to an array of enabledExtensionCount null-terminated UTF-8 strings", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-ppEnabledLayerNames-parameter", "If enabledLayerCount is not 0, ppEnabledLayerNames must be a valid pointer to an array of enabledLayerCount null-terminated UTF-8 strings", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkInstanceCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkDebugUtilsMessengerCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-pView-01317", "If pView is an NSView object, it must be a valid NSView, must be backed by a CALayer object of type CAMetalLayer, and vkCreateMacOSSurfaceMVK must be called on the main thread.", "1.2-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-pView-04144", "If pView is a CAMetalLayer object, it must be a valid CAMetalLayer.", "1.2-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-sType-sType", "sType must be VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-memory-00684", "memory must be currently host mapped", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-offset-00687", "offset must be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-sType-sType", "sType must be VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-size-00685", "If size is not equal to VK_WHOLE_SIZE, offset and size must specify a range contained within the currently mapped range of memory", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-size-00686", "If size is equal to VK_WHOLE_SIZE, offset must be within the currently mapped range of memory", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-size-01389", "If size is equal to VK_WHOLE_SIZE, the end of the current mapping of memory must either be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize bytes from the beginning of the memory object, or be equal to the end of the memory object", "1.2-extensions"},
    {"VUID-VkMappedMemoryRange-size-01390", "If size is not equal to VK_WHOLE_SIZE, size must either be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize, or offset plus size must equal the size of memory", "1.2-extensions"},
    {"VUID-VkMemoryAllocateFlagsInfo-deviceMask-00675", "If VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT is set, deviceMask must be a valid device mask", "1.2-extensions"},
    {"VUID-VkMemoryAllocateFlagsInfo-deviceMask-00676", "If VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT is set, deviceMask must not be zero", "1.2-extensions"},
    {"VUID-VkMemoryAllocateFlagsInfo-flags-parameter", "flags must be a valid combination of VkMemoryAllocateFlagBits values", "1.2-extensions"},
    {"VUID-VkMemoryAllocateFlagsInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-None-00643", "If the parameters define an import operation and the external handle specified was created by the Vulkan API, the device mask specified by VkMemoryAllocateFlagsInfo must match that specified when the payload being imported was allocated.", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-None-00644", "If the parameters define an import operation and the external handle specified was created by the Vulkan API, the list of physical devices that comprise the logical device passed to vkAllocateMemory must match the list of physical devices that comprise the logical device on which the payload was originally allocated.", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-None-04749", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA, the value of memoryTypeIndex must be an index identifying a memory type from the memoryTypeBits field of the VkMemoryZirconHandlePropertiesFUCHSIA structure populated by a call to vkGetMemoryZirconHandlePropertiesFUCHSIA.", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-00638", "allocationSize must be greater than 0", "1.2-khr-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-00647", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, allocationSize must match the size specified when creating the Direct3D 12 heap from which the payload was extracted.", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01742", "If the parameters define an import operation, the external handle specified was created by the Vulkan API, and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR, then the values of allocationSize and memoryTypeIndex must match those specified when the payload being imported was created.", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01743", "If the parameters define an import operation, the external handle was created by the Vulkan API, and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR or VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR, then the values of allocationSize and memoryTypeIndex must match those specified when the payload being imported was created.", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01745", "If the parameters define an import operation and the external handle is a host pointer, allocationSize must be an integer multiple of VkPhysicalDeviceExternalMemoryHostPropertiesEXT::minImportedHostPointerAlignment", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-02383", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, allocationSize must be the size returned by vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-04750", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA, the value of allocationSize must be greater than 0 and must be less than or equal to the size of the VMO as determined by zx_vmo_get_size(handle) where handle is the VMO handle to the imported external memory.", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-flags-03330", "If VkMemoryAllocateFlagsInfo::flags includes VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the bufferDeviceAddressCaptureReplay feature must be enabled", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-flags-03331", "If VkMemoryAllocateFlagsInfo::flags includes VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT, the bufferDeviceAddress feature must be enabled", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-00645", "If the parameters define an import operation and the external handle is an NT handle or a global share handle created outside of the Vulkan API, the value of memoryTypeIndex must be one of those returned by vkGetMemoryWin32HandlePropertiesKHR", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-00648", "If the parameters define an import operation and the external handle is a POSIX file descriptor created outside of the Vulkan API, the value of memoryTypeIndex must be one of those returned by vkGetMemoryFdPropertiesKHR", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-01744", "If the parameters define an import operation and the external handle is a host pointer, the value of memoryTypeIndex must be one of those returned by vkGetMemoryHostPointerPropertiesEXT", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-01872", "If the protected memory feature is not enabled, the VkMemoryAllocateInfo::memoryTypeIndex must not indicate a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-02385", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, memoryTypeIndex must be one of those returned by vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-opaqueCaptureAddress-03329", "If VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress is not zero, VkMemoryAllocateFlagsInfo::flags must include VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-opaqueCaptureAddress-03333", "If the parameters define an import operation, VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress must be zero", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-00639", "If the pNext chain includes a VkExportMemoryAllocateInfo     structure, and any of the handle types specified in     VkExportMemoryAllocateInfo::handleTypes require a dedicated     allocation, as reported by     vkGetPhysicalDeviceImageFormatProperties2 in     VkExternalImageFormatProperties::externalMemoryProperties.externalMemoryFeatures     or     VkExternalBufferProperties::externalMemoryProperties.externalMemoryFeatures,     the pNext chain must include a ifdef::VK_KHR_dedicated_allocation[VkMemoryDedicatedAllocateInfo]", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-00640", "If the pNext chain includes a VkExportMemoryAllocateInfo structure, it must not include a VkExportMemoryAllocateInfoNV or VkExportMemoryWin32HandleInfoNV structure", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-00641", "If the pNext chain includes a VkImportMemoryWin32HandleInfoKHR structure, it must not include a VkImportMemoryWin32HandleInfoNV structure", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-01874", "If the parameters do not define an import operation, and the pNext chain includes a VkExportMemoryAllocateInfo structure with VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID included in its handleTypes member, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image not equal to VK_NULL_HANDLE, then allocationSize must be 0, otherwise allocationSize must be greater than 0", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02384", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, and the pNext chain does not include a VkMemoryDedicatedAllocateInfo structure or VkMemoryDedicatedAllocateInfo::image is VK_NULL_HANDLE, the Android hardware buffer must have a AHardwareBuffer_Desc::format of AHARDWAREBUFFER_FORMAT_BLOB and a AHardwareBuffer_Desc::usage that includes AHARDWAREBUFFER_USAGE_GPU_DATA_BUFFER", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02386", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo with image that is not VK_NULL_HANDLE, the Android hardware buffer's AHardwareBuffer::usage must include at least one of AHARDWAREBUFFER_USAGE_GPU_FRAMEBUFFER or AHARDWAREBUFFER_USAGE_GPU_SAMPLED_IMAGE", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02387", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo with image that is not VK_NULL_HANDLE, the format of image must be VK_FORMAT_UNDEFINED or the format returned by vkGetAndroidHardwareBufferPropertiesANDROID in VkAndroidHardwareBufferFormatPropertiesANDROID::format for the Android hardware buffer", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02388", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, the width, height, and array layer dimensions of image and the Android hardware buffer's AHardwareBuffer_Desc must be identical", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02389", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, and the Android hardware buffer's AHardwareBuffer::usage includes AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE, the image must have a complete mipmap chain", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02390", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, each bit set in the usage of image must be listed in AHardwareBuffer Usage Equivalence, and if there is a corresponding AHARDWAREBUFFER_USAGE bit listed that bit must be included in the Android hardware buffer's AHardwareBuffer_Desc::usage", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02586", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, and the Android hardware buffer's AHardwareBuffer::usage does not include AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE, the image must have exactly one mipmap level", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02805", "If the parameters define an import operation and the external handle is a host pointer, the pNext chain must not include a VkDedicatedAllocationMemoryAllocateInfoNV structure with either its image or buffer field set to a value other than VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02806", "If the parameters define an import operation and the external handle is a host pointer, the pNext chain must not include a VkMemoryDedicatedAllocateInfo structure with either its image or buffer field set to a value other than VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-03332", "If the pNext chain includes a VkImportMemoryHostPointerInfoEXT structure, VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress must be zero", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDedicatedAllocationMemoryAllocateInfoNV, VkExportMemoryAllocateInfo, VkExportMemoryAllocateInfoNV, VkExportMemoryWin32HandleInfoKHR, VkExportMemoryWin32HandleInfoNV, VkImportAndroidHardwareBufferInfoANDROID, VkImportMemoryFdInfoKHR, VkImportMemoryHostPointerInfoEXT, VkImportMemoryWin32HandleInfoKHR, VkImportMemoryWin32HandleInfoNV, VkImportMemoryZirconHandleInfoFUCHSIA, VkMemoryAllocateFlagsInfo, VkMemoryDedicatedAllocateInfo, VkMemoryOpaqueCaptureAddressAllocateInfo, or VkMemoryPriorityAllocateInfoEXT", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO", "1.2-extensions"},
    {"VUID-VkMemoryAllocateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkMemoryBarrier-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits values", "1.2-extensions"},
    {"VUID-VkMemoryBarrier-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_BARRIER", "1.2-extensions"},
    {"VUID-VkMemoryBarrier-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits values", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03900", "If pname:dstAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03901", "If pname:dstAccessMask includes VK_ACCESS_2_INDEX_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03902", "If pname:dstAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03903", "If pname:dstAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT_KHR, VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03904", "If pname:dstAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03905", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03906", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03907", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03908", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03909", "If pname:dstAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03910", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03911", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03912", "If pname:dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03913", "If pname:dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03914", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03915", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_CLEAR_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03916", "If pname:dstAccessMask includes VK_ACCESS_2_HOST_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03917", "If pname:dstAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03918", "If pname:dstAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03919", "If pname:dstAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03920", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03922", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03923", "If pname:dstAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03924", "If pname:dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03925", "If pname:dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03926", "If pname:dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03927", "If pname:dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-03928", "If pname:dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-04747", "If pname:dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, pname:dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-04858", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-04859", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-04860", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-04861", "If pname:dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, pname:dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-03929", "If the geometry shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-03930", "If the tessellation shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-03931", "If the conditional rendering feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-03932", "If the fragment density map feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-03933", "If the transform feedback feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-03934", "If the mesh shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-03935", "If the task shaders feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-04956", "If the shading rate image feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-04957", "If the subpass shading feature is not enabled, pname:dstStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03900", "If pname:srcAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03901", "If pname:srcAccessMask includes VK_ACCESS_2_INDEX_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03902", "If pname:srcAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03903", "If pname:srcAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT_KHR, VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03904", "If pname:srcAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03905", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03906", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03907", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03908", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03909", "If pname:srcAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03910", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03911", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03912", "If pname:srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03913", "If pname:srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03914", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03915", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_BLIT_BIT_KHR, VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR, VK_PIPELINE_STAGE_2_CLEAR_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03916", "If pname:srcAccessMask includes VK_ACCESS_2_HOST_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03917", "If pname:srcAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03918", "If pname:srcAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03919", "If pname:srcAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03920", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03922", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03923", "If pname:srcAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03924", "If pname:srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03925", "If pname:srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03926", "If pname:srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03927", "If pname:srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-03928", "If pname:srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-04747", "If pname:srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, pname:srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-04858", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-04859", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-04860", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-04861", "If pname:srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, pname:srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-03929", "If the geometry shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-03930", "If the tessellation shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-03931", "If the conditional rendering feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-03932", "If the fragment density map feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-03933", "If the transform feedback feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-03934", "If the mesh shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-03935", "If the task shaders feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-04956", "If the shading rate image feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-04957", "If the subpass shading feature is not enabled, pname:srcStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI", "1.2-extensions"},
    {"VUID-VkMemoryBarrier2KHR-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-01435", "If buffer is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the buffer", "1.2-khr-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-01436", "If buffer is not VK_NULL_HANDLE, buffer must have been created without VK_BUFFER_CREATE_SPARSE_BINDING_BIT set in VkBufferCreateInfo::flags", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-01877", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, and the external handle was created by the Vulkan API, then the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-01879", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT, the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-02965", "If buffer is not VK_NULL_HANDLE and the memory is not an imported Android Hardware Buffer, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the buffer", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-04752", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA, the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-commonparent", "Both of buffer, and image that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01432", "At least one of image and buffer must be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01433", "If image is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the image", "1.2-khr-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01434", "If image is not VK_NULL_HANDLE, image must have been created without VK_IMAGE_CREATE_SPARSE_BINDING_BIT set in VkImageCreateInfo::flags", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01797", "If image is not VK_NULL_HANDLE, image must not have been created with VK_IMAGE_CREATE_DISJOINT_BIT set in VkImageCreateInfo::flags", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01876", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, and the external handle was created by the Vulkan API, then the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01878", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT, the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-02964", "If image is not VK_NULL_HANDLE and the memory is not an imported Android Hardware Buffer, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the image", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-04751", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA, the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-parameter", "If image is not VK_NULL_HANDLE, image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO", "1.2-extensions"},
    {"VUID-VkMemoryDedicatedRequirements-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS", "1.2-extensions"},
    {"VUID-VkMemoryFdPropertiesKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryFdPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-handleTypes-01882", "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must have been included in VkExportMemoryAllocateInfo::handleTypes when memory was created", "1.2-extensions"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-pNext-01883", "If the pNext chain of the VkMemoryAllocateInfo used to allocate memory included a VkMemoryDedicatedAllocateInfo with non-NULL image member, then that image must already be bound to memory", "1.2-extensions"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID", "1.2-extensions"},
    {"VUID-VkMemoryGetFdInfoKHR-handleType-00671", "handleType must have been included in VkExportMemoryAllocateInfo::handleTypes when memory was created", "1.2-extensions"},
    {"VUID-VkMemoryGetFdInfoKHR-handleType-00672", "handleType must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT", "1.2-extensions"},
    {"VUID-VkMemoryGetFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkMemoryGetFdInfoKHR-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkMemoryGetFdInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryGetFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR", "1.2-extensions"},
    {"VUID-VkMemoryGetRemoteAddressInfoNV-handleType-04966", "handleType must have been included in VkExportMemoryAllocateInfo::handleTypes when memory was created", "1.2-extensions"},
    {"VUID-VkMemoryGetRemoteAddressInfoNV-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkMemoryGetRemoteAddressInfoNV-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkMemoryGetRemoteAddressInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryGetRemoteAddressInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV", "1.2-extensions"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00662", "handleType must have been included in VkExportMemoryAllocateInfo::handleTypes when memory was created", "1.2-extensions"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00663", "If handleType is defined as an NT handle, vkGetMemoryWin32HandleKHR must be called no more than once for each valid unique combination of memory and handleType", "1.2-extensions"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00664", "handleType must be defined as an NT handle or a global share handle", "1.2-extensions"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkMemoryGetZirconHandleInfoFUCHSIA-handleType-04775", "handleType must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA.", "1.2-extensions"},
    {"VUID-VkMemoryGetZirconHandleInfoFUCHSIA-handleType-04776", "handleType must have been included in the handleTypes field of the VkExportMemoryAllocateInfo structure when the external memory was allocated.", "1.2-extensions"},
    {"VUID-VkMemoryGetZirconHandleInfoFUCHSIA-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkMemoryGetZirconHandleInfoFUCHSIA-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkMemoryGetZirconHandleInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryGetZirconHandleInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA", "1.2-extensions"},
    {"VUID-VkMemoryHostPointerPropertiesEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryHostPointerPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkMemoryOpaqueCaptureAddressAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO", "1.2-extensions"},
    {"VUID-VkMemoryPriorityAllocateInfoEXT-priority-02602", "priority must be between 0 and 1, inclusive", "1.2-extensions"},
    {"VUID-VkMemoryPriorityAllocateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkMemoryRequirements2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkMemoryDedicatedRequirements", "1.2-extensions"},
    {"VUID-VkMemoryRequirements2-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2", "1.2-extensions"},
    {"VUID-VkMemoryRequirements2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkMemoryWin32HandlePropertiesKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryWin32HandlePropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkMemoryZirconHandlePropertiesFUCHSIA-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMemoryZirconHandlePropertiesFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA", "1.2-extensions"},
    {"VUID-VkMetalSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkMetalSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMetalSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkMultisamplePropertiesEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkMultisamplePropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeCreateInfoVALVE-pMutableDescriptorTypeLists-parameter", "If mutableDescriptorTypeListCount is not 0, pMutableDescriptorTypeLists must be a valid pointer to an array of mutableDescriptorTypeListCount valid VkMutableDescriptorTypeListVALVE structures", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeCreateInfoVALVE-sType-sType", "sType must be VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeListVALVE-descriptorTypeCount-04597", "descriptorTypeCount must not be 0 if the corresponding binding is of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeListVALVE-descriptorTypeCount-04599", "descriptorTypeCount must be 0 if the corresponding binding is not of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeListVALVE-pDescriptorTypes-04598", "pDescriptorTypes must be a valid pointer to an array of descriptorTypeCount valid, unique VkDescriptorType values if the given binding is of VK_DESCRIPTOR_TYPE_MUTABLE_VALVE type", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeListVALVE-pDescriptorTypes-04600", "pDescriptorTypes must not contain VK_DESCRIPTOR_TYPE_MUTABLE_VALVE", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeListVALVE-pDescriptorTypes-04601", "pDescriptorTypes must not contain VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeListVALVE-pDescriptorTypes-04602", "pDescriptorTypes must not contain VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeListVALVE-pDescriptorTypes-04603", "pDescriptorTypes must not contain VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT", "1.2-extensions"},
    {"VUID-VkMutableDescriptorTypeListVALVE-pDescriptorTypes-parameter", "If descriptorTypeCount is not 0, pDescriptorTypes must be a valid pointer to an array of descriptorTypeCount valid VkDescriptorType values", "1.2-extensions"},
    {"VUID-VkPerformanceConfigurationAcquireInfoINTEL-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPerformanceConfigurationAcquireInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL", "1.2-extensions"},
    {"VUID-VkPerformanceConfigurationAcquireInfoINTEL-type-parameter", "type must be a valid VkPerformanceConfigurationTypeINTEL value", "1.2-extensions"},
    {"VUID-VkPerformanceCounterDescriptionKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPerformanceCounterDescriptionKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR", "1.2-extensions"},
    {"VUID-VkPerformanceCounterKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPerformanceCounterKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR", "1.2-extensions"},
    {"VUID-VkPerformanceMarkerInfoINTEL-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPerformanceMarkerInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL", "1.2-extensions"},
    {"VUID-VkPerformanceOverrideInfoINTEL-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPerformanceOverrideInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL", "1.2-extensions"},
    {"VUID-VkPerformanceOverrideInfoINTEL-type-parameter", "type must be a valid VkPerformanceOverrideTypeINTEL value", "1.2-extensions"},
    {"VUID-VkPerformanceQuerySubmitInfoKHR-counterPassIndex-03221", "counterPassIndex must be less than the number of counter passes required by any queries within the batch. The required number of counter passes for a performance query is obtained by calling vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR", "1.2-extensions"},
    {"VUID-VkPerformanceQuerySubmitInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkPerformanceStreamMarkerInfoINTEL-marker-02735", "The value written by the application into marker must only used the valid bits as reported by vkGetPerformanceParameterINTEL with the VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL", "1.2-extensions"},
    {"VUID-VkPerformanceStreamMarkerInfoINTEL-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPerformanceStreamMarkerInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL", "1.2-extensions"},
    {"VUID-VkPerformanceValueINTEL-type-parameter", "type must be a valid VkPerformanceValueTypeINTEL value", "1.2-extensions"},
    {"VUID-VkPerformanceValueINTEL-valueString-parameter", "If type is VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL, the valueString member of data must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkPhysicalDevice16BitStorageFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDevice4444FormatsFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDevice8BitStorageFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceASTCDecodeFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceAccelerationStructureFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceAccelerationStructurePropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceBufferDeviceAddressFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceCoherentMemoryFeaturesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceColorWriteEnableFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceConditionalRenderingFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceConservativeRasterizationPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceCooperativeMatrixFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceCooperativeMatrixPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceCornerSampledImageFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceCoverageReductionModeFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceCustomBorderColorFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceCustomBorderColorPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDepthClipEnableFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDepthStencilResolveProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDescriptorIndexingFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDescriptorIndexingProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDeviceMemoryReportFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDiagnosticsConfigFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDiscardRectanglePropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDriverProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceDrmPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExclusiveScissorFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExtendedDynamicState2FeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExtendedDynamicStateFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-flags-parameter", "flags must be a valid combination of VkBufferCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-usage-parameter", "usage must be a valid combination of VkBufferUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-usage-requiredbitmask", "usage must not be 0", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalFenceInfo-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalFenceInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalFenceInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalImageFormatInfo-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalImageFormatInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalMemoryHostPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalMemoryRDMAFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalSemaphoreInfo-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalSemaphoreInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkSemaphoreTypeCreateInfo", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalSemaphoreInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceExternalSemaphoreInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFeatures2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFloatControlsProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentDensityMap2FeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentDensityMapFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentDensityMapPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-maxFragmentShadingRateInvocationCount-parameter", "maxFragmentShadingRateInvocationCount must be a valid VkSampleCountFlagBits value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShadingRateFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShadingRateKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShadingRateKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceFragmentShadingRatePropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceGroupProperties-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceGroupProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceHostQueryResetFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceIDProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02314", "If sharingMode is VK_SHARING_MODE_CONCURRENT, then pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02315", "If sharingMode is VK_SHARING_MODE_CONCURRENT, then queueFamilyIndexCount must be greater than 1", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02316", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than the pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, VkPhysicalDeviceExternalImageFormatInfo, VkPhysicalDeviceImageDrmFormatModifierInfoEXT, or VkPhysicalDeviceImageViewImageFormatInfoEXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-tiling-02249", "tiling must be VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT if and only if the pNext chain includes VkPhysicalDeviceImageDrmFormatModifierInfoEXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-tiling-02313", "If tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT and flags contains VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, then the pNext chain must include a VkImageFormatListCreateInfo structure with non-zero viewFormatCount", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-tiling-parameter", "tiling must be a valid VkImageTiling value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-type-parameter", "type must be a valid VkImageType value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-usage-requiredbitmask", "usage must not be 0", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageRobustnessFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-imageViewType-parameter", "imageViewType must be a valid VkImageViewType value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceImagelessFramebufferFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceIndexTypeUint8FeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceInheritedViewportScissorFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceInlineUniformBlockFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceInlineUniformBlockPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceLineRasterizationFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceLineRasterizationPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMaintenance3Properties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMemoryBudgetPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMemoryPriorityFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMemoryProperties2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPhysicalDeviceMemoryBudgetPropertiesEXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMemoryProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMemoryProperties2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMeshShaderFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMeshShaderPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMultiDrawFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMultiDrawPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMultiviewFeatures-multiviewGeometryShader-00580", "If multiviewGeometryShader is enabled then multiview must also be enabled", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMultiviewFeatures-multiviewTessellationShader-00581", "If multiviewTessellationShader is enabled then multiview must also be enabled", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMultiviewFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMultiviewProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePCIBusInfoPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePerformanceQueryFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePerformanceQueryPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePointClippingProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePortabilitySubsetFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePortabilitySubsetPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePrivateDataFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPhysicalDeviceAccelerationStructurePropertiesKHR, VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, VkPhysicalDeviceConservativeRasterizationPropertiesEXT, VkPhysicalDeviceCooperativeMatrixPropertiesNV, VkPhysicalDeviceCustomBorderColorPropertiesEXT, VkPhysicalDeviceDepthStencilResolveProperties, VkPhysicalDeviceDescriptorIndexingProperties, VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, VkPhysicalDeviceDiscardRectanglePropertiesEXT, VkPhysicalDeviceDriverProperties, VkPhysicalDeviceDrmPropertiesEXT, VkPhysicalDeviceExternalMemoryHostPropertiesEXT, VkPhysicalDeviceFloatControlsProperties, VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, VkPhysicalDeviceFragmentDensityMapPropertiesEXT, VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV, VkPhysicalDeviceFragmentShadingRatePropertiesKHR, VkPhysicalDeviceIDProperties, VkPhysicalDeviceInlineUniformBlockPropertiesEXT, VkPhysicalDeviceLineRasterizationPropertiesEXT, VkPhysicalDeviceMaintenance3Properties, VkPhysicalDeviceMeshShaderPropertiesNV, VkPhysicalDeviceMultiDrawPropertiesEXT, VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX, VkPhysicalDeviceMultiviewProperties, VkPhysicalDevicePCIBusInfoPropertiesEXT, VkPhysicalDevicePerformanceQueryPropertiesKHR, VkPhysicalDevicePointClippingProperties, VkPhysicalDevicePortabilitySubsetPropertiesKHR, VkPhysicalDeviceProtectedMemoryProperties, VkPhysicalDeviceProvokingVertexPropertiesEXT, VkPhysicalDevicePushDescriptorPropertiesKHR, VkPhysicalDeviceRayTracingPipelinePropertiesKHR, VkPhysicalDeviceRayTracingPropertiesNV, VkPhysicalDeviceRobustness2PropertiesEXT, VkPhysicalDeviceSampleLocationsPropertiesEXT, VkPhysicalDeviceSamplerFilterMinmaxProperties, VkPhysicalDeviceShaderCoreProperties2AMD, VkPhysicalDeviceShaderCorePropertiesAMD, VkPhysicalDeviceShaderSMBuiltinsPropertiesNV, VkPhysicalDeviceShadingRateImagePropertiesNV, VkPhysicalDeviceSubgroupProperties, VkPhysicalDeviceSubgroupSizeControlPropertiesEXT, VkPhysicalDeviceSubpassShadingPropertiesHUAWEI, VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT, VkPhysicalDeviceTimelineSemaphoreProperties, VkPhysicalDeviceTransformFeedbackPropertiesEXT, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT, VkPhysicalDeviceVulkan11Properties, or VkPhysicalDeviceVulkan12Properties", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceProperties2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceProtectedMemoryFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceProtectedMemoryProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceProvokingVertexFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceProvokingVertexPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDevicePushDescriptorPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRayQueryFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRayTracingMotionBlurFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRayTracingPipelineFeaturesKHR-rayTracingPipelineShaderGroupHandleCaptureReplayMixed-03575", "If rayTracingPipelineShaderGroupHandleCaptureReplayMixed is VK_TRUE, rayTracingPipelineShaderGroupHandleCaptureReplay must also be VK_TRUE", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRayTracingPipelineFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRayTracingPipelinePropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRayTracingPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRobustness2FeaturesEXT-robustBufferAccess2-04000", "If robustBufferAccess2 is enabled then robustBufferAccess must also be enabled", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRobustness2FeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceRobustness2PropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSampleLocationsPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSamplerFilterMinmaxProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSamplerYcbcrConversionFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceScalarBlockLayoutFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderAtomicInt64Features-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderClockFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderCoreProperties2AMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderCorePropertiesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderDrawParametersFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderFloat16Int8Features-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderImageFootprintFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderSMBuiltinsFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShadingRateImageFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceShadingRateImagePropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-01095", "samples must be a bit value that is set in VkImageFormatProperties::sampleCounts returned by vkGetPhysicalDeviceImageFormatProperties with format, type, tiling, and usage equal to those in this command and flags equal to the value that is set in VkImageCreateInfo::flags when the image is created", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-tiling-parameter", "tiling must be a valid VkImageTiling value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-type-parameter", "type must be a valid VkImageType value", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-requiredbitmask", "usage must not be 0", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSubgroupProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSubgroupSizeControlFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSubpassShadingFeaturesHUAWEI-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSubpassShadingPropertiesHUAWEI-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-pNext-02672", "If the pNext chain includes a VkSurfaceFullScreenExclusiveInfoEXT structure with its fullScreenExclusive member set to VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT, and surface was created using vkCreateWin32SurfaceKHR, a VkSurfaceFullScreenExclusiveWin32InfoEXT structure must be included in the pNext chain", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkSurfaceFullScreenExclusiveInfoEXT or VkSurfaceFullScreenExclusiveWin32InfoEXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-surface-parameter", "surface must be a valid VkSurfaceKHR handle", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceSynchronization2FeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceTimelineSemaphoreFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceTimelineSemaphoreProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceToolPropertiesEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceToolPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceTransformFeedbackFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceTransformFeedbackPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceUniformBufferStandardLayoutFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVariablePointersFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVariablePointersFeatures-variablePointers-01431", "If variablePointers is enabled then variablePointersStorageBuffer must also be enabled", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVideoFormatInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVideoFormatInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVulkan11Features-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVulkan11Properties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVulkan12Features-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceVulkanMemoryModelFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceYcbcrImageArraysFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR", "1.2-extensions"},
    {"VUID-VkPipelineCacheCreateInfo-flags-parameter", "flags must be a valid combination of VkPipelineCacheCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkPipelineCacheCreateInfo-initialDataSize-00768", "If initialDataSize is not 0, it must be equal to the size of pInitialData, as returned by vkGetPipelineCacheData when pInitialData was originally retrieved", "1.2-extensions"},
    {"VUID-VkPipelineCacheCreateInfo-initialDataSize-00769", "If initialDataSize is not 0, pInitialData must have been retrieved from a previous call to vkGetPipelineCacheData", "1.2-extensions"},
    {"VUID-VkPipelineCacheCreateInfo-pInitialData-parameter", "If initialDataSize is not 0, pInitialData must be a valid pointer to an array of initialDataSize bytes", "1.2-extensions"},
    {"VUID-VkPipelineCacheCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineCacheCreateInfo-pipelineCreationCacheControl-02892", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT_EXT", "1.2-extensions"},
    {"VUID-VkPipelineCacheCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineCacheHeaderVersionOne-headerSize-04967", "headerSize must be 32", "1.2-extensions"},
    {"VUID-VkPipelineCacheHeaderVersionOne-headerVersion-04968", "headerVersion must be VK_PIPELINE_CACHE_HEADER_VERSION_ONE", "1.2-extensions"},
    {"VUID-VkPipelineCacheHeaderVersionOne-headerVersion-parameter", "headerVersion must be a valid VkPipelineCacheHeaderVersion value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap-01426", "If the correlated overlap property is not supported, blendOverlap must be VK_BLEND_OVERLAP_UNCORRELATED_EXT", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap-parameter", "blendOverlap must be a valid VkBlendOverlapEXT value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-dstPremultiplied-01425", "If the non-premultiplied destination color property is not supported, dstPremultiplied must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-srcPremultiplied-01424", "If the non-premultiplied source color property is not supported, srcPremultiplied must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-advancedBlendAllOperations-01409", "If VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::advancedBlendAllOperations is VK_FALSE, then colorBlendOp must not be VK_BLEND_OP_ZERO_EXT, VK_BLEND_OP_SRC_EXT, VK_BLEND_OP_DST_EXT, VK_BLEND_OP_SRC_OVER_EXT, VK_BLEND_OP_DST_OVER_EXT, VK_BLEND_OP_SRC_IN_EXT, VK_BLEND_OP_DST_IN_EXT, VK_BLEND_OP_SRC_OUT_EXT, VK_BLEND_OP_DST_OUT_EXT, VK_BLEND_OP_SRC_ATOP_EXT, VK_BLEND_OP_DST_ATOP_EXT, VK_BLEND_OP_XOR_EXT, VK_BLEND_OP_INVERT_EXT, VK_BLEND_OP_INVERT_RGB_EXT, VK_BLEND_OP_LINEARDODGE_EXT, VK_BLEND_OP_LINEARBURN_EXT, VK_BLEND_OP_VIVIDLIGHT_EXT, VK_BLEND_OP_LINEARLIGHT_EXT, VK_BLEND_OP_PINLIGHT_EXT, VK_BLEND_OP_HARDMIX_EXT, VK_BLEND_OP_PLUS_EXT, VK_BLEND_OP_PLUS_CLAMPED_EXT, VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT, VK_BLEND_OP_PLUS_DARKER_EXT, VK_BLEND_OP_MINUS_EXT, VK_BLEND_OP_MINUS_CLAMPED_EXT, VK_BLEND_OP_CONTRAST_EXT, VK_BLEND_OP_INVERT_OVG_EXT, VK_BLEND_OP_RED_EXT, VK_BLEND_OP_GREEN_EXT, or VK_BLEND_OP_BLUE_EXT", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-advancedBlendIndependentBlend-01407", "If VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::advancedBlendIndependentBlend is VK_FALSE and colorBlendOp is an advanced blend operation, then colorBlendOp must be the same for all attachments", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-advancedBlendIndependentBlend-01408", "If VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::advancedBlendIndependentBlend is VK_FALSE and alphaBlendOp is an advanced blend operation, then alphaBlendOp must be the same for all attachments", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-alphaBlendOp-parameter", "alphaBlendOp must be a valid VkBlendOp value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-01406", "If either of colorBlendOp or alphaBlendOp is an advanced blend operation, then colorBlendOp must equal alphaBlendOp", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-01410", "If colorBlendOp or alphaBlendOp is an advanced blend operation, then colorAttachmentCount of the subpass this pipeline is compiled against must be less than or equal to VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::advancedBlendMaxColorAttachments", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-parameter", "colorBlendOp must be a valid VkBlendOp value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-colorWriteMask-parameter", "colorWriteMask must be a valid combination of VkColorComponentFlagBits values", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-constantAlphaColorBlendFactors-04454", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::constantAlphaColorBlendFactors is VK_FALSE, srcColorBlendFactor must not be VK_BLEND_FACTOR_CONSTANT_ALPHA or VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA.", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-constantAlphaColorBlendFactors-04455", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::constantAlphaColorBlendFactors is VK_FALSE, dstColorBlendFactor must not be VK_BLEND_FACTOR_CONSTANT_ALPHA or VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA.", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-dstAlphaBlendFactor-00611", "If the dual source blending feature is not enabled, dstAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-dstAlphaBlendFactor-parameter", "dstAlphaBlendFactor must be a valid VkBlendFactor value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-dstColorBlendFactor-00609", "If the dual source blending feature is not enabled, dstColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-dstColorBlendFactor-parameter", "dstColorBlendFactor must be a valid VkBlendFactor value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-srcAlphaBlendFactor-00610", "If the dual source blending feature is not enabled, srcAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-srcAlphaBlendFactor-parameter", "srcAlphaBlendFactor must be a valid VkBlendFactor value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-srcColorBlendFactor-00608", "If the dual source blending feature is not enabled, srcColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendAttachmentState-srcColorBlendFactor-parameter", "srcColorBlendFactor must be a valid VkBlendFactor value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-logicOpEnable-00606", "If the logic operations feature is not enabled, logicOpEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-logicOpEnable-00607", "If logicOpEnable is VK_TRUE, logicOp must be a valid VkLogicOp value", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-pAttachments-00605", "If the independent blending feature is not enabled, all elements of pAttachments must be identical", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-pAttachments-parameter", "If attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkPipelineColorBlendAttachmentState structures", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineColorBlendAdvancedStateCreateInfoEXT or VkPipelineColorWriteCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPipelineColorWriteCreateInfoEXT-attachmentCount-04802", "attachmentCount must be equal to the attachmentCount member of the VkPipelineColorBlendStateCreateInfo structure specified during pipeline creation", "1.2-extensions"},
    {"VUID-VkPipelineColorWriteCreateInfoEXT-pAttachments-04801", "If the colorWriteEnable feature is not enabled, all elements of pColorWriteEnables must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkPipelineColorWriteCreateInfoEXT-pColorWriteEnables-parameter", "If attachmentCount is not 0, pColorWriteEnables must be a valid pointer to an array of attachmentCount VkBool32 values", "1.2-extensions"},
    {"VUID-VkPipelineColorWriteCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineCompilerControlCreateInfoAMD-compilerControlFlags-zerobitmask", "compilerControlFlags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineCompilerControlCreateInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD", "1.2-extensions"},
    {"VUID-VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationMode-parameter", "coverageModulationMode must be a valid VkCoverageModulationModeNV value", "1.2-extensions"},
    {"VUID-VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationTableEnable-01405", "If coverageModulationTableEnable is VK_TRUE, coverageModulationTableCount must be equal to the number of rasterization samples divided by the number of color samples in the subpass", "1.2-extensions"},
    {"VUID-VkPipelineCoverageModulationStateCreateInfoNV-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineCoverageModulationStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineCoverageReductionStateCreateInfoNV-coverageReductionMode-parameter", "coverageReductionMode must be a valid VkCoverageReductionModeNV value", "1.2-extensions"},
    {"VUID-VkPipelineCoverageReductionStateCreateInfoNV-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineCoverageReductionStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineCoverageToColorStateCreateInfoNV-coverageToColorEnable-01404", "If coverageToColorEnable is VK_TRUE, then the render pass subpass indicated by VkGraphicsPipelineCreateInfo::renderPass and VkGraphicsPipelineCreateInfo::subpass must have a color attachment at the location selected by coverageToColorLocation, with a VkFormat of VK_FORMAT_R8_UINT, VK_FORMAT_R8_SINT, VK_FORMAT_R16_UINT, VK_FORMAT_R16_SINT, VK_FORMAT_R32_UINT, or VK_FORMAT_R32_SINT", "1.2-extensions"},
    {"VUID-VkPipelineCoverageToColorStateCreateInfoNV-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineCoverageToColorStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pPipelineCreationFeedback-parameter", "pPipelineCreationFeedback must be a valid pointer to a VkPipelineCreationFeedbackEXT structure", "1.2-extensions"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pPipelineStageCreationFeedbacks-parameter", "pPipelineStageCreationFeedbacks must be a valid pointer to an array of pipelineStageCreationFeedbackCount VkPipelineCreationFeedbackEXT structures", "1.2-extensions"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02668", "When chained to VkGraphicsPipelineCreateInfo, VkPipelineCreationFeedbackEXT::pipelineStageCreationFeedbackCount must equal VkGraphicsPipelineCreateInfo::stageCount", "1.2-extensions"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02669", "When chained to VkComputePipelineCreateInfo, VkPipelineCreationFeedbackEXT::pipelineStageCreationFeedbackCount must equal 1", "1.2-extensions"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02670", "When chained to VkRayTracingPipelineCreateInfoKHR, VkPipelineCreationFeedbackEXT::pipelineStageCreationFeedbackCount must equal VkRayTracingPipelineCreateInfoKHR::stageCount", "1.2-extensions"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02969", "When chained to VkRayTracingPipelineCreateInfoNV, VkPipelineCreationFeedbackEXT::pipelineStageCreationFeedbackCount must equal VkRayTracingPipelineCreateInfoNV::stageCount", "1.2-extensions"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-arraylength", "pipelineStageCreationFeedbackCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-back-parameter", "back must be a valid VkStencilOpState structure", "1.2-extensions"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-depthBoundsTestEnable-00598", "If the depth bounds testing feature is not enabled, depthBoundsTestEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-depthCompareOp-parameter", "depthCompareOp must be a valid VkCompareOp value", "1.2-extensions"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-front-parameter", "front must be a valid VkStencilOpState structure", "1.2-extensions"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-separateStencilMaskRef-04453", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::separateStencilMaskRef is VK_FALSE, and the value of VkPipelineDepthStencilStateCreateInfo::stencilTestEnable is VK_TRUE, and the value of VkPipelineRasterizationStateCreateInfo::cullMode is VK_CULL_MODE_NONE, the value of reference in each of the VkStencilOpState structs in front and back must be the same.", "1.2-extensions"},
    {"VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleCount-00582", "discardRectangleCount must be less than or equal to VkPhysicalDeviceDiscardRectanglePropertiesEXT::maxDiscardRectangles", "1.2-extensions"},
    {"VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleMode-parameter", "discardRectangleMode must be a valid VkDiscardRectangleModeEXT value", "1.2-extensions"},
    {"VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineDynamicStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineDynamicStateCreateInfo-pDynamicStates-01442", "Each element of pDynamicStates must be unique", "1.2-extensions"},
    {"VUID-VkPipelineDynamicStateCreateInfo-pDynamicStates-parameter", "If dynamicStateCount is not 0, pDynamicStates must be a valid pointer to an array of dynamicStateCount valid VkDynamicState values", "1.2-extensions"},
    {"VUID-VkPipelineDynamicStateCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineDynamicStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineExecutableInfoKHR-executableIndex-03275", "executableIndex must be less than the number of pipeline executables associated with pipeline as returned in the pExecutableCount parameter of vkGetPipelineExecutablePropertiesKHR", "1.2-extensions"},
    {"VUID-VkPipelineExecutableInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineExecutableInfoKHR-pipeline-parameter", "pipeline must be a valid VkPipeline handle", "1.2-extensions"},
    {"VUID-VkPipelineExecutableInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkPipelineExecutableInternalRepresentationKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineExecutableInternalRepresentationKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR", "1.2-extensions"},
    {"VUID-VkPipelineExecutablePropertiesKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineExecutablePropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkPipelineExecutableStatisticKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineExecutableStatisticKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR", "1.2-extensions"},
    {"VUID-VkPipelineFragmentShadingRateEnumStateCreateInfoNV-combinerOps-parameter", "Any given element of combinerOps must be a valid VkFragmentShadingRateCombinerOpKHR value", "1.2-extensions"},
    {"VUID-VkPipelineFragmentShadingRateEnumStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineFragmentShadingRateEnumStateCreateInfoNV-shadingRate-parameter", "shadingRate must be a valid VkFragmentShadingRateNV value", "1.2-extensions"},
    {"VUID-VkPipelineFragmentShadingRateEnumStateCreateInfoNV-shadingRateType-parameter", "shadingRateType must be a valid VkFragmentShadingRateTypeNV value", "1.2-extensions"},
    {"VUID-VkPipelineFragmentShadingRateStateCreateInfoKHR-combinerOps-parameter", "Any given element of combinerOps must be a valid VkFragmentShadingRateCombinerOpKHR value", "1.2-extensions"},
    {"VUID-VkPipelineFragmentShadingRateStateCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkPipelineInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineInfoKHR-pipeline-parameter", "pipeline must be a valid VkPipeline handle", "1.2-extensions"},
    {"VUID-VkPipelineInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00428", "If topology is VK_PRIMITIVE_TOPOLOGY_POINT_LIST, VK_PRIMITIVE_TOPOLOGY_LINE_LIST, VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST, VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY, VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY or VK_PRIMITIVE_TOPOLOGY_PATCH_LIST, primitiveRestartEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00429", "If the geometry shaders feature is not enabled, topology must not be any of VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY, VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY, VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY or VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY", "1.2-extensions"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00430", "If the tessellation shaders feature is not enabled, topology must not be VK_PRIMITIVE_TOPOLOGY_PATCH_LIST", "1.2-extensions"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-topology-parameter", "topology must be a valid VkPrimitiveTopology value", "1.2-extensions"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-triangleFans-04452", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::triangleFans is VK_FALSE, topology must not be VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN.", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02212", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxPerStageDescriptorInlineUniformBlocks", "default"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02213", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxDescriptorSetInlineUniformBlocks", "default"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02214", "The total number of bindings in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxPerStageDescriptorInlineUniformBlocks", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02215", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02216", "The total number of bindings in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxDescriptorSetInlineUniformBlocks", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02217", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxDescriptorSetUpdateAfterBindInlineUniformBlocks", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02381", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxDescriptorSetAccelerationStructures", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03016", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorSamplers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03017", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER and VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorUniformBuffers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03018", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_BUFFER and VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorStorageBuffers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03019", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorSampledImages", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03020", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorStorageImages", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03021", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorInputAttachments", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03022", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindSamplers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03023", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER and VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindUniformBuffers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03024", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_BUFFER and VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindStorageBuffers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03025", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindSampledImages", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03026", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindStorageImages", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03027", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindInputAttachments", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03028", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetSamplers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03029", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03030", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffersDynamic", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03031", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03032", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffersDynamic", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03033", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetSampledImages", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03034", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageImages", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03035", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetInputAttachments", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03571", "The total number of bindings in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPerStageDescriptorAccelerationStructures", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03572", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPerStageDescriptorUpdateAfterBindAccelerationStructures", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03573", "The total number of bindings in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxDescriptorSetAccelerationStructures", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03574", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxDescriptorSetUpdateAfterBindAccelerationStructures", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pImmutableSamplers-03566", "The total number of pImmutableSamplers created with flags containing VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT or VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceFragmentDensityMap2PropertiesEXT::maxDescriptorSetSubsampledSamplers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-00292", "Any two elements of pPushConstantRanges must not include the same stage in stageFlags", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-parameter", "If pushConstantRangeCount is not 0, pPushConstantRanges must be a valid pointer to an array of pushConstantRangeCount valid VkPushConstantRange structures", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00287", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorSamplers", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00288", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER and VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorUniformBuffers", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00289", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER and VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorStorageBuffers", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00290", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorSampledImages", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00291", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorStorageImages", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00293", "pSetLayouts must not contain more than one descriptor set layout that was created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR set", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01676", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorInputAttachments", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01677", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetSamplers", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01678", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffers", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01679", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffersDynamic", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01680", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffers", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01681", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffersDynamic", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01682", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetSampledImages", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01683", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageImages", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01684", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetInputAttachments", "1.1-khr-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03036", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindSamplers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03037", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindUniformBuffers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03038", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindUniformBuffersDynamic", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03039", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindStorageBuffers", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03040", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindStorageBuffersDynamic", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03041", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindSampledImages", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03042", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindStorageImages", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03043", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindInputAttachments", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-04606", "Any element of pSetLayouts must not have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE bit set", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-parameter", "If setLayoutCount is not 0, pSetLayouts must be a valid pointer to an array of setLayoutCount valid VkDescriptorSetLayout handles", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineLayoutCreateInfo-setLayoutCount-00286", "setLayoutCount must be less than or equal to VkPhysicalDeviceLimits::maxBoundDescriptorSets", "1.2-extensions"},
    {"VUID-VkPipelineLibraryCreateInfoKHR-pLibraries-03381", "Each element of pLibraries must have been created with VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkPipelineLibraryCreateInfoKHR-pLibraries-parameter", "If libraryCount is not 0, pLibraries must be a valid pointer to an array of libraryCount valid VkPipeline handles", "1.2-extensions"},
    {"VUID-VkPipelineLibraryCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPipelineLibraryCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-alphaToOneEnable-00785", "If the alpha to one feature is not enabled, alphaToOneEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-minSampleShading-00786", "minSampleShading must be in the range [0,1]", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineCoverageModulationStateCreateInfoNV, VkPipelineCoverageReductionStateCreateInfoNV, VkPipelineCoverageToColorStateCreateInfoNV, or VkPipelineSampleLocationsStateCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-pSampleMask-parameter", "If pSampleMask is not NULL, pSampleMask must be a valid pointer to an array of (rasterizationSamples/32) VkSampleMask values", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-rasterizationSamples-01415", "If the VK_NV_framebuffer_mixed_samples extension is enabled, and if the subpass has any color attachments and rasterizationSamples is greater than the number of color samples, then sampleShadingEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-rasterizationSamples-parameter", "rasterizationSamples must be a valid VkSampleCountFlagBits value", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-sampleShadingEnable-00784", "If the sample rate shading feature is not enabled, sampleShadingEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-conservativeRasterizationMode-parameter", "conservativeRasterizationMode must be a valid VkConservativeRasterizationModeEXT value", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-extraPrimitiveOverestimationSize-01769", "extraPrimitiveOverestimationSize must be in the range of 0.0 to VkPhysicalDeviceConservativeRasterizationPropertiesEXT::maxExtraPrimitiveOverestimationSize inclusive", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02768", "If lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT, then the rectangularLines feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02769", "If lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT, then the bresenhamLines feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02770", "If lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT, then the smoothLines feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-parameter", "lineRasterizationMode must be a valid VkLineRasterizationModeEXT value", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02771", "If stippledLineEnable is VK_TRUE and lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT, then the stippledRectangularLines feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02772", "If stippledLineEnable is VK_TRUE and lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT, then the stippledBresenhamLines feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02773", "If stippledLineEnable is VK_TRUE and lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT, then the stippledSmoothLines feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02774", "If stippledLineEnable is VK_TRUE and lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_DEFAULT_EXT, then the stippledRectangularLines feature must be enabled and VkPhysicalDeviceLimits::strictLines must be VK_TRUE", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-provokingVertexMode-04883", "If provokingVertexMode is VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT, then the provokingVertexLast feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-provokingVertexMode-parameter", "provokingVertexMode must be a valid VkProvokingVertexModeEXT value", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-cullMode-parameter", "cullMode must be a valid combination of VkCullModeFlagBits values", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-depthClampEnable-00782", "If the depth clamping feature is not enabled, depthClampEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-frontFace-parameter", "frontFace must be a valid VkFrontFace value", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineRasterizationConservativeStateCreateInfoEXT, VkPipelineRasterizationDepthClipStateCreateInfoEXT, VkPipelineRasterizationLineStateCreateInfoEXT, VkPipelineRasterizationProvokingVertexStateCreateInfoEXT, VkPipelineRasterizationStateRasterizationOrderAMD, or VkPipelineRasterizationStateStreamCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-pointPolygons-04458", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::pointPolygons is VK_FALSE, and rasterizerDiscardEnable is VK_FALSE, polygonMode must not be VK_POLYGON_MODE_POINT.", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01413", "If the non-solid fill modes feature is not enabled, polygonMode must be VK_POLYGON_MODE_FILL", "1.2-khr-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01414", "If the VK_NV_fill_rectangle extension is not enabled, polygonMode must not be VK_POLYGON_MODE_FILL_RECTANGLE_NV", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01507", "If the non-solid fill modes feature is not enabled, polygonMode must be VK_POLYGON_MODE_FILL or VK_POLYGON_MODE_FILL_RECTANGLE_NV", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-parameter", "polygonMode must be a valid VkPolygonMode value", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateRasterizationOrderAMD-rasterizationOrder-parameter", "rasterizationOrder must be a valid VkRasterizationOrderAMD value", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateRasterizationOrderAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-geometryStreams-02324", "VkPhysicalDeviceTransformFeedbackFeaturesEXT::geometryStreams must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-rasterizationStream-02325", "rasterizationStream must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-rasterizationStream-02326", "rasterizationStream must be zero if VkPhysicalDeviceTransformFeedbackPropertiesEXT::transformFeedbackRasterizationStreamSelect is VK_FALSE", "1.2-extensions"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineRepresentativeFragmentTestStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineSampleLocationsStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineSampleLocationsStateCreateInfoEXT-sampleLocationsInfo-parameter", "sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-02758", "If flags has both the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT and VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT flags set, the local workgroup size in the X dimension of the pipeline must be a multiple of maxSubgroupSize", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-02759", "If flags has the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT flag set and flags does not have the VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT flag set and no VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain, the local workgroup size in the X dimension of the pipeline must be a multiple of subgroupSize", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-02784", "If flags has the VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT flag set, the subgroupSizeControl feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-02785", "If flags has the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT flag set, the computeFullSubgroups feature must be enabled", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-parameter", "flags must be a valid combination of VkPipelineShaderStageCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-maxClipDistances-00708", "If the identified entry point includes any variable in its interface that is declared with the ClipDistance BuiltIn decoration, that variable must not have an array size greater than VkPhysicalDeviceLimits::maxClipDistances", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-maxCombinedClipAndCullDistances-00710", "If the identified entry point includes any variables in its interface that are declared with the ClipDistance or CullDistance BuiltIn decoration, those variables must not have array sizes which sum to more than VkPhysicalDeviceLimits::maxCombinedClipAndCullDistances", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-maxCullDistances-00709", "If the identified entry point includes any variable in its interface that is declared with the CullDistance BuiltIn decoration, that variable must not have an array size greater than VkPhysicalDeviceLimits::maxCullDistances", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-maxSampleMaskWords-00711", "If the identified entry point includes any variable in its interface that is declared with the SampleMask BuiltIn decoration, that variable must not have an array size greater than VkPhysicalDeviceLimits::maxSampleMaskWords", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-module-04145", "The SPIR-V code that was used to create module must be valid as described by the Khronos SPIR-V Specification after applying the specializations provided in pSpecializationInfo, if any, and then converting all specialization constants into fixed constants.", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-module-parameter", "module must be a valid VkShaderModule handle", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-pName-00707", "pName must be the name of an OpEntryPoint in module with an execution model that matches stage", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-pName-parameter", "pName must be a null-terminated UTF-8 string", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-02754", "If a VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain, flags must not have the VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT flag set", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-02755", "If a VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain, the subgroupSizeControl feature must be enabled, and stage must be a valid bit specified in requiredSubgroupSizeStages", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-02756", "If a VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain and stage is VK_SHADER_STAGE_COMPUTE_BIT, the local workgroup size of the shader must be less than or equal to the product of VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::requiredSubgroupSize and maxComputeWorkgroupSubgroups", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-02757", "If a VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain, and flags has the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT flag set, the local workgroup size in the X dimension of the pipeline must be a multiple of VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::requiredSubgroupSize", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-pSpecializationInfo-parameter", "If pSpecializationInfo is not NULL, pSpecializationInfo must be a valid pointer to a valid VkSpecializationInfo structure", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00704", "If the geometry shaders feature is not enabled, stage must not be VK_SHADER_STAGE_GEOMETRY_BIT", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00705", "If the tessellation shaders feature is not enabled, stage must not be VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT or VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00706", "stage must not be VK_SHADER_STAGE_ALL_GRAPHICS, or VK_SHADER_STAGE_ALL", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00712", "If stage is VK_SHADER_STAGE_VERTEX_BIT, the identified entry point must not include any input variable in its interface that is decorated with CullDistance", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00713", "If stage is VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT or VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, and the identified entry point has an OpExecutionMode instruction that specifies a patch size with OutputVertices, the patch size must be greater than 0 and less than or equal to VkPhysicalDeviceLimits::maxTessellationPatchSize", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00714", "If stage is VK_SHADER_STAGE_GEOMETRY_BIT, the identified entry point must have an OpExecutionMode instruction that specifies a maximum output vertex count that is greater than 0 and less than or equal to VkPhysicalDeviceLimits::maxGeometryOutputVertices", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00715", "If stage is VK_SHADER_STAGE_GEOMETRY_BIT, the identified entry point must have an OpExecutionMode instruction that specifies an invocation count that is greater than 0 and less than or equal to VkPhysicalDeviceLimits::maxGeometryShaderInvocations", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00718", "If stage is VK_SHADER_STAGE_FRAGMENT_BIT, the identified entry point must not include any output variables in its interface decorated with CullDistance", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00719", "If stage is VK_SHADER_STAGE_FRAGMENT_BIT, and the identified entry point writes to FragDepth in any execution path, it must write to FragDepth in all execution paths", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-01511", "If stage is VK_SHADER_STAGE_FRAGMENT_BIT, and the identified entry point writes to FragStencilRefEXT in any execution path, it must write to FragStencilRefEXT in all execution paths", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02091", "If the mesh shader feature is not enabled, stage must not be VK_SHADER_STAGE_MESH_BIT_NV", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02092", "If the task shader feature is not enabled, stage must not be VK_SHADER_STAGE_TASK_BIT_NV", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02093", "If stage is VK_SHADER_STAGE_MESH_BIT_NV, the identified entry point must have an OpExecutionMode instruction that specifies a maximum output vertex count, OutputVertices, that is greater than 0 and less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputVertices", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02094", "If stage is VK_SHADER_STAGE_MESH_BIT_NV, the identified entry point must have an OpExecutionMode instruction that specifies a maximum output primitive count, OutputPrimitivesNV, that is greater than 0 and less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputPrimitives", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02596", "If stage is a pre-rasterization shader stage, and the identified entry point writes to Layer for any primitive, it must write the same value to Layer for all vertices of a given primitive", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02597", "If stage is a pre-rasterization shader stage, and the identified entry point writes to ViewportIndex for any primitive, it must write the same value to ViewportIndex for all vertices of a given primitive", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-parameter", "stage must be a valid VkShaderStageFlagBits value", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02760", "requiredSubgroupSize must be a power-of-two integer", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02761", "requiredSubgroupSize must be greater or equal to minSubgroupSize", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02762", "requiredSubgroupSize must be less than or equal to maxSubgroupSize", "1.2-extensions"},
    {"VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineTessellationDomainOriginStateCreateInfo-domainOrigin-parameter", "domainOrigin must be a valid VkTessellationDomainOrigin value", "1.2-extensions"},
    {"VUID-VkPipelineTessellationDomainOriginStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineTessellationStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineTessellationStateCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineTessellationDomainOriginStateCreateInfo", "1.2-extensions"},
    {"VUID-VkPipelineTessellationStateCreateInfo-patchControlPoints-01214", "patchControlPoints must be greater than zero and less than or equal to VkPhysicalDeviceLimits::maxTessellationPatchSize", "1.2-extensions"},
    {"VUID-VkPipelineTessellationStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineTessellationStateCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-pVertexBindingDivisors-parameter", "pVertexBindingDivisors must be a valid pointer to an array of vertexBindingDivisorCount VkVertexInputBindingDivisorDescriptionEXT structures", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-vertexBindingDivisorCount-arraylength", "vertexBindingDivisorCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-binding-00615", "For every binding specified by each element of pVertexAttributeDescriptions, a VkVertexInputBindingDescription must exist in pVertexBindingDescriptions with the same value of binding", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineVertexInputDivisorStateCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pVertexAttributeDescriptions-00617", "All elements of pVertexAttributeDescriptions must describe distinct attribute locations", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pVertexAttributeDescriptions-parameter", "If vertexAttributeDescriptionCount is not 0, pVertexAttributeDescriptions must be a valid pointer to an array of vertexAttributeDescriptionCount valid VkVertexInputAttributeDescription structures", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pVertexBindingDescriptions-00616", "All elements of pVertexBindingDescriptions must describe distinct binding numbers", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pVertexBindingDescriptions-parameter", "If vertexBindingDescriptionCount is not 0, pVertexBindingDescriptions must be a valid pointer to an array of vertexBindingDescriptionCount valid VkVertexInputBindingDescription structures", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-vertexAttributeDescriptionCount-00614", "vertexAttributeDescriptionCount must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputAttributes", "1.2-extensions"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-vertexBindingDescriptionCount-00613", "vertexBindingDescriptionCount must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputBindings", "1.2-extensions"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders-02234", "The array pCustomSampleOrders must not contain two structures with matching values for both the shadingRate and sampleCount members", "1.2-extensions"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders-parameter", "If customSampleOrderCount is not 0, pCustomSampleOrders must be a valid pointer to an array of customSampleOrderCount valid VkCoarseSampleOrderCustomNV structures", "1.2-extensions"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType-02072", "If sampleOrderType is not VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV, customSamplerOrderCount must be 0", "1.2-extensions"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType-parameter", "sampleOrderType must be a valid VkCoarseSampleOrderTypeNV value", "1.2-extensions"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02027", "If the multiple viewports feature is not enabled, exclusiveScissorCount must be 0 or 1", "1.2-extensions"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02028", "exclusiveScissorCount must be less than or equal to VkPhysicalDeviceLimits::maxViewports", "1.2-extensions"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02029", "exclusiveScissorCount must be 0 or greater than or equal to the viewportCount member of VkPipelineViewportStateCreateInfo", "1.2-extensions"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-shadingRateImageEnable-02056", "If shadingRateImageEnable is VK_TRUE, viewportCount must be greater or equal to the viewportCount member of VkPipelineViewportStateCreateInfo", "1.2-extensions"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-viewportCount-02054", "If the multiple viewports feature is not enabled, viewportCount must be 0 or 1", "1.2-extensions"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-viewportCount-02055", "viewportCount must be less than or equal to VkPhysicalDeviceLimits::maxViewports", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-offset-02822", "Evaluation of (offset.x + extent.width) must not cause a signed integer addition overflow for any element of pScissors", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-offset-02823", "Evaluation of (offset.y + extent.height) must not cause a signed integer addition overflow for any element of pScissors", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, VkPipelineViewportExclusiveScissorStateCreateInfoNV, VkPipelineViewportShadingRateImageStateCreateInfoNV, VkPipelineViewportSwizzleStateCreateInfoNV, or VkPipelineViewportWScalingStateCreateInfoNV", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-01217", "If the multiple viewports feature is not enabled, scissorCount must not be greater than 1", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-01219", "scissorCount must be less than or equal to VkPhysicalDeviceLimits::maxViewports", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-01220", "scissorCount and viewportCount must be identical", "1.2-khr-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-04134", "If the graphics pipeline is being created without VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT and VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT set then scissorCount and viewportCount must be identical", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-04136", "If the graphics pipeline is being created with VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT set then scissorCount must be 0, otherwise it must be greater than 0", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-arraylength", "scissorCount must be greater than 0", "1.2-khr-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportCount-01216", "If the multiple viewports feature is not enabled, viewportCount must not be greater than 1", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportCount-01218", "viewportCount must be less than or equal to VkPhysicalDeviceLimits::maxViewports", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportCount-04135", "If the graphics pipeline is being created with VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT set then viewportCount must be 0, otherwise it must be greater than 0", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportCount-arraylength", "viewportCount must be greater than 0", "1.2-khr-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportWScalingEnable-01726", "If the viewportWScalingEnable member of a VkPipelineViewportWScalingStateCreateInfoNV structure included in the pNext chain is VK_TRUE, the viewportCount member of the VkPipelineViewportWScalingStateCreateInfoNV structure must be greater than or equal to VkPipelineViewportStateCreateInfo::viewportCount", "1.2-extensions"},
    {"VUID-VkPipelineViewportStateCreateInfo-x-02821", "The x and y members of offset member of any element of pScissors must be greater than or equal to 0", "1.2-extensions"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-pViewportSwizzles-parameter", "pViewportSwizzles must be a valid pointer to an array of viewportCount valid VkViewportSwizzleNV structures", "1.2-extensions"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount-01215", "viewportCount must be greater than or equal to the viewportCount set in VkPipelineViewportStateCreateInfo", "1.2-extensions"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount-arraylength", "viewportCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkPipelineViewportWScalingStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkPipelineViewportWScalingStateCreateInfoNV-viewportCount-arraylength", "viewportCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkPresentFrameTokenGGP-frameToken-02680", "frameToken must be a valid GgpFrameToken", "1.2-extensions"},
    {"VUID-VkPresentFrameTokenGGP-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-commonparent", "Both of the elements of pSwapchains, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkInstance", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-pImageIndices-01296", "Each element of pImageIndices must be the index of a presentable image acquired from the swapchain specified by the corresponding element of the pSwapchains array, and the presented image subresource must be in the VK_IMAGE_LAYOUT_PRESENT_SRC_KHR layout at the time the operation is executed on a VkDevice", "default"},
    {"VUID-VkPresentInfoKHR-pImageIndices-01430", "Each element of pImageIndices must be the index of a presentable image acquired from the swapchain specified by the corresponding element of the pSwapchains array, and the presented image subresource must be in the VK_IMAGE_LAYOUT_PRESENT_SRC_KHR or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR layout at the time the operation is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-pImageIndices-parameter", "pImageIndices must be a valid pointer to an array of swapchainCount uint32_t values", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupPresentInfoKHR, VkDisplayPresentInfoKHR, VkPresentFrameTokenGGP, VkPresentRegionsKHR, or VkPresentTimesInfoGOOGLE", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-pResults-parameter", "If pResults is not NULL, pResults must be a valid pointer to an array of swapchainCount VkResult values", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-pSwapchains-parameter", "pSwapchains must be a valid pointer to an array of swapchainCount valid VkSwapchainKHR handles", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-pWaitSemaphores-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRESENT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkPresentInfoKHR-swapchainCount-arraylength", "swapchainCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkPresentRegionKHR-pRectangles-parameter", "If rectangleCount is not 0, and pRectangles is not NULL, pRectangles must be a valid pointer to an array of rectangleCount valid VkRectLayerKHR structures", "1.2-extensions"},
    {"VUID-VkPresentRegionsKHR-pRegions-parameter", "If pRegions is not NULL, pRegions must be a valid pointer to an array of swapchainCount valid VkPresentRegionKHR structures", "1.2-extensions"},
    {"VUID-VkPresentRegionsKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR", "1.2-extensions"},
    {"VUID-VkPresentRegionsKHR-swapchainCount-01260", "swapchainCount must be the same value as VkPresentInfoKHR::swapchainCount, where VkPresentInfoKHR is included in the pNext chain of this VkPresentRegionsKHR structure", "1.2-extensions"},
    {"VUID-VkPresentRegionsKHR-swapchainCount-arraylength", "swapchainCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkPresentTimesInfoGOOGLE-pTimes-parameter", "If pTimes is not NULL, pTimes must be a valid pointer to an array of swapchainCount VkPresentTimeGOOGLE structures", "1.2-extensions"},
    {"VUID-VkPresentTimesInfoGOOGLE-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE", "1.2-extensions"},
    {"VUID-VkPresentTimesInfoGOOGLE-swapchainCount-01247", "swapchainCount must be the same value as VkPresentInfoKHR::swapchainCount, where VkPresentInfoKHR is included in the pNext chain of this VkPresentTimesInfoGOOGLE structure", "1.2-extensions"},
    {"VUID-VkPresentTimesInfoGOOGLE-swapchainCount-arraylength", "swapchainCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkPrivateDataSlotCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkPrivateDataSlotCreateInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkPrivateDataSlotCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkProtectedSubmitInfo-protectedSubmit-01816", "If the protected memory feature is not enabled, protectedSubmit must not be VK_TRUE", "1.2-extensions"},
    {"VUID-VkProtectedSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO", "1.2-extensions"},
    {"VUID-VkPushConstantRange-offset-00294", "offset must be less than VkPhysicalDeviceLimits::maxPushConstantsSize", "1.2-extensions"},
    {"VUID-VkPushConstantRange-offset-00295", "offset must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkPushConstantRange-size-00296", "size must be greater than 0", "1.2-extensions"},
    {"VUID-VkPushConstantRange-size-00297", "size must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkPushConstantRange-size-00298", "size must be less than or equal to VkPhysicalDeviceLimits::maxPushConstantsSize minus offset", "1.2-extensions"},
    {"VUID-VkPushConstantRange-stageFlags-parameter", "stageFlags must be a valid combination of VkShaderStageFlagBits values", "1.2-extensions"},
    {"VUID-VkPushConstantRange-stageFlags-requiredbitmask", "stageFlags must not be 0", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkQueryPoolPerformanceCreateInfoKHR, VkQueryPoolPerformanceQueryCreateInfoINTEL, or VkVideoProfileKHR", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-queryCount-02763", "queryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-queryType-00791", "If the pipeline statistics queries feature is not enabled, queryType must not be VK_QUERY_TYPE_PIPELINE_STATISTICS", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-queryType-00792", "If queryType is VK_QUERY_TYPE_PIPELINE_STATISTICS, pipelineStatistics must be a valid combination of VkQueryPipelineStatisticFlagBits values", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-queryType-03222", "If queryType is VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR, the pNext chain must include a VkQueryPoolPerformanceCreateInfoKHR structure", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-queryType-parameter", "queryType must be a valid VkQueryType value", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkQueryPoolCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-counterIndexCount-arraylength", "counterIndexCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices-03321", "Each element of pCounterIndices must be in the range of counters reported by vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR for the queue family specified in queueFamilyIndex", "1.2-extensions"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices-parameter", "pCounterIndices must be a valid pointer to an array of counterIndexCount uint32_t values", "1.2-extensions"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-performanceCounterQueryPools-03237", "The performanceCounterQueryPools feature must be enabled", "1.2-extensions"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-queueFamilyIndex-03236", "queueFamilyIndex must be a valid queue family index of the device", "1.2-extensions"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkQueryPoolPerformanceQueryCreateInfoINTEL-performanceCountersSampling-parameter", "performanceCountersSampling must be a valid VkQueryPoolSamplingModeINTEL value", "1.2-extensions"},
    {"VUID-VkQueryPoolPerformanceQueryCreateInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL", "1.2-extensions"},
    {"VUID-VkQueueFamilyCheckpointProperties2NV-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV", "1.2-extensions"},
    {"VUID-VkQueueFamilyCheckpointPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV", "1.2-extensions"},
    {"VUID-VkQueueFamilyGlobalPriorityPropertiesEXT-priorities-parameter", "Any given element of priorities must be a valid VkQueueGlobalPriorityEXT value", "1.2-extensions"},
    {"VUID-VkQueueFamilyGlobalPriorityPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT", "1.2-extensions"},
    {"VUID-VkQueueFamilyProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkQueueFamilyCheckpointProperties2NV, VkQueueFamilyCheckpointPropertiesNV, VkQueueFamilyGlobalPriorityPropertiesEXT, or VkVideoQueueFamilyProperties2KHR", "1.2-extensions"},
    {"VUID-VkQueueFamilyProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2", "1.2-extensions"},
    {"VUID-VkQueueFamilyProperties2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-02904", "flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03421", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid handle to a ray tracing VkPipeline", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03422", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03423", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is not -1, basePipelineHandle must be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03424", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is not VK_NULL_HANDLE, basePipelineIndex must be -1", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03465", "If flags includes VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, pLibraryInterface must not be NULL", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03470", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR, for any element of pGroups with a type of VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR or VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR, the anyHitShader of that element must not be VK_SHADER_UNUSED_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03471", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR, for any element of pGroups with a type of VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR or VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR, the closestHitShader of that element must not be VK_SHADER_UNUSED_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03594", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR, each element of pLibraryInfo->pLibraries must have been created with the VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR bit set", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-03598", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR, rayTracingPipelineShaderGroupHandleCaptureReplay must be enabled", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-04718", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR, each element of pLibraryInfo->pLibraries must have been created with the VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR bit set", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-04719", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR, each element of pLibraryInfo->pLibraries must have been created with the VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR bit set", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-04720", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR, each element of pLibraryInfo->pLibraries must have been created with the VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR bit set", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-04721", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR, each element of pLibraryInfo->pLibraries must have been created with the VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR bit set", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-04722", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR, each element of pLibraryInfo->pLibraries must have been created with the VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR bit set", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-04723", "If flags includes VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR, each element of pLibraryInfo->pLibraries must have been created with the VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR bit set", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-flags-parameter", "flags must be a valid combination of VkPipelineCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-layout-03427", "layout must be consistent with all shaders specified in pStages", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-layout-03428", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-layout-parameter", "layout must be a valid VkPipelineLayout handle", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-maxPipelineRayRecursionDepth-03589", "maxPipelineRayRecursionDepth must be less than or equal to VkPhysicalDeviceRayTracingPipelinePropertiesKHR::maxRayRecursionDepth", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pDynamicState-parameter", "If pDynamicState is not NULL, pDynamicState must be a valid pointer to a valid VkPipelineDynamicStateCreateInfo structure", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pDynamicStates-03602", "Any element of the pDynamicStates member of pDynamicState must be VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pGroups-parameter", "If groupCount is not 0, pGroups must be a valid pointer to an array of groupCount valid VkRayTracingShaderGroupCreateInfoKHR structures", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraries-03591", "Each element of pLibraryInfo->pLibraries must have been created with the value of maxPipelineRayRecursionDepth equal to that in this pipeline", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraryInfo-03590", "If pLibraryInfo is not NULL and its libraryCount member is greater than 0, its pLibraryInterface member must not be NULL", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraryInfo-03592", "If pLibraryInfo is not NULL, each element of its pLibraries member must have been created with a layout that is compatible with the layout in this pipeline", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraryInfo-03593", "If pLibraryInfo is not NULL, each element of its pLibraries member must have been created with values of the maxPipelineRayPayloadSize and maxPipelineRayHitAttributeSize members of pLibraryInterface equal to those in this pipeline", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraryInfo-03595", "If the VK_KHR_pipeline_library extension is not enabled, pLibraryInfo and pLibraryInterface must be NULL.", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraryInfo-03600", "If pLibraryInfo is not NULL and its libraryCount is 0, stageCount must not be 0", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraryInfo-03601", "If pLibraryInfo is not NULL and its libraryCount is 0, groupCount must not be 0", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraryInfo-parameter", "If pLibraryInfo is not NULL, pLibraryInfo must be a valid pointer to a valid VkPipelineLibraryCreateInfoKHR structure", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pLibraryInterface-parameter", "If pLibraryInterface is not NULL, pLibraryInterface must be a valid pointer to a valid VkRayTracingPipelineInterfaceCreateInfoKHR structure", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineCreationFeedbackCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pStages-03426", "The shader code for the entry points identified by pStages, and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pStages-parameter", "If stageCount is not 0, pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-pipelineCreationCacheControl-02905", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-rayTracingPipelineShaderGroupHandleCaptureReplay-03599", "If VkPhysicalDeviceRayTracingPipelineFeaturesKHR::rayTracingPipelineShaderGroupHandleCaptureReplay is VK_TRUE and the pShaderGroupCaptureReplayHandle member of any element of pGroups is not NULL, flags must include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-rayTraversalPrimitiveCulling-03596", "If the rayTraversalPrimitiveCulling feature is not enabled, flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-rayTraversalPrimitiveCulling-03597", "If the rayTraversalPrimitiveCulling feature is not enabled, flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoKHR-stage-03425", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, the stage member of at least one element of pStages, including those implicitly added by pLibraryInfo, must be VK_SHADER_STAGE_RAYGEN_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-02904", "flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-02957", "flags must not include both VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV and VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT at the same time", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03421", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid handle to a ray tracing VkPipeline", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03422", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03423", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is not -1, basePipelineHandle must be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03424", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is not VK_NULL_HANDLE, basePipelineIndex must be -1", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03456", "flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03458", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03459", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03460", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03461", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03462", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03463", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-03588", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-04948", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-parameter", "flags must be a valid combination of VkPipelineCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-groupCount-arraylength", "groupCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-layout-03427", "layout must be consistent with all shaders specified in pStages", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-layout-03428", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-layout-parameter", "layout must be a valid VkPipelineLayout handle", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-maxRecursionDepth-03457", "maxRecursionDepth must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxRecursionDepth", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pGroups-parameter", "pGroups must be a valid pointer to an array of groupCount valid VkRayTracingShaderGroupCreateInfoNV structures", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineCreationFeedbackCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pStages-03426", "The shader code for the entry points identified by pStages, and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pStages-parameter", "pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pipelineCreationCacheControl-02905", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-stage-03425", "The stage member of at least one element of pStages must be VK_SHADER_STAGE_RAYGEN_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-stageCount-arraylength", "stageCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineInterfaceCreateInfoKHR-maxPipelineRayHitAttributeSize-03605", "maxPipelineRayHitAttributeSize must be less than or equal to VkPhysicalDeviceRayTracingPipelinePropertiesKHR::maxRayHitAttributeSize", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineInterfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkRayTracingPipelineInterfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-anyHitShader-03479", "anyHitShader must be either VK_SHADER_UNUSED_KHR or a valid index into VkRayTracingPipelineCreateInfoKHR::pStages referring to a shader of VK_SHADER_STAGE_ANY_HIT_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-closestHitShader-03478", "closestHitShader must be either VK_SHADER_UNUSED_KHR or a valid index into VkRayTracingPipelineCreateInfoKHR::pStages referring to a shader of VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-rayTracingPipelineShaderGroupHandleCaptureReplayMixed-03603", "If VkPhysicalDeviceRayTracingPipelineFeaturesKHR::rayTracingPipelineShaderGroupHandleCaptureReplayMixed is VK_FALSE then pShaderGroupCaptureReplayHandle must not be provided if it has not been provided on a previous call to ray tracing pipeline creation", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-rayTracingPipelineShaderGroupHandleCaptureReplayMixed-03604", "If VkPhysicalDeviceRayTracingPipelineFeaturesKHR::rayTracingPipelineShaderGroupHandleCaptureReplayMixed is VK_FALSE then the caller must guarantee that no ray tracing pipeline creation commands with pShaderGroupCaptureReplayHandle provided execute simultaneously with ray tracing pipeline creation commands without pShaderGroupCaptureReplayHandle provided", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-type-03474", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR then generalShader must be a valid index into VkRayTracingPipelineCreateInfoKHR::pStages referring to a shader of VK_SHADER_STAGE_RAYGEN_BIT_KHR, VK_SHADER_STAGE_MISS_BIT_KHR, or VK_SHADER_STAGE_CALLABLE_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-type-03475", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR then closestHitShader, anyHitShader, and intersectionShader must be VK_SHADER_UNUSED_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-type-03476", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR then intersectionShader must be a valid index into VkRayTracingPipelineCreateInfoKHR::pStages referring to a shader of VK_SHADER_STAGE_INTERSECTION_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-type-03477", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR then intersectionShader must be VK_SHADER_UNUSED_KHR", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoKHR-type-parameter", "type must be a valid VkRayTracingShaderGroupTypeKHR value", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-anyHitShader-02418", "anyHitShader must be either VK_SHADER_UNUSED_NV or a valid index into VkRayTracingPipelineCreateInfoNV::pStages referring to a shader of VK_SHADER_STAGE_ANY_HIT_BIT_NV", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-closestHitShader-02417", "closestHitShader must be either VK_SHADER_UNUSED_NV or a valid index into VkRayTracingPipelineCreateInfoNV::pStages referring to a shader of VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-02413", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV then generalShader must be a valid index into VkRayTracingPipelineCreateInfoNV::pStages referring to a shader of VK_SHADER_STAGE_RAYGEN_BIT_NV, VK_SHADER_STAGE_MISS_BIT_NV, or VK_SHADER_STAGE_CALLABLE_BIT_NV", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-02414", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV then closestHitShader, anyHitShader, and intersectionShader must be VK_SHADER_UNUSED_NV", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-02415", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV then intersectionShader must be a valid index into VkRayTracingPipelineCreateInfoNV::pStages referring to a shader of VK_SHADER_STAGE_INTERSECTION_BIT_NV", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-02416", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV then intersectionShader must be VK_SHADER_UNUSED_NV", "1.2-extensions"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-parameter", "type must be a valid VkRayTracingShaderGroupTypeKHR value", "1.2-extensions"},
    {"VUID-VkRectLayerKHR-layer-01262", "layer must be less than the imageArrayLayers member of the VkSwapchainCreateInfoKHR structure passed to vkCreateSwapchainKHR", "1.2-extensions"},
    {"VUID-VkRectLayerKHR-offset-04864", "The sum of offset and extent, after being transformed according to the preTransform member of the VkSwapchainCreateInfoKHR structure, must be no greater than the imageExtent member of the VkSwapchainCreateInfoKHR structure passed to vkCreateSwapchainKHR.", "1.2-extensions"},
    {"VUID-VkRenderPassAttachmentBeginInfo-pAttachments-03218", "Each element of pAttachments must only specify a single mip level", "1.2-extensions"},
    {"VUID-VkRenderPassAttachmentBeginInfo-pAttachments-03219", "Each element of pAttachments must have been created with the identity swizzle", "1.2-extensions"},
    {"VUID-VkRenderPassAttachmentBeginInfo-pAttachments-04114", "Each element of pAttachments must have been created with VkImageViewCreateInfo::viewType not equal to VK_IMAGE_VIEW_TYPE_3D", "1.2-extensions"},
    {"VUID-VkRenderPassAttachmentBeginInfo-pAttachments-parameter", "If attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkImageView handles", "1.2-extensions"},
    {"VUID-VkRenderPassAttachmentBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-clearValueCount-00902", "clearValueCount must be greater than the largest attachment index in renderPass that specifies a loadOp (or stencilLoadOp, if the attachment has a depth/stencil format) of VK_ATTACHMENT_LOAD_OP_CLEAR", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-clearValueCount-04962", "If clearValueCount is not 0, pClearValues must be a valid pointer to an array of clearValueCount VkClearValue unions", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-commonparent", "Both of framebuffer, and renderPass must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-02780", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must have been created on the same VkDevice as framebuffer and renderPass", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03207", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that did not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and the pNext chain includes a VkRenderPassAttachmentBeginInfo structure, its attachmentCount must be zero", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03208", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the attachmentCount of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be equal to the value of VkFramebufferAttachmentsCreateInfo::attachmentImageInfoCount used to create framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03209", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageCreateInfo::flags equal to the flags member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachmentImageInfos used to create framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03211", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView with a width equal to the width member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachmentImageInfos used to create framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03212", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView with a height equal to the height member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachmentImageInfos used to create framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03213", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageViewCreateInfo::subresourceRange.layerCount equal to the layerCount member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachmentImageInfos used to create framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03214", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageFormatListCreateInfo::viewFormatCount equal to the viewFormatCount member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachmentImageInfos used to create framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03215", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a set of elements in VkImageFormatListCreateInfo::pViewFormats equal to the set of elements in the pViewFormats member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachmentImageInfos used to create framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03216", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageViewCreateInfo::format equal to the corresponding value of VkAttachmentDescription::format in renderPass", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03217", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageCreateInfo::samples equal to the corresponding value of VkAttachmentDescription::samples in renderPass", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-04627", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView with an inherited usage equal to the usage member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachmentImageInfos used to create framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-parameter", "framebuffer must be a valid VkFramebuffer handle", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02850", "If the pNext chain does not contain VkDeviceGroupRenderPassBeginInfo or its deviceRenderAreaCount member is equal to 0, renderArea.offset.x must be greater than or equal to 0", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02851", "If the pNext chain does not contain VkDeviceGroupRenderPassBeginInfo or its deviceRenderAreaCount member is equal to 0, renderArea.offset.y must be greater than or equal to 0", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02852", "If the pNext chain does not contain VkDeviceGroupRenderPassBeginInfo or its deviceRenderAreaCount member is equal to 0, renderArea.offset.x + renderArea.offset.width must be less than or equal to VkFramebufferCreateInfo::width the framebuffer was created with", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02853", "If the pNext chain does not contain VkDeviceGroupRenderPassBeginInfo or its deviceRenderAreaCount member is equal to 0, renderArea.offset.y + renderArea.offset.height must be less than or equal to VkFramebufferCreateInfo::height the framebuffer was created with", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02854", "If the pNext chain contains VkDeviceGroupRenderPassBeginInfo, the offset.x member of each element of pDeviceRenderAreas must be greater than or equal to 0", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02855", "If the pNext chain contains VkDeviceGroupRenderPassBeginInfo, the offset.y member of each element of pDeviceRenderAreas must be greater than or equal to 0", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02856", "If the pNext chain contains VkDeviceGroupRenderPassBeginInfo, offset.x + offset.width of each element of pDeviceRenderAreas must be less than or equal to VkFramebufferCreateInfo::width the framebuffer was created with", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02857", "If the pNext chain contains VkDeviceGroupRenderPassBeginInfo, offset.y + offset.height of each element of pDeviceRenderAreas must be less than or equal to VkFramebufferCreateInfo::height the framebuffer was created with", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02869", "If the pNext chain includes VkRenderPassTransformBeginInfoQCOM, renderArea.offset must equal (0,0)", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-02870", "If the pNext chain includes VkRenderPassTransformBeginInfoQCOM, renderArea.extent transformed by VkRenderPassTransformBeginInfoQCOM::transform must equal the framebuffer dimensions", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupRenderPassBeginInfo, VkRenderPassAttachmentBeginInfo, VkRenderPassSampleLocationsBeginInfoEXT, or VkRenderPassTransformBeginInfoQCOM", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-renderArea-02846", "renderArea.offset.x must be greater than or equal to 0", "1.0"},
    {"VUID-VkRenderPassBeginInfo-renderArea-02847", "renderArea.offset.y must be greater than or equal to 0", "1.0"},
    {"VUID-VkRenderPassBeginInfo-renderArea-02848", "renderArea.offset.x + renderArea.offset.width must be less than or equal to VkFramebufferCreateInfo::width the framebuffer was created with", "1.0"},
    {"VUID-VkRenderPassBeginInfo-renderArea-02849", "renderArea.offset.y + renderArea.offset.height must be less than or equal to VkFramebufferCreateInfo::height the framebuffer was created with", "1.0"},
    {"VUID-VkRenderPassBeginInfo-renderPass-00904", "renderPass must be compatible with the renderPass member of the VkFramebufferCreateInfo structure specified when creating framebuffer", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-renderPass-parameter", "renderPass must be a valid VkRenderPass handle", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO", "1.2-extensions"},
    {"VUID-VkRenderPassBeginInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-attachment-00834", "If the attachment member of any element of pInputAttachments, pColorAttachments, pResolveAttachments or pDepthStencilAttachment, or any element of pPreserveAttachments in any element of pSubpasses is not VK_ATTACHMENT_UNUSED, it must be less than attachmentCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-dstSubpass-02518", "The dstSubpass member of each element of pDependencies must be less than subpassCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-flags-parameter", "flags must be a valid combination of VkRenderPassCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-00836", "For any member of pAttachments with a loadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-01566", "For any member of pAttachments with a loadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-01567", "For any member of pAttachments with a stencilLoadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-02511", "For any member of pAttachments with a stencilLoadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-parameter", "If attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkAttachmentDescription structures", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pDependencies-00837", "For any element of pDependencies, if the srcSubpass is not VK_SUBPASS_EXTERNAL, all stage flags included in the srcStageMask member of that dependency must be a pipeline stage supported by the pipeline identified by the pipelineBindPoint member of the source subpass", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pDependencies-00838", "For any element of pDependencies, if the dstSubpass is not VK_SUBPASS_EXTERNAL, all stage flags included in the dstStageMask member of that dependency must be a pipeline stage supported by the pipeline identified by the pipelineBindPoint member of the destination subpass", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pDependencies-parameter", "If dependencyCount is not 0, pDependencies must be a valid pointer to an array of dependencyCount valid VkSubpassDependency structures", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-01926", "If the pNext chain includes a VkRenderPassInputAttachmentAspectCreateInfo structure, the subpass member of each element of its pAspectReferences member must be less than subpassCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-01927", "If the pNext chain includes a VkRenderPassInputAttachmentAspectCreateInfo structure, the inputAttachmentIndex member of each element of its pAspectReferences member must be less than the value of inputAttachmentCount in the element of pSubpasses identified by its subpass member", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-01928", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, and its subpassCount member is not zero, that member must be equal to the value of subpassCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-01929", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, if its dependencyCount member is not zero, it must be equal to dependencyCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-01930", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, for each non-zero element of pViewOffsets, the srcSubpass and dstSubpass members of pDependencies at the same index must not be equal", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-01963", "If the pNext chain includes a VkRenderPassInputAttachmentAspectCreateInfo structure, for any element of the pInputAttachments member of any element of pSubpasses where the attachment member is not VK_ATTACHMENT_UNUSED, the aspectMask member of the corresponding element of VkRenderPassInputAttachmentAspectCreateInfo::pAspectReferences must only include aspects that are present in images of the format specified by the element of pAttachments at attachment", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-02512", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, for any element of pDependencies with a dependencyFlags member that does not include VK_DEPENDENCY_VIEW_LOCAL_BIT, the corresponding element of the pViewOffsets member of that VkRenderPassMultiviewCreateInfo instance must be 0", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-02513", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, elements of its pViewMasks member must either all be 0, or all not be 0", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-02514", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, and each element of its pViewMasks member is 0, the dependencyFlags member of each element of pDependencies must not include VK_DEPENDENCY_VIEW_LOCAL_BIT", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-02515", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, and each element of its pViewMasks member is 0, correlatedViewMaskCount must be 0", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkRenderPassFragmentDensityMapCreateInfoEXT, VkRenderPassInputAttachmentAspectCreateInfo, or VkRenderPassMultiviewCreateInfo", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-pSubpasses-parameter", "pSubpasses must be a valid pointer to an array of subpassCount valid VkSubpassDescription structures", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-srcSubpass-02517", "The srcSubpass member of each element of pDependencies must be less than subpassCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo-subpassCount-arraylength", "subpassCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-None-03049", "If any two subpasses operate on attachments with overlapping ranges of the same VkDeviceMemory object, and at least one subpass writes to that area of VkDeviceMemory, a subpass dependency must be included (either directly or via some intermediate subpasses) between them", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-attachment-02525", "If the attachment member of any element of the pInputAttachments member of any element of pSubpasses is not VK_ATTACHMENT_UNUSED, the aspectMask member of that element of pInputAttachments must only include aspects that are present in images of the format specified by the element of pAttachments specified by attachment", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-attachment-03050", "If the attachment member of any element of pInputAttachments, pColorAttachments, pResolveAttachments or pDepthStencilAttachment, or the attachment indexed by any element of pPreserveAttachments in any given element of pSubpasses is bound to a range of a VkDeviceMemory object that overlaps with any other attachment in any subpass (including the same subpass), the VkAttachmentDescription2 structures describing them must include VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT in flags", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-attachment-03051", "If the attachment member of any element of pInputAttachments, pColorAttachments, pResolveAttachments or pDepthStencilAttachment, or any element of pPreserveAttachments in any given element of pSubpasses is not VK_ATTACHMENT_UNUSED, it must be less than attachmentCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-dstSubpass-02527", "The dstSubpass member of each element of pDependencies must be less than subpassCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-flags-04521", "If flags includes VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM, an element of pSubpasses includes an instance of VkFragmentShadingRateAttachmentInfoKHR in its pNext chain, and the pFragmentShadingRateAttachment member of that structure is not equal to NULL, the attachment member of pFragmentShadingRateAttachment must be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-flags-04907", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if pResolveAttachments is not NULL, then each resolve attachment must be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-flags-04908", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if pDepthStencilResolveAttachmentKHR is not NULL, then the depth/stencil resolve attachment must be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-flags-04909", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, then the subpass must be the last subpass in a subpass dependency chain", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-flags-parameter", "flags must be a valid combination of VkRenderPassCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pAttachments-02522", "For any member of pAttachments with a loadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pAttachments-02523", "For any member of pAttachments with a stencilLoadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pAttachments-04585", "If any element of pAttachments is used as a fragment shading rate attachment in any subpass, it must not be used as any other attachment in the render pass", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pAttachments-04586", "If any element of pAttachments is used as a fragment shading rate attachment in any subpass, it must have an image format whose potential format features contain VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pAttachments-parameter", "If attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkAttachmentDescription2 structures", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pCorrelatedViewMasks-03056", "The set of bits included in any element of pCorrelatedViewMasks must not overlap with the set of bits included in any other element of pCorrelatedViewMasks", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pCorrelatedViewMasks-parameter", "If correlatedViewMaskCount is not 0, pCorrelatedViewMasks must be a valid pointer to an array of correlatedViewMaskCount uint32_t values", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pDependencies-03054", "For any element of pDependencies, if the srcSubpass is not VK_SUBPASS_EXTERNAL, all stage flags included in the srcStageMask member of that dependency must be a pipeline stage supported by the pipeline identified by the pipelineBindPoint member of the source subpass", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pDependencies-03055", "For any element of pDependencies, if the dstSubpass is not VK_SUBPASS_EXTERNAL, all stage flags included in the dstStageMask member of that dependency must be a pipeline stage supported by the pipeline identified by the pipelineBindPoint member of the destination subpass", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pDependencies-03060", "For any element of pDependencies where its srcSubpass member equals its dstSubpass member, if the viewMask member of the corresponding element of pSubpasses includes more than one bit, its dependencyFlags member must include VK_DEPENDENCY_VIEW_LOCAL_BIT", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pDependencies-parameter", "If dependencyCount is not 0, pDependencies must be a valid pointer to an array of dependencyCount valid VkSubpassDependency2 structures", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkRenderPassFragmentDensityMapCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-pSubpasses-parameter", "pSubpasses must be a valid pointer to an array of subpassCount valid VkSubpassDescription2 structures", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-rasterizationSamples-04905", "If the pipeline is being created with fragment shader state, and the VK_QCOM_render_pass_shader_resolve extension is enabled, and if subpass has any input attachments, and if the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then the sample count of the input attachments must equal rasterizationSamples", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-sampleShadingEnable-04906", "If the pipeline is being created with fragment shader state, and the VK_QCOM_render_pass_shader_resolve extension is enabled, and if the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then sampleShadingEnable must be false", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-srcSubpass-02526", "The srcSubpass member of each element of pDependencies must be less than subpassCount", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-subpassCount-arraylength", "subpassCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-viewMask-03057", "If the VkSubpassDescription2::viewMask member of all elements of pSubpasses is 0, correlatedViewMaskCount must be 0", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-viewMask-03058", "The VkSubpassDescription2::viewMask member of all elements of pSubpasses must either all be 0, or all not be 0", "1.2-extensions"},
    {"VUID-VkRenderPassCreateInfo2-viewMask-03059", "If the VkSubpassDescription2::viewMask member of all elements of pSubpasses is 0, the dependencyFlags member of any element of pDependencies must not include VK_DEPENDENCY_VIEW_LOCAL_BIT", "1.2-extensions"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02547", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, fragmentDensityMapAttachment must be less than VkRenderPassCreateInfo::attachmentCount", "1.2-extensions"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02548", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, fragmentDensityMapAttachment must not be an element of VkSubpassDescription::pInputAttachments, VkSubpassDescription::pColorAttachments, VkSubpassDescription::pResolveAttachments, VkSubpassDescription::pDepthStencilAttachment, or VkSubpassDescription::pPreserveAttachments for any subpass", "1.2-extensions"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02549", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, layout must be equal to VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT, or VK_IMAGE_LAYOUT_GENERAL", "1.2-extensions"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02550", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, fragmentDensityMapAttachment must reference an attachment with a loadOp equal to VK_ATTACHMENT_LOAD_OP_LOAD or VK_ATTACHMENT_LOAD_OP_DONT_CARE", "1.2-extensions"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02551", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, fragmentDensityMapAttachment must reference an attachment with a storeOp equal to VK_ATTACHMENT_STORE_OP_DONT_CARE", "1.2-extensions"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-parameter", "fragmentDensityMapAttachment must be a valid VkAttachmentReference structure", "1.2-extensions"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkRenderPassInputAttachmentAspectCreateInfo-aspectReferenceCount-arraylength", "aspectReferenceCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkRenderPassInputAttachmentAspectCreateInfo-pAspectReferences-parameter", "pAspectReferences must be a valid pointer to an array of aspectReferenceCount valid VkInputAttachmentAspectReference structures", "1.2-extensions"},
    {"VUID-VkRenderPassInputAttachmentAspectCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkRenderPassMultiviewCreateInfo-pCorrelationMasks-00841", "Each view index must not be set in more than one element of pCorrelationMasks", "1.2-extensions"},
    {"VUID-VkRenderPassMultiviewCreateInfo-pCorrelationMasks-parameter", "If correlationMaskCount is not 0, pCorrelationMasks must be a valid pointer to an array of correlationMaskCount uint32_t values", "1.2-extensions"},
    {"VUID-VkRenderPassMultiviewCreateInfo-pViewMasks-parameter", "If subpassCount is not 0, pViewMasks must be a valid pointer to an array of subpassCount uint32_t values", "1.2-extensions"},
    {"VUID-VkRenderPassMultiviewCreateInfo-pViewOffsets-parameter", "If dependencyCount is not 0, pViewOffsets must be a valid pointer to an array of dependencyCount int32_t values", "1.2-extensions"},
    {"VUID-VkRenderPassMultiviewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkRenderPassSampleLocationsBeginInfoEXT-pAttachmentInitialSampleLocations-parameter", "If attachmentInitialSampleLocationsCount is not 0, pAttachmentInitialSampleLocations must be a valid pointer to an array of attachmentInitialSampleLocationsCount valid VkAttachmentSampleLocationsEXT structures", "1.2-extensions"},
    {"VUID-VkRenderPassSampleLocationsBeginInfoEXT-pPostSubpassSampleLocations-parameter", "If postSubpassSampleLocationsCount is not 0, pPostSubpassSampleLocations must be a valid pointer to an array of postSubpassSampleLocationsCount valid VkSubpassSampleLocationsEXT structures", "1.2-extensions"},
    {"VUID-VkRenderPassSampleLocationsBeginInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT", "1.2-extensions"},
    {"VUID-VkRenderPassTransformBeginInfoQCOM-flags-02872", "The renderpass must have been created with VkRenderPassCreateInfo::flags containing VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM", "1.2-extensions"},
    {"VUID-VkRenderPassTransformBeginInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM", "1.2-extensions"},
    {"VUID-VkRenderPassTransformBeginInfoQCOM-transform-02871", "transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImage-00258", "If dstImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImage-00259", "dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImage-00276", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.y must be 0 and extent.height must be 1", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImage-00278", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffset.z must be 0 and extent.depth must be 1", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImage-02003", "The format features of dstImage must contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImage-02546", "dstImage and srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImageLayout-00262", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImageLayout-00263", "dstImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "default"},
    {"VUID-VkResolveImageInfo2KHR-dstImageLayout-01401", "dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstOffset-00274", "For each element of pRegions, dstOffset.x and (extent.width + dstOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstOffset-00275", "For each element of pRegions, dstOffset.y and (extent.height + dstOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstOffset-00277", "For each element of pRegions, dstOffset.z and (extent.depth + dstOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstSubresource-01710", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-dstSubresource-01712", "The dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-pRegions-00255", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageResolve2KHR structures", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-regionCount-arraylength", "regionCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImage-00256", "If srcImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImage-00257", "srcImage must have a sample count equal to any valid sample count value other than VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImage-00271", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.y must be 0 and extent.height must be 1", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImage-00273", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffset.z must be 0 and extent.depth must be 1", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImage-01386", "srcImage and dstImage must have been created with the same image format", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImage-04446", "If either srcImage or dstImage are of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer must be 0 and srcSubresource.layerCount must be 1", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImage-04447", "If either srcImage or dstImage are of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstSubresource.baseArrayLayer must be 0 and dstSubresource.layerCount must be 1", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImageLayout-00260", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImageLayout-00261", "srcImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "default"},
    {"VUID-VkResolveImageInfo2KHR-srcImageLayout-01400", "srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcOffset-00269", "For each element of pRegions, srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcOffset-00270", "For each element of pRegions, srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcOffset-00272", "For each element of pRegions, srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcSubresource-01709", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.2-extensions"},
    {"VUID-VkResolveImageInfo2KHR-srcSubresource-01711", "The srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.2-extensions"},
    {"VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter", "If sampleLocationsCount is not 0, pSampleLocations must be a valid pointer to an array of sampleLocationsCount VkSampleLocationEXT structures", "1.2-extensions"},
    {"VUID-VkSampleLocationsInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT", "1.2-extensions"},
    {"VUID-VkSampleLocationsInfoEXT-sampleLocationsCount-01527", "sampleLocationsCount must equal sampleLocationsPerPixel {times} sampleLocationGridSize.width {times} sampleLocationGridSize.height", "1.2-extensions"},
    {"VUID-VkSampleLocationsInfoEXT-sampleLocationsPerPixel-01526", "sampleLocationsPerPixel must be a bit value that is set in VkPhysicalDeviceSampleLocationsPropertiesEXT::sampleLocationSampleCounts", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-None-01647", "The sampler reduction mode must be set to VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE if sampler {YCbCr} conversion is enabled", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-None-04012", "The maximum number of samplers with custom border colors which can be simultaneously created on a device is implementation-dependent and specified by the maxCustomBorderColorSamplers member of the VkPhysicalDeviceCustomBorderColorPropertiesEXT structure", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-addressModeU-01078", "If any of addressModeU, addressModeV or addressModeW are VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER, borderColor must be a valid VkBorderColor value", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-addressModeU-01079", "If samplerMirrorClampToEdge is not enabled, and if the VK_KHR_sampler_mirror_clamp_to_edge extension is not enabled, addressModeU, addressModeV and addressModeW must not be VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-addressModeU-01646", "If sampler {YCbCr} conversion is enabled, addressModeU, addressModeV, and addressModeW must be VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE, anisotropyEnable must be VK_FALSE, and unnormalizedCoordinates must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-addressModeU-parameter", "addressModeU must be a valid VkSamplerAddressMode value", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-addressModeV-parameter", "addressModeV must be a valid VkSamplerAddressMode value", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-addressModeW-parameter", "addressModeW must be a valid VkSamplerAddressMode value", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-anisotropyEnable-01070", "If the anisotropic sampling feature is not enabled, anisotropyEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-anisotropyEnable-01071", "If anisotropyEnable is VK_TRUE, maxAnisotropy must be between 1.0 and VkPhysicalDeviceLimits::maxSamplerAnisotropy, inclusive", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-borderColor-04011", "If borderColor is one of VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT, then a VkSamplerCustomBorderColorCreateInfoEXT must be present in the pNext chain", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-borderColor-04442", "If borderColor is one of VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT, and VkSamplerCustomBorderColorCreateInfoEXT::format is not VK_FORMAT_UNDEFINED, VkSamplerCustomBorderColorCreateInfoEXT::customBorderColor must be within the range of values representable in format.", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-compareEnable-01080", "If compareEnable is VK_TRUE, compareOp must be a valid VkCompareOp value", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-compareEnable-01423", "If compareEnable is VK_TRUE, the reductionMode member of VkSamplerReductionModeCreateInfo must be VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-customBorderColors-04085", "If the customBorderColors feature is not enabled, borderColor must not be VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-flags-02574", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then minFilter and magFilter must be equal", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-flags-02575", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then mipmapMode must be VK_SAMPLER_MIPMAP_MODE_NEAREST", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-flags-02576", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then minLod and maxLod must be zero", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-flags-02577", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then addressModeU and addressModeV must each be either VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE or VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-flags-02578", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then anisotropyEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-flags-02579", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then compareEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-flags-02580", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then unnormalizedCoordinates must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-flags-parameter", "flags must be a valid combination of VkSamplerCreateFlagBits values", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-magFilter-01081", "If either magFilter or minFilter is VK_FILTER_CUBIC_EXT, anisotropyEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-magFilter-01422", "If either magFilter or minFilter is VK_FILTER_CUBIC_EXT, the reductionMode member of VkSamplerReductionModeCreateInfo must be VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE", "default"},
    {"VUID-VkSamplerCreateInfo-magFilter-parameter", "magFilter must be a valid VkFilter value", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-maxLod-01973", "maxLod must be greater than or equal to minLod", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-minFilter-01645", "If sampler {YCbCr} conversion is enabled and the potential format features of the sampler {YCbCr} conversion do not support VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT, minFilter and magFilter must be equal to the sampler {YCbCr} conversion's chromaFilter", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-minFilter-parameter", "minFilter must be a valid VkFilter value", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-mipLodBias-01069", "The absolute value of mipLodBias must be less than or equal to VkPhysicalDeviceLimits::maxSamplerLodBias", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-mipmapMode-parameter", "mipmapMode must be a valid VkSamplerMipmapMode value", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkSamplerCustomBorderColorCreateInfoEXT, VkSamplerReductionModeCreateInfo, or VkSamplerYcbcrConversionInfo", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-samplerMipLodBias-04467", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::samplerMipLodBias is VK_FALSE, mipLodBias must be zero.", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01072", "If unnormalizedCoordinates is VK_TRUE, minFilter and magFilter must be equal", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01073", "If unnormalizedCoordinates is VK_TRUE, mipmapMode must be VK_SAMPLER_MIPMAP_MODE_NEAREST", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01074", "If unnormalizedCoordinates is VK_TRUE, minLod and maxLod must be zero", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01075", "If unnormalizedCoordinates is VK_TRUE, addressModeU and addressModeV must each be either VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE or VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01076", "If unnormalizedCoordinates is VK_TRUE, anisotropyEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01077", "If unnormalizedCoordinates is VK_TRUE, compareEnable must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerCustomBorderColorCreateInfoEXT-format-04013", "If provided format is not VK_FORMAT_UNDEFINED then the VkSamplerCreateInfo::borderColor type must match the sampled type of the provided format, as shown in the SPIR-V Sampled Type column of the Interpretation of Numeric Format table", "1.2-extensions"},
    {"VUID-VkSamplerCustomBorderColorCreateInfoEXT-format-04014", "If the customBorderColorWithoutFormat feature is not enabled then format must not be VK_FORMAT_UNDEFINED", "1.2-extensions"},
    {"VUID-VkSamplerCustomBorderColorCreateInfoEXT-format-04015", "If the sampler is used to sample an image view of VK_FORMAT_B4G4R4A4_UNORM_PACK16, VK_FORMAT_B5G6R5_UNORM_PACK16, or VK_FORMAT_B5G5R5A1_UNORM_PACK16 format then format must not be VK_FORMAT_UNDEFINED", "1.2-extensions"},
    {"VUID-VkSamplerCustomBorderColorCreateInfoEXT-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkSamplerCustomBorderColorCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkSamplerReductionModeCreateInfo-reductionMode-parameter", "reductionMode must be a valid VkSamplerReductionMode value", "1.2-extensions"},
    {"VUID-VkSamplerReductionModeCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-chromaFilter-01657", "If the potential format features of the sampler {YCbCr} conversion do not support VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT, chromaFilter must not be VK_FILTER_LINEAR", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-chromaFilter-parameter", "chromaFilter must be a valid VkFilter value", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02581", "If the format has a _422 or _420 suffix, then components.g must be the identity swizzle", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02582", "If the format has a _422 or _420 suffix, then components.a must be the identity swizzle, VK_COMPONENT_SWIZZLE_ONE, or VK_COMPONENT_SWIZZLE_ZERO", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02583", "If the format has a _422 or _420 suffix, then components.r must be the identity swizzle or VK_COMPONENT_SWIZZLE_B", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02584", "If the format has a _422 or _420 suffix, then components.b must be the identity swizzle or VK_COMPONENT_SWIZZLE_R", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02585", "If the format has a _422 or _420 suffix, and if either components.r or components.b is the identity swizzle, both values must be the identity swizzle", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-parameter", "components must be a valid VkComponentMapping structure", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-forceExplicitReconstruction-01656", "If the potential format features of the sampler {YCbCr} conversion do not support VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT forceExplicitReconstruction must be VK_FALSE", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-01650", "The potential format features of the sampler {YCbCr} conversion must support VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT or VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-01904", "If an external format conversion is being created, format must be VK_FORMAT_UNDEFINED", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-04060", "format must represent unsigned normalized values (i.e. the format must be a UNORM format)", "1.2-khr-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-04061", "If an external format conversion is not being created, format must represent unsigned normalized values (i.e. the format must be a UNORM format)", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkExternalFormatANDROID", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-01651", "If the potential format features of the sampler {YCbCr} conversion do not support VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT, xChromaOffset and yChromaOffset must not be VK_CHROMA_LOCATION_COSITED_EVEN if the corresponding channels are downsampled", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-01652", "If the potential format features of the sampler {YCbCr} conversion do not support VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT, xChromaOffset and yChromaOffset must not be VK_CHROMA_LOCATION_MIDPOINT if the corresponding channels are downsampled", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-parameter", "xChromaOffset must be a valid VkChromaLocation value", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-yChromaOffset-parameter", "yChromaOffset must be a valid VkChromaLocation value", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrModel-01655", "If ycbcrModel is not VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY, then components.r, components.g, and components.b must correspond to channels of the format; that is, components.r, components.g, and components.b must not be VK_COMPONENT_SWIZZLE_ZERO or VK_COMPONENT_SWIZZLE_ONE, and must not correspond to a channel which contains zero or one as a consequence of conversion to RGBA", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrModel-parameter", "ycbcrModel must be a valid VkSamplerYcbcrModelConversion value", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrRange-02748", "If ycbcrRange is VK_SAMPLER_YCBCR_RANGE_ITU_NARROW then the R, G and B channels obtained by applying the component swizzle to format must each have a bit-depth greater than or equal to 8", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrRange-parameter", "ycbcrRange must be a valid VkSamplerYcbcrRange value", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionImageFormatProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionInfo-conversion-parameter", "conversion must be a valid VkSamplerYcbcrConversion handle", "1.2-extensions"},
    {"VUID-VkSamplerYcbcrConversionInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO", "1.2-extensions"},
    {"VUID-VkScreenSurfaceCreateInfoQNX-context-04741", "context must point to a valid QNX Screen struct _screen_context", "1.2-extensions"},
    {"VUID-VkScreenSurfaceCreateInfoQNX-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkScreenSurfaceCreateInfoQNX-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkScreenSurfaceCreateInfoQNX-sType-sType", "sType must be VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX", "1.2-extensions"},
    {"VUID-VkScreenSurfaceCreateInfoQNX-window-04742", "window must point to a valid QNX Screen struct _screen_window", "1.2-extensions"},
    {"VUID-VkSemaphoreCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkSemaphoreCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportSemaphoreCreateInfo, VkExportSemaphoreWin32HandleInfoKHR, or VkSemaphoreTypeCreateInfo", "1.2-extensions"},
    {"VUID-VkSemaphoreCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkSemaphoreCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-01132", "handleType must have been included in VkExportSemaphoreCreateInfo::handleTypes when semaphore's current payload was created", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-01134", "If handleType refers to a handle type with copy payload transference semantics, as defined below in Importing Semaphore Payloads, there must be no queue waiting on semaphore", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-01135", "If handleType refers to a handle type with copy payload transference semantics, semaphore must be signaled, or have an associated semaphore signal operation pending execution", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-01136", "handleType must be defined as a POSIX file descriptor handle", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-03253", "If handleType refers to a handle type with copy payload transference semantics, semaphore must have been created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-03254", "If handleType refers to a handle type with copy payload transference semantics, semaphore must have an associated semaphore signal operation that has been submitted for execution and any semaphore signal operations on which it depends (if any) must have also been submitted for execution", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-semaphore-01133", "semaphore must not currently have its payload replaced by an imported payload as described below in Importing Semaphore Payloads unless that imported payload's handle type was included in VkExternalSemaphoreProperties::exportFromImportedHandleTypes for handleType", "1.2-extensions"},
    {"VUID-VkSemaphoreGetFdInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01126", "handleType must have been included in VkExportSemaphoreCreateInfo::handleTypes when the semaphore's current payload was created", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01127", "If handleType is defined as an NT handle, vkGetSemaphoreWin32HandleKHR must be called no more than once for each valid unique combination of semaphore and handleType", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01129", "If handleType refers to a handle type with copy payload transference semantics, as defined below in Importing Semaphore Payloads, there must be no queue waiting on semaphore", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01130", "If handleType refers to a handle type with copy payload transference semantics, semaphore must be signaled, or have an associated semaphore signal operation pending execution", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01131", "handleType must be defined as an NT handle or a global share handle", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-semaphore-01128", "semaphore must not currently have its payload replaced by an imported payload as described below in Importing Semaphore Payloads unless that imported payload's handle type was included in VkExternalSemaphoreProperties::exportFromImportedHandleTypes for handleType", "1.2-extensions"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-handleType-04758", "handleType must have been included in VkExportSemaphoreCreateInfo::handleTypes when semaphore's current payload was created.", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-handleType-04760", "If handleType refers to a handle type with copy payload transference semantics, as defined below in Importing Semaphore Payloads, there must be no queue waiting on semaphore.", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-handleType-04761", "If handleType refers to a handle type with copy payload transference semantics, semaphore must be signaled, or have an associated semaphore signal operation pending execution.", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-handleType-04762", "handleType must be defined as a Zircon event handle.", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-semaphore-04759", "semaphore must not currently have its payload replaced by an imported payload as described below in Importing Semaphore Payloads unless that imported payload's handle type was included in VkExternalSemaphoreProperties::exportFromImportedHandleTypes for handleType.", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-semaphore-04763", "semaphore must have been created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY.", "1.2-extensions"},
    {"VUID-VkSemaphoreGetZirconHandleInfoFUCHSIA-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkSemaphoreSignalInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSemaphoreSignalInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO", "1.2-extensions"},
    {"VUID-VkSemaphoreSignalInfo-semaphore-03257", "semaphore must have been created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE", "1.2-extensions"},
    {"VUID-VkSemaphoreSignalInfo-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkSemaphoreSignalInfo-value-03258", "value must have a value greater than the current value of the semaphore", "1.2-extensions"},
    {"VUID-VkSemaphoreSignalInfo-value-03259", "value must be less than the value of any pending semaphore signal operations", "1.2-extensions"},
    {"VUID-VkSemaphoreSignalInfo-value-03260", "value must have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on semaphore by more than maxTimelineSemaphoreValueDifference", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-device-03888", "If the device that semaphore was created on is not a device group, deviceIndex must be 0", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-device-03889", "If the device that semaphore was created on is a device group, deviceIndex must be a valid device index", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-03929", "If the geometry shaders feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-03930", "If the tessellation shaders feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-03931", "If the conditional rendering feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-03932", "If the fragment density map feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-03933", "If the transform feedback feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-03934", "If the mesh shaders feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-03935", "If the task shaders feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-04956", "If the shading rate image feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-04957", "If the subpass shading feature is not enabled, pname:stageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI", "1.2-extensions"},
    {"VUID-VkSemaphoreSubmitInfoKHR-stageMask-parameter", "stageMask must be a valid combination of VkPipelineStageFlagBits2KHR values", "1.2-extensions"},
    {"VUID-VkSemaphoreTypeCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkSemaphoreTypeCreateInfo-semaphoreType-03279", "If semaphoreType is VK_SEMAPHORE_TYPE_BINARY, initialValue must be zero", "1.2-extensions"},
    {"VUID-VkSemaphoreTypeCreateInfo-semaphoreType-parameter", "semaphoreType must be a valid VkSemaphoreType value", "1.2-extensions"},
    {"VUID-VkSemaphoreTypeCreateInfo-timelineSemaphore-03252", "If the timelineSemaphore feature is not enabled, semaphoreType must not equal VK_SEMAPHORE_TYPE_TIMELINE", "1.2-extensions"},
    {"VUID-VkSemaphoreWaitInfo-flags-parameter", "flags must be a valid combination of VkSemaphoreWaitFlagBits values", "1.2-extensions"},
    {"VUID-VkSemaphoreWaitInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSemaphoreWaitInfo-pSemaphores-03256", "All of the elements of pSemaphores must reference a semaphore that was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE", "1.2-extensions"},
    {"VUID-VkSemaphoreWaitInfo-pSemaphores-parameter", "pSemaphores must be a valid pointer to an array of semaphoreCount valid VkSemaphore handles", "1.2-extensions"},
    {"VUID-VkSemaphoreWaitInfo-pValues-parameter", "pValues must be a valid pointer to an array of semaphoreCount uint64_t values", "1.2-extensions"},
    {"VUID-VkSemaphoreWaitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO", "1.2-extensions"},
    {"VUID-VkSemaphoreWaitInfo-semaphoreCount-arraylength", "semaphoreCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-codeSize-01085", "codeSize must be greater than 0", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-codeSize-01086", "codeSize must be a multiple of 4", "1.2-khr-extensions"},
    {"VUID-VkShaderModuleCreateInfo-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01087", "pCode must point to valid SPIR-V code, formatted and packed as described by the Khronos SPIR-V Specification", "1.2-khr-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01088", "pCode must adhere to the validation rules described by the Validation Rules within a Module section of the SPIR-V Environment appendix", "1.2-khr-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01089", "pCode must declare the Shader capability for SPIR-V code", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01090", "pCode must not declare any capability that is not supported by the API, as described by the Capabilities section of the SPIR-V Environment appendix", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01091", "If pCode declares any of the capabilities listed in the SPIR-V Environment appendix, one of the corresponding requirements must be satisfied", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01376", "If pCode is a pointer to SPIR-V code, codeSize must be a multiple of 4", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01377", "pCode must point to either valid SPIR-V code, formatted and packed as described by the Khronos SPIR-V Specification or valid GLSL code which must be written to the GL_KHR_vulkan_glsl extension specification", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01378", "If pCode is a pointer to SPIR-V code, that code must adhere to the validation rules described by the Validation Rules within a Module section of the SPIR-V Environment appendix", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01379", "If pCode is a pointer to GLSL code, it must be valid GLSL code written to the GL_KHR_vulkan_glsl GLSL extension specification", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-04146", "pCode must not declare any SPIR-V extension that is not supported by the API, as described by the Extension section of the SPIR-V Environment appendix", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-04147", "If pCode declares any of the SPIR-V extensions listed in the SPIR-V Environment appendix, one of the corresponding requirements must be satisfied", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pCode-parameter", "pCode must be a valid pointer to an array of (codeSize/4) uint32_t values", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkShaderModuleValidationCacheCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO", "1.2-extensions"},
    {"VUID-VkShaderModuleCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkShaderModuleValidationCacheCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkShaderModuleValidationCacheCreateInfoEXT-validationCache-parameter", "validationCache must be a valid VkValidationCacheEXT handle", "1.2-extensions"},
    {"VUID-VkShadingRatePaletteNV-pShadingRatePaletteEntries-parameter", "pShadingRatePaletteEntries must be a valid pointer to an array of shadingRatePaletteEntryCount valid VkShadingRatePaletteEntryNV values", "1.2-extensions"},
    {"VUID-VkShadingRatePaletteNV-shadingRatePaletteEntryCount-02071", "shadingRatePaletteEntryCount must be between 1 and VkPhysicalDeviceShadingRateImagePropertiesNV::shadingRatePaletteSize, inclusive", "1.2-extensions"},
    {"VUID-VkShadingRatePaletteNV-shadingRatePaletteEntryCount-arraylength", "shadingRatePaletteEntryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkSharedPresentSurfaceCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR", "1.2-extensions"},
    {"VUID-VkSparseBufferMemoryBindInfo-bindCount-arraylength", "bindCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkSparseBufferMemoryBindInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkSparseBufferMemoryBindInfo-pBinds-parameter", "pBinds must be a valid pointer to an array of bindCount valid VkSparseMemoryBind structures", "1.2-extensions"},
    {"VUID-VkSparseImageFormatProperties2-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSparseImageFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-extent-01108", "extent.width must either be a multiple of the sparse image block width of the image, or else (extent.width + offset.x) must equal the width of the image subresource", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-extent-01110", "extent.height must either be a multiple of the sparse image block height of the image, or else (extent.height + offset.y) must equal the height of the image subresource", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-extent-01112", "extent.depth must either be a multiple of the sparse image block depth of the image, or else (extent.depth + offset.z) must equal the depth of the image subresource", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-flags-parameter", "flags must be a valid combination of VkSparseMemoryBindFlagBits values", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-memory-01104", "If the sparse aliased residency feature is not enabled, and if any other resources are bound to ranges of memory, the range of memory being bound must not overlap with those bound ranges", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-memory-01105", "memory and memoryOffset must match the memory requirements of the calling command's image, as described in section Resource Memory Association", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-memory-02732", "If memory was created with VkExportMemoryAllocateInfo::handleTypes not equal to 0, at least one handle type it contained must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when the image was created", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-memory-02733", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-memory-parameter", "If memory is not VK_NULL_HANDLE, memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-offset-01107", "offset.x must be a multiple of the sparse image block width (VkSparseImageFormatProperties::imageGranularity.width) of the image", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-offset-01109", "offset.y must be a multiple of the sparse image block height (VkSparseImageFormatProperties::imageGranularity.height) of the image", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-offset-01111", "offset.z must be a multiple of the sparse image block depth (VkSparseImageFormatProperties::imageGranularity.depth) of the image", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-subresource-01106", "subresource must be a valid image subresource for image (see Image Views)", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBind-subresource-parameter", "subresource must be a valid VkImageSubresource structure", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBindInfo-bindCount-arraylength", "bindCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBindInfo-image-02901", "image must have been created with VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT set", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBindInfo-image-parameter", "image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBindInfo-pBinds-parameter", "pBinds must be a valid pointer to an array of bindCount valid VkSparseImageMemoryBind structures", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBindInfo-subresource-01722", "The subresource.mipLevel member of each element of pBinds must be less than the mipLevels specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryBindInfo-subresource-01723", "The subresource.arrayLayer member of each element of pBinds must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryRequirements2-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSparseImageMemoryRequirements2-sType-sType", "sType must be VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2", "1.2-extensions"},
    {"VUID-VkSparseImageOpaqueMemoryBindInfo-bindCount-arraylength", "bindCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkSparseImageOpaqueMemoryBindInfo-image-parameter", "image must be a valid VkImage handle", "1.2-extensions"},
    {"VUID-VkSparseImageOpaqueMemoryBindInfo-pBinds-01103", "If the flags member of any element of pBinds contains VK_SPARSE_MEMORY_BIND_METADATA_BIT, the binding range defined must be within the mip tail region of the metadata aspect of image", "1.2-extensions"},
    {"VUID-VkSparseImageOpaqueMemoryBindInfo-pBinds-parameter", "pBinds must be a valid pointer to an array of bindCount valid VkSparseMemoryBind structures", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-flags-parameter", "flags must be a valid combination of VkSparseMemoryBindFlagBits values", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-memory-01096", "If memory is not VK_NULL_HANDLE, memory and memoryOffset must match the memory requirements of the resource, as described in section Resource Memory Association", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-memory-01097", "If memory is not VK_NULL_HANDLE, memory must not have been created with a memory type that reports VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT bit set", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-memory-02730", "If memory was created with VkExportMemoryAllocateInfo::handleTypes not equal to 0, at least one handle type it contained must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes or VkExternalMemoryImageCreateInfo::handleTypes when the resource was created", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-memory-02731", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes or VkExternalMemoryImageCreateInfo::handleTypes when the resource was created", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-memory-parameter", "If memory is not VK_NULL_HANDLE, memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-memoryOffset-01101", "memoryOffset must be less than the size of memory", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-resourceOffset-01099", "resourceOffset must be less than the size of the resource", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-size-01098", "size must be greater than 0", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-size-01100", "size must be less than or equal to the size of the resource minus resourceOffset", "1.2-extensions"},
    {"VUID-VkSparseMemoryBind-size-01102", "size must be less than or equal to the size of memory minus memoryOffset", "1.2-extensions"},
    {"VUID-VkSpecializationInfo-constantID-04911", "The constantID value of each element of pMapEntries must be unique within pMapEntries", "1.2-extensions"},
    {"VUID-VkSpecializationInfo-offset-00773", "The offset member of each element of pMapEntries must be less than dataSize", "1.2-extensions"},
    {"VUID-VkSpecializationInfo-pData-parameter", "If dataSize is not 0, pData must be a valid pointer to an array of dataSize bytes", "1.2-extensions"},
    {"VUID-VkSpecializationInfo-pMapEntries-00774", "The size member of each element of pMapEntries must be less than or equal to dataSize minus offset", "1.2-extensions"},
    {"VUID-VkSpecializationInfo-pMapEntries-parameter", "If mapEntryCount is not 0, pMapEntries must be a valid pointer to an array of mapEntryCount valid VkSpecializationMapEntry structures", "1.2-extensions"},
    {"VUID-VkSpecializationMapEntry-constantID-00776", "For a constantID specialization constant declared in a shader, size must match the byte size of the constantID. If the specialization constant is of type boolean, size must be the byte size of VkBool32", "1.2-extensions"},
    {"VUID-VkStencilOpState-compareOp-parameter", "compareOp must be a valid VkCompareOp value", "1.2-extensions"},
    {"VUID-VkStencilOpState-depthFailOp-parameter", "depthFailOp must be a valid VkStencilOp value", "1.2-extensions"},
    {"VUID-VkStencilOpState-failOp-parameter", "failOp must be a valid VkStencilOp value", "1.2-extensions"},
    {"VUID-VkStencilOpState-passOp-parameter", "passOp must be a valid VkStencilOp value", "1.2-extensions"},
    {"VUID-VkStreamDescriptorSurfaceCreateInfoGGP-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkStreamDescriptorSurfaceCreateInfoGGP-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkStreamDescriptorSurfaceCreateInfoGGP-sType-sType", "sType must be VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP", "1.2-extensions"},
    {"VUID-VkStreamDescriptorSurfaceCreateInfoGGP-streamDescriptor-02681", "streamDescriptor must be a valid GgpStreamDescriptor", "1.2-extensions"},
    {"VUID-VkStridedDeviceAddressRegionKHR-size-04631", "If size is not zero, all addresses between deviceAddress and deviceAddress + size - 1 must be in the buffer device address range of the same buffer", "1.2-extensions"},
    {"VUID-VkStridedDeviceAddressRegionKHR-size-04632", "If size is not zero, stride must be less than or equal to the size of the buffer from which deviceAddress was queried", "1.2-extensions"},
    {"VUID-VkSubmitInfo-commonparent", "Each of the elements of pCommandBuffers, the elements of pSignalSemaphores, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pCommandBuffers-00075", "Each element of pCommandBuffers must not have been allocated with VK_COMMAND_BUFFER_LEVEL_SECONDARY", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pCommandBuffers-parameter", "If commandBufferCount is not 0, pCommandBuffers must be a valid pointer to an array of commandBufferCount valid VkCommandBuffer handles", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pNext-03240", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pWaitSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE, then its waitSemaphoreValueCount member must equal waitSemaphoreCount", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pNext-03241", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE, then its signalSemaphoreValueCount member must equal signalSemaphoreCount", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pNext-04120", "If the pNext chain of this structure does not include a VkProtectedSubmitInfo structure with protectedSubmit set to VK_TRUE, then each element of the pCommandBuffers array must be an unprotected command buffer", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pNext-04148", "If the pNext chain of this structure includes a VkProtectedSubmitInfo structure with protectedSubmit set to VK_TRUE, then each element of the pCommandBuffers array must be a protected command buffer", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkD3D12FenceSubmitInfoKHR, VkDeviceGroupSubmitInfo, VkPerformanceQuerySubmitInfoKHR, VkProtectedSubmitInfo, VkTimelineSemaphoreSubmitInfo, VkWin32KeyedMutexAcquireReleaseInfoKHR, or VkWin32KeyedMutexAcquireReleaseInfoNV", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pSignalSemaphores-03242", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value greater than the current value of the semaphore when the semaphore signal operation is executed", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pSignalSemaphores-03244", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pSignalSemaphores-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphores must be a valid pointer to an array of signalSemaphoreCount valid VkSemaphore handles", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-00076", "If the geometry shaders feature is not enabled, each element of pWaitDstStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-00077", "If the tessellation shaders feature is not enabled, each element of pWaitDstStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-00078", "Each element of pWaitDstStageMask must not include VK_PIPELINE_STAGE_HOST_BIT", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-02089", "If the mesh shaders feature is not enabled, each element of pWaitDstStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-02090", "If the task shaders feature is not enabled, each element of pWaitDstStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-parameter", "If waitSemaphoreCount is not 0, pWaitDstStageMask must be a valid pointer to an array of waitSemaphoreCount valid combinations of VkPipelineStageFlagBits values", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-requiredbitmask", "Each element of pWaitDstStageMask must not be 0", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitSemaphores-03239", "If any element of pWaitSemaphores or pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE, then the pNext chain must include a VkTimelineSemaphoreSubmitInfo structure", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitSemaphores-03243", "For each element of pWaitSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pWaitSemaphoreValues must have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "1.2-extensions"},
    {"VUID-VkSubmitInfo-pWaitSemaphores-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles", "1.2-extensions"},
    {"VUID-VkSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBMIT_INFO", "1.2-extensions"},
    {"VUID-VkSubmitInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-flags-03885", "If the protected memory feature is not enabled, flags must not include VK_SUBMIT_PROTECTED_BIT_KHR", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-flags-03886", "If flags includes VK_SUBMIT_PROTECTED_BIT_KHR, all elements of pCommandBuffers must be protected command buffers", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-flags-03887", "If flags does not include VK_SUBMIT_PROTECTED_BIT_KHR, each element of pCommandBuffers must not be a protected command buffer", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-flags-parameter", "flags must be a valid combination of VkSubmitFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-pCommandBufferInfos-parameter", "If commandBufferInfoCount is not 0, pCommandBufferInfos must be a valid pointer to an array of commandBufferInfoCount valid VkCommandBufferSubmitInfoKHR structures", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPerformanceQuerySubmitInfoKHR, VkWin32KeyedMutexAcquireReleaseInfoKHR, or VkWin32KeyedMutexAcquireReleaseInfoNV", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-pSignalSemaphoreInfos-parameter", "If signalSemaphoreInfoCount is not 0, pSignalSemaphoreInfos must be a valid pointer to an array of signalSemaphoreInfoCount valid VkSemaphoreSubmitInfoKHR structures", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-pWaitSemaphoreInfos-parameter", "If waitSemaphoreInfoCount is not 0, pWaitSemaphoreInfos must be a valid pointer to an array of waitSemaphoreInfoCount valid VkSemaphoreSubmitInfoKHR structures", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBMIT_INFO_2_KHR", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-semaphore-03881", "If the same semaphore is used as the semaphore member of both an element of pSignalSemaphoreInfos and pWaitSemaphoreInfos, and that semaphore is a timeline semaphore, the value member of the pSignalSemaphoreInfos element must be greater than the value member of the pWaitSemaphoreInfos element", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-semaphore-03882", "If the semaphore member of any element of pSignalSemaphoreInfos is a timeline semaphore, the value member of that element must have a value greater than the current value of the semaphore when the semaphore signal operation is executed", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-semaphore-03883", "If the semaphore member of any element of pSignalSemaphoreInfos is a timeline semaphore, the value member of that element must have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "1.2-extensions"},
    {"VUID-VkSubmitInfo2KHR-semaphore-03884", "If the semaphore member of any element of pWaitSemaphoreInfos is a timeline semaphore, the value member of that element must have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "1.2-extensions"},
    {"VUID-VkSubpassBeginInfo-contents-parameter", "contents must be a valid VkSubpassContents value", "1.2-extensions"},
    {"VUID-VkSubpassBeginInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSubpassBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dependencyFlags-02520", "If dependencyFlags includes VK_DEPENDENCY_VIEW_LOCAL_BIT, srcSubpass must not be equal to VK_SUBPASS_EXTERNAL", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dependencyFlags-02521", "If dependencyFlags includes VK_DEPENDENCY_VIEW_LOCAL_BIT, dstSubpass must not be equal to VK_SUBPASS_EXTERNAL", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dependencyFlags-parameter", "dependencyFlags must be a valid combination of VkDependencyFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dstAccessMask-00869", "Any access flag included in dstAccessMask must be supported by one of the pipeline stages in dstStageMask, as specified in the table of supported access types", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dstStageMask-00861", "If the geometry shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dstStageMask-00863", "If the tessellation shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dstStageMask-02101", "If the mesh shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dstStageMask-02102", "If the task shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubpassDependency-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcAccessMask-00868", "Any access flag included in srcAccessMask must be supported by one of the pipeline stages in srcStageMask, as specified in the table of supported access types", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcStageMask-00860", "If the geometry shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcStageMask-00862", "If the tessellation shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcStageMask-02099", "If the mesh shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcStageMask-02100", "If the task shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcSubpass-00864", "srcSubpass must be less than or equal to dstSubpass, unless one of them is VK_SUBPASS_EXTERNAL, to avoid cyclic dependencies and ensure a valid execution order", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcSubpass-00865", "srcSubpass and dstSubpass must not both be equal to VK_SUBPASS_EXTERNAL", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcSubpass-00867", "If srcSubpass is equal to dstSubpass and not all of the stages in srcStageMask and dstStageMask are framebuffer-space stages, the logically latest pipeline stage in srcStageMask must be logically earlier than or equal to the logically earliest pipeline stage in dstStageMask", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcSubpass-00872", "If srcSubpass equals dstSubpass and that subpass has more than one bit set in the view mask, then dependencyFlags must include VK_DEPENDENCY_VIEW_LOCAL_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency-srcSubpass-02243", "If srcSubpass equals dstSubpass, and srcStageMask and dstStageMask both include a framebuffer-space stage, then dependencyFlags must include VK_DEPENDENCY_BY_REGION_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dependencyFlags-03090", "If dependencyFlags includes VK_DEPENDENCY_VIEW_LOCAL_BIT, srcSubpass must not be equal to VK_SUBPASS_EXTERNAL", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dependencyFlags-03091", "If dependencyFlags includes VK_DEPENDENCY_VIEW_LOCAL_BIT, dstSubpass must not be equal to VK_SUBPASS_EXTERNAL", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dependencyFlags-03092", "If dependencyFlags does not include VK_DEPENDENCY_VIEW_LOCAL_BIT, viewOffset must be 0", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dependencyFlags-parameter", "dependencyFlags must be a valid combination of VkDependencyFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dstAccessMask-03089", "Any access flag included in dstAccessMask must be supported by one of the pipeline stages in dstStageMask, as specified in the table of supported access types", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dstStageMask-02105", "If the mesh shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dstStageMask-02106", "If the task shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dstStageMask-03081", "If the geometry shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dstStageMask-03083", "If the tessellation shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkMemoryBarrier2KHR", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcAccessMask-03088", "Any access flag included in srcAccessMask must be supported by one of the pipeline stages in srcStageMask, as specified in the table of supported access types", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcStageMask-02103", "If the mesh shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcStageMask-02104", "If the task shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcStageMask-03080", "If the geometry shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcStageMask-03082", "If the tessellation shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcSubpass-02245", "If srcSubpass equals dstSubpass, and srcStageMask and dstStageMask both include a framebuffer-space stage, then dependencyFlags must include VK_DEPENDENCY_BY_REGION_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcSubpass-03084", "srcSubpass must be less than or equal to dstSubpass, unless one of them is VK_SUBPASS_EXTERNAL, to avoid cyclic dependencies and ensure a valid execution order", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcSubpass-03085", "srcSubpass and dstSubpass must not both be equal to VK_SUBPASS_EXTERNAL", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-srcSubpass-03087", "If srcSubpass is equal to dstSubpass and not all of the stages in srcStageMask and dstStageMask are framebuffer-space stages, the logically latest pipeline stage in srcStageMask must be logically earlier than or equal to the logically earliest pipeline stage in dstStageMask", "1.2-extensions"},
    {"VUID-VkSubpassDependency2-viewOffset-02530", "If viewOffset is not equal to 0, srcSubpass must not be equal to dstSubpass", "1.2-extensions"},
    {"VUID-VkSubpassDescription-None-04437", "Each attachment must follow the image layout requirements specified for its attachment type", "1.2-extensions"},
    {"VUID-VkSubpassDescription-attachment-00853", "Each element of pPreserveAttachments must not be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription-colorAttachmentCount-00845", "colorAttachmentCount must be less than or equal to VkPhysicalDeviceLimits::maxColorAttachments", "1.2-extensions"},
    {"VUID-VkSubpassDescription-flags-00856", "If flags includes VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX, it must also include VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX", "1.2-extensions"},
    {"VUID-VkSubpassDescription-flags-03341", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if pResolveAttachments is not NULL, then each resolve attachment must be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription-flags-03342", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if pDepthStencilResolveAttachmentKHR is not NULL, then the depth/stencil resolve attachment must be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription-flags-03343", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, then the subpass must be the last subpass in a subpass dependency chain", "1.2-extensions"},
    {"VUID-VkSubpassDescription-flags-parameter", "flags must be a valid combination of VkSubpassDescriptionFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDescription-layout-02519", "If any attachment is used by more than one VkAttachmentReference member, then each use must use the same layout", "1.2-extensions"},
    {"VUID-VkSubpassDescription-loadOp-00846", "If the first use of an attachment in this render pass is as an input attachment, and the attachment is not also used as a color or depth/stencil attachment in the same subpass, then loadOp must not be VK_ATTACHMENT_LOAD_OP_CLEAR", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pColorAttachments-01417", "All attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have the same sample count", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pColorAttachments-01506", "If the VK_AMD_mixed_attachment_samples extension is enabled, and all attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have a sample count that is smaller than or equal to the sample count of pDepthStencilAttachment if it is not VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pColorAttachments-02648", "All attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have image formats whose potential format features contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pColorAttachments-parameter", "If colorAttachmentCount is not 0, pColorAttachments must be a valid pointer to an array of colorAttachmentCount valid VkAttachmentReference structures", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pDepthStencilAttachment-01418", "If neither the VK_AMD_mixed_attachment_samples nor the VK_NV_framebuffer_mixed_samples extensions are enabled, and if pDepthStencilAttachment is not VK_ATTACHMENT_UNUSED and any attachments in pColorAttachments are not VK_ATTACHMENT_UNUSED, they must have the same sample count", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pDepthStencilAttachment-02650", "If pDepthStencilAttachment is not NULL and the attachment is not VK_ATTACHMENT_UNUSED then it must have an image format whose potential format features contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pDepthStencilAttachment-04438", "pDepthStencilAttachment and pColorAttachments must not contain references to the same attachment", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pDepthStencilAttachment-parameter", "If pDepthStencilAttachment is not NULL, pDepthStencilAttachment must be a valid pointer to a valid VkAttachmentReference structure", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pInputAttachments-02647", "All attachments in pInputAttachments that are not VK_ATTACHMENT_UNUSED must have image formats whose potential format features contain at least VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pInputAttachments-02868", "If the render pass is created with VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM each of the elements of pInputAttachments must be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pInputAttachments-parameter", "If inputAttachmentCount is not 0, pInputAttachments must be a valid pointer to an array of inputAttachmentCount valid VkAttachmentReference structures", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pPreserveAttachments-00854", "Each element of pPreserveAttachments must not also be an element of any other member of the subpass description", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pPreserveAttachments-parameter", "If preserveAttachmentCount is not 0, pPreserveAttachments must be a valid pointer to an array of preserveAttachmentCount uint32_t values", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pResolveAttachments-00847", "If pResolveAttachments is not NULL, for each resolve attachment that is not VK_ATTACHMENT_UNUSED, the corresponding color attachment must not be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pResolveAttachments-00848", "If pResolveAttachments is not NULL, for each resolve attachment that is not VK_ATTACHMENT_UNUSED, the corresponding color attachment must not have a sample count of VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pResolveAttachments-00849", "If pResolveAttachments is not NULL, each resolve attachment that is not VK_ATTACHMENT_UNUSED must have a sample count of VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pResolveAttachments-00850", "If pResolveAttachments is not NULL, each resolve attachment that is not VK_ATTACHMENT_UNUSED must have the same VkFormat as its corresponding color attachment", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pResolveAttachments-02649", "All attachments in pResolveAttachments that are not VK_ATTACHMENT_UNUSED must have image formats whose potential format features contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pResolveAttachments-parameter", "If colorAttachmentCount is not 0, and pResolveAttachments is not NULL, pResolveAttachments must be a valid pointer to an array of colorAttachmentCount valid VkAttachmentReference structures", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pipelineBindPoint-00844", "pipelineBindPoint must be VK_PIPELINE_BIND_POINT_GRAPHICS", "1.2-khr-extensions"},
    {"VUID-VkSubpassDescription-pipelineBindPoint-04952", "pipelineBindPoint must be VK_PIPELINE_BIND_POINT_GRAPHICS or VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI", "1.2-extensions"},
    {"VUID-VkSubpassDescription-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-None-04439", "Attachments must follow the image layout requirements based on the type of attachment it is being used as", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-attachment-02799", "If the attachment member of any element of pInputAttachments is not VK_ATTACHMENT_UNUSED, then the aspectMask member must be a valid combination of VkImageAspectFlagBits", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-attachment-02800", "If the attachment member of any element of pInputAttachments is not VK_ATTACHMENT_UNUSED, then the aspectMask member must not be 0", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-attachment-02801", "If the attachment member of any element of pInputAttachments is not VK_ATTACHMENT_UNUSED, then the aspectMask member must not include VK_IMAGE_ASPECT_METADATA_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-attachment-03073", "Each element of pPreserveAttachments must not be VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-attachment-04563", "If the attachment member of any element of pInputAttachments is not VK_ATTACHMENT_UNUSED, then the aspectMask member must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-colorAttachmentCount-03063", "colorAttachmentCount must be less than or equal to VkPhysicalDeviceLimits::maxColorAttachments", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-flags-03076", "If flags includes VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX, it must also include VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-flags-parameter", "flags must be a valid combination of VkSubpassDescriptionFlagBits values", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-layout-02528", "If any attachment is used by more than one VkAttachmentReference2 member, then each use must use the same layout", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-loadOp-03064", "If the first use of an attachment in this render pass is as an input attachment, and the attachment is not also used as a color or depth/stencil attachment in the same subpass, then loadOp must not be VK_ATTACHMENT_LOAD_OP_CLEAR", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pColorAttachments-02898", "All attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have image formats whose potential format features contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pColorAttachments-03069", "All attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have the same sample count", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pColorAttachments-03070", "If the VK_AMD_mixed_attachment_samples extension is enabled, all attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have a sample count that is smaller than or equal to the sample count of pDepthStencilAttachment if it is not VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pColorAttachments-parameter", "If colorAttachmentCount is not 0, pColorAttachments must be a valid pointer to an array of colorAttachmentCount valid VkAttachmentReference2 structures", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pDepthStencilAttachment-02900", "If pDepthStencilAttachment is not NULL and the attachment is not VK_ATTACHMENT_UNUSED then it must have an image format whose potential format features contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pDepthStencilAttachment-03071", "If neither the VK_AMD_mixed_attachment_samples nor the VK_NV_framebuffer_mixed_samples extensions are enabled, and if pDepthStencilAttachment is not VK_ATTACHMENT_UNUSED and any attachments in pColorAttachments are not VK_ATTACHMENT_UNUSED, they must have the same sample count", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pDepthStencilAttachment-04440", "An attachment must not be used in both pDepthStencilAttachment and pColorAttachments", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pDepthStencilAttachment-parameter", "If pDepthStencilAttachment is not NULL, pDepthStencilAttachment must be a valid pointer to a valid VkAttachmentReference2 structure", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pInputAttachments-02897", "All attachments in pInputAttachments that are not VK_ATTACHMENT_UNUSED must have image formats whose potential format features contain at least VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pInputAttachments-parameter", "If inputAttachmentCount is not 0, pInputAttachments must be a valid pointer to an array of inputAttachmentCount valid VkAttachmentReference2 structures", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkFragmentShadingRateAttachmentInfoKHR or VkSubpassDescriptionDepthStencilResolve", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pPreserveAttachments-03074", "Any given element of pPreserveAttachments must not also be an element of any other member of the subpass description", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pPreserveAttachments-parameter", "If preserveAttachmentCount is not 0, pPreserveAttachments must be a valid pointer to an array of preserveAttachmentCount uint32_t values", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-02899", "All attachments in pResolveAttachments that are not VK_ATTACHMENT_UNUSED must have image formats whose potential format features contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-03065", "If pResolveAttachments is not NULL, for each resolve attachment that does not have the value VK_ATTACHMENT_UNUSED, the corresponding color attachment must not have the value VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-03066", "If pResolveAttachments is not NULL, for each resolve attachment that is not VK_ATTACHMENT_UNUSED, the corresponding color attachment must not have a sample count of VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-03067", "If pResolveAttachments is not NULL, each resolve attachment that is not VK_ATTACHMENT_UNUSED must have a sample count of VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-03068", "Any given element of pResolveAttachments must have the same VkFormat as its corresponding color attachment", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-parameter", "If colorAttachmentCount is not 0, and pResolveAttachments is not NULL, pResolveAttachments must be a valid pointer to an array of colorAttachmentCount valid VkAttachmentReference2 structures", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pipelineBindPoint-03062", "pipelineBindPoint must be VK_PIPELINE_BIND_POINT_GRAPHICS", "1.2-khr-extensions"},
    {"VUID-VkSubpassDescription2-pipelineBindPoint-04953", "pipelineBindPoint must be VK_PIPELINE_BIND_POINT_GRAPHICS or VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2", "1.2-extensions"},
    {"VUID-VkSubpassDescription2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-depthResolveMode-03183", "The value of depthResolveMode must be one of the bits set in VkPhysicalDeviceDepthStencilResolveProperties::supportedDepthResolveModes or VK_RESOLVE_MODE_NONE", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-02651", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED then it must have a format whose features contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03177", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED, pDepthStencilAttachment must not have the value VK_ATTACHMENT_UNUSED", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03178", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED, depthResolveMode and stencilResolveMode must not both be VK_RESOLVE_MODE_NONE", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03179", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED, pDepthStencilAttachment must not have a sample count of VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03180", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED, pDepthStencilResolveAttachment must have a sample count of VK_SAMPLE_COUNT_1_BIT", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03181", "If the VkFormat of pDepthStencilResolveAttachment has a depth component, then the VkFormat of pDepthStencilAttachment must have a depth component with the same number of bits and numerical type", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03182", "If the VkFormat of pDepthStencilResolveAttachment has a stencil component, then the VkFormat of pDepthStencilAttachment must have a stencil component with the same number of bits and numerical type", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03185", "If the VkFormat of pDepthStencilResolveAttachment has both depth and stencil components, VkPhysicalDeviceDepthStencilResolveProperties::independentResolve is VK_FALSE, and VkPhysicalDeviceDepthStencilResolveProperties::independentResolveNone is VK_FALSE, then the values of depthResolveMode and stencilResolveMode must be identical", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03186", "If the VkFormat of pDepthStencilResolveAttachment has both depth and stencil components, VkPhysicalDeviceDepthStencilResolveProperties::independentResolve is VK_FALSE and VkPhysicalDeviceDepthStencilResolveProperties::independentResolveNone is VK_TRUE, then the values of depthResolveMode and stencilResolveMode must be identical or one of them must be VK_RESOLVE_MODE_NONE", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-04588", "If the VkFormat of pDepthStencilResolveAttachment has a depth component, depthResolveMode must be a valid VkResolveModeFlagBits value", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-04589", "If the VkFormat of pDepthStencilResolveAttachment has a stencil component, stencilResolveMode must be a valid VkResolveModeFlagBits value", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-parameter", "If pDepthStencilResolveAttachment is not NULL, pDepthStencilResolveAttachment must be a valid pointer to a valid VkAttachmentReference2 structure", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE", "1.2-extensions"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-stencilResolveMode-03184", "The value of stencilResolveMode must be one of the bits set in VkPhysicalDeviceDepthStencilResolveProperties::supportedStencilResolveModes or VK_RESOLVE_MODE_NONE", "1.2-extensions"},
    {"VUID-VkSubpassEndInfo-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSubpassEndInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_END_INFO", "1.2-extensions"},
    {"VUID-VkSubpassSampleLocationsEXT-sampleLocationsInfo-parameter", "sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure", "1.2-extensions"},
    {"VUID-VkSubpassSampleLocationsEXT-subpassIndex-01532", "subpassIndex must be less than the subpassCount specified in VkRenderPassCreateInfo the render pass specified by VkRenderPassBeginInfo::renderPass was created with", "1.2-extensions"},
    {"VUID-VkSubpassShadingPipelineCreateInfoHUAWEI-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI", "1.2-extensions"},
    {"VUID-VkSubpassShadingPipelineCreateInfoHUAWEI-subpass-04946", "subpass must be created with VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI bind point.", "1.2-extensions"},
    {"VUID-VkSurfaceCapabilities2EXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSurfaceCapabilities2EXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT", "1.2-extensions"},
    {"VUID-VkSurfaceCapabilities2EXT-supportedSurfaceCounters-01246", "supportedSurfaceCounters must not include VK_SURFACE_COUNTER_VBLANK_BIT_EXT unless the surface queried is a display surface", "1.2-extensions"},
    {"VUID-VkSurfaceCapabilities2KHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDisplayNativeHdrSurfaceCapabilitiesAMD, VkSharedPresentSurfaceCapabilitiesKHR, VkSurfaceCapabilitiesFullScreenExclusiveEXT, or VkSurfaceProtectedCapabilitiesKHR", "1.2-extensions"},
    {"VUID-VkSurfaceCapabilities2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR", "1.2-extensions"},
    {"VUID-VkSurfaceCapabilities2KHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSurfaceCapabilitiesFullScreenExclusiveEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT", "1.2-extensions"},
    {"VUID-VkSurfaceFormat2KHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkSurfaceFormat2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR", "1.2-extensions"},
    {"VUID-VkSurfaceFullScreenExclusiveInfoEXT-fullScreenExclusive-parameter", "fullScreenExclusive must be a valid VkFullScreenExclusiveEXT value", "1.2-extensions"},
    {"VUID-VkSurfaceFullScreenExclusiveInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkSurfaceFullScreenExclusiveWin32InfoEXT-hmonitor-02673", "hmonitor must be a valid HMONITOR", "1.2-extensions"},
    {"VUID-VkSurfaceFullScreenExclusiveWin32InfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT", "1.2-extensions"},
    {"VUID-VkSurfaceProtectedCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR", "1.2-extensions"},
    {"VUID-VkSwapchainCounterCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkSwapchainCounterCreateInfoEXT-surfaceCounters-01244", "The bits in surfaceCounters must be supported by VkSwapchainCreateInfoKHR::surface, as reported by vkGetPhysicalDeviceSurfaceCapabilities2EXT", "1.2-extensions"},
    {"VUID-VkSwapchainCounterCreateInfoEXT-surfaceCounters-parameter", "surfaceCounters must be a valid combination of VkSurfaceCounterFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-commonparent", "Both of oldSwapchain, and surface that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkInstance", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-compositeAlpha-01280", "compositeAlpha must be one of the bits present in the supportedCompositeAlpha member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-compositeAlpha-parameter", "compositeAlpha must be a valid VkCompositeAlphaFlagBitsKHR value", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-flags-03168", "If flags contains VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR then the pNext chain must include a VkImageFormatListCreateInfo structure with a viewFormatCount greater than zero and pViewFormats must have an element equal to imageFormat", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-flags-03187", "If flags contains VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR, then VkSurfaceProtectedCapabilitiesKHR::supportsProtected must be VK_TRUE in the VkSurfaceProtectedCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilities2KHR for surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-flags-04100", "If flags does not contain VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR and the pNext chain include a VkImageFormatListCreateInfo structure then VkImageFormatListCreateInfo::viewFormatCount must be 0 or 1", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-flags-parameter", "flags must be a valid combination of VkSwapchainCreateFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageArrayLayers-01275", "imageArrayLayers must be greater than 0 and less than or equal to the maxImageArrayLayers member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageColorSpace-parameter", "imageColorSpace must be a valid VkColorSpaceKHR value", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageExtent-01274", "imageExtent must be between minImageExtent and maxImageExtent, inclusive, where minImageExtent and maxImageExtent are members of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageExtent-01689", "imageExtent members width and height must both be non-zero", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageFormat-01273", "imageFormat and imageColorSpace must match the format and colorSpace members, respectively, of one of the VkSurfaceFormatKHR structures returned by vkGetPhysicalDeviceSurfaceFormatsKHR for the surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageFormat-01778", "The implied image creation parameters of the swapchain must be supported as reported by vkGetPhysicalDeviceImageFormatProperties", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageFormat-parameter", "imageFormat must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01277", "If imageSharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01278", "If imageSharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01393", "If imageSharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device", "default"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01428", "If imageSharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties or vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-parameter", "imageSharingMode must be a valid VkSharingMode value", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageUsage-01276", "imageUsage must be a subset of the supported usage flags present in the supportedUsageFlags member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface", "default"},
    {"VUID-VkSwapchainCreateInfoKHR-imageUsage-01384", "If presentMode is VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR or VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR, imageUsage must be a subset of the supported usage flags present in the sharedPresentSupportedUsageFlags member of the VkSharedPresentSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilities2KHR for surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageUsage-parameter", "imageUsage must be a valid combination of VkImageUsageFlagBits values", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-imageUsage-requiredbitmask", "imageUsage must not be 0", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-minImageCount-01271", "minImageCount must be greater than or equal to the value returned in the minImageCount member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface", "default"},
    {"VUID-VkSwapchainCreateInfoKHR-minImageCount-01272", "minImageCount must be less than or equal to the value returned in the maxImageCount member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface if the returned maxImageCount is not zero", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-minImageCount-01383", "minImageCount must be 1 if presentMode is either VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR or VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-oldSwapchain-01933", "If oldSwapchain is not VK_NULL_HANDLE, oldSwapchain must be a non-retired swapchain associated with native window referred to by surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-oldSwapchain-parameter", "If oldSwapchain is not VK_NULL_HANDLE, oldSwapchain must be a valid VkSwapchainKHR handle", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-oldSwapchain-parent", "If oldSwapchain is a valid handle, it must have been created, allocated, or retrieved from surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-pNext-02679", "If the pNext chain includes a VkSurfaceFullScreenExclusiveInfoEXT structure with its fullScreenExclusive member set to VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT, and surface was created using vkCreateWin32SurfaceKHR, a VkSurfaceFullScreenExclusiveWin32InfoEXT structure must be included in the pNext chain", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-pNext-04099", "If a VkImageFormatListCreateInfo structure was included in the pNext chain and VkImageFormatListCreateInfo::viewFormatCount is not zero then all of the formats in VkImageFormatListCreateInfo::pViewFormats must be compatible with the format as described in the compatibility table", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupSwapchainCreateInfoKHR, VkImageFormatListCreateInfo, VkSurfaceFullScreenExclusiveInfoEXT, VkSurfaceFullScreenExclusiveWin32InfoEXT, VkSwapchainCounterCreateInfoEXT, or VkSwapchainDisplayNativeHdrCreateInfoAMD", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-physicalDeviceCount-01429", "If the logical device was created with VkDeviceGroupDeviceCreateInfo::physicalDeviceCount equal to 1, flags must not contain VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-preTransform-01279", "preTransform must be one of the bits present in the supportedTransforms member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-preTransform-parameter", "preTransform must be a valid VkSurfaceTransformFlagBitsKHR value", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-presentMode-01281", "presentMode must be one of the VkPresentModeKHR values returned by vkGetPhysicalDeviceSurfacePresentModesKHR for the surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-presentMode-01427", "If presentMode is VK_PRESENT_MODE_IMMEDIATE_KHR, VK_PRESENT_MODE_MAILBOX_KHR, VK_PRESENT_MODE_FIFO_KHR or VK_PRESENT_MODE_FIFO_RELAXED_KHR, imageUsage must be a subset of the supported usage flags present in the supportedUsageFlags member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-presentMode-02839", "If presentMode is not VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR nor VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR, then minImageCount must be greater than or equal to the value returned in the minImageCount member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-presentMode-parameter", "presentMode must be a valid VkPresentModeKHR value", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-surface-01270", "surface must be a surface that is supported by the device as determined using vkGetPhysicalDeviceSurfaceSupportKHR", "1.2-extensions"},
    {"VUID-VkSwapchainCreateInfoKHR-surface-parameter", "surface must be a valid VkSurfaceKHR handle", "1.2-extensions"},
    {"VUID-VkSwapchainDisplayNativeHdrCreateInfoAMD-localDimmingEnable-04449", "It is only valid to set localDimmingEnable to VK_TRUE if VkDisplayNativeHdrSurfaceCapabilitiesAMD::localDimmingSupport is supported", "1.2-extensions"},
    {"VUID-VkSwapchainDisplayNativeHdrCreateInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD", "1.2-extensions"},
    {"VUID-VkTextureLODGatherFormatPropertiesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD", "1.2-extensions"},
    {"VUID-VkTimelineSemaphoreSubmitInfo-pSignalSemaphoreValues-parameter", "If signalSemaphoreValueCount is not 0, and pSignalSemaphoreValues is not NULL, pSignalSemaphoreValues must be a valid pointer to an array of signalSemaphoreValueCount uint64_t values", "1.2-extensions"},
    {"VUID-VkTimelineSemaphoreSubmitInfo-pWaitSemaphoreValues-parameter", "If waitSemaphoreValueCount is not 0, and pWaitSemaphoreValues is not NULL, pWaitSemaphoreValues must be a valid pointer to an array of waitSemaphoreValueCount uint64_t values", "1.2-extensions"},
    {"VUID-VkTimelineSemaphoreSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO", "1.2-extensions"},
    {"VUID-VkTraceRaysIndirectCommandKHR-depth-03640", "depth must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2] {times} VkPhysicalDeviceLimits::maxComputeWorkGroupSize[2]", "1.2-extensions"},
    {"VUID-VkTraceRaysIndirectCommandKHR-height-03639", "height must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1] {times} VkPhysicalDeviceLimits::maxComputeWorkGroupSize[1]", "1.2-extensions"},
    {"VUID-VkTraceRaysIndirectCommandKHR-width-03638", "width must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0] {times} VkPhysicalDeviceLimits::maxComputeWorkGroupSize[0]", "1.2-extensions"},
    {"VUID-VkTraceRaysIndirectCommandKHR-width-03641", "width {times} height {times} depth must be less than or equal to VkPhysicalDeviceRayTracingPipelinePropertiesKHR::maxRayDispatchInvocationCount", "1.2-extensions"},
    {"VUID-VkTransformMatrixKHR-matrix-03799", "The first three columns of matrix must define an invertible 3x3 matrix", "1.2-extensions"},
    {"VUID-VkValidationCacheCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkValidationCacheCreateInfoEXT-initialDataSize-01534", "If initialDataSize is not 0, it must be equal to the size of pInitialData, as returned by vkGetValidationCacheDataEXT when pInitialData was originally retrieved", "1.2-extensions"},
    {"VUID-VkValidationCacheCreateInfoEXT-initialDataSize-01535", "If initialDataSize is not 0, pInitialData must have been retrieved from a previous call to vkGetValidationCacheDataEXT", "1.2-extensions"},
    {"VUID-VkValidationCacheCreateInfoEXT-pInitialData-parameter", "If initialDataSize is not 0, pInitialData must be a valid pointer to an array of initialDataSize bytes", "1.2-extensions"},
    {"VUID-VkValidationCacheCreateInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkValidationCacheCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkValidationFeaturesEXT-pDisabledValidationFeatures-parameter", "If disabledValidationFeatureCount is not 0, pDisabledValidationFeatures must be a valid pointer to an array of disabledValidationFeatureCount valid VkValidationFeatureDisableEXT values", "1.2-extensions"},
    {"VUID-VkValidationFeaturesEXT-pEnabledValidationFeatures-02967", "If the pEnabledValidationFeatures array contains VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT, then it must also contain VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT", "1.2-extensions"},
    {"VUID-VkValidationFeaturesEXT-pEnabledValidationFeatures-02968", "If the pEnabledValidationFeatures array contains VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT, then it must not contain VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT", "1.2-extensions"},
    {"VUID-VkValidationFeaturesEXT-pEnabledValidationFeatures-parameter", "If enabledValidationFeatureCount is not 0, pEnabledValidationFeatures must be a valid pointer to an array of enabledValidationFeatureCount valid VkValidationFeatureEnableEXT values", "1.2-extensions"},
    {"VUID-VkValidationFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT", "1.2-extensions"},
    {"VUID-VkValidationFlagsEXT-disabledValidationCheckCount-arraylength", "disabledValidationCheckCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkValidationFlagsEXT-pDisabledValidationChecks-parameter", "pDisabledValidationChecks must be a valid pointer to an array of disabledValidationCheckCount valid VkValidationCheckEXT values", "1.2-extensions"},
    {"VUID-VkValidationFlagsEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription-binding-00621", "binding must be less than VkPhysicalDeviceLimits::maxVertexInputBindings", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription-format-00623", "format must be allowed as a vertex buffer format, as specified by the VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT flag in VkFormatProperties::bufferFeatures returned by vkGetPhysicalDeviceFormatProperties", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription-location-00620", "location must be less than VkPhysicalDeviceLimits::maxVertexInputAttributes", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription-offset-00622", "offset must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputAttributeOffset", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription-vertexAttributeAccessBeyondStride-04457", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::vertexAttributeAccessBeyondStride is VK_FALSE, the sum of offset plus the size of the vertex attribute data described by format must not be greater than stride in the VkVertexInputBindingDescription referenced in binding.", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription2EXT-binding-04803", "binding must be less than VkPhysicalDeviceLimits::maxVertexInputBindings", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription2EXT-format-04805", "format must be allowed as a vertex buffer format, as specified by the VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT flag in VkFormatProperties::bufferFeatures returned by vkGetPhysicalDeviceFormatProperties", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription2EXT-format-parameter", "format must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription2EXT-location-04802", "location must be less than VkPhysicalDeviceLimits::maxVertexInputAttributes", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription2EXT-offset-04804", "offset must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputAttributeOffset", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription2EXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT", "1.2-extensions"},
    {"VUID-VkVertexInputAttributeDescription2EXT-vertexAttributeAccessBeyondStride-04806", "If the [VK_KHR_portability_subset] extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::vertexAttributeAccessBeyondStride is VK_FALSE, the sum of offset plus the size of the vertex attribute data described by format must not be greater than stride in the VkVertexInputBindingDescription2EXT referenced in binding.", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription-binding-00618", "binding must be less than VkPhysicalDeviceLimits::maxVertexInputBindings", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription-inputRate-parameter", "inputRate must be a valid VkVertexInputRate value", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription-stride-00619", "stride must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputBindingStride", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription-stride-04456", "If the [VK_KHR_portability_subset] extension is enabled, stride must be a multiple of, and at least as large as, VkPhysicalDevicePortabilitySubsetPropertiesKHR::minVertexInputBindingStrideAlignment.", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription2EXT-binding-04796", "binding must be less than VkPhysicalDeviceLimits::maxVertexInputBindings", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription2EXT-divisor-04798", "If the vertexAttributeInstanceRateZeroDivisor feature is not enabled, divisor must not be 0", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription2EXT-divisor-04799", "If the vertexAttributeInstanceRateDivisor feature is not enabled, divisor must be 1", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription2EXT-divisor-04800", "divisor must be a value between 0 and VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::maxVertexAttribDivisor, inclusive", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription2EXT-divisor-04801", "If divisor is not 1 then inputRate must be of type VK_VERTEX_INPUT_RATE_INSTANCE", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription2EXT-inputRate-parameter", "inputRate must be a valid VkVertexInputRate value", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription2EXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDescription2EXT-stride-04797", "stride must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputBindingStride", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-binding-01869", "binding must be less than VkPhysicalDeviceLimits::maxVertexInputBindings", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-divisor-01870", "divisor must be a value between 0 and VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::maxVertexAttribDivisor, inclusive", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-inputRate-01871", "VkVertexInputBindingDescription::inputRate must be of type VK_VERTEX_INPUT_RATE_INSTANCE for this binding", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-vertexAttributeInstanceRateDivisor-02229", "If the vertexAttributeInstanceRateDivisor feature is not enabled, divisor must be 1", "1.2-extensions"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-vertexAttributeInstanceRateZeroDivisor-02228", "If the vertexAttributeInstanceRateZeroDivisor feature is not enabled, divisor must not be 0", "1.2-extensions"},
    {"VUID-VkViSurfaceCreateInfoNN-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkViSurfaceCreateInfoNN-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkViSurfaceCreateInfoNN-sType-sType", "sType must be VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN", "1.2-extensions"},
    {"VUID-VkViSurfaceCreateInfoNN-window-01318", "window must be a valid nn::vi::NativeWindowHandle", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-codecQualityPreset-parameter", "codecQualityPreset must be a valid combination of VkVideoCodingQualityPresetFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-codecQualityPreset-requiredbitmask", "codecQualityPreset must not be 0", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-commonparent", "Both of videoSession, and videoSessionParameters that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-pReferenceSlots-parameter", "pReferenceSlots must be a valid pointer to an array of referenceSlotCount valid VkVideoReferenceSlotKHR structures", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-referenceSlotCount-04856", "VkVideoBeginCodingInfoKHR::referenceSlotCount must not exceed the value specified in VkVideoSessionCreateInfoKHR::maxReferencePicturesSlotsCount when creating the video session object that is being provided in videoSession.", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-referenceSlotCount-arraylength", "referenceSlotCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-videoSession-parameter", "videoSession must be a valid VkVideoSessionKHR handle", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-videoSessionParameters-04857", "If videoSessionParameters is not VK_NULL_HANDLE, it must have been created using videoSession as a parent object.", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-videoSessionParameters-parameter", "If videoSessionParameters is not VK_NULL_HANDLE, videoSessionParameters must be a valid VkVideoSessionParametersKHR handle", "1.2-extensions"},
    {"VUID-VkVideoBeginCodingInfoKHR-videoSessionParameters-parent", "If videoSessionParameters is a valid handle, it must have been created, allocated, or retrieved from videoSession", "1.2-extensions"},
    {"VUID-VkVideoBindMemoryKHR-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.2-extensions"},
    {"VUID-VkVideoBindMemoryKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkVideoBindMemoryKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_BIND_MEMORY_KHR", "1.2-extensions"},
    {"VUID-VkVideoCapabilitiesKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkVideoDecodeH264CapabilitiesEXT, VkVideoDecodeH265CapabilitiesEXT, or VkVideoEncodeH264CapabilitiesEXT", "1.2-extensions"},
    {"VUID-VkVideoCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR", "1.2-extensions"},
    {"VUID-VkVideoCapabilitiesKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkVideoCodingControlInfoKHR-flags-parameter", "flags must be a valid combination of VkVideoCodingControlFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoCodingControlInfoKHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkVideoEncodeRateControlInfoKHR", "1.2-extensions"},
    {"VUID-VkVideoCodingControlInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoCodingControlInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264CapabilitiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264DpbSlotInfoEXT-pStdReferenceInfo-parameter", "pStdReferenceInfo must be a valid pointer to a valid StdVideoDecodeH264ReferenceInfo value", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264DpbSlotInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264MvcEXT-pStdMvc-parameter", "pStdMvc must be a valid pointer to a valid StdVideoDecodeH264Mvc value", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264MvcEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_MVC_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264PictureInfoEXT-pSlicesDataOffsets-parameter", "pSlicesDataOffsets must be a valid pointer to an array of slicesCount uint32_t values", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264PictureInfoEXT-pStdPictureInfo-parameter", "pStdPictureInfo must be a valid pointer to a valid StdVideoDecodeH264PictureInfo value", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264PictureInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264PictureInfoEXT-slicesCount-arraylength", "slicesCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264ProfileEXT-fieldLayout-parameter", "fieldLayout must be a valid combination of VkVideoDecodeH264FieldLayoutFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264ProfileEXT-fieldLayout-requiredbitmask", "fieldLayout must not be 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264ProfileEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionCreateInfoEXT-pStdExtensionVersion-parameter", "pStdExtensionVersion must be a valid pointer to a valid VkExtensionProperties structure", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-None-04825", "Each entry to be added must have a unique, to the rest of the parameter array entries and the existing parameters in the Video Session Parameters Object that is being updated, SPS-PPS IDs.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-None-04826", "Parameter entries that already exist in Video Session Parameters object with a particular SPS-PPS IDs cannot be replaced nor updated.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-None-04827", "When creating a new object using a Video Session Parameters as a template, the array's parameters with the same SPS-PPS IDs as the ones from the template take precedence.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-None-04828", "SPS/PPS parameters must comply with the limits specified in VkVideoSessionCreateInfoKHR during Video Session creation.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-maxPpsStdCount-04824", "When the maxPpsStdCount number of parameters of type StdVideoH264PictureParameterSet in the Video Session Parameters object is reached, no additional parameters of that type can be added to this object. VK_ERROR_TOO_MANY_OBJECTS will be returned if an attempt is made to add additional data to this object at this point.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-maxSpsStdCount-04823", "When the maxSpsStdCount number of parameters of type StdVideoH264SequenceParameterSet in the Video Session Parameters object is reached, no additional parameters of that type can be added to this object. VK_ERROR_TOO_MANY_OBJECTS will be returned if an attempt is made to add additional data to this object at this point.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-pPpsStd-parameter", "If pPpsStd is not NULL, pPpsStd must be a valid pointer to an array of ppsStdCount StdVideoH264PictureParameterSet values", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-pSpsStd-parameter", "If pSpsStd is not NULL, pSpsStd must be a valid pointer to an array of spsStdCount StdVideoH264SequenceParameterSet values", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-ppsStdCount-arraylength", "ppsStdCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-spsStdCount-04822", "The values of spsStdCount and ppsStdCount must be less than or equal to the values of maxSpsStdCount and maxPpsStdCount, respectively.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersAddInfoEXT-spsStdCount-arraylength", "spsStdCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersCreateInfoEXT-pParametersAddInfo-parameter", "If pParametersAddInfo is not NULL, pParametersAddInfo must be a valid pointer to a valid VkVideoDecodeH264SessionParametersAddInfoEXT structure", "1.2-extensions"},
    {"VUID-VkVideoDecodeH264SessionParametersCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265CapabilitiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265DpbSlotInfoEXT-pStdReferenceInfo-parameter", "pStdReferenceInfo must be a valid pointer to a valid StdVideoDecodeH265ReferenceInfo value", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265DpbSlotInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265PictureInfoEXT-pSlicesDataOffsets-parameter", "pSlicesDataOffsets must be a valid pointer to an array of slicesCount uint32_t values", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265PictureInfoEXT-pStdPictureInfo-parameter", "pStdPictureInfo must be a valid pointer to a StdVideoDecodeH265PictureInfo value", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265PictureInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265PictureInfoEXT-slicesCount-arraylength", "slicesCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265ProfileEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionCreateInfoEXT-pStdExtensionVersion-parameter", "pStdExtensionVersion must be a valid pointer to a valid VkExtensionProperties structure", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-None-04833", "Each entry to be added must have a unique, to the rest of the parameter array entries and the existing parameters in the Video Session Parameters Object that is being updated, VPS-SPS-PPS IDs.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-None-04834", "Parameter entries that already exist in Video Session Parameters object with a particular VPS-SPS-PPS IDs cannot be replaced nor updated.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-None-04835", "When creating a new object using a Video Session Parameters as a template, the array's parameters with the same VPS-SPS-PPS IDs as the ones from the template take precedence.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-None-04836", "VPS/SPS/PPS parameters must comply with the limits specified in VkVideoSessionCreateInfoKHR during Video Session creation.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-maxPpsStdCount-04832", "When the maxPpsStdCount number of parameters of type StdVideoH265PictureParameterSet in the Video Session Parameters object is reached, no additional parameters of that type can be added to the object. VK_ERROR_TOO_MANY_OBJECTS will be returned if an attempt is made to add additional data to this object at this point.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-maxSpsStdCount-04831", "When the maxSpsStdCount number of parameters of type StdVideoH265SequenceParameterSet in the Video Session Parameters object is reached, no additional parameters of that type can be added to the object. VK_ERROR_TOO_MANY_OBJECTS will be returned if an attempt is made to add additional data to this object at this point.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-maxVpsStdCount-04830", "When the maxVpsStdCount number of parameters of type StdVideoH265VideoParameterSet in the Video Session Parameters object is reached, no additional parameters of that type can be added to the object. VK_ERROR_TOO_MANY_OBJECTS will be returned if an attempt is made to add additional data to this object at this point.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-pPpsStd-parameter", "If pPpsStd is not NULL, pPpsStd must be a valid pointer to an array of ppsStdCount StdVideoH265PictureParameterSet values", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-pSpsStd-parameter", "If pSpsStd is not NULL, pSpsStd must be a valid pointer to an array of spsStdCount StdVideoH265SequenceParameterSet values", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-ppsStdCount-arraylength", "ppsStdCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-spsStdCount-arraylength", "spsStdCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersAddInfoEXT-vpsStdCount-04829", "The values of vpsStdCount, spsStdCount and ppsStdCount must be less than or equal to the values of maxVpsStdCount, maxSpsStdCount and maxPpsStdCount, respectively.", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersCreateInfoEXT-pParametersAddInfo-parameter", "If pParametersAddInfo is not NULL, pParametersAddInfo must be a valid pointer to a valid VkVideoDecodeH265SessionParametersAddInfoEXT structure", "1.2-extensions"},
    {"VUID-VkVideoDecodeH265SessionParametersCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-dstPictureResource-parameter", "dstPictureResource must be a valid VkVideoPictureResourceKHR structure", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-flags-parameter", "flags must be a valid combination of VkVideoDecodeFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkVideoDecodeH264PictureInfoEXT or VkVideoDecodeH265PictureInfoEXT", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-pReferenceSlots-parameter", "pReferenceSlots must be a valid pointer to an array of referenceSlotCount valid VkVideoReferenceSlotKHR structures", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-pSetupReferenceSlot-parameter", "pSetupReferenceSlot must be a valid pointer to a valid VkVideoReferenceSlotKHR structure", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-referenceSlotCount-arraylength", "referenceSlotCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkVideoDecodeInfoKHR-srcBuffer-parameter", "srcBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264CapabilitiesEXT-flags-parameter", "flags must be a valid combination of VkVideoEncodeH264CapabilitiesFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264CapabilitiesEXT-flags-requiredbitmask", "flags must not be 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264CapabilitiesEXT-inputModeFlags-parameter", "inputModeFlags must be a valid combination of VkVideoEncodeH264InputModeFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264CapabilitiesEXT-inputModeFlags-requiredbitmask", "inputModeFlags must not be 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264CapabilitiesEXT-outputModeFlags-parameter", "outputModeFlags must be a valid combination of VkVideoEncodeH264OutputModeFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264CapabilitiesEXT-outputModeFlags-requiredbitmask", "outputModeFlags must not be 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264CapabilitiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264CapabilitiesEXT-stdExtensionVersion-parameter", "stdExtensionVersion must be a valid VkExtensionProperties structure", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264DpbSlotInfoEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264DpbSlotInfoEXT-pStdPictureInfo-parameter", "pStdPictureInfo must be a valid pointer to a valid StdVideoEncodeH264PictureInfo value", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264DpbSlotInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264EmitPictureParametersEXT-ppsIdEntries-parameter", "ppsIdEntries must be a valid pointer to an array of ppsIdEntryCount uint8_t values", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264EmitPictureParametersEXT-ppsIdEntryCount-arraylength", "ppsIdEntryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264EmitPictureParametersEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_EMIT_PICTURE_PARAMETERS_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264NaluSliceEXT-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264NaluSliceEXT-pRefFinalList0Entries-parameter", "pRefFinalList0Entries must be a valid pointer to an array of refFinalList0EntryCount valid VkVideoEncodeH264DpbSlotInfoEXT structures", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264NaluSliceEXT-pRefFinalList1Entries-parameter", "pRefFinalList1Entries must be a valid pointer to an array of refFinalList1EntryCount valid VkVideoEncodeH264DpbSlotInfoEXT structures", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264NaluSliceEXT-pSliceHeaderStd-parameter", "pSliceHeaderStd must be a valid pointer to a valid StdVideoEncodeH264SliceHeader value", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264NaluSliceEXT-refFinalList0EntryCount-arraylength", "refFinalList0EntryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264NaluSliceEXT-refFinalList1EntryCount-arraylength", "refFinalList1EntryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264NaluSliceEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264ProfileEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionCreateInfoEXT-flags-parameter", "flags must be a valid combination of VkVideoEncodeH264CreateFlagBitsEXT values", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionCreateInfoEXT-flags-requiredbitmask", "flags must not be 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionCreateInfoEXT-pStdExtensionVersion-parameter", "pStdExtensionVersion must be a valid pointer to a valid VkExtensionProperties structure", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-None-04840", "Each entry to be added must have a unique, to the rest of the parameter array entries and the existing parameters in the Video Session Parameters Object that is being updated, SPS-PPS IDs.", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-None-04841", "Parameter entries that already exist in Video Session Parameters object with a particular SPS-PPS IDs cannot be replaced nor updated.", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-None-04842", "When creating a new object using a Video Session Parameters as a template, the array's parameters with the same SPS-PPS IDs as the ones from the template take precedence.", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-None-04843", "SPS/PPS parameters must comply with the limits specified in VkVideoSessionCreateInfoKHR during Video Session creation.", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-maxPpsStdCount-04839", "When the maxPpsStdCount number of parameters of type StdVideoH264PictureParameterSet in the Video Session Parameters object is reached, no additional parameters of that type can be added to the object. VK_ERROR_TOO_MANY_OBJECTS will be returned if an attempt is made to add additional data to this object at this point.", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-maxSpsStdCount-04838", "When the maxSpsStdCount number of parameters of type StdVideoH264SequenceParameterSet in the Video Session Parameters object is reached, no additional parameters of that type can be added to the object. VK_ERROR_TOO_MANY_OBJECTS will be returned if an attempt is made to add additional data to this object at this point.", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-pPpsStd-parameter", "If pPpsStd is not NULL, pPpsStd must be a valid pointer to an array of ppsStdCount StdVideoH264PictureParameterSet values", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-pSpsStd-parameter", "If pSpsStd is not NULL, pSpsStd must be a valid pointer to an array of spsStdCount StdVideoH264SequenceParameterSet values", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-ppsStdCount-arraylength", "ppsStdCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-spsStdCount-04837", "The values of spsStdCount and ppsStdCount must be less than or equal to the values of maxSpsStdCount and maxPpsStdCount, respectively.", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-spsStdCount-arraylength", "spsStdCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersCreateInfoEXT-pParametersAddInfo-parameter", "If pParametersAddInfo is not NULL, pParametersAddInfo must be a valid pointer to a valid VkVideoEncodeH264SessionParametersAddInfoEXT structure", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264SessionParametersCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264VclFrameInfoEXT-naluSliceEntryCount-arraylength", "naluSliceEntryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264VclFrameInfoEXT-pCurrentPictureInfo-parameter", "pCurrentPictureInfo must be a valid pointer to a valid VkVideoEncodeH264DpbSlotInfoEXT structure", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264VclFrameInfoEXT-pNaluSliceEntries-parameter", "pNaluSliceEntries must be a valid pointer to an array of naluSliceEntryCount valid VkVideoEncodeH264NaluSliceEXT structures", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264VclFrameInfoEXT-pRefDefaultFinalList0Entries-parameter", "pRefDefaultFinalList0Entries must be a valid pointer to an array of refDefaultFinalList0EntryCount valid VkVideoEncodeH264DpbSlotInfoEXT structures", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264VclFrameInfoEXT-pRefDefaultFinalList1Entries-parameter", "pRefDefaultFinalList1Entries must be a valid pointer to an array of refDefaultFinalList1EntryCount valid VkVideoEncodeH264DpbSlotInfoEXT structures", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264VclFrameInfoEXT-refDefaultFinalList0EntryCount-arraylength", "refDefaultFinalList0EntryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264VclFrameInfoEXT-refDefaultFinalList1EntryCount-arraylength", "refDefaultFinalList1EntryCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeH264VclFrameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_VCL_FRAME_INFO_EXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-dstBitstreamBuffer-parameter", "dstBitstreamBuffer must be a valid VkBuffer handle", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-flags-parameter", "flags must be a valid combination of VkVideoEncodeFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkVideoEncodeH264EmitPictureParametersEXT or VkVideoEncodeH264VclFrameInfoEXT", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-pReferenceSlots-parameter", "pReferenceSlots must be a valid pointer to an array of referenceSlotCount valid VkVideoReferenceSlotKHR structures", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-pSetupReferenceSlot-parameter", "pSetupReferenceSlot must be a valid pointer to a valid VkVideoReferenceSlotKHR structure", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-referenceSlotCount-arraylength", "referenceSlotCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkVideoEncodeInfoKHR-srcPictureResource-parameter", "srcPictureResource must be a valid VkVideoPictureResourceKHR structure", "1.2-extensions"},
    {"VUID-VkVideoEncodeRateControlInfoKHR-flags-parameter", "flags must be a valid combination of VkVideoEncodeRateControlFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoEncodeRateControlInfoKHR-flags-requiredbitmask", "flags must not be 0", "1.2-extensions"},
    {"VUID-VkVideoEncodeRateControlInfoKHR-rateControlMode-parameter", "rateControlMode must be a valid VkVideoEncodeRateControlModeFlagBitsKHR value", "1.2-extensions"},
    {"VUID-VkVideoEncodeRateControlInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoEndCodingInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkVideoEndCodingInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkVideoEndCodingInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoFormatPropertiesKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkVideoFormatPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkVideoGetMemoryPropertiesKHR-pMemoryRequirements-parameter", "pMemoryRequirements must be a valid pointer to a VkMemoryRequirements2 structure", "1.2-extensions"},
    {"VUID-VkVideoGetMemoryPropertiesKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkVideoGetMemoryPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_GET_MEMORY_PROPERTIES_KHR", "1.2-extensions"},
    {"VUID-VkVideoPictureResourceKHR-imageViewBinding-parameter", "imageViewBinding must be a valid VkImageView handle", "1.2-extensions"},
    {"VUID-VkVideoPictureResourceKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkVideoPictureResourceKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_KHR", "1.2-extensions"},
    {"VUID-VkVideoProfileKHR-chromaBitDepth-parameter", "chromaBitDepth must be a valid combination of VkVideoComponentBitDepthFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoProfileKHR-chromaBitDepth-requiredbitmask", "chromaBitDepth must not be 0", "1.2-extensions"},
    {"VUID-VkVideoProfileKHR-chromaSubsampling-parameter", "chromaSubsampling must be a valid combination of VkVideoChromaSubsamplingFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoProfileKHR-chromaSubsampling-requiredbitmask", "chromaSubsampling must not be 0", "1.2-extensions"},
    {"VUID-VkVideoProfileKHR-lumaBitDepth-parameter", "lumaBitDepth must be a valid combination of VkVideoComponentBitDepthFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoProfileKHR-lumaBitDepth-requiredbitmask", "lumaBitDepth must not be 0", "1.2-extensions"},
    {"VUID-VkVideoProfileKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_PROFILE_KHR", "1.2-extensions"},
    {"VUID-VkVideoProfileKHR-videoCodecOperation-parameter", "videoCodecOperation must be a valid VkVideoCodecOperationFlagBitsKHR value", "1.2-extensions"},
    {"VUID-VkVideoProfilesKHR-pProfiles-parameter", "pProfiles must be a valid pointer to a valid VkVideoProfileKHR structure", "1.2-extensions"},
    {"VUID-VkVideoProfilesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_PROFILES_KHR", "1.2-extensions"},
    {"VUID-VkVideoQueueFamilyProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_QUEUE_FAMILY_PROPERTIES_2_KHR", "1.2-extensions"},
    {"VUID-VkVideoQueueFamilyProperties2KHR-videoCodecOperations-parameter", "videoCodecOperations must be a valid combination of VkVideoCodecOperationFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoQueueFamilyProperties2KHR-videoCodecOperations-requiredbitmask", "videoCodecOperations must not be 0", "1.2-extensions"},
    {"VUID-VkVideoReferenceSlotKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkVideoDecodeH264DpbSlotInfoEXT or VkVideoDecodeH265DpbSlotInfoEXT", "1.2-extensions"},
    {"VUID-VkVideoReferenceSlotKHR-pPictureResource-parameter", "pPictureResource must be a valid pointer to a valid VkVideoPictureResourceKHR structure", "1.2-extensions"},
    {"VUID-VkVideoReferenceSlotKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_KHR", "1.2-extensions"},
    {"VUID-VkVideoReferenceSlotKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-flags-parameter", "flags must be a valid combination of VkVideoSessionCreateFlagBitsKHR values", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-maxCodedExtent-04851", "maxCodedExtent cannot be smaller than VkVideoCapabilitiesKHR::minExtent and bigger than VkVideoCapabilitiesKHR::maxExtent.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-maxReferencePicturesActiveCount-04848", "If Reference Pictures are required for use with the created video session, the maxReferencePicturesActiveCount must be set to a value bigger than 0.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-maxReferencePicturesActiveCount-04849", "maxReferencePicturesActiveCount cannot exceed the implementation reported VkVideoCapabilitiesKHR::maxReferencePicturesActiveCount.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-maxReferencePicturesActiveCount-04850", "maxReferencePicturesActiveCount cannot exceed the maxReferencePicturesSlotsCount.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-maxReferencePicturesSlotsCount-04846", "If Reference Pictures are required for use with the created video session, the maxReferencePicturesSlotsCount must be set to a value bigger than 0.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-maxReferencePicturesSlotsCount-04847", "maxReferencePicturesSlotsCount cannot exceed the implementation reported VkVideoCapabilitiesKHR::maxReferencePicturesSlotsCount.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkVideoDecodeH264SessionCreateInfoEXT, VkVideoDecodeH265SessionCreateInfoEXT, or VkVideoEncodeH264SessionCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-pVideoProfile-04845", "pVideoProfile must be a pointer to a valid VkVideoProfileKHR structure whose pNext chain must include a valid codec-specific profile structure.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-pVideoProfile-parameter", "pVideoProfile must be a valid pointer to a valid VkVideoProfileKHR structure", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-pictureFormat-04853", "pictureFormat for decode output must be one of the supported formats in VkVideoFormatPropertiesKHR format returned by the vkGetPhysicalDeviceVideoFormatPropertiesKHR when the VkPhysicalDeviceVideoFormatInfoKHR imageUsage contains VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-pictureFormat-04854", "pictureFormat targeting encode operations must be one of the supported formats in VkVideoFormatPropertiesKHR format returned by the vkGetPhysicalDeviceVideoFormatPropertiesKHR when the VkPhysicalDeviceVideoFormatInfoKHR imageUsage contains VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-pictureFormat-parameter", "pictureFormat must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-referencePicturesFormat-04852", "referencePicturesFormat must be one of the supported formats in VkVideoFormatPropertiesKHR format returned by the vkGetPhysicalDeviceVideoFormatPropertiesKHR when the VkPhysicalDeviceVideoFormatInfoKHR imageUsage contains VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR or VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR depending on the session codec operation.", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-referencePicturesFormat-parameter", "referencePicturesFormat must be a valid VkFormat value", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoSessionCreateInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersCreateInfoKHR-commonparent", "Both of videoSession, and videoSessionParametersTemplate must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersCreateInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkVideoDecodeH264SessionParametersCreateInfoEXT, VkVideoDecodeH265SessionParametersCreateInfoEXT, or VkVideoEncodeH264SessionParametersCreateInfoEXT", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersCreateInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersCreateInfoKHR-videoSession-parameter", "videoSession must be a valid VkVideoSessionKHR handle", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersCreateInfoKHR-videoSessionParametersTemplate-04855", "If videoSessionParametersTemplate represents a valid handle, it must have been created against videoSession.", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersCreateInfoKHR-videoSessionParametersTemplate-parameter", "videoSessionParametersTemplate must be a valid VkVideoSessionParametersKHR handle", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersCreateInfoKHR-videoSessionParametersTemplate-parent", "videoSessionParametersTemplate must have been created, allocated, or retrieved from videoSession", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersUpdateInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkVideoDecodeH264SessionParametersAddInfoEXT, VkVideoDecodeH265SessionParametersAddInfoEXT, or VkVideoEncodeH264SessionParametersAddInfoEXT", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersUpdateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkVideoSessionParametersUpdateInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkViewport-height-01772", "height must be greater than 0.0", "1.0"},
    {"VUID-VkViewport-height-01773", "The absolute value of height must be less than or equal to VkPhysicalDeviceLimits::maxViewportDimensions[1]", "1.2-extensions"},
    {"VUID-VkViewport-maxDepth-01235", "Unless VK_EXT_depth_range_unrestricted extension is enabled maxDepth must be between 0.0 and 1.0, inclusive", "1.2-extensions"},
    {"VUID-VkViewport-maxDepth-02541", "maxDepth must be between 0.0 and 1.0, inclusive", "1.2-khr-extensions"},
    {"VUID-VkViewport-minDepth-01234", "Unless VK_EXT_depth_range_unrestricted extension is enabled minDepth must be between 0.0 and 1.0, inclusive", "1.2-extensions"},
    {"VUID-VkViewport-minDepth-02540", "minDepth must be between 0.0 and 1.0, inclusive", "1.2-khr-extensions"},
    {"VUID-VkViewport-width-01770", "width must be greater than 0.0", "1.2-extensions"},
    {"VUID-VkViewport-width-01771", "width must be less than or equal to VkPhysicalDeviceLimits::maxViewportDimensions[0]", "1.2-extensions"},
    {"VUID-VkViewport-x-01232", "(x + width) must be less than or equal to viewportBoundsRange[1]", "1.2-extensions"},
    {"VUID-VkViewport-x-01774", "x must be greater than or equal to viewportBoundsRange[0]", "1.2-extensions"},
    {"VUID-VkViewport-y-01233", "(y + height) must be less than or equal to viewportBoundsRange[1]", "1.2-extensions"},
    {"VUID-VkViewport-y-01775", "y must be greater than or equal to viewportBoundsRange[0]", "1.2-extensions"},
    {"VUID-VkViewport-y-01776", "y must be less than or equal to viewportBoundsRange[1]", "1.2-extensions"},
    {"VUID-VkViewport-y-01777", "(y + height) must be greater than or equal to viewportBoundsRange[0]", "1.2-extensions"},
    {"VUID-VkViewportSwizzleNV-w-parameter", "w must be a valid VkViewportCoordinateSwizzleNV value", "1.2-extensions"},
    {"VUID-VkViewportSwizzleNV-x-parameter", "x must be a valid VkViewportCoordinateSwizzleNV value", "1.2-extensions"},
    {"VUID-VkViewportSwizzleNV-y-parameter", "y must be a valid VkViewportCoordinateSwizzleNV value", "1.2-extensions"},
    {"VUID-VkViewportSwizzleNV-z-parameter", "z must be a valid VkViewportCoordinateSwizzleNV value", "1.2-extensions"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-display-01304", "display must point to a valid Wayland wl_display", "1.2-extensions"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-surface-01305", "surface must point to a valid Wayland wl_surface", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-commonparent", "Both of the elements of pAcquireSyncs, and the elements of pReleaseSyncs that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireKeys-parameter", "If acquireCount is not 0, pAcquireKeys must be a valid pointer to an array of acquireCount uint64_t values", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireSyncs-00081", "Each member of pAcquireSyncs and pReleaseSyncs must be a device memory object imported by setting VkImportMemoryWin32HandleInfoKHR::handleType to VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireSyncs-parameter", "If acquireCount is not 0, pAcquireSyncs must be a valid pointer to an array of acquireCount valid VkDeviceMemory handles", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireTimeouts-parameter", "If acquireCount is not 0, pAcquireTimeouts must be a valid pointer to an array of acquireCount uint32_t values", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseKeys-parameter", "If releaseCount is not 0, pReleaseKeys must be a valid pointer to an array of releaseCount uint64_t values", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseSyncs-parameter", "If releaseCount is not 0, pReleaseSyncs must be a valid pointer to an array of releaseCount valid VkDeviceMemory handles", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-commonparent", "Both of the elements of pAcquireSyncs, and the elements of pReleaseSyncs that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireKeys-parameter", "If acquireCount is not 0, pAcquireKeys must be a valid pointer to an array of acquireCount uint64_t values", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireSyncs-parameter", "If acquireCount is not 0, pAcquireSyncs must be a valid pointer to an array of acquireCount valid VkDeviceMemory handles", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireTimeoutMilliseconds-parameter", "If acquireCount is not 0, pAcquireTimeoutMilliseconds must be a valid pointer to an array of acquireCount uint32_t values", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseKeys-parameter", "If releaseCount is not 0, pReleaseKeys must be a valid pointer to an array of releaseCount uint64_t values", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseSyncs-parameter", "If releaseCount is not 0, pReleaseSyncs must be a valid pointer to an array of releaseCount valid VkDeviceMemory handles", "1.2-extensions"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV", "1.2-extensions"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-hinstance-01307", "hinstance must be a valid Win32 HINSTANCE", "1.2-extensions"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-hwnd-01308", "hwnd must be a valid Win32 HWND", "1.2-extensions"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-commonparent", "Both of dstSet, and the elements of pTexelBufferView that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorCount-00317", "All consecutive bindings updated via a single VkWriteDescriptorSet structure, except those with a descriptorCount of zero, must have identical descriptorType and stageFlags", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorCount-00318", "All consecutive bindings updated via a single VkWriteDescriptorSet structure, except those with a descriptorCount of zero, must all either use immutable samplers or must all not use immutable samplers", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorCount-arraylength", "descriptorCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00319", "descriptorType must match the type of dstBinding within dstSet", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00322", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER, VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, or VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, pImageInfo must be a valid pointer to an array of descriptorCount valid VkDescriptorImageInfo structures", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00324", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, pBufferInfo must be a valid pointer to an array of descriptorCount valid VkDescriptorBufferInfo structures", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00325", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and dstSet was not allocated with a layout that included immutable samplers for dstBinding with descriptorType, the sampler member of each element of pImageInfo must be a valid VkSampler object", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00327", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER or VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the offset member of each element of pBufferInfo must be a multiple of VkPhysicalDeviceLimits::minUniformBufferOffsetAlignment", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00328", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the offset member of each element of pBufferInfo must be a multiple of VkPhysicalDeviceLimits::minStorageBufferOffsetAlignment", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00329", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, and the buffer member of any element of pBufferInfo is the handle of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00330", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER or VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the buffer member of each element of pBufferInfo must have been created with VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT set", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00331", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the buffer member of each element of pBufferInfo must have been created with VK_BUFFER_USAGE_STORAGE_BUFFER_BIT set", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00332", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER or VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the range member of each element of pBufferInfo, or the effective range if range is VK_WHOLE_SIZE, must be less than or equal to VkPhysicalDeviceLimits::maxUniformBufferRange", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00333", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the range member of each element of pBufferInfo, or the effective range if range is VK_WHOLE_SIZE, must be less than or equal to VkPhysicalDeviceLimits::maxStorageBufferRange", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00334", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, the VkBuffer that each element of pTexelBufferView was created from must have been created with VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT set", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00335", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, the VkBuffer that each element of pTexelBufferView was created from must have been created with VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT set", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00336", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE or VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the imageView member of each element of pImageInfo must have been created with the identity swizzle", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00337", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the imageView member of each element of pImageInfo must have been created with VK_IMAGE_USAGE_SAMPLED_BIT set", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00338", "If descriptorType is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the imageView member of each element of pImageInfo must have been created with VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT set", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00339", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, the imageView member of each element of pImageInfo must have been created with VK_IMAGE_USAGE_STORAGE_BIT set", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-01946", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, then the imageView member of each pImageInfo element must have been created without a VkSamplerYcbcrConversionInfo structure in its pNext chain", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-01948", "If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and dstSet was allocated with a layout that included immutable samplers for dstBinding, then the imageView member of each element of pImageInfo which corresponds to an immutable sampler that enables sampler {YCbCr} conversion must have been created with a VkSamplerYcbcrConversionInfo structure in its pNext chain with an identically defined VkSamplerYcbcrConversionInfo to the corresponding immutable sampler", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02219", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, dstArrayElement must be an integer multiple of 4", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02220", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, descriptorCount must be an integer multiple of 4", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02221", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, the pNext chain must include a VkWriteDescriptorSetInlineUniformBlockEXT structure whose dataSize member equals descriptorCount", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02382", "If descriptorType is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR, the pNext chain must include a VkWriteDescriptorSetAccelerationStructureKHR structure whose accelerationStructureCount member equals descriptorCount", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02738", "If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and if any element of pImageInfo has a imageView member that was created with a VkSamplerYcbcrConversionInfo structure in its pNext chain, then dstSet must have been allocated with a layout that included immutable samplers for dstBinding, and the corresponding immutable sampler must have been created with an identically defined VkSamplerYcbcrConversionInfo object", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02752", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER, then dstSet must not have been allocated with a layout that included immutable samplers for dstBinding", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02994", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, each element of pTexelBufferView must be either a valid VkBufferView handle or VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02995", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER and the nullDescriptor feature is not enabled, each element of pTexelBufferView must not be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02996", "If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, or VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the imageView member of each element of pImageInfo must be either a valid VkImageView handle or VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02997", "If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, or VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT and the nullDescriptor feature is not enabled, the imageView member of each element of pImageInfo must not be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-03817", "If descriptorType is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, the pNext chain must include a VkWriteDescriptorSetAccelerationStructureNV structure whose accelerationStructureCount member equals descriptorCount", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-04149", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE the imageLayout member of each element of pImageInfo must be a member of the list given in Sampled Image", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-04150", "If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER the imageLayout member of each element of pImageInfo must be a member of the list given in Combined Image Sampler", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-04151", "If descriptorType is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT the imageLayout member of each element of pImageInfo must be a member of the list given in Input Attachment", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-04152", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE the imageLayout member of each element of pImageInfo must be a member of the list given in Storage Image", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-dstArrayElement-00321", "The sum of dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by dstBinding, and all applicable consecutive bindings, as described by consecutive binding updates", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-dstBinding-00315", "dstBinding must be less than or equal to the maximum value of binding of all VkDescriptorSetLayoutBinding structures specified when dstSet's descriptor set layout was created", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-dstBinding-00316", "dstBinding must be a binding with a non-zero descriptorCount", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-dstSet-00320", "dstSet must be a valid VkDescriptorSet handle", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-dstSet-04611", "If the VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, the new active descriptor type descriptorType must exist in the corresponding pMutableDescriptorTypeLists list for dstBinding", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkWriteDescriptorSetAccelerationStructureKHR, VkWriteDescriptorSetAccelerationStructureNV, or VkWriteDescriptorSetInlineUniformBlockEXT", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-sType-sType", "sType must be VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSet-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureKHR-accelerationStructureCount-02236", "accelerationStructureCount must be equal to descriptorCount in the extended structure", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureKHR-accelerationStructureCount-arraylength", "accelerationStructureCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureKHR-pAccelerationStructures-03579", "Each acceleration structure in pAccelerationStructures must have been created with a type of VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR or VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureKHR-pAccelerationStructures-03580", "If the nullDescriptor feature is not enabled, each element of pAccelerationStructures must not be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureKHR-pAccelerationStructures-parameter", "pAccelerationStructures must be a valid pointer to an array of accelerationStructureCount valid or VK_NULL_HANDLE VkAccelerationStructureKHR handles", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount-03747", "accelerationStructureCount must be equal to descriptorCount in the extended structure", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount-arraylength", "accelerationStructureCount must be greater than 0", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-03748", "Each acceleration structure in pAccelerationStructures must have been created with VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-03749", "If the nullDescriptor feature is not enabled, each member of pAccelerationStructures must not be VK_NULL_HANDLE", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-parameter", "pAccelerationStructures must be a valid pointer to an array of accelerationStructureCount valid or VK_NULL_HANDLE VkAccelerationStructureNV handles", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetInlineUniformBlockEXT-dataSize-02222", "dataSize must be an integer multiple of 4", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetInlineUniformBlockEXT-dataSize-arraylength", "dataSize must be greater than 0", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetInlineUniformBlockEXT-pData-parameter", "pData must be a valid pointer to an array of dataSize bytes", "1.2-extensions"},
    {"VUID-VkWriteDescriptorSetInlineUniformBlockEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT", "1.2-extensions"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-connection-01310", "connection must point to a valid X11 xcb_connection_t", "1.2-extensions"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-window-01311", "window must be a valid X11 xcb_window_t", "1.2-extensions"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-dpy-01313", "dpy must point to a valid Xlib Display", "1.2-extensions"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.2-extensions"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.2-extensions"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR", "1.2-extensions"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-window-01314", "window must be a valid Xlib Window", "1.2-extensions"},
    {"VUID-WarpIDNV-WarpIDNV-04420", "The variable decorated with WarpIDNV must be declared using the Input {StorageClass}", "1.2-extensions"},
    {"VUID-WarpIDNV-WarpIDNV-04421", "The variable decorated with WarpIDNV must be 