/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.formatter;

import cc.arduino.packages.formatter.AStyleInterface;
import java.io.File;
import java.io.IOException;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.helpers.FileUtils;
import processing.app.tools.Tool;

public class AStyle
implements Tool {
    private static final String FORMATTER_CONF = "formatter.conf";
    private final AStyleInterface aStyleInterface = new AStyleInterface();
    private final String formatterConfiguration;
    private Editor editor;

    public AStyle() {
        File customFormatterConf = BaseNoGui.getSettingsFile((String)FORMATTER_CONF);
        File defaultFormatterConf = new File(Base.getContentFile("lib"), FORMATTER_CONF);
        File formatterConf = customFormatterConf.exists() ? customFormatterConf : defaultFormatterConf;
        String formatterConfiguration = "";
        try {
            formatterConfiguration = FileUtils.readFileToString((File)formatterConf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.formatterConfiguration = formatterConfiguration;
    }

    @Override
    public void init(Editor editor) {
        this.editor = editor;
    }

    @Override
    public void run() {
        String originalText = this.editor.getCurrentTab().getText();
        String formattedText = this.aStyleInterface.AStyleMain(originalText, this.formatterConfiguration);
        if (formattedText.equals(originalText)) {
            this.editor.statusNotice(I18n.tr((String)"No changes necessary for Auto Format."));
            return;
        }
        this.editor.getCurrentTab().setText(formattedText);
        this.editor.statusNotice(I18n.tr((String)"Auto Format finished."));
    }

    @Override
    public String getMenuTitle() {
        return I18n.tr((String)"Auto Format");
    }
}

