/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import jogamp.graph.font.typecast.ot.table.GlyfCompositeComp;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfTable;

public class GlyfCompositeDescript
extends GlyfDescript {
    private final ArrayList<GlyfCompositeComp> _components = new ArrayList();

    public GlyfCompositeDescript(GlyfTable glyfTable, int n, DataInput dataInput) throws IOException {
        super(glyfTable, n, (short)-1, dataInput);
        GlyfCompositeComp glyfCompositeComp;
        int n2 = 0;
        int n3 = 0;
        do {
            glyfCompositeComp = new GlyfCompositeComp(n2, n3, dataInput);
            this._components.add(glyfCompositeComp);
            GlyfDescript glyfDescript = glyfTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfDescript == null) continue;
            n2 += glyfDescript.getPointCount();
            n3 += glyfDescript.getContourCount();
        } while ((glyfCompositeComp.getFlags() & 0x20) != 0);
        if ((glyfCompositeComp.getFlags() & 0x100) != 0) {
            this.readInstructions(dataInput, dataInput.readShort());
        }
    }

    @Override
    public int getEndPtOfContours(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeCompEndPt(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getEndPtOfContours(n - glyfCompositeComp.getFirstContour()) + glyfCompositeComp.getFirstIndex();
        }
        return 0;
    }

    @Override
    public byte getFlags(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getFlags(n - glyfCompositeComp.getFirstIndex());
        }
        return 0;
    }

    @Override
    public short getXCoordinate(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n2 = n - glyfCompositeComp.getFirstIndex();
            short s = glyfDescript.getXCoordinate(n2);
            short s2 = glyfDescript.getYCoordinate(n2);
            short s3 = (short)glyfCompositeComp.scaleX(s, s2);
            s3 = (short)(s3 + glyfCompositeComp.getXTranslate());
            return s3;
        }
        return 0;
    }

    @Override
    public short getYCoordinate(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n2 = n - glyfCompositeComp.getFirstIndex();
            short s = glyfDescript.getXCoordinate(n2);
            short s2 = glyfDescript.getYCoordinate(n2);
            short s3 = (short)glyfCompositeComp.scaleY(s, s2);
            s3 = (short)(s3 + glyfCompositeComp.getYTranslate());
            return s3;
        }
        return 0;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int getPointCount() {
        GlyfCompositeComp glyfCompositeComp = this._components.get(this._components.size() - 1);
        GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
        if (glyfDescript != null) {
            return glyfCompositeComp.getFirstIndex() + glyfDescript.getPointCount();
        }
        return 0;
    }

    @Override
    public int getContourCount() {
        GlyfCompositeComp glyfCompositeComp = this._components.get(this._components.size() - 1);
        GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
        return glyfCompositeComp.getFirstContour() + (null != glyfDescript ? glyfDescript.getContourCount() : 0);
    }

    public int getComponentIndex(int n) {
        return this._components.get(n).getFirstIndex();
    }

    public int getComponentCount() {
        return this._components.size();
    }

    public GlyfCompositeComp getComponent(int n) {
        return this._components.get(n);
    }

    protected GlyfCompositeComp getCompositeComp(int n) {
        for (int i = 0; i < this._components.size(); ++i) {
            GlyfCompositeComp glyfCompositeComp = this._components.get(i);
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstIndex() > n || n >= glyfCompositeComp.getFirstIndex() + glyfDescript.getPointCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }

    protected GlyfCompositeComp getCompositeCompEndPt(int n) {
        for (int i = 0; i < this._components.size(); ++i) {
            GlyfCompositeComp glyfCompositeComp = this._components.get(i);
            GlyfDescript glyfDescript = this._parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstContour() > n || n >= glyfCompositeComp.getFirstContour() + glyfDescript.getContourCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }
}

