/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;

public final class IntervalShortMap
extends IntervalMap<Short> {
    private short[] values;

    public IntervalShortMap() {
        this.values = new short[0];
    }

    public IntervalShortMap(int capacity) {
        super(capacity);
        this.values = new short[capacity];
    }

    public IntervalShortMap(double[] keys, short[] vals) {
        super(keys);
        this.values = new short[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public short getShort(Interval interval) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public short getShort(Interval interval, short defaultValue) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        return defaultValue;
    }

    public short[] toShortArray() {
        return (short[])this.toNativeArray();
    }

    @Override
    public Class<Short> getTypeClass() {
        return Short.class;
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Short.valueOf(max.shortValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Short.valueOf(min.shortValue()) : null;
    }

    @Override
    protected Short getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (short[])array;
    }
}

