/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.Cif2DataParser;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Logger;

public class TopoCifParser
implements CifReader.Parser {
    private static double ERROR_TOLERANCE = 0.001;
    CifReader reader;
    Lst<Node> nodes = new Lst();
    private Lst<Link> links = new Lst();
    Lst<Net> nets = new Lst();
    private String allowedTypes = "+v+hb+";
    private String bondlist = "";
    private static final String[] topolFields = new String[]{"_topol_link_node_label_1", "_topol_link_node_label_2", "_topol_link_distance", "_topol_link_site_symmetry_symop_1", "_topol_link_site_symmetry_translation_1_x", "_topol_link_site_symmetry_translation_1_y", "_topol_link_site_symmetry_translation_1_z", "_topol_link_site_symmetry_symop_2", "_topol_link_site_symmetry_translation_2_x", "_topol_link_site_symmetry_translation_2_y", "_topol_link_site_symmetry_translation_2_z", "_topol_link_type", "_topol_link_multiplicity", "_topol_link_voronoi_solidangle", "_topol_link_site_symmetry_translation_1", "_topol_link_site_symmetry_translation_2", "_topol_link_order", "_topol_node_atom_label", "_topol_node_label", "_topol_node_fract_x", "_topol_node_fract_y", "_topol_node_fract_z", "_topol_node_net_id", "_topol_node_chemical_formula_sum", "_topol_net_id"};
    private static final byte topol_link_node_label_1 = 0;
    private static final byte topol_link_node_label_2 = 1;
    private static final byte topol_link_distance = 2;
    private static final byte topol_link_site_symmetry_symop_1 = 3;
    private static final byte topol_link_site_symmetry_translation_1_x = 4;
    private static final byte topol_link_site_symmetry_translation_1_y = 5;
    private static final byte topol_link_site_symmetry_translation_1_z = 6;
    private static final byte topol_link_site_symmetry_symop_2 = 7;
    private static final byte topol_link_site_symmetry_translation_2_x = 8;
    private static final byte topol_link_site_symmetry_translation_2_y = 9;
    private static final byte topol_link_site_symmetry_translation_2_z = 10;
    private static final byte topol_link_type = 11;
    private static final byte topol_link_multiplicity = 12;
    private static final byte topol_link_voronoi_solidangle = 13;
    private static final byte topol_link_site_symmetry_translation_1 = 14;
    private static final byte topol_link_site_symmetry_translation_2 = 15;
    private static final byte topol_link_order = 16;
    private static final byte topol_node_atom_label = 17;
    private static final byte topol_node_label = 18;
    private static final byte topol_node_fract_x = 19;
    private static final byte topol_node_fract_y = 20;
    private static final byte topol_node_fract_z = 21;
    private static final byte topol_node_net_id = 22;
    private static final byte topol_node_chemical_formula_sum = 23;
    private static final byte topol_net_id = 24;
    String pre = "Net1";
    int linkIndex;
    int nodeIndex;
    int netIndex;
    private int ac0 = -1;

    public Node addNodeIfNull(String label) throws Exception {
        Node node = (Node)this.getTopo(this.nodes, label, 'n');
        Atom atom = this.reader.asc.getAtomFromName(node.atomName);
        if (atom == null) {
            atom = this.reader.asc.getAtomFromName(label);
            if (atom == null) {
                throw new Exception("TopoCIFParser.addNodeIfNull no atom " + label);
            }
            Node n = new Node(this.nodeIndex++, atom.atomName, atom.atomName, atom.getElementSymbol(), this.pre);
            n.set(atom.x, atom.y, atom.z);
            this.nodes.addLast(n);
            atom = n;
        }
        return (Node)atom;
    }

    public Object getTopo(Lst<?> l, String id, char type) {
        block4: for (int i = 0; i < l.size(); ++i) {
            Object o = l.get(i);
            switch (type) {
                case 'n': {
                    if (!((Node)o).label.equals(id)) continue block4;
                    return (Node)o;
                }
                case 'N': {
                    if (!((Net)o).id.equals(id)) continue block4;
                    return (Net)o;
                }
            }
        }
        return null;
    }

    @Override
    public TopoCifParser setReader(CifReader reader) {
        if (reader.checkFilterKey("NOTOPOL")) {
            return this;
        }
        this.reader = reader;
        String types = reader.getFilter("TOPOS_TYPES");
        if (types != null && types.length() > 1) {
            types = "+" + types.substring(1).toLowerCase() + "+";
        }
        if (reader.doApplySymmetry) {
            reader.asc.setNoAutoBond();
        }
        return this;
    }

    @Override
    public void processBlock(String key) throws Exception {
        if (this.reader == null) {
            return;
        }
        if (this.ac0 < 0) {
            this.ac0 = this.reader.asc.ac;
        }
        if (this.reader.ucItems != null) {
            this.reader.allow_a_len_1 = true;
            for (int i = 0; i < 6; ++i) {
                this.reader.setUnitCellItem(i, this.reader.ucItems[i]);
            }
        }
        this.reader.parseLoopParameters(topolFields);
        while (this.reader.cifParser.getData()) {
            if (this.getField((byte)18) != null) {
                this.processNode();
                continue;
            }
            if (this.getField((byte)0) != null) {
                this.processLink();
                continue;
            }
            if (this.getField((byte)24) == null) continue;
            this.processNet();
        }
    }

    private void processNode() throws Exception {
        String label = this.getField((byte)18);
        String atomLabel = this.getField((byte)17);
        String sym = this.getField((byte)23);
        float x = this.getFloat((byte)19);
        float y = this.getFloat((byte)20);
        float z = this.getFloat((byte)21);
        String netID = this.getField((byte)22);
        Node n = new Node(this.nodeIndex++, label, atomLabel, sym, netID);
        this.nodes.addLast(n);
        if (!Float.isNaN(x)) {
            n.set(x, y, z);
        }
    }

    private void processLink() throws Exception {
        int[] t1 = new int[3];
        int[] t2 = new int[3];
        String type = this.getField((byte)11);
        if (this.allowedTypes.indexOf("+" + type + "+") < 0) {
            return;
        }
        String label1 = this.getField((byte)0);
        String label2 = this.getField((byte)1);
        float d = this.getFloat((byte)2);
        if (d == 0.0f) {
            Logger.warn("TopoCifParser invalid distance");
            return;
        }
        int multiplicity = this.getInt((byte)12);
        float angle = this.getFloat((byte)13);
        int op1 = this.getInt((byte)3);
        int op2 = this.getInt((byte)7);
        int order = this.getInt((byte)16);
        String field = this.getField((byte)14);
        if (field.length() > 1) {
            t1 = Cif2DataParser.getIntArrayFromStringList(field, 3);
        } else {
            t1[0] = this.getInt((byte)4);
            t1[1] = this.getInt((byte)5);
            t1[2] = this.getInt((byte)6);
        }
        field = this.getField((byte)15);
        if (field.length() > 1) {
            t2 = Cif2DataParser.getIntArrayFromStringList(field, 3);
        } else {
            t2[0] = this.getInt((byte)8);
            t2[1] = this.getInt((byte)9);
            t2[2] = this.getInt((byte)10);
        }
        this.links.addLast(new Link(this.linkIndex++, label1, label2, d, op1, t1, op2, t2, multiplicity, type, angle, order));
    }

    private void processNet() throws Exception {
        this.nets.addLast(new Net(this.netIndex++, this.getField((byte)24)));
    }

    @Override
    public boolean finalizeReader() throws Exception {
        int i;
        if (this.reader == null) {
            return false;
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            ((Node)this.nodes.get(i)).finalizeNode();
        }
        for (i = 0; i < this.links.size(); ++i) {
            ((Link)this.links.get(i)).finalizeLink();
        }
        this.reader.applySymmetryAndSetTrajectory();
        return true;
    }

    @Override
    public void finalizeSymmetry(boolean haveSymmetry) throws Exception {
        if (this.reader == null || !haveSymmetry || !this.reader.doApplySymmetry) {
            return;
        }
        SymmetryInterface sym = this.reader.asc.getXSymmetry().getBaseSymmetry();
        int nOps = sym.getSpaceGroupOperationCount();
        M4[] operations = new M4[nOps];
        for (int i = 0; i < nOps; ++i) {
            operations[i] = sym.getSpaceGroupOperationRaw(i);
        }
        P3[] carts = new P3[this.reader.asc.ac];
        Atom[] atoms = this.reader.asc.atoms;
        int i = this.reader.asc.ac;
        while (--i >= this.ac0) {
            carts[i] = P3.newP(atoms[i]);
            sym.toCartesian(carts[i], true);
        }
        int n = 0;
        BS bsConnected = new BS();
        int nLinks = this.links.size();
        for (int i2 = 0; i2 < nLinks; ++i2) {
            Link link = (Link)this.links.get(i2);
            link.setPrimitives(sym, operations);
            n += this.setBonds(i2, atoms, carts, link, sym, nOps, bsConnected);
        }
        if (bsConnected.cardinality() > 0) {
            this.reader.asc.bsAtoms = bsConnected;
        }
        this.reader.appendLoadNote("TopoCifParser read " + nLinks + " links; created " + n + " edges and " + bsConnected.cardinality() + " nodes");
        Lst<Map<String, Object>> info = new Lst<Map<String, Object>>();
        for (int i3 = 0; i3 < nLinks; ++i3) {
            info.addLast(((Link)this.links.get(i3)).getInfo());
        }
        this.reader.asc.setCurrentModelInfo("topology", info);
    }

    private int setBonds(int index, Atom[] atoms, P3[] carts, Link link, SymmetryInterface sym, int nOps, BS bsConnected) {
        int nbonds = 0;
        BS bs1 = new BS();
        BS bs2 = new BS();
        int i = this.reader.asc.ac;
        while (--i >= this.ac0) {
            Atom a = atoms[i];
            if (!(a instanceof Node)) continue;
            if (a.atomSite == link.a1.atomSite) {
                bs1.set(i);
            }
            if (a.atomSite != link.a2.atomSite) continue;
            bs2.set(i);
        }
        P3 pa = new P3();
        BS bsym = new BS();
        int i1 = bs1.nextSetBit(0);
        while (i1 >= 0) {
            Atom at1 = atoms[i1];
            bsym.clearAll();
            for (int i2 = 0; i2 < nOps; ++i2) {
                TopoPrimitive prim = link.primitives[i2];
                if (prim == null) continue;
                pa.setT(at1);
                sym.unitize(pa);
                if (!TopoCifParser.isEqualD(pa, prim.p1u, 0.0)) continue;
                if (this.reader.debugging) {
                    Logger.debug("TopoCifParser " + link.info() + " primitive: " + prim.info());
                }
                bsym.set(i2);
            }
            link.symops = bsym;
            int i2 = bs2.nextSetBit(0);
            while (i2 >= 0) {
                if (i1 != i2 && TopoCifParser.isEqualD(carts[i1], carts[i2], link.d)) {
                    Atom at2 = atoms[i2];
                    V3 va12 = V3.newVsub(at2, at1);
                    int i3 = bsym.nextSetBit(0);
                    while (i3 >= 0) {
                        String key;
                        if (TopoCifParser.isEqualD(va12, link.primitives[i3].v12f, 0.0) && this.bondlist.indexOf(key = "," + at1.index + "," + at2.index + ",") < 0) {
                            this.bondlist = this.bondlist + key + at1.index + ",";
                            ++nbonds;
                            if (this.reader.debugging) {
                                Logger.debug(nbonds + " " + at1 + " " + at2 + " " + at1.index + " " + at2.index);
                            }
                            this.reader.asc.addNewBondWithOrderA(at1, at2, link.order);
                            bsConnected.set(at1.index);
                            bsConnected.set(at2.index);
                        }
                        i3 = bsym.nextSetBit(i3 + 1);
                    }
                }
                i2 = bs2.nextSetBit(i2 + 1);
            }
            i1 = bs1.nextSetBit(i1 + 1);
        }
        return nbonds;
    }

    static boolean isEqualD(T3 p1, T3 p2, double d) {
        return Double.isNaN(d) || Math.abs((double)p1.distance(p2) - d) < ERROR_TOLERANCE;
    }

    private String getField(byte field) {
        String f = this.reader.getField(field);
        return "\u0000".equals(f) ? null : f;
    }

    private int getInt(byte field) {
        String f = this.getField(field);
        return f == null ? Integer.MIN_VALUE : this.reader.parseIntStr(f);
    }

    private float getFloat(byte field) {
        String f = this.getField(field);
        return f == null ? Float.NaN : this.reader.parseFloatStr(f);
    }

    private class TopoPrimitive {
        P3 p1u;
        P3 p2u;
        V3 v12f;
        boolean isValid;
        int symop;

        TopoPrimitive(Link link, int symop, SymmetryInterface sym, M4 op) {
            this.symop = symop;
            P3 p1 = new P3();
            P3 p2 = new P3();
            p1.setT(link.p1f);
            p2.setT(link.p2f);
            op.rotTrans(p1);
            op.rotTrans(p2);
            this.p1u = P3.newP(p1);
            sym.unitize(this.p1u);
            this.p2u = P3.newP(p2);
            this.p2u.add(V3.newVsub(this.p1u, p1));
            this.v12f = V3.newVsub(this.p2u, this.p1u);
            p1.setT(this.p1u);
            p2.setT(this.p2u);
            sym.toCartesian(p1, true);
            sym.toCartesian(p2, true);
            if (Float.isNaN(link.d) || link.d == 0.0f) {
                System.out.println("TopoCifParser link distance " + link.p1f + "-" + link.p2f + " assigned " + p1.distance(p2) + " given as " + link.d);
                link.d = p1.distance(p2);
                this.isValid = true;
            } else {
                this.isValid = TopoCifParser.isEqualD(p1, p2, link.d);
            }
            if (!this.isValid) {
                String msg = "TopoCifParser link ignored due to distance error " + link.p1f + "-" + link.p2f + " actual " + p1.distance(p2) + " expected " + link.d + " for operator " + symop + "\n";
                TopoCifParser.this.reader.appendLoadNote(msg);
            }
        }

        public String info() {
            return "op=" + this.symop + " pt=" + this.p1u + " v=" + this.v12f;
        }

        public String toString() {
            return this.info();
        }
    }

    private class Net {
        int idx;
        BS nodes = new BS();
        String id;

        public Net(int index, String id) {
            this.idx = index;
            this.id = id;
        }
    }

    private class Link {
        int idx;
        String label1;
        String label2;
        Node a1;
        Node a2;
        int op1;
        int op2;
        P3 t1;
        P3 t2;
        P3 dt;
        String type;
        float voronoiAngle;
        int multiplicity;
        M4 m1;
        M4 m2;
        P3 p1f;
        P3 p2f;
        float d;
        int order;
        TopoPrimitive[] primitives;
        public BS symops;
        private int topoOrder;

        Link(int index, String label1, String label2, float d, int op1, int[] t1, int op2, int[] t2, int multiplicity, String type, float vAngle, int order) {
            this.idx = index;
            this.topoOrder = order;
            this.label1 = label1;
            this.label2 = label2;
            this.d = d;
            this.op1 = op1 - 1;
            this.op2 = op2 - 1;
            this.type = type;
            this.order = "vw".equals(type) ? 33 : ("hb".equals(type) ? 2048 : 1);
            this.t1 = P3.new3(t1[0], t1[1], t1[2]);
            this.t2 = P3.new3(t2[0], t2[1], t2[2]);
            this.dt = P3.new3(t2[0] - t1[0], t2[1] - t1[1], t2[2] - t1[2]);
            this.multiplicity = multiplicity;
            this.voronoiAngle = vAngle;
        }

        Map<String, Object> getInfo() {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("label1", this.a1.atomName);
            info.put("label2", this.a2.atomName);
            if (!Float.isNaN(this.d)) {
                info.put("distance", Float.valueOf(this.d));
            }
            info.put("symop1", this.op1 + 1);
            info.put("symop2", this.op2 + 1);
            info.put("t1", this.t1);
            info.put("t2", this.t2);
            info.put("multiplicity", this.multiplicity);
            info.put("type", this.type);
            info.put("voronoiSolidAngle", Float.valueOf(this.voronoiAngle));
            info.put("atomIndex1", this.a1.index);
            info.put("atomIndex2", this.a2.index);
            info.put("index", this.idx + 1);
            info.put("op1", this.m1);
            info.put("op2", this.m2);
            info.put("dt", this.dt);
            info.put("primitive1", this.p1f);
            info.put("primitive2", this.p2f);
            int[] ops = new int[this.symops.cardinality()];
            int p = 0;
            int i = this.symops.nextSetBit(0);
            while (i >= 0) {
                ops[p++] = i + 1;
                i = this.symops.nextSetBit(i + 1);
            }
            info.put("primitiveSymops", ops);
            info.put("topoOrder", this.topoOrder);
            info.put("order", this.order);
            return info;
        }

        void setPrimitives(SymmetryInterface sym, M4[] operations) {
            int nOps = operations.length;
            this.p1f = P3.new3(this.a1.x, this.a1.y, this.a1.z);
            this.p2f = P3.new3(this.a2.x, this.a2.y, this.a2.z);
            this.m1 = operations[this.op1];
            this.m1.rotTrans(this.p1f);
            this.m2 = operations[this.op2];
            this.m2.rotTrans(this.p2f);
            this.p2f.add(this.dt);
            this.primitives = new TopoPrimitive[nOps];
            for (int j = 0; j < nOps; ++j) {
                TopoPrimitive prim = new TopoPrimitive(this, j + 1, sym, operations[j]);
                if (!prim.isValid) continue;
                this.primitives[j] = prim;
            }
        }

        public String info() {
            return "[link " + (this.idx + 1) + " " + this.label1 + " " + this.label2 + " " + this.d + " " + this.type + "]";
        }

        public String toString() {
            return this.info();
        }

        public void finalizeLink() throws Exception {
            this.a1 = TopoCifParser.this.addNodeIfNull(this.label1);
            this.a2 = TopoCifParser.this.addNodeIfNull(this.label2);
            if (this.a1 == null || this.a2 == null) {
                Logger.warn("TopoCifParser atom " + (this.a1 == null ? this.label1 : this.label2) + " could not be found");
                return;
            }
        }
    }

    private class Node
    extends Atom {
        int idx;
        String label;
        String netID;
        Net net;
        private String formula;

        Node(int idx, String label, String atomLabel, String formula, String netID) {
            this.idx = idx;
            this.label = label;
            this.netID = netID;
            this.formula = formula;
            if (formula != null && formula.indexOf(" ") < 0) {
                this.atomName = formula;
                this.getElementSymbol();
                if (!formula.equals(this.elementSymbol)) {
                    this.elementSymbol = "Z";
                }
            }
            this.atomName = atomLabel;
        }

        public void finalizeNode() throws Exception {
            Net net;
            Atom a;
            Atom atom = a = this.atomName == null ? null : TopoCifParser.this.reader.asc.getAtomFromName(this.atomName);
            if (a == null) {
                if (Float.isNaN(this.x)) {
                    throw new Exception("TopoCIFParser.finalizeNode no atom " + this.atomName);
                }
                a = this;
                this.atomName = this.label;
                if (this.elementSymbol == null) {
                    this.getElementSymbol();
                }
            } else {
                this.atomName = a.atomName;
                this.elementSymbol = a.getElementSymbol();
                if (this.atomName == null) {
                    this.atomName = a.atomName = a.elementSymbol + (this.idx + 1);
                }
                this.set(a.x, a.y, a.z);
                this.atomName = this.label;
            }
            if (TopoCifParser.this.nets.size() == 0) {
                TopoCifParser.this.nets.addLast(new Net(TopoCifParser.this.netIndex++, TopoCifParser.this.pre));
            }
            if (this.netID == null) {
                this.netID = TopoCifParser.this.pre;
            }
            if ((net = (Net)TopoCifParser.this.getTopo(TopoCifParser.this.nets, this.netID, 'N')) == null) {
                net = (Net)TopoCifParser.this.getTopo(TopoCifParser.this.nets, TopoCifParser.this.pre, 'N');
            }
            this.atomName = this.netID + "_" + this.label;
            TopoCifParser.this.reader.addCifAtom(this, this.atomName, null, null);
        }

        public String info() {
            return "[node " + this.idx + " " + this.label + "/" + this.atomName + " " + super.toString() + "]";
        }

        @Override
        public String toString() {
            return this.info();
        }
    }
}

