/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.openstreetmap.josm.gui.mappaint.DividedScale;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.tools.Pair;

public final class StyleCache {
    private static final Map<StyleCache, StyleCache> internPool = new ConcurrentHashMap<StyleCache, StyleCache>();
    public static final StyleCache EMPTY_STYLECACHE = new StyleCache().intern();
    private DividedScale<StyleElementList> plainStyle;
    private DividedScale<StyleElementList> selectedStyle;

    private StyleCache(StyleCache sc) {
        this.plainStyle = sc.plainStyle;
        this.selectedStyle = sc.selectedStyle;
    }

    private StyleCache() {
    }

    public StyleCache put(StyleElementList o, Range r, boolean selected) {
        StyleCache s = new StyleCache(this);
        if (selected) {
            s.selectedStyle = (s.selectedStyle == null ? new DividedScale<StyleElementList>() : s.selectedStyle).put(o, r);
        } else {
            s.plainStyle = (s.plainStyle == null ? new DividedScale<StyleElementList>() : s.plainStyle).put(o, r);
        }
        return s.intern();
    }

    public Pair<StyleElementList, Range> getWithRange(double scale, boolean selected) {
        DividedScale<StyleElementList> style = selected ? this.selectedStyle : this.plainStyle;
        return style != null ? style.getWithRange(scale) : Pair.create(null, Range.ZERO_TO_INFINITY);
    }

    public String toString() {
        return "StyleCache{PLAIN: " + this.plainStyle + " SELECTED: " + this.selectedStyle + "}";
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.plainStyle) + Objects.hashCode(this.selectedStyle);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyleCache other = (StyleCache)obj;
        return Objects.equals(this.plainStyle, other.plainStyle) && Objects.equals(this.selectedStyle, other.selectedStyle);
    }

    private StyleCache intern() {
        return internPool.computeIfAbsent(this, Function.identity());
    }

    static void clearStyleCachePool() {
        internPool.clear();
    }

    public static int getInternPoolSize() {
        return internPool.size();
    }
}

