# This file has been autogenerated by the pywayland scanner

# Copyright © 2017 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource


class ZxdgOutputV1(Interface):
    """Compositor logical output region

    An xdg_output describes part of the compositor geometry.

    This typically corresponds to a monitor that displays part of the
    compositor space.

    For objects version 3 onwards, after all xdg_output properties have been
    sent (when the object is created and when properties are updated), a
    :func:`WlOutput.done() <pywayland.protocol.wayland.WlOutput.done>` event is
    sent. This allows changes to the output properties to be seen as atomic,
    even if they happen via multiple events.
    """

    name = "zxdg_output_v1"
    version = 3


class ZxdgOutputV1Proxy(Proxy):
    interface = ZxdgOutputV1

    @ZxdgOutputV1.request()
    def destroy(self):
        """Destroy the xdg_output object

        Using this request a client can tell the server that it is not going to
        use the xdg_output object anymore.
        """
        self._marshal(0)
        self._destroy()


class ZxdgOutputV1Resource(Resource):
    interface = ZxdgOutputV1

    @ZxdgOutputV1.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def logical_position(self, x, y):
        """Position of the output within the global compositor space

        The position event describes the location of the
        :class:`~pywayland.protocol.wayland.WlOutput` within the global
        compositor space.

        The logical_position event is sent after creating an xdg_output (see
        xdg_output_manager.get_xdg_output) and whenever the location of the
        output changes within the global compositor space.

        :param x:
            x position within the global compositor space
        :type x:
            `ArgumentType.Int`
        :param y:
            y position within the global compositor space
        :type y:
            `ArgumentType.Int`
        """
        self._post_event(0, x, y)

    @ZxdgOutputV1.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def logical_size(self, width, height):
        """Size of the output in the global compositor space

        The logical_size event describes the size of the output in the global
        compositor space.

        For example, a surface without any buffer scale, transformation nor
        rotation set, with the size matching the logical_size will have the
        same size as the corresponding output when displayed.

        Most regular Wayland clients should not pay attention to the logical
        size and would rather rely on
        :class:`~pywayland.protocol.xdg_shell_unstable_v5.XdgShell` interfaces.

        Some clients such as Xwayland, however, need this to configure their
        surfaces in the global compositor space as the compositor may apply a
        different scale from what is advertised by the output scaling property
        (to achieve fractional scaling, for example).

        For example, for a :class:`~pywayland.protocol.wayland.WlOutput` mode
        3840×2160 and a scale factor 2:

        - A compositor not scaling the surface buffers will advertise a logical
          size of 3840×2160,

        - A compositor automatically scaling the surface buffers will advertise
          a logical size of 1920×1080,

        - A compositor using a fractional scale of 1.5 will advertise a logical
          size to 2560×1620.

        For example, for a :class:`~pywayland.protocol.wayland.WlOutput` mode
        1920×1080 and a 90 degree rotation, the compositor will advertise a
        logical size of 1080x1920.

        The logical_size event is sent after creating an xdg_output (see
        xdg_output_manager.get_xdg_output) and whenever the logical size of the
        output changes, either as a result of a change in the applied scale or
        because of a change in the corresponding output mode(see
        :func:`WlOutput.mode() <pywayland.protocol.wayland.WlOutput.mode>`) or
        transform (see :func:`WlOutput.transform()
        <pywayland.protocol.wayland.WlOutput.transform>`).

        :param width:
            width in global compositor space
        :type width:
            `ArgumentType.Int`
        :param height:
            height in global compositor space
        :type height:
            `ArgumentType.Int`
        """
        self._post_event(1, width, height)

    @ZxdgOutputV1.event()
    def done(self):
        """All information about the output have been sent

        This event is sent after all other properties of an xdg_output have
        been sent.

        This allows changes to the xdg_output properties to be seen as atomic,
        even if they happen via multiple events.

        For objects version 3 onwards, this event is deprecated. Compositors
        are not required to send it anymore and must send
        :func:`WlOutput.done() <pywayland.protocol.wayland.WlOutput.done>`
        instead.
        """
        self._post_event(2)

    @ZxdgOutputV1.event(
        Argument(ArgumentType.String),
        version=2,
    )
    def name(self, name):
        """Name of this output

        Many compositors will assign names to their outputs, show them to the
        user, allow them to be configured by name, etc. The client may wish to
        know this name as well to offer the user similar behaviors.

        The naming convention is compositor defined, but limited to
        alphanumeric characters and dashes (-). Each name is unique among all
        :class:`~pywayland.protocol.wayland.WlOutput` globals, but if a
        :class:`~pywayland.protocol.wayland.WlOutput` global is destroyed the
        same name may be reused later. The names will also remain consistent
        across sessions with the same hardware and software configuration.

        Examples of names include 'HDMI-A-1', 'WL-1', 'X11-1', etc. However, do
        not assume that the name is a reflection of an underlying DRM
        connector, X11 connection, etc.

        The name event is sent after creating an xdg_output (see
        xdg_output_manager.get_xdg_output). This event is only sent once per
        xdg_output, and the name does not change over the lifetime of the
        :class:`~pywayland.protocol.wayland.WlOutput` global.

        :param name:
            output name
        :type name:
            `ArgumentType.String`
        """
        self._post_event(3, name)

    @ZxdgOutputV1.event(
        Argument(ArgumentType.String),
        version=2,
    )
    def description(self, description):
        """Human-readable description of this output

        Many compositors can produce human-readable descriptions of their
        outputs.  The client may wish to know this description as well, to
        communicate the user for various purposes.

        The description is a UTF-8 string with no convention defined for its
        contents. Examples might include 'Foocorp 11" Display' or 'Virtual X11
        output via :1'.

        The description event is sent after creating an xdg_output (see
        xdg_output_manager.get_xdg_output) and whenever the description
        changes. The description is optional, and may not be sent at all.

        For objects of version 2 and lower, this event is only sent once per
        xdg_output, and the description does not change over the lifetime of
        the :class:`~pywayland.protocol.wayland.WlOutput` global.

        :param description:
            output description
        :type description:
            `ArgumentType.String`
        """
        self._post_event(4, description)


class ZxdgOutputV1Global(Global):
    interface = ZxdgOutputV1


ZxdgOutputV1._gen_c()
ZxdgOutputV1.proxy_class = ZxdgOutputV1Proxy
ZxdgOutputV1.resource_class = ZxdgOutputV1Resource
ZxdgOutputV1.global_class = ZxdgOutputV1Global
