/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.CharacterIterator;
import java.text.DictionaryBasedBreakIterator;
import java.text.RuleBasedBreakIterator;
import java.text.StringCharacterIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.util.LocaleServiceProviderPool;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    private static final int CHARACTER_INDEX = 0;
    private static final int WORD_INDEX = 1;
    private static final int LINE_INDEX = 2;
    private static final int SENTENCE_INDEX = 3;
    private static final SoftReference[] iterCache = new SoftReference[4];

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    public int preceding(int offset) {
        int pos = this.following(offset);
        while (pos >= offset && pos != -1) {
            pos = this.previous();
        }
        return pos;
    }

    public boolean isBoundary(int offset) {
        if (offset == 0) {
            return true;
        }
        int boundary = this.following(offset - 1);
        if (boundary == -1) {
            throw new IllegalArgumentException();
        }
        return boundary == offset;
    }

    public abstract int current();

    public abstract CharacterIterator getText();

    public void setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 1, "WordData", "WordDictionary");
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 2, "LineData", "LineDictionary");
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 0, "CharacterData", "CharacterDictionary");
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 3, "SentenceData", "SentenceDictionary");
    }

    private static BreakIterator getBreakInstance(Locale locale, int type, String dataName, String dictionaryName) {
        BreakIteratorCache cache;
        if (iterCache[type] != null && (cache = (BreakIteratorCache)iterCache[type].get()) != null && cache.getLocale().equals(locale)) {
            return cache.createBreakInstance();
        }
        BreakIterator result = BreakIterator.createBreakInstance(locale, type, dataName, dictionaryName);
        BreakIteratorCache cache2 = new BreakIteratorCache(locale, result);
        BreakIterator.iterCache[type] = new SoftReference<BreakIteratorCache>(cache2);
        return result;
    }

    private static ResourceBundle getBundle(final String baseName, final Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle(baseName, locale);
            }
        });
    }

    private static BreakIterator createBreakInstance(Locale locale, int type, String dataName, String dictionaryName) {
        BreakIterator providersInstance;
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(BreakIteratorProvider.class);
        if (pool.hasProviders() && (providersInstance = pool.getLocalizedObject(BreakIteratorGetter.INSTANCE, locale, type)) != null) {
            return providersInstance;
        }
        ResourceBundle bundle = BreakIterator.getBundle("sun.text.resources.BreakIteratorInfo", locale);
        String[] classNames = bundle.getStringArray("BreakIteratorClasses");
        String dataFile = bundle.getString(dataName);
        try {
            if (classNames[type].equals("RuleBasedBreakIterator")) {
                return new RuleBasedBreakIterator(dataFile);
            }
            if (classNames[type].equals("DictionaryBasedBreakIterator")) {
                String dictionaryFile = bundle.getString(dictionaryName);
                return new DictionaryBasedBreakIterator(dataFile, dictionaryFile);
            }
            throw new IllegalArgumentException("Invalid break iterator class \"" + classNames[type] + "\"");
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    public static synchronized Locale[] getAvailableLocales() {
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(BreakIteratorProvider.class);
        return pool.getAvailableLocales();
    }

    static long getLong(byte[] buf, int offset) {
        long num = buf[offset] & 0xFF;
        for (int i = 1; i < 8; ++i) {
            num = num << 8 | (long)(buf[offset + i] & 0xFF);
        }
        return num;
    }

    static int getInt(byte[] buf, int offset) {
        int num = buf[offset] & 0xFF;
        for (int i = 1; i < 4; ++i) {
            num = num << 8 | buf[offset + i] & 0xFF;
        }
        return num;
    }

    static short getShort(byte[] buf, int offset) {
        short num = (short)(buf[offset] & 0xFF);
        num = (short)(num << 8 | buf[offset + 1] & 0xFF);
        return num;
    }

    private static class BreakIteratorGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<BreakIteratorProvider, BreakIterator> {
        private static final BreakIteratorGetter INSTANCE = new BreakIteratorGetter();

        private BreakIteratorGetter() {
        }

        @Override
        public BreakIterator getObject(BreakIteratorProvider breakIteratorProvider, Locale locale, String key, Object ... params) {
            assert (params.length == 1);
            switch ((Integer)params[0]) {
                case 0: {
                    return breakIteratorProvider.getCharacterInstance(locale);
                }
                case 1: {
                    return breakIteratorProvider.getWordInstance(locale);
                }
                case 2: {
                    return breakIteratorProvider.getLineInstance(locale);
                }
                case 3: {
                    return breakIteratorProvider.getSentenceInstance(locale);
                }
            }
            assert (false) : "should not happen";
            return null;
        }
    }

    private static final class BreakIteratorCache {
        private BreakIterator iter;
        private Locale locale;

        BreakIteratorCache(Locale locale, BreakIterator iter) {
            this.locale = locale;
            this.iter = (BreakIterator)iter.clone();
        }

        Locale getLocale() {
            return this.locale;
        }

        BreakIterator createBreakInstance() {
            return (BreakIterator)this.iter.clone();
        }
    }
}

