/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.HashMap;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.ContentType;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.Parameters;

public final class Request {
    private int serverPort = -1;
    private MessageBytes serverNameMB = MessageBytes.newInstance();
    private int remotePort;
    private int localPort;
    private MessageBytes schemeMB = MessageBytes.newInstance();
    private MessageBytes methodMB = MessageBytes.newInstance();
    private MessageBytes unparsedURIMB = MessageBytes.newInstance();
    private MessageBytes uriMB = MessageBytes.newInstance();
    private MessageBytes decodedUriMB = MessageBytes.newInstance();
    private MessageBytes queryMB = MessageBytes.newInstance();
    private MessageBytes protoMB = MessageBytes.newInstance();
    private MessageBytes remoteAddrMB = MessageBytes.newInstance();
    private MessageBytes localNameMB = MessageBytes.newInstance();
    private MessageBytes remoteHostMB = MessageBytes.newInstance();
    private MessageBytes localAddrMB = MessageBytes.newInstance();
    private MimeHeaders headers = new MimeHeaders();
    private MessageBytes instanceId = MessageBytes.newInstance();
    private Object[] notes = new Object[32];
    private InputBuffer inputBuffer = null;
    private UDecoder urlDecoder = new UDecoder();
    private long contentLength = -1L;
    private MessageBytes contentTypeMB = null;
    private String charEncoding = null;
    private Cookies cookies = new Cookies(this.headers);
    private Parameters parameters = new Parameters();
    private MessageBytes remoteUser = MessageBytes.newInstance();
    private boolean remoteUserNeedsAuthorization = false;
    private MessageBytes authType = MessageBytes.newInstance();
    private HashMap<String, Object> attributes = new HashMap();
    private Response response;
    private ActionHook hook;
    private long bytesRead = 0L;
    private long startTime = -1L;
    private int available = 0;
    private RequestInfo reqProcessorMX = new RequestInfo(this);

    public Request() {
        this.parameters.setQuery(this.queryMB);
        this.parameters.setURLDecoder(this.urlDecoder);
    }

    public MessageBytes instanceId() {
        return this.instanceId;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public UDecoder getURLDecoder() {
        return this.urlDecoder;
    }

    public MessageBytes scheme() {
        return this.schemeMB;
    }

    public MessageBytes method() {
        return this.methodMB;
    }

    public MessageBytes unparsedURI() {
        return this.unparsedURIMB;
    }

    public MessageBytes requestURI() {
        return this.uriMB;
    }

    public MessageBytes decodedURI() {
        return this.decodedUriMB;
    }

    public MessageBytes queryString() {
        return this.queryMB;
    }

    public MessageBytes protocol() {
        return this.protoMB;
    }

    public MessageBytes serverName() {
        return this.serverNameMB;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int n) {
        this.serverPort = n;
    }

    public MessageBytes remoteAddr() {
        return this.remoteAddrMB;
    }

    public MessageBytes remoteHost() {
        return this.remoteHostMB;
    }

    public MessageBytes localName() {
        return this.localNameMB;
    }

    public MessageBytes localAddr() {
        return this.localAddrMB;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int n) {
        this.remotePort = n;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int n) {
        this.localPort = n;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        this.charEncoding = ContentType.getCharsetFromContentType(this.getContentType());
        return this.charEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.charEncoding = string;
    }

    public void setContentLength(long l) {
        this.contentLength = l;
    }

    public int getContentLength() {
        long l = this.getContentLengthLong();
        if (l < Integer.MAX_VALUE) {
            return (int)l;
        }
        return -1;
    }

    public long getContentLengthLong() {
        if (this.contentLength > -1L) {
            return this.contentLength;
        }
        MessageBytes messageBytes = this.headers.getUniqueValue("content-length");
        this.contentLength = messageBytes == null || messageBytes.isNull() ? -1L : messageBytes.getLong();
        return this.contentLength;
    }

    public String getContentType() {
        this.contentType();
        if (this.contentTypeMB == null || this.contentTypeMB.isNull()) {
            return null;
        }
        return this.contentTypeMB.toString();
    }

    public void setContentType(String string) {
        this.contentTypeMB.setString(string);
    }

    public MessageBytes contentType() {
        if (this.contentTypeMB == null) {
            this.contentTypeMB = this.headers.getValue("content-type");
        }
        return this.contentTypeMB;
    }

    public void setContentType(MessageBytes messageBytes) {
        this.contentTypeMB = messageBytes;
    }

    public String getHeader(String string) {
        return this.headers.getHeader(string);
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
        response.setRequest(this);
    }

    public void action(ActionCode actionCode, Object object) {
        if (this.hook == null && this.response != null) {
            this.hook = this.response.getHook();
        }
        if (this.hook != null) {
            if (object == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, object);
            }
        }
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public HashMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public MessageBytes getRemoteUser() {
        return this.remoteUser;
    }

    public boolean getRemoteUserNeedsAuthorization() {
        return this.remoteUserNeedsAuthorization;
    }

    public void setRemoteUserNeedsAuthorization(boolean bl) {
        this.remoteUserNeedsAuthorization = bl;
    }

    public MessageBytes getAuthType() {
        return this.authType;
    }

    public int getAvailable() {
        return this.available;
    }

    public void setAvailable(int n) {
        this.available = n;
    }

    public boolean getSupportsRelativeRedirects() {
        return !this.protocol().equals("") && !this.protocol().equals("HTTP/1.0");
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(InputBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    public int doRead(ByteChunk byteChunk) throws IOException {
        int n = this.inputBuffer.doRead(byteChunk, this);
        if (n > 0) {
            this.bytesRead += (long)n;
        }
        return n;
    }

    public String toString() {
        return "R( " + this.requestURI().toString() + ")";
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public final void setNote(int n, Object object) {
        this.notes[n] = object;
    }

    public final Object getNote(int n) {
        return this.notes[n];
    }

    public void recycle() {
        this.bytesRead = 0L;
        this.contentLength = -1L;
        this.contentTypeMB = null;
        this.charEncoding = null;
        this.headers.recycle();
        this.serverNameMB.recycle();
        this.serverPort = -1;
        this.localNameMB.recycle();
        this.localPort = -1;
        this.remotePort = -1;
        this.available = 0;
        this.cookies.recycle();
        this.parameters.recycle();
        this.unparsedURIMB.recycle();
        this.uriMB.recycle();
        this.decodedUriMB.recycle();
        this.queryMB.recycle();
        this.methodMB.recycle();
        this.protoMB.recycle();
        this.schemeMB.recycle();
        this.instanceId.recycle();
        this.remoteUser.recycle();
        this.remoteUserNeedsAuthorization = false;
        this.authType.recycle();
        this.attributes.clear();
        this.startTime = -1L;
    }

    public void updateCounters() {
        this.reqProcessorMX.updateCounters();
    }

    public RequestInfo getRequestProcessor() {
        return this.reqProcessorMX;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public boolean isProcessing() {
        return this.reqProcessorMX.getStage() == 3;
    }
}

