/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.util.BitSet;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.CharChunk;

public final class UEncoder {
    private BitSet safeChars = null;
    private C2BConverter c2b = null;
    private ByteChunk bb = null;
    private CharChunk cb = null;
    private CharChunk output = null;
    private final boolean readOnlySafeChars;
    private String encoding = "UTF-8";

    public UEncoder() {
        this.safeChars = UEncoder.initialSafeChars();
        this.readOnlySafeChars = false;
    }

    public UEncoder(SafeCharsSet safeCharsSet) {
        this.safeChars = safeCharsSet.getSafeChars();
        this.readOnlySafeChars = true;
    }

    @Deprecated
    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void addSafeCharacter(char c) {
        if (this.readOnlySafeChars) {
            throw new IllegalStateException("UEncoders safeChararacters are read only");
        }
        this.safeChars.set(c);
    }

    public CharChunk encodeURL(String string, int n, int n2) throws IOException {
        if (this.c2b == null) {
            this.bb = new ByteChunk(8);
            this.cb = new CharChunk(2);
            this.output = new CharChunk(64);
            this.c2b = new C2BConverter(this.encoding);
        } else {
            this.bb.recycle();
            this.cb.recycle();
            this.output.recycle();
        }
        for (int i = n; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (this.safeChars.get(c2)) {
                this.output.append(c2);
                continue;
            }
            this.cb.append(c2);
            this.c2b.convert(this.cb, this.bb);
            if (c2 >= '\ud800' && c2 <= '\udbff' && i + 1 < n2 && (c = string.charAt(i + 1)) >= '\udc00' && c <= '\udfff') {
                this.cb.append(c);
                this.c2b.convert(this.cb, this.bb);
                ++i;
            }
            this.urlEncode(this.output, this.bb);
            this.cb.recycle();
            this.bb.recycle();
        }
        return this.output;
    }

    protected void urlEncode(CharChunk charChunk, ByteChunk byteChunk) throws IOException {
        byte[] byArray = byteChunk.getBuffer();
        for (int i = byteChunk.getStart(); i < byteChunk.getEnd(); ++i) {
            charChunk.append('%');
            char c = Character.forDigit(byArray[i] >> 4 & 0xF, 16);
            charChunk.append(c);
            c = Character.forDigit(byArray[i] & 0xF, 16);
            charChunk.append(c);
        }
    }

    private static BitSet initialSafeChars() {
        int n;
        BitSet bitSet = new BitSet(128);
        for (n = 97; n <= 122; ++n) {
            bitSet.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            bitSet.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            bitSet.set(n);
        }
        bitSet.set(36);
        bitSet.set(45);
        bitSet.set(95);
        bitSet.set(46);
        bitSet.set(33);
        bitSet.set(42);
        bitSet.set(39);
        bitSet.set(40);
        bitSet.set(41);
        bitSet.set(44);
        return bitSet;
    }

    static /* synthetic */ BitSet access$000() {
        return UEncoder.initialSafeChars();
    }

    public static enum SafeCharsSet {
        WITH_SLASH("/"),
        DEFAULT("");

        private final BitSet safeChars = UEncoder.access$000();

        private BitSet getSafeChars() {
            return this.safeChars;
        }

        private SafeCharsSet(String string2) {
            for (char c : string2.toCharArray()) {
                this.safeChars.set(c);
            }
        }
    }
}

