/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.CookieSupport;

public class ServerCookie
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MessageBytes name = MessageBytes.newInstance();
    private final MessageBytes value = MessageBytes.newInstance();
    private final MessageBytes path = MessageBytes.newInstance();
    private final MessageBytes domain = MessageBytes.newInstance();
    private boolean secure;
    private final MessageBytes comment = MessageBytes.newInstance();
    private int maxAge = -1;
    private int version = 0;
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> OLD_COOKIE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ServerCookie.OLD_COOKIE_PATTERN, Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return simpleDateFormat;
        }
    };
    private static final String ancientDate = OLD_COOKIE_FORMAT.get().format(new Date(10000L));

    public void recycle() {
        this.name.recycle();
        this.value.recycle();
        this.comment.recycle();
        this.maxAge = -1;
        this.path.recycle();
        this.domain.recycle();
        this.version = 0;
        this.secure = false;
    }

    public MessageBytes getComment() {
        return this.comment;
    }

    public MessageBytes getDomain() {
        return this.domain;
    }

    public void setMaxAge(int n) {
        this.maxAge = n;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public MessageBytes getPath() {
        return this.path;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public MessageBytes getName() {
        return this.name;
    }

    public MessageBytes getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public String toString() {
        return "Cookie " + this.getName() + "=" + this.getValue() + " ; " + this.getVersion() + " " + this.getPath() + " " + this.getDomain();
    }

    public static void appendCookieValue(StringBuffer stringBuffer, int n, String string, String string2, String string3, String string4, String string5, int n2, boolean bl, boolean bl2) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string);
        stringBuffer2.append("=");
        int n3 = n;
        if (n3 == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isHttpToken(string2) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isV0Token(string2))) {
            n3 = 1;
        }
        if (n3 == 0 && string5 != null) {
            n3 = 1;
        }
        if (n3 == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isHttpToken(string3) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isV0Token(string3))) {
            n3 = 1;
        }
        if (n3 == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isHttpToken(string4) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isV0Token(string4))) {
            n3 = 1;
        }
        ServerCookie.maybeQuote(stringBuffer2, string2);
        if (n3 == 1) {
            stringBuffer2.append("; Version=1");
            if (string5 != null) {
                stringBuffer2.append("; Comment=");
                ServerCookie.maybeQuote(stringBuffer2, string5);
            }
        }
        if (string4 != null) {
            stringBuffer2.append("; Domain=");
            ServerCookie.maybeQuote(stringBuffer2, string4);
        }
        if (n2 >= 0) {
            if (n3 > 0) {
                stringBuffer2.append("; Max-Age=");
                stringBuffer2.append(n2);
            }
            if (n3 == 0 || CookieSupport.ALWAYS_ADD_EXPIRES) {
                stringBuffer2.append("; Expires=");
                if (n2 == 0) {
                    stringBuffer2.append(ancientDate);
                } else {
                    OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)n2 * 1000L), stringBuffer2, new FieldPosition(0));
                }
            }
        }
        if (string3 != null) {
            stringBuffer2.append("; Path=");
            ServerCookie.maybeQuote(stringBuffer2, string3);
        }
        if (bl) {
            stringBuffer2.append("; Secure");
        }
        if (bl2) {
            stringBuffer2.append("; HttpOnly");
        }
        stringBuffer.append(stringBuffer2);
    }

    private static void maybeQuote(StringBuffer stringBuffer, String string) {
        if (string == null || string.length() == 0) {
            stringBuffer.append("\"\"");
        } else if (CookieSupport.alreadyQuoted(string)) {
            stringBuffer.append('\"');
            stringBuffer.append(ServerCookie.escapeDoubleQuotes(string, 1, string.length() - 1));
            stringBuffer.append('\"');
        } else if (CookieSupport.isHttpToken(string) && !CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 || CookieSupport.isV0Token(string) && CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0) {
            stringBuffer.append('\"');
            stringBuffer.append(ServerCookie.escapeDoubleQuotes(string, 0, string.length()));
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string);
        }
    }

    private static String escapeDoubleQuotes(String string, int n, int n2) {
        if (string == null || string.length() == 0 || string.indexOf(34) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append(c);
                if (++i >= n2) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (c == '\"') {
                stringBuffer.append('\\').append('\"');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

