/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AccessLogAdapter;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.MultiThrowable;
import org.apache.tomcat.util.res.StringManager;

public abstract class ContainerBase
extends LifecycleMBeanBase
implements Container {
    private static final Log log = LogFactory.getLog(ContainerBase.class);
    protected HashMap<String, Container> children = new HashMap();
    protected int backgroundProcessorDelay = -1;
    protected List<ContainerListener> listeners = new CopyOnWriteArrayList<ContainerListener>();
    protected Loader loader = null;
    private final ReadWriteLock loaderLock = new ReentrantReadWriteLock();
    protected Log logger = null;
    protected String logName = null;
    protected Manager manager = null;
    private final ReadWriteLock managerLock = new ReentrantReadWriteLock();
    protected Cluster cluster = null;
    private final ReadWriteLock clusterLock = new ReentrantReadWriteLock();
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected Pipeline pipeline = new StandardPipeline(this);
    private volatile Realm realm = null;
    private final ReadWriteLock realmLock = new ReentrantReadWriteLock();
    protected DirContext resources = null;
    private final ReadWriteLock resourcesLock = new ReentrantReadWriteLock();
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    protected boolean startChildren = true;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private volatile boolean threadDone = false;
    protected volatile AccessLog accessLog = null;
    private volatile boolean accessLogScanComplete = false;
    private int startStopThreads = 1;
    protected ThreadPoolExecutor startStopExecutor;

    @Override
    public int getStartStopThreads() {
        return this.startStopThreads;
    }

    private int getStartStopThreadsInternal() {
        int n = this.getStartStopThreads();
        if (n > 0) {
            return n;
        }
        n = Runtime.getRuntime().availableProcessors() + n;
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    @Override
    public void setStartStopThreads(int n) {
        this.startStopThreads = n;
        ThreadPoolExecutor threadPoolExecutor = this.startStopExecutor;
        if (threadPoolExecutor != null) {
            int n2 = this.getStartStopThreadsInternal();
            threadPoolExecutor.setMaximumPoolSize(n2);
            threadPoolExecutor.setCorePoolSize(n2);
        }
    }

    @Override
    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    @Override
    public void setBackgroundProcessorDelay(int n) {
        this.backgroundProcessorDelay = n;
    }

    @Override
    public String getInfo() {
        return this.getClass().getName();
    }

    @Override
    public Loader getLoader() {
        Lock lock = this.loaderLock.readLock();
        lock.lock();
        try {
            if (this.loader != null) {
                Loader loader = this.loader;
                return loader;
            }
            if (this.parent != null) {
                Loader loader = this.parent.getLoader();
                return loader;
            }
            Loader loader = null;
            return loader;
        }
        finally {
            lock.unlock();
        }
    }

    protected Loader getLoaderInternal() {
        Lock lock = this.loaderLock.readLock();
        lock.lock();
        try {
            Loader loader = this.loader;
            return loader;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoader(Loader loader) {
        Lock lock = this.loaderLock.writeLock();
        lock.lock();
        Loader loader2 = null;
        try {
            loader2 = this.loader;
            if (loader2 == loader) {
                return;
            }
            this.loader = loader;
            if (this.getState().isAvailable() && loader2 != null && loader2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)loader2)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"ContainerBase.setLoader: stop: ", (Throwable)lifecycleException);
                }
            }
            if (loader != null) {
                loader.setContainer(this);
            }
            if (this.getState().isAvailable() && loader != null && loader instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)loader)).start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"ContainerBase.setLoader: start: ", (Throwable)lifecycleException);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.support.firePropertyChange("loader", loader2, loader);
    }

    @Override
    public Log getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        this.logger = LogFactory.getLog((String)this.logName());
        return this.logger;
    }

    @Override
    public Manager getManager() {
        Lock lock = this.managerLock.readLock();
        lock.lock();
        try {
            if (this.manager != null) {
                Manager manager = this.manager;
                return manager;
            }
            if (this.parent != null) {
                Manager manager = this.parent.getManager();
                return manager;
            }
            Manager manager = null;
            return manager;
        }
        finally {
            lock.unlock();
        }
    }

    protected Manager getManagerInternal() {
        Lock lock = this.managerLock.readLock();
        lock.lock();
        try {
            Manager manager = this.manager;
            return manager;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setManager(Manager manager) {
        Lock lock = this.managerLock.writeLock();
        lock.lock();
        Manager manager2 = null;
        try {
            manager2 = this.manager;
            if (manager2 == manager) {
                return;
            }
            this.manager = manager;
            if (manager2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)manager2)).stop();
                    ((Lifecycle)((Object)manager2)).destroy();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"ContainerBase.setManager: stop-destroy: ", (Throwable)lifecycleException);
                }
            }
            if (manager != null) {
                manager.setContainer(this);
            }
            if (this.getState().isAvailable() && manager instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)manager)).start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"ContainerBase.setManager: start: ", (Throwable)lifecycleException);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.support.firePropertyChange("manager", manager2, manager);
    }

    @Override
    @Deprecated
    public Object getMappingObject() {
        return this;
    }

    @Override
    public Cluster getCluster() {
        Lock lock = this.clusterLock.readLock();
        lock.lock();
        try {
            if (this.cluster != null) {
                Cluster cluster = this.cluster;
                return cluster;
            }
            if (this.parent != null) {
                Cluster cluster = this.parent.getCluster();
                return cluster;
            }
            Cluster cluster = null;
            return cluster;
        }
        finally {
            lock.unlock();
        }
    }

    protected Cluster getClusterInternal() {
        Lock lock = this.clusterLock.readLock();
        lock.lock();
        try {
            Cluster cluster = this.cluster;
            return cluster;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCluster(Cluster cluster) {
        Cluster cluster2 = null;
        Lock lock = this.clusterLock.writeLock();
        lock.lock();
        try {
            cluster2 = this.cluster;
            if (cluster2 == cluster) {
                return;
            }
            this.cluster = cluster;
            if (this.getState().isAvailable() && cluster2 != null && cluster2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)cluster2)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"ContainerBase.setCluster: stop: ", (Throwable)lifecycleException);
                }
            }
            if (cluster != null) {
                cluster.setContainer(this);
            }
            if (this.getState().isAvailable() && cluster != null && cluster instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)cluster)).start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"ContainerBase.setCluster: start: ", (Throwable)lifecycleException);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.support.firePropertyChange("cluster", cluster2, cluster);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("containerBase.nullName"));
        }
        String string2 = this.name;
        this.name = string;
        this.support.firePropertyChange("name", string2, this.name);
    }

    public boolean getStartChildren() {
        return this.startChildren;
    }

    public void setStartChildren(boolean bl) {
        boolean bl2 = this.startChildren;
        this.startChildren = bl;
        this.support.firePropertyChange("startChildren", bl2, this.startChildren);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container container) {
        Container container2 = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", container2, this.parent);
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = this.parentClassLoader;
        this.parentClassLoader = classLoader;
        this.support.firePropertyChange("parentClassLoader", classLoader2, this.parentClassLoader);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Realm getRealm() {
        Lock lock = this.realmLock.readLock();
        lock.lock();
        try {
            if (this.realm != null) {
                Realm realm = this.realm;
                return realm;
            }
            if (this.parent != null) {
                Realm realm = this.parent.getRealm();
                return realm;
            }
            Realm realm = null;
            return realm;
        }
        finally {
            lock.unlock();
        }
    }

    protected Realm getRealmInternal() {
        Lock lock = this.realmLock.readLock();
        lock.lock();
        try {
            Realm realm = this.realm;
            return realm;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRealm(Realm realm) {
        Lock lock = this.realmLock.writeLock();
        lock.lock();
        try {
            Realm realm2 = this.realm;
            if (realm2 == realm) {
                return;
            }
            this.realm = realm;
            if (this.getState().isAvailable() && realm2 != null && realm2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)realm2)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"ContainerBase.setRealm: stop: ", (Throwable)lifecycleException);
                }
            }
            if (realm != null) {
                realm.setContainer(this);
            }
            if (this.getState().isAvailable() && realm != null && realm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)realm)).start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"ContainerBase.setRealm: start: ", (Throwable)lifecycleException);
                }
            }
            this.support.firePropertyChange("realm", realm2, this.realm);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public DirContext getResources() {
        Lock lock = this.resourcesLock.readLock();
        lock.lock();
        try {
            if (this.resources != null) {
                DirContext dirContext = this.resources;
                return dirContext;
            }
            if (this.parent != null) {
                DirContext dirContext = this.parent.getResources();
                return dirContext;
            }
            DirContext dirContext = null;
            return dirContext;
        }
        finally {
            lock.unlock();
        }
    }

    protected DirContext getResourcesInternal() {
        Lock lock = this.resourcesLock.readLock();
        lock.lock();
        try {
            DirContext dirContext = this.resources;
            return dirContext;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResources(DirContext dirContext) {
        Lock lock = this.resourcesLock.writeLock();
        lock.lock();
        DirContext dirContext2 = null;
        try {
            dirContext2 = this.resources;
            if (dirContext2 == dirContext) {
                return;
            }
            if (dirContext == null || dirContext instanceof ProxyDirContext) {
                this.resources = dirContext;
            } else {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                if (this.getParent() != null) {
                    hashtable.put("host", this.getParent().getName());
                }
                hashtable.put("context", this.getName());
                this.resources = new ProxyDirContext(hashtable, dirContext);
            }
        }
        finally {
            lock.unlock();
        }
        this.support.firePropertyChange("resources", dirContext2, dirContext);
    }

    @Override
    public void addChild(Container container) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAddChild privilegedAddChild = new PrivilegedAddChild(container);
            AccessController.doPrivileged(privilegedAddChild);
        } else {
            this.addChildInternal(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildInternal(Container container) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add child " + container + " " + this));
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(container.getName()) != null) {
                throw new IllegalArgumentException("addChild:  Child name '" + container.getName() + "' is not unique");
            }
            container.setParent(this);
            this.children.put(container.getName(), container);
        }
        try {
            if ((this.getState().isAvailable() || LifecycleState.STARTING_PREP.equals((Object)this.getState())) && this.startChildren) {
                container.start();
            }
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)"ContainerBase.addChild: start: ", (Throwable)lifecycleException);
            throw new IllegalStateException("ContainerBase.addChild: start: " + lifecycleException);
        }
        finally {
            this.fireContainerEvent("addChild", container);
        }
    }

    @Override
    public void addContainerListener(ContainerListener containerListener) {
        this.listeners.add(containerListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container findChild(String string) {
        if (string == null) {
            return null;
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            return this.children.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container[] findChildren() {
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            Container[] containerArray = new Container[this.children.size()];
            return this.children.values().toArray(containerArray);
        }
    }

    @Override
    public ContainerListener[] findContainerListeners() {
        ContainerListener[] containerListenerArray = new ContainerListener[]{};
        return this.listeners.toArray(containerListenerArray);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.pipeline.getFirst().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(Container container) {
        if (container == null) {
            return;
        }
        try {
            if (container.getState().isAvailable()) {
                container.stop();
            }
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)"ContainerBase.removeChild: stop: ", (Throwable)lifecycleException);
        }
        try {
            if (!LifecycleState.DESTROYING.equals((Object)container.getState())) {
                container.destroy();
            }
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)"ContainerBase.removeChild: destroy: ", (Throwable)lifecycleException);
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(container.getName()) == null) {
                return;
            }
            this.children.remove(container.getName());
        }
        this.fireContainerEvent("removeChild", container);
    }

    @Override
    public void removeContainerListener(ContainerListener containerListener) {
        this.listeners.remove(containerListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        this.startStopExecutor = new ThreadPoolExecutor(this.getStartStopThreadsInternal(), this.getStartStopThreadsInternal(), 10L, TimeUnit.SECONDS, linkedBlockingQueue, new StartStopThreadFactory(this.getName() + "-startStop-"));
        this.startStopExecutor.allowCoreThreadTimeOut(true);
        super.initInternal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void startInternal() throws LifecycleException {
        void future;
        DirContext dirContext;
        Realm realm;
        Cluster cluster;
        Loader loader = this.getLoaderInternal();
        if (loader != null && loader instanceof Lifecycle) {
            ((Lifecycle)((Object)loader)).start();
        }
        this.logger = null;
        this.getLogger();
        Manager manager = this.getManagerInternal();
        if (manager != null && manager instanceof Lifecycle) {
            ((Lifecycle)((Object)manager)).start();
        }
        if ((cluster = this.getClusterInternal()) != null && cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)cluster)).start();
        }
        if ((realm = this.getRealmInternal()) != null && realm instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).start();
        }
        if ((dirContext = this.getResourcesInternal()) != null && dirContext instanceof Lifecycle) {
            ((Lifecycle)((Object)dirContext)).start();
        }
        MultiThrowable multiThrowable = this.findChildren();
        ArrayList<Future<Void>> arrayList = new ArrayList<Future<Void>>();
        MultiThrowable multiThrowable2 = multiThrowable;
        int n = ((Container[])multiThrowable2).length;
        boolean bl = false;
        while (future < n) {
            Container throwable = multiThrowable2[future];
            arrayList.add(this.startStopExecutor.submit(new StartChild(throwable)));
            ++future;
        }
        multiThrowable2 = null;
        for (Future future2 : arrayList) {
            try {
                future2.get();
            }
            catch (Throwable throwable) {
                log.error((Object)sm.getString("containerBase.threadedStartFailed"), throwable);
                if (multiThrowable2 == null) {
                    multiThrowable2 = new MultiThrowable();
                }
                multiThrowable2.add(throwable);
            }
        }
        if (multiThrowable2 != null) {
            throw new LifecycleException(sm.getString("containerBase.threadedStartFailed"), multiThrowable2.getThrowable());
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.setState(LifecycleState.STARTING);
        this.threadStart();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        Loader loader;
        Manager manager;
        Cluster cluster;
        Realm realm;
        void future;
        this.threadStop();
        this.setState(LifecycleState.STOPPING);
        if (this.pipeline instanceof Lifecycle && ((Lifecycle)((Object)this.pipeline)).getState().isAvailable()) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] containerArray = this.findChildren();
        ArrayList<Future<Void>> arrayList = new ArrayList<Future<Void>>();
        Container[] containerArray2 = containerArray;
        int n = containerArray2.length;
        boolean bl = false;
        while (future < n) {
            Container exception = containerArray2[future];
            arrayList.add(this.startStopExecutor.submit(new StopChild(exception)));
            ++future;
        }
        boolean bl2 = false;
        for (Future realm2 : arrayList) {
            try {
                realm2.get();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("containerBase.threadedStopFailed"), (Throwable)exception);
                bl2 = true;
            }
        }
        if (bl2) {
            throw new LifecycleException(sm.getString("containerBase.threadedStopFailed"));
        }
        DirContext dirContext = this.getResourcesInternal();
        if (dirContext != null && dirContext instanceof Lifecycle) {
            ((Lifecycle)((Object)dirContext)).stop();
        }
        if ((realm = this.getRealmInternal()) != null && realm instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).stop();
        }
        if ((cluster = this.getClusterInternal()) != null && cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)cluster)).stop();
        }
        if ((manager = this.getManagerInternal()) != null && manager instanceof Lifecycle && ((Lifecycle)((Object)manager)).getState().isAvailable()) {
            ((Lifecycle)((Object)manager)).stop();
        }
        if ((loader = this.getLoaderInternal()) != null && loader instanceof Lifecycle) {
            ((Lifecycle)((Object)loader)).stop();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        Loader loader;
        Cluster cluster;
        Realm realm;
        Manager manager = this.getManagerInternal();
        if (manager != null && manager instanceof Lifecycle) {
            ((Lifecycle)((Object)manager)).destroy();
        }
        if ((realm = this.getRealmInternal()) != null && realm instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).destroy();
        }
        if ((cluster = this.getClusterInternal()) != null && cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)cluster)).destroy();
        }
        if ((loader = this.getLoaderInternal()) != null && loader instanceof Lifecycle) {
            ((Lifecycle)((Object)loader)).destroy();
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).destroy();
        }
        for (Container container : this.findChildren()) {
            this.removeChild(container);
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        if (this.startStopExecutor != null) {
            this.startStopExecutor.shutdownNow();
        }
        super.destroyInternal();
    }

    @Override
    public void logAccess(Request request, Response response, long l, boolean bl) {
        boolean bl2 = false;
        if (this.getAccessLog() != null) {
            this.getAccessLog().log(request, response, l);
            bl2 = true;
        }
        if (this.getParent() != null) {
            this.getParent().logAccess(request, response, l, bl && !bl2);
        }
    }

    @Override
    public AccessLog getAccessLog() {
        Valve[] valveArray;
        if (this.accessLogScanComplete) {
            return this.accessLog;
        }
        AccessLogAdapter accessLogAdapter = null;
        for (Valve valve : valveArray = this.getPipeline().getValves()) {
            if (!(valve instanceof AccessLog)) continue;
            if (accessLogAdapter == null) {
                accessLogAdapter = new AccessLogAdapter((AccessLog)((Object)valve));
                continue;
            }
            accessLogAdapter.add((AccessLog)((Object)valve));
        }
        if (accessLogAdapter != null) {
            this.accessLog = accessLogAdapter;
        }
        this.accessLogScanComplete = true;
        return this.accessLog;
    }

    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
    }

    @Override
    public void backgroundProcess() {
        Realm realm;
        Manager manager;
        Loader loader;
        if (!this.getState().isAvailable()) {
            return;
        }
        Cluster cluster = this.getClusterInternal();
        if (cluster != null) {
            try {
                cluster.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.cluster", new Object[]{cluster}), (Throwable)exception);
            }
        }
        if ((loader = this.getLoaderInternal()) != null) {
            try {
                loader.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.loader", new Object[]{loader}), (Throwable)exception);
            }
        }
        if ((manager = this.getManagerInternal()) != null) {
            try {
                manager.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.manager", new Object[]{manager}), (Throwable)exception);
            }
        }
        if ((realm = this.getRealmInternal()) != null) {
            try {
                realm.backgroundProcess();
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.realm", new Object[]{realm}), (Throwable)exception);
            }
        }
        for (Valve valve = this.pipeline.getFirst(); valve != null; valve = valve.getNext()) {
            try {
                valve.backgroundProcess();
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.valve", new Object[]{valve}), (Throwable)exception);
            }
        }
        this.fireLifecycleEvent("periodic", null);
    }

    @Override
    public void fireContainerEvent(String string, Object object) {
        if (this.listeners.size() < 1) {
            return;
        }
        ContainerEvent containerEvent = new ContainerEvent(this, string, object);
        for (ContainerListener containerListener : this.listeners) {
            containerListener.containerEvent(containerEvent);
        }
    }

    protected String logName() {
        if (this.logName != null) {
            return this.logName;
        }
        String string = null;
        for (Container container = this; container != null; container = container.getParent()) {
            String string2 = container.getName();
            if (string2 == null || string2.equals("")) {
                string2 = "/";
            } else if (string2.startsWith("##")) {
                string2 = "/" + string2;
            }
            string = "[" + string2 + "]" + (string != null ? "." + string : "");
        }
        this.logName = ContainerBase.class.getName() + "." + string;
        return this.logName;
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this);
    }

    public ObjectName[] getChildren() {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>(this.children.size());
        for (Container container : this.children.values()) {
            if (!(container instanceof ContainerBase)) continue;
            arrayList.add(((ContainerBase)container).getObjectName());
        }
        return arrayList.toArray(new ObjectName[0]);
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (this.backgroundProcessorDelay <= 0) {
            return;
        }
        this.threadDone = false;
        String string = "ContainerBackgroundProcessor[" + this.toString() + "]";
        this.thread = new Thread((Runnable)new ContainerBackgroundProcessor(), string);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    private static class StartStopThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public StartStopThreadFactory(String string) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = string;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class StopChild
    implements Callable<Void> {
        private Container child;

        public StopChild(Container container) {
            this.child = container;
        }

        @Override
        public Void call() throws LifecycleException {
            if (this.child.getState().isAvailable()) {
                this.child.stop();
            }
            return null;
        }
    }

    private static class StartChild
    implements Callable<Void> {
        private Container child;

        public StartChild(Container container) {
            this.child = container;
        }

        @Override
        public Void call() throws LifecycleException {
            this.child.start();
            return null;
        }
    }

    protected class ContainerBackgroundProcessor
    implements Runnable {
        protected ContainerBackgroundProcessor() {
        }

        @Override
        public void run() {
            Throwable throwable = null;
            String string = sm.getString("containerBase.backgroundProcess.unexpectedThreadDeath", new Object[]{Thread.currentThread().getName()});
            try {
                while (!ContainerBase.this.threadDone) {
                    try {
                        Thread.sleep((long)ContainerBase.this.backgroundProcessorDelay * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (ContainerBase.this.threadDone) continue;
                    Container container = (Container)ContainerBase.this.getMappingObject();
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (container.getLoader() != null) {
                        classLoader = container.getLoader().getClassLoader();
                    }
                    this.processChildren(container, classLoader);
                }
            }
            catch (RuntimeException runtimeException) {
                throwable = runtimeException;
                throw runtimeException;
            }
            catch (Error error) {
                throwable = error;
                throw error;
            }
            finally {
                if (!ContainerBase.this.threadDone) {
                    log.error((Object)string, throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processChildren(Container container, ClassLoader classLoader) {
            try {
                if (container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(container.getLoader().getClassLoader());
                }
                container.backgroundProcess();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)"Exception invoking periodic operation: ", throwable);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            Container[] containerArray = container.findChildren();
            for (int i = 0; i < containerArray.length; ++i) {
                if (containerArray[i].getBackgroundProcessorDelay() > 0) continue;
                this.processChildren(containerArray[i], classLoader);
            }
        }
    }

    protected class PrivilegedAddChild
    implements PrivilegedAction<Void> {
        private final Container child;

        PrivilegedAddChild(Container container) {
            this.child = container;
        }

        @Override
        public Void run() {
            ContainerBase.this.addChildInternal(this.child);
            return null;
        }
    }
}

