/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.HashMap;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.security.SecurityConfig;
import org.apache.catalina.startup.ContextConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public class Embedded
extends StandardService {
    private static final Log log = LogFactory.getLog(Embedded.class);
    protected boolean useNaming = true;
    protected boolean redirectStreams = true;
    protected Engine[] engines = new Engine[0];
    protected volatile HashMap<String, Authenticator> authenticators;
    protected static final String info = "org.apache.catalina.startup.Embedded/1.0";
    protected Realm realm = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    protected boolean await = false;

    public Embedded() {
        this(null);
    }

    public Embedded(Realm realm) {
        this.setRealm(realm);
        this.setSecurityProtection();
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        boolean bl2 = this.useNaming;
        this.useNaming = bl;
        this.support.firePropertyChange("useNaming", (Object)bl2, (Object)this.useNaming);
    }

    public boolean isRedirectStreams() {
        return this.redirectStreams;
    }

    public void setRedirectStreams(boolean bl) {
        boolean bl2 = this.redirectStreams;
        this.redirectStreams = bl;
        this.support.firePropertyChange("redirectStreams", (Object)bl2, (Object)this.redirectStreams);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        Realm realm2 = this.realm;
        this.realm = realm;
        this.support.firePropertyChange("realm", realm2, this.realm);
    }

    public void setAwait(boolean bl) {
        this.await = bl;
    }

    public boolean isAwait() {
        return this.await;
    }

    public void setCatalinaHome(String string) {
        System.setProperty("catalina.home", string);
    }

    public void setCatalinaBase(String string) {
        System.setProperty("catalina.base", string);
    }

    public String getCatalinaHome() {
        return System.getProperty("catalina.home");
    }

    public String getCatalinaBase() {
        return System.getProperty("catalina.base");
    }

    @Override
    public synchronized void addConnector(Connector connector) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding connector (" + connector.getInfo() + ")"));
        }
        if (this.engines.length < 1) {
            throw new IllegalStateException(sm.getString("embedded.noEngines"));
        }
        super.addConnector(connector);
    }

    public synchronized void addEngine(Engine engine) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding engine (" + engine.getInfo() + ")"));
        }
        Engine[] engineArray = new Engine[this.engines.length + 1];
        for (int i = 0; i < this.engines.length; ++i) {
            engineArray[i] = this.engines[i];
        }
        engineArray[this.engines.length] = engine;
        this.engines = engineArray;
        if (this.getState().isAvailable()) {
            try {
                engine.start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)"Engine.start", (Throwable)lifecycleException);
            }
        }
        this.container = engine;
    }

    public Connector createConnector(InetAddress inetAddress, int n, boolean bl) {
        return this.createConnector(inetAddress != null ? inetAddress.toString() : null, n, bl);
    }

    public Connector createConnector(String string, int n, boolean bl) {
        String string2 = "http";
        if (bl) {
            string2 = "https";
        }
        return this.createConnector(string, n, string2);
    }

    public Connector createConnector(InetAddress inetAddress, int n, String string) {
        return this.createConnector(inetAddress != null ? inetAddress.toString() : null, n, string);
    }

    public Connector createConnector(String string, int n, String string2) {
        int n2;
        Connector connector = null;
        if (string != null && (n2 = string.indexOf(47)) != -1) {
            string = string.substring(n2 + 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating connector for address='" + (string == null ? "ALL" : string) + "' port='" + n + "' protocol='" + string2 + "'"));
        }
        try {
            if (string2.equals("ajp")) {
                connector = new Connector("org.apache.coyote.ajp.AjpProtocol");
            } else if (string2.equals("memory")) {
                connector = new Connector("org.apache.coyote.memory.MemoryProtocolHandler");
            } else if (string2.equals("http")) {
                connector = new Connector();
            } else if (string2.equals("https")) {
                connector = new Connector();
                connector.setScheme("https");
                connector.setSecure(true);
                connector.setProperty("SSLEnabled", "true");
            } else {
                connector = new Connector(string2);
            }
            if (string != null) {
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)("" + string));
            }
            IntrospectionUtils.setProperty((Object)connector, (String)"port", (String)("" + n));
        }
        catch (Exception exception) {
            log.error((Object)"Couldn't create connector.");
        }
        return connector;
    }

    public Context createContext(String string, String string2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating context '" + string + "' with docBase '" + string2 + "'"));
        }
        StandardContext standardContext = new StandardContext();
        standardContext.setDocBase(string2);
        standardContext.setPath(string);
        ContextConfig contextConfig = new ContextConfig();
        contextConfig.setCustomAuthenticators(this.authenticators);
        standardContext.addLifecycleListener(contextConfig);
        return standardContext;
    }

    public Engine createEngine() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating engine");
        }
        StandardEngine standardEngine = new StandardEngine();
        standardEngine.setRealm(this.realm);
        return standardEngine;
    }

    public Host createHost(String string, String string2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating host '" + string + "' with appBase '" + string2 + "'"));
        }
        StandardHost standardHost = new StandardHost();
        standardHost.setAppBase(string2);
        standardHost.setName(string);
        return standardHost;
    }

    public Loader createLoader(ClassLoader classLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Loader with parent class loader '" + classLoader + "'"));
        }
        WebappLoader webappLoader = new WebappLoader(classLoader);
        return webappLoader;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public synchronized void removeContext(Context context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing context[" + context.getName() + "]"));
        }
        boolean bl = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] containerArray = this.engines[i].findChildren();
            for (int j = 0; j < containerArray.length; ++j) {
                Container[] containerArray2 = containerArray[j].findChildren();
                for (int k = 0; k < containerArray2.length; ++k) {
                    if (context != (Context)containerArray2[k]) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) break;
        }
        if (!bl) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Removing this Context");
        }
        context.getParent().removeChild(context);
    }

    public synchronized void removeEngine(Engine engine) {
        int n;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing engine (" + engine.getInfo() + ")"));
        }
        int n2 = -1;
        for (n = 0; n < this.engines.length; ++n) {
            if (engine != this.engines[n]) continue;
            n2 = n;
            break;
        }
        if (n2 < 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Removing related Containers");
        }
        while (true) {
            n = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (this.connectors[i].getService().getContainer() != engine) continue;
                n = i;
                break;
            }
            if (n < 0) break;
            this.removeConnector(this.connectors[n]);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Stopping this Engine");
        }
        try {
            engine.stop();
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)"Engine.stop", (Throwable)lifecycleException);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Removing this Engine");
        }
        int n3 = 0;
        Engine[] engineArray = new Engine[this.engines.length - 1];
        for (int i = 0; i < this.engines.length; ++i) {
            if (i == n2) continue;
            engineArray[n3++] = this.engines[i];
        }
        this.engines = engineArray;
    }

    public synchronized void removeHost(Host host) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing host[" + host.getName() + "]"));
        }
        boolean bl = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] containerArray = this.engines[i].findChildren();
            for (int j = 0; j < containerArray.length; ++j) {
                if (host != (Host)containerArray[j]) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Removing this Host");
        }
        host.getParent().removeChild(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticator(Authenticator authenticator, String string) {
        if (!(authenticator instanceof Valve)) {
            throw new IllegalArgumentException(sm.getString("embedded.authenticatorNotInstanceOfValve"));
        }
        if (this.authenticators == null) {
            Embedded embedded = this;
            synchronized (embedded) {
                if (this.authenticators == null) {
                    this.authenticators = new HashMap();
                }
            }
        }
        this.authenticators.put(string, authenticator);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        int n;
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting tomcat server");
        }
        this.initDirs();
        this.initNaming();
        this.setState(LifecycleState.STARTING);
        for (n = 0; n < this.engines.length; ++n) {
            this.engines[n].start();
        }
        for (n = 0; n < this.connectors.length; ++n) {
            this.connectors[n].start();
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        int n;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping embedded server");
        }
        this.setState(LifecycleState.STOPPING);
        for (n = 0; n < this.connectors.length; ++n) {
            this.connectors[n].stop();
        }
        for (n = 0; n < this.engines.length; ++n) {
            this.engines[n].stop();
        }
    }

    protected void initNaming() {
        if (!this.useNaming) {
            log.info((Object)"Catalina naming disabled");
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            String string = "org.apache.naming";
            String string2 = System.getProperty("java.naming.factory.url.pkgs");
            if (string2 != null) {
                string = string + ":" + string2;
            }
            System.setProperty("java.naming.factory.url.pkgs", string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting naming prefix=" + string));
            }
            if ((string = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            } else {
                log.debug((Object)("INITIAL_CONTEXT_FACTORY already set " + string));
            }
        }
    }

    protected void initDirs() {
        Object object;
        String string = System.getProperty("catalina.home");
        if (string == null) {
            object = System.getProperty("com.sun.enterprise.home");
            if (object != null) {
                string = System.getProperty("com.sun.enterprise.home");
            } else if (System.getProperty("catalina.base") != null) {
                string = System.getProperty("catalina.base");
            } else {
                string = IntrospectionUtils.guessInstall((String)"catalina.home", (String)"catalina.base", (String)"catalina.jar");
                if (string == null) {
                    string = IntrospectionUtils.guessInstall((String)"tomcat.install", (String)"catalina.home", (String)"tomcat.jar");
                }
            }
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (string != null) {
            object = new File(string);
            if (!((File)object).isAbsolute()) {
                try {
                    string = ((File)object).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = ((File)object).getAbsolutePath();
                }
            }
            System.setProperty("catalina.home", string);
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", string);
        } else {
            object = System.getProperty("catalina.base");
            File file = new File((String)object);
            if (!file.isAbsolute()) {
                try {
                    object = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    object = file.getAbsolutePath();
                }
            }
            System.setProperty("catalina.base", (String)object);
        }
        object = System.getProperty("java.io.tmpdir");
        if (object == null || !new File((String)object).exists() || !new File((String)object).isDirectory()) {
            log.error((Object)sm.getString("embedded.notmp", new Object[]{object}));
        }
    }

    protected void initStreams() {
        if (this.redirectStreams) {
            System.setOut((PrintStream)new SystemLogHandler(System.out));
            System.setErr((PrintStream)new SystemLogHandler(System.err));
        }
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }
}

