/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IOTools {
    protected static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOTools() {
    }

    public static void flow(Reader reader, Writer writer, char[] cArray) throws IOException {
        int n;
        while ((n = reader.read(cArray)) >= 0) {
            writer.write(cArray, 0, n);
        }
    }

    public static void flow(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[4096];
        IOTools.flow(reader, writer, cArray);
    }

    public static void flow(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        while ((n = inputStream.read(byArray)) >= 0) {
            if (outputStream == null) continue;
            outputStream.write(byArray, 0, n);
        }
    }

    public static void flow(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        IOTools.flow(inputStream, outputStream, byArray);
    }

    public static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        return n;
    }
}

