/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JdkLoggerFormatter
extends Formatter {
    private static final String LINE_SEP = System.getProperty("line.separator");
    public static final int LOG_LEVEL_TRACE = 400;
    public static final int LOG_LEVEL_DEBUG = 500;
    public static final int LOG_LEVEL_INFO = 800;
    public static final int LOG_LEVEL_WARN = 900;
    public static final int LOG_LEVEL_ERROR = 1000;
    public static final int LOG_LEVEL_FATAL = 1000;

    @Override
    public String format(LogRecord logRecord) {
        int n;
        Throwable throwable = logRecord.getThrown();
        int n2 = logRecord.getLevel().intValue();
        String string = logRecord.getLoggerName();
        long l = logRecord.getMillis();
        String string2 = this.formatMessage(logRecord);
        if (string.indexOf(46) >= 0) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l);
        for (n = 0; n < 8 - stringBuilder.length(); ++n) {
            stringBuilder.append(" ");
        }
        switch (n2) {
            case 400: {
                stringBuilder.append(" T ");
                break;
            }
            case 500: {
                stringBuilder.append(" D ");
                break;
            }
            case 800: {
                stringBuilder.append(" I ");
                break;
            }
            case 900: {
                stringBuilder.append(" W ");
                break;
            }
            case 1000: {
                stringBuilder.append(" E ");
                break;
            }
            default: {
                stringBuilder.append("   ");
            }
        }
        stringBuilder.append(string);
        stringBuilder.append(" ");
        for (n = 0; n < 8 - stringBuilder.length(); ++n) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string2);
        if (throwable != null) {
            stringBuilder.append(LINE_SEP);
            StringWriter stringWriter = new StringWriter(1024);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            stringBuilder.append(stringWriter.toString());
        }
        stringBuilder.append(LINE_SEP);
        return stringBuilder.toString();
    }
}

