/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.LookUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.PrintGraphics;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.fibs.geotag.util.ClassLoaderUtil;

public final class RenderingUtils {
    private static final String PROP_DESKTOPHINTS = "awt.font.desktophints";
    private static final String SWING_UTILITIES2_NAME = LookUtils.IS_JAVA_6_OR_LATER ? "sun.swing.SwingUtilities2" : "com.sun.java.swing.SwingUtilities2";
    private static Method drawStringUnderlineCharAtMethod = null;

    static {
        if (LookUtils.IS_JAVA_5_OR_LATER) {
            drawStringUnderlineCharAtMethod = RenderingUtils.getMethodDrawStringUnderlineCharAt();
        }
    }

    private RenderingUtils() {
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        if (LookUtils.IS_JAVA_5_OR_LATER) {
            if (drawStringUnderlineCharAtMethod != null) {
                try {
                    drawStringUnderlineCharAtMethod.invoke(null, c, g, text, new Integer(underlinedIndex), new Integer(x), new Integer(y));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            Graphics2D g2 = (Graphics2D)g;
            Map oldRenderingHints = RenderingUtils.installDesktopHints(g2);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, underlinedIndex, x, y);
            if (oldRenderingHints != null) {
                g2.addRenderingHints(oldRenderingHints);
            }
            return;
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, underlinedIndex, x, y);
    }

    private static Method getMethodDrawStringUnderlineCharAt() {
        try {
            Class<?> clazz = ClassLoaderUtil.getClassForName(SWING_UTILITIES2_NAME);
            return clazz.getMethod("drawStringUnderlineCharAt", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Map installDesktopHints(Graphics2D g2) {
        Map desktopHints;
        HashMap<RenderingHints.Key, Object> oldRenderingHints = null;
        if (LookUtils.IS_JAVA_6_OR_LATER && (desktopHints = RenderingUtils.desktopHints(g2)) != null && !desktopHints.isEmpty()) {
            oldRenderingHints = new HashMap<RenderingHints.Key, Object>(desktopHints.size());
            for (RenderingHints.Key key : desktopHints.keySet()) {
                oldRenderingHints.put(key, g2.getRenderingHint(key));
            }
            g2.addRenderingHints(desktopHints);
        }
        return oldRenderingHints;
    }

    private static Map desktopHints(Graphics2D g2) {
        Object aaHint;
        GraphicsDevice device;
        if (RenderingUtils.isPrinting(g2)) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints." + (device = g2.getDeviceConfiguration().getDevice()).getIDstring());
        if (desktopHints == null) {
            desktopHints = (Map)toolkit.getDesktopProperty(PROP_DESKTOPHINTS);
        }
        if (desktopHints != null && ((aaHint = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
            desktopHints = null;
        }
        return desktopHints;
    }

    private static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }
}

