/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.gradientslider;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.gephi.ui.components.gradientslider.GradientSlider;
import org.gephi.ui.components.gradientslider.MultiThumbSliderUI;
import org.gephi.ui.components.gradientslider.PaintUtils;

public class GradientSliderUI
extends MultiThumbSliderUI {
    int TRIANGLE_SIZE = 8;
    BufferedImage img = new BufferedImage(1000, 1, 2);
    int[] array = new int[this.img.getWidth()];
    static TexturePaint checkerPaint;
    static GeneralPath hTriangle;
    static GeneralPath vTriangle;

    public GradientSliderUI(GradientSlider slider) {
        super(slider);
    }

    @Override
    public int getClickLocationTolerance() {
        return this.TRIANGLE_SIZE;
    }

    protected void calculateImage() {
        Color[] c2;
        float[] f2;
        float[] f = this.slider.getThumbPositions();
        Color[] c = ((GradientSlider)this.slider).getColors();
        if (f[0] != 0.0f) {
            f2 = new float[f.length + 1];
            System.arraycopy(f, 0, f2, 1, f.length);
            c2 = new Color[c.length + 1];
            System.arraycopy(c, 0, c2, 1, f.length);
            f = f2;
            c = c2;
            f[0] = 0.0f;
            c[0] = c[1];
        }
        if (f[f.length - 1] != 1.0f) {
            f2 = new float[f.length + 1];
            System.arraycopy(f, 0, f2, 0, f.length);
            c2 = new Color[c.length + 1];
            System.arraycopy(c, 0, c2, 0, f.length);
            f = f2;
            c = c2;
            f[f.length - 1] = 1.0f;
            c[c.length - 1] = c[c.length - 2];
        }
        int[] argb = new int[c.length];
        for (int a = 0; a < argb.length; ++a) {
            argb[a] = ((c[a].getAlpha() & 0xFF) << 24) + ((c[a].getRed() & 0xFF) << 16) + ((c[a].getGreen() & 0xFF) << 8) + ((c[a].getBlue() & 0xFF) << 0);
        }
        int max = this.slider.getOrientation() == 0 ? this.trackRect.width : this.trackRect.height;
        if (max <= 0) {
            return;
        }
        boolean alwaysOpaque = GradientSliderUI.getProperty(this.slider, "GradientSlider.showTranslucency", "true").equals("false");
        int i1 = 0;
        int i2 = 1;
        int a1 = argb[0] >> 24 & 0xFF;
        int r1 = (argb[0] & 0xFF0000) >> 16;
        int g1 = (argb[0] & 0xFF00) >> 8;
        int b1 = (argb[0] & 0xFF) >> 0;
        int a2 = argb[1] >> 24 & 0xFF;
        int r2 = (argb[1] & 0xFF0000) >> 16;
        int g2 = (argb[1] & 0xFF00) >> 8;
        int b2 = (argb[1] & 0xFF) >> 0;
        for (int z = 0; z < max; ++z) {
            float colorFraction;
            float fraction = (float)z / (float)(max - 1);
            if (fraction < 1.0f && fraction >= f[i2]) {
                while (fraction < 1.0f && fraction >= f[i2]) {
                    ++i1;
                    ++i2;
                }
                a1 = argb[i1] >> 24 & 0xFF;
                r1 = (argb[i1] & 0xFF0000) >> 16;
                g1 = (argb[i1] & 0xFF00) >> 8;
                b1 = (argb[i1] & 0xFF) >> 0;
                a2 = argb[i2] >> 24 & 0xFF;
                r2 = (argb[i2] & 0xFF0000) >> 16;
                g2 = (argb[i2] & 0xFF00) >> 8;
                b2 = (argb[i2] & 0xFF) >> 0;
            }
            if ((colorFraction = (fraction - f[i1]) / (f[i2] - f[i1])) > 1.0f) {
                colorFraction = 1.0f;
            }
            if (colorFraction < 0.0f) {
                colorFraction = 0.0f;
            }
            if (alwaysOpaque) {
                a1 = 255;
                a2 = 255;
            }
            this.array[z] = ((int)((float)a1 * (1.0f - colorFraction) + (float)a2 * colorFraction) << 24) + ((int)((float)r1 * (1.0f - colorFraction) + (float)r2 * colorFraction) << 16) + ((int)((float)g1 * (1.0f - colorFraction) + (float)g2 * colorFraction) << 8) + (int)((float)b1 * (1.0f - colorFraction) + (float)b2 * colorFraction);
        }
        this.img.getRaster().setDataElements(0, 0, max, 1, this.array);
    }

    @Override
    public Dimension getMinimumSize(JComponent s) {
        Dimension d = super.getMinimumSize(s);
        if (this.slider.getOrientation() == 0) {
            d.height += 2;
        } else {
            d.width += 2;
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent s) {
        Dimension d = super.getPreferredSize(s);
        if (this.slider.getOrientation() == 0) {
            d.height += 2;
        } else {
            d.width += 2;
        }
        return d;
    }

    @Override
    protected Rectangle calculateTrackRect() {
        int w = this.slider.getWidth();
        int h = this.slider.getHeight();
        Rectangle r = new Rectangle();
        if (this.slider.getOrientation() == 0) {
            r.x = this.TRIANGLE_SIZE;
            r.y = 3;
            r.height = h - this.TRIANGLE_SIZE - r.y;
            r.width = w - 2 * this.TRIANGLE_SIZE;
            if (r.width > this.img.getWidth()) {
                r.width = this.img.getWidth();
                r.x = (w - 2 * this.TRIANGLE_SIZE) / 2 - r.width / 2;
            }
            if (r.height > 2 * this.DEPTH) {
                r.height = 2 * this.DEPTH;
                r.y = (h - this.TRIANGLE_SIZE) / 2 - r.height / 2;
            }
        } else {
            r.x = 3;
            r.y = this.TRIANGLE_SIZE;
            r.width = w - this.TRIANGLE_SIZE - r.x;
            r.height = h - 2 * this.TRIANGLE_SIZE;
            if (r.height > this.img.getWidth()) {
                r.height = this.img.getWidth();
                r.y = (h - 2 * this.TRIANGLE_SIZE) / 2 - r.height / 2;
            }
            if (r.width > 2 * this.DEPTH) {
                r.width = 2 * this.DEPTH;
                r.x = (w - this.TRIANGLE_SIZE) / 2 - r.width / 2;
            }
        }
        return r;
    }

    @Override
    protected void calculateGeometry() {
        super.calculateGeometry();
        this.calculateImage();
    }

    private static void createCheckerPaint() {
        int k = 4;
        BufferedImage bi = new BufferedImage(2 * k, 2 * k, 1);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 2 * k, 2 * k);
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, k, k);
        g.fillRect(k, k, k, k);
        checkerPaint = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
    }

    private Shape getFrame() {
        if (GradientSliderUI.getProperty(this.slider, "GradientSlider.useBevel", "false").equals("true")) {
            return this.trackRect;
        }
        if (this.slider.getOrientation() == 0) {
            int curve = Math.min(this.TRIANGLE_SIZE - 2, this.trackRect.height / 2);
            return new RoundRectangle2D.Float(this.trackRect.x - curve, this.trackRect.y, this.trackRect.width + 2 * curve, this.trackRect.height, curve * 2, curve * 2);
        }
        int curve = Math.min(this.TRIANGLE_SIZE - 2, this.trackRect.width / 2);
        return new RoundRectangle2D.Float(this.trackRect.x, this.trackRect.y - curve, this.trackRect.width, this.trackRect.height + 2 * curve, curve * 2, curve * 2);
    }

    @Override
    protected void paintTrack(Graphics2D g) {
        Composite oldComposite = g.getComposite();
        float alpha = this.slider.isEnabled() ? 1.0f : 0.5f;
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        Shape frame = this.getFrame();
        boolean alwaysOpaque = GradientSliderUI.getProperty(this.slider, "GradientSlider.showTranslucency", "true").equals("false");
        if (!alwaysOpaque) {
            if (checkerPaint == null) {
                GradientSliderUI.createCheckerPaint();
            }
            g.setPaint(checkerPaint);
            g.fill(frame);
        }
        TexturePaint tp = new TexturePaint(this.img, new Rectangle(this.trackRect.x, 0, this.img.getWidth(), 1));
        g.setPaint(tp);
        AffineTransform oldTransform = null;
        oldTransform = g.getTransform();
        AffineTransform transform = new AffineTransform();
        if (this.slider.getOrientation() == 1) {
            if (this.slider.isInverted()) {
                transform.rotate(1.5707963267948966, this.trackRect.x, this.trackRect.y);
            } else {
                transform.rotate(-1.5707963267948966, this.trackRect.x, this.trackRect.y + this.trackRect.height);
            }
        } else if (this.slider.isInverted()) {
            double x1 = this.trackRect.x;
            double x2 = this.trackRect.x + this.trackRect.width;
            double m00 = (x2 - x1) / (x1 - x2);
            double m02 = x1 - m00 * x2;
            transform.setTransform(m00, 0.0, 0.0, 1.0, m02, 0.0);
        }
        g.transform(transform);
        try {
            g.fill(transform.createInverse().createTransformedShape(this.trackRect));
        }
        catch (NoninvertibleTransformException x1) {
            // empty catch block
        }
        if (oldTransform != null) {
            g.setTransform(oldTransform);
        }
        if (GradientSliderUI.getProperty(this.slider, "GradientSlider.useBevel", "false").equals("true")) {
            PaintUtils.drawBevel(g, this.trackRect);
        } else {
            int last;
            int first;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Shape oldClip = g.getClip();
            Color[] colors = ((GradientSlider)this.slider).getColors();
            float[] f = this.slider.getThumbPositions();
            if (!this.slider.isInverted() && this.slider.getOrientation() == 0 || this.slider.isInverted() && this.slider.getOrientation() == 1) {
                first = 0;
                last = colors.length - 1;
                while (f[first] < 0.0f) {
                    ++first;
                }
                while (f[last] > 1.0f) {
                    --last;
                }
            } else {
                last = 0;
                first = colors.length - 1;
                while (f[last] < 0.0f) {
                    ++last;
                }
                while (f[first] > 1.0f) {
                    --first;
                }
            }
            if (this.slider.getOrientation() == 0) {
                g.clip(frame);
                g.setColor(colors[first]);
                g.fillRect(0, 0, this.trackRect.x, this.slider.getHeight());
                g.setColor(colors[last]);
                g.fillRect(this.trackRect.x + this.trackRect.width, 0, this.slider.getWidth() - (this.trackRect.x + this.trackRect.width), this.slider.getHeight());
            } else {
                g.clip(frame);
                g.setColor(colors[first]);
                g.fillRect(0, 0, this.slider.getWidth(), this.trackRect.y);
                g.setColor(colors[last]);
                g.fillRect(0, this.trackRect.y + this.trackRect.height, this.slider.getWidth(), this.slider.getHeight() - (this.trackRect.y + this.trackRect.height));
            }
            g.setStroke(new BasicStroke(1.0f));
            g.setClip(oldClip);
            g.setColor(new Color(0, 0, 0, 130));
            g.draw(frame);
            g.setColor(new Color(0, 0, 0, 130));
        }
        if (this.slider.isPaintTicks()) {
            this.paintTick(g, 0.25f, 2);
            this.paintTick(g, 0.5f, 2);
            this.paintTick(g, 0.75f, 2);
            this.paintTick(g, 0.0f, 2);
            this.paintTick(g, 1.0f, 2);
        }
        g.setComposite(oldComposite);
    }

    protected void paintTick(Graphics2D g, float f, int d) {
        if (this.slider.getOrientation() == 0) {
            int x = (int)((float)this.trackRect.x + (float)this.trackRect.width * f + 0.5f);
            int y = this.trackRect.y + this.trackRect.height;
            g.drawLine(x, y, x, y + d);
            y = this.trackRect.y;
            g.drawLine(x, y, x, y - d);
        } else {
            int y = (int)((float)this.trackRect.y + (float)this.trackRect.height * f + 0.5f);
            int x = this.trackRect.x + this.trackRect.width;
            g.drawLine(x, y, x + d, y);
            x = this.trackRect.x;
            g.drawLine(x, y, x - d, y);
        }
    }

    @Override
    protected void paintFocus(Graphics2D g) {
    }

    @Override
    protected void paintThumbs(Graphics2D g) {
        GeneralPath shape;
        if (!this.slider.isEnabled()) {
            return;
        }
        if (hTriangle == null) {
            hTriangle = new GeneralPath();
            hTriangle.moveTo(0.0f, 0.0f);
            hTriangle.lineTo(this.TRIANGLE_SIZE, this.TRIANGLE_SIZE);
            hTriangle.lineTo(-this.TRIANGLE_SIZE, this.TRIANGLE_SIZE);
            hTriangle.lineTo(0.0f, 0.0f);
            hTriangle.closePath();
            vTriangle = new GeneralPath();
            vTriangle.moveTo(0.0f, 0.0f);
            vTriangle.lineTo(this.TRIANGLE_SIZE, this.TRIANGLE_SIZE);
            vTriangle.lineTo(this.TRIANGLE_SIZE, -this.TRIANGLE_SIZE);
            vTriangle.lineTo(0.0f, 0.0f);
            vTriangle.closePath();
        }
        AffineTransform t = new AffineTransform();
        int dx = this.trackRect.x + this.trackRect.width;
        int dy = this.trackRect.y + this.trackRect.height;
        dy -= this.trackRect.height / 6;
        dx -= this.trackRect.width / 6;
        int selected = this.slider.getSelectedThumb(false);
        float[] f = this.slider.getThumbPositions();
        int orientation = this.slider.getOrientation();
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, this.indication));
        for (int a = 0; a < this.thumbPositions.length; ++a) {
            if (!(f[a] >= 0.0f) || !(f[a] <= 1.0f) || a == selected) continue;
            if (orientation == 0) {
                dx = this.thumbPositions[a];
                shape = hTriangle;
            } else {
                dy = this.thumbPositions[a];
                shape = vTriangle;
            }
            t.setToTranslation(dx, dy);
            g.transform(t);
            float brightness = Math.max(0.0f, this.thumbIndications[a] * 0.6f);
            g.setColor(new Color((int)(255.0f * brightness), (int)(255.0f * brightness), (int)(255.0f * brightness)));
            g.fill(shape);
            g.translate(-0.5, -0.5);
            g.setColor(new Color(255, 255, 255));
            g.draw(shape);
            g.translate(0.5, 0.5);
            t.setToTranslation(-dx, -dy);
            g.transform(t);
        }
        g.setComposite(AlphaComposite.getInstance(3, this.indication));
        if (selected != -1 && f[selected] >= 0.0f && f[selected] <= 1.0f) {
            if (orientation == 0) {
                dx = this.thumbPositions[selected];
                shape = hTriangle;
            } else {
                dy = this.thumbPositions[selected];
                shape = vTriangle;
            }
            t.setToTranslation(dx, dy);
            g.transform(t);
            g.setColor(new Color(255, 255, 255));
            g.fill(shape);
            g.translate(-0.5, -0.5);
            g.setColor(new Color(0, 0, 0));
            g.draw(shape);
            g.translate(0.5, 0.5);
            t.setToTranslation(-dx, -dy);
            g.transform(t);
        }
        g.setComposite(oldComposite);
    }

    static {
        hTriangle = null;
        vTriangle = null;
    }
}

