/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2SubGrid;
import org.openstreetmap.josm.data.projection.datum.NTV2Util;
import org.openstreetmap.josm.tools.Logging;

public class NTV2GridShiftFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int overviewHeaderCount;
    private int subGridHeaderCount;
    private int subGridCount;
    private String shiftType;
    private String version;
    private String fromEllipsoid = "";
    private String toEllipsoid = "";
    private double fromSemiMajorAxis;
    private double fromSemiMinorAxis;
    private double toSemiMajorAxis;
    private double toSemiMinorAxis;
    private NTV2SubGrid[] topLevelSubGrid;
    private NTV2SubGrid lastSubGrid;

    private static void readBytes(InputStream in, byte[] b) throws IOException {
        if (in.read(b) < b.length) {
            Logging.error("Failed to read expected amount of bytes (" + b.length + ") from stream");
        }
    }

    public void loadGridShiftFile(InputStream in, boolean loadAccuracy) throws IOException {
        boolean bigEndian;
        byte[] b8 = new byte[8];
        this.fromEllipsoid = "";
        this.toEllipsoid = "";
        this.topLevelSubGrid = null;
        NTV2GridShiftFile.readBytes(in, b8);
        String overviewHeaderCountId = new String(b8, StandardCharsets.UTF_8);
        if (!"NUM_OREC".equals(overviewHeaderCountId)) {
            throw new IllegalArgumentException("Input file is not an NTv2 grid shift file");
        }
        NTV2GridShiftFile.readBytes(in, b8);
        this.overviewHeaderCount = NTV2Util.getIntBE(b8, 0);
        if (this.overviewHeaderCount == 11) {
            bigEndian = true;
        } else {
            this.overviewHeaderCount = NTV2Util.getIntLE(b8, 0);
            if (this.overviewHeaderCount == 11) {
                bigEndian = false;
            } else {
                throw new IllegalArgumentException("Input file is not an NTv2 grid shift file");
            }
        }
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.subGridHeaderCount = NTV2Util.getInt(b8, bigEndian);
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.subGridCount = NTV2Util.getInt(b8, bigEndian);
        NTV2SubGrid[] subGrid = new NTV2SubGrid[this.subGridCount];
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.shiftType = new String(b8, StandardCharsets.UTF_8);
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.version = new String(b8, StandardCharsets.UTF_8);
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.fromEllipsoid = new String(b8, StandardCharsets.UTF_8);
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.toEllipsoid = new String(b8, StandardCharsets.UTF_8);
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.fromSemiMajorAxis = NTV2Util.getDouble(b8, bigEndian);
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.fromSemiMinorAxis = NTV2Util.getDouble(b8, bigEndian);
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.toSemiMajorAxis = NTV2Util.getDouble(b8, bigEndian);
        NTV2GridShiftFile.readBytes(in, b8);
        NTV2GridShiftFile.readBytes(in, b8);
        this.toSemiMinorAxis = NTV2Util.getDouble(b8, bigEndian);
        for (int i = 0; i < this.subGridCount; ++i) {
            subGrid[i] = new NTV2SubGrid(in, bigEndian, loadAccuracy);
        }
        this.topLevelSubGrid = NTV2GridShiftFile.createSubGridTree(subGrid);
        this.lastSubGrid = this.topLevelSubGrid[0];
    }

    private static NTV2SubGrid[] createSubGridTree(NTV2SubGrid ... subGrid) {
        int topLevelCount = 0;
        HashMap subGridMap = new HashMap();
        for (int i = 0; i < subGrid.length; ++i) {
            if ("NONE".equalsIgnoreCase(subGrid[i].getParentSubGridName())) {
                ++topLevelCount;
            }
            subGridMap.put(subGrid[i].getSubGridName(), new ArrayList());
        }
        NTV2SubGrid[] topLevelSubGrid = new NTV2SubGrid[topLevelCount];
        topLevelCount = 0;
        for (int i = 0; i < subGrid.length; ++i) {
            if ("NONE".equalsIgnoreCase(subGrid[i].getParentSubGridName())) {
                topLevelSubGrid[topLevelCount++] = subGrid[i];
                continue;
            }
            List parent = (List)subGridMap.get(subGrid[i].getParentSubGridName());
            parent.add(subGrid[i]);
        }
        NTV2SubGrid[] nullArray = new NTV2SubGrid[]{};
        for (int i = 0; i < subGrid.length; ++i) {
            List subSubGrids = (List)subGridMap.get(subGrid[i].getSubGridName());
            if (subSubGrids.isEmpty()) continue;
            NTV2SubGrid[] subGridArray = subSubGrids.toArray(nullArray);
            subGrid[i].setSubGridArray(subGridArray);
        }
        return topLevelSubGrid;
    }

    public boolean gridShiftForward(NTV2GridShift gs) {
        NTV2SubGrid subGrid = null;
        if (this.lastSubGrid != null) {
            subGrid = this.lastSubGrid.getSubGridForCoord(gs.getLonPositiveWestSeconds(), gs.getLatSeconds());
        }
        if (subGrid == null) {
            subGrid = NTV2GridShiftFile.getSubGrid(this.topLevelSubGrid, gs.getLonPositiveWestSeconds(), gs.getLatSeconds());
        }
        if (subGrid == null) {
            return false;
        }
        subGrid.interpolateGridShift(gs);
        gs.setSubGridName(subGrid.getSubGridName());
        this.lastSubGrid = subGrid;
        return true;
    }

    public boolean gridShiftReverse(NTV2GridShift gs) {
        NTV2GridShift forwardGs = new NTV2GridShift();
        forwardGs.setLonPositiveWestSeconds(gs.getLonPositiveWestSeconds());
        forwardGs.setLatSeconds(gs.getLatSeconds());
        for (int i = 0; i < 4; ++i) {
            if (!this.gridShiftForward(forwardGs)) {
                return false;
            }
            forwardGs.setLonPositiveWestSeconds(gs.getLonPositiveWestSeconds() - forwardGs.getLonShiftPositiveWestSeconds());
            forwardGs.setLatSeconds(gs.getLatSeconds() - forwardGs.getLatShiftSeconds());
        }
        gs.setLonShiftPositiveWestSeconds(-forwardGs.getLonShiftPositiveWestSeconds());
        gs.setLatShiftSeconds(-forwardGs.getLatShiftSeconds());
        gs.setLonAccuracyAvailable(forwardGs.isLonAccuracyAvailable());
        if (forwardGs.isLonAccuracyAvailable()) {
            gs.setLonAccuracySeconds(forwardGs.getLonAccuracySeconds());
        }
        gs.setLatAccuracyAvailable(forwardGs.isLatAccuracyAvailable());
        if (forwardGs.isLatAccuracyAvailable()) {
            gs.setLatAccuracySeconds(forwardGs.getLatAccuracySeconds());
        }
        return true;
    }

    private static NTV2SubGrid getSubGrid(NTV2SubGrid[] topLevelSubGrid, double lon, double lat) {
        NTV2SubGrid topLevel;
        NTV2SubGrid sub = null;
        NTV2SubGrid[] nTV2SubGridArray = topLevelSubGrid;
        int n = nTV2SubGridArray.length;
        for (int i = 0; i < n && (sub = (topLevel = nTV2SubGridArray[i]).getSubGridForCoord(lon, lat)) == null; ++i) {
        }
        return sub;
    }

    public String toString() {
        char endl = '\n';
        return "Headers  : " + this.overviewHeaderCount + endl + "Sub Hdrs : " + this.subGridHeaderCount + endl + "Sub Grids: " + this.subGridCount + endl + "Type     : " + this.shiftType + endl + "Version  : " + this.version + endl + "Fr Ellpsd: " + this.fromEllipsoid + endl + "To Ellpsd: " + this.toEllipsoid + endl + "Fr Maj Ax: " + this.fromSemiMajorAxis + endl + "Fr Min Ax: " + this.fromSemiMinorAxis + endl + "To Maj Ax: " + this.toSemiMajorAxis + endl + "To Min Ax: " + this.toSemiMinorAxis;
    }

    public String getFromEllipsoid() {
        return this.fromEllipsoid;
    }

    public String getToEllipsoid() {
        return this.toEllipsoid;
    }
}

