/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.languagetool.gui.CategoryNode;
import org.languagetool.gui.RuleNode;

class CheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private final DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
    private final JCheckBox checkBox = new JCheckBox();
    private Component defaultComponent;

    CheckBoxTreeCellRenderer() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
        this.renderer.setLeafIcon(null);
        this.add((Component)this.checkBox, "West");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component component = this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof CategoryNode) {
            if (this.defaultComponent != null) {
                this.remove(this.defaultComponent);
            }
            this.defaultComponent = component;
            this.add(component, "Center");
            CategoryNode node = (CategoryNode)value;
            this.checkBox.setSelected(node.isEnabled());
            return this;
        }
        if (value instanceof RuleNode) {
            if (this.defaultComponent != null) {
                this.remove(this.defaultComponent);
            }
            this.defaultComponent = component;
            this.add(component, "Center");
            RuleNode node = (RuleNode)value;
            this.checkBox.setSelected(node.isEnabled());
            return this;
        }
        return component;
    }
}

