/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.CheckResults;
import org.languagetool.ErrorRateTooHighException;
import org.languagetool.GlobalConfig;
import org.languagetool.InputSentence;
import org.languagetool.Language;
import org.languagetool.Range;
import org.languagetool.ResourceBundleTools;
import org.languagetool.ResultCache;
import org.languagetool.RuleMatchListener;
import org.languagetool.ShortDescriptionProvider;
import org.languagetool.SimpleInputSentence;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.broker.ClassBroker;
import org.languagetool.broker.DefaultClassBroker;
import org.languagetool.broker.DefaultResourceDataBroker;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.markup.TextPart;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.CleanOverlappingFilter;
import org.languagetool.rules.LanguageDependentFilter;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleMetrics;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.SameRuleGroupFilter;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.FalseFriendRuleLoader;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.RuleSet;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class JLanguageTool {
    private static final Logger logger = LoggerFactory.getLogger(JLanguageTool.class);
    public static final String VERSION = "5.4";
    @Nullable
    public static final String BUILD_DATE = JLanguageTool.getBuildDate();
    @Nullable
    public static final String GIT_SHORT_ID = JLanguageTool.getShortGitId();
    public static final String PATTERN_FILE = "grammar.xml";
    public static final String FALSE_FRIEND_FILE = "false-friends.xml";
    public static final String SENTENCE_START_TAGNAME = "SENT_START";
    public static final String SENTENCE_END_TAGNAME = "SENT_END";
    public static final String PARAGRAPH_END_TAGNAME = "PARA_END";
    public static final String MESSAGE_BUNDLE = "org.languagetool.MessagesBundle";
    public static final String DICTIONARY_FILENAME_EXTENSION = ".dict";
    private final ResultCache cache;
    private final UserConfig userConfig;
    private final GlobalConfig globalConfig;
    private final ShortDescriptionProvider descProvider;
    private float maxErrorsPerWordRate;
    private static ResourceDataBroker dataBroker = new DefaultResourceDataBroker();
    private static ClassBroker classBroker = new DefaultClassBroker();
    private final List<Rule> builtinRules;
    private final List<Rule> userRules = new ArrayList<Rule>();
    private final Set<String> optionalLanguageModelRules = new HashSet<String>();
    private final Set<String> disabledRules = new HashSet<String>();
    private final Set<CategoryId> disabledRuleCategories = new HashSet<CategoryId>();
    private final Set<String> enabledRules = new HashSet<String>();
    private final Set<CategoryId> enabledRuleCategories = new HashSet<CategoryId>();
    private final Language language;
    private final List<Language> altLanguages;
    private final Language motherTongue;
    private final boolean inputLogging;
    private final List<RuleMatchFilter> matchFilters = new LinkedList<RuleMatchFilter>();
    private CheckCancelledCallback checkCancelledCallback;
    private PrintStream printStream;
    private boolean listUnknownWords;
    private Set<String> unknownWords = new HashSet<String>();
    private boolean cleanOverlappingMatches;
    private static final List<File> temporaryFiles = new ArrayList<File>();
    private final Map<Level, RuleSet> ruleSetCache = new ConcurrentHashMap<Level, RuleSet>();

    @Nullable
    private static String getBuildDate() {
        try {
            URL res = JLanguageTool.getDataBroker().getAsURL("/" + JLanguageTool.class.getName().replace('.', '/') + ".class");
            if (res == null) {
                return null;
            }
            URLConnection connObj = res.openConnection();
            if (connObj instanceof JarURLConnection) {
                JarURLConnection conn = (JarURLConnection)connObj;
                Manifest manifest = conn.getManifest();
                return manifest.getMainAttributes().getValue("Implementation-Date");
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get build date from JAR", e);
        }
    }

    @Nullable
    private static String getShortGitId() {
        try {
            InputStream in = JLanguageTool.getDataBroker().getAsStream("/git.properties");
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                return props.getProperty("git.commit.id.abbrev");
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get git id from 'git.properties'", e);
        }
    }

    public static boolean isPremiumVersion() {
        return false;
    }

    public JLanguageTool(Language lang, Language motherTongue) {
        this(lang, motherTongue, null);
    }

    public JLanguageTool(Language language) {
        this(language, null, null, null);
    }

    public JLanguageTool(Language language, Language motherTongue, ResultCache cache) {
        this(language, motherTongue, cache, null);
    }

    public JLanguageTool(Language language, ResultCache cache, UserConfig userConfig) {
        this(language, null, cache, userConfig);
    }

    public JLanguageTool(Language language, List<Language> altLanguages, Language motherTongue, ResultCache cache, GlobalConfig globalConfig, UserConfig userConfig) {
        this(language, altLanguages, motherTongue, cache, globalConfig, userConfig, true);
    }

    public JLanguageTool(Language language, List<Language> altLanguages, Language motherTongue, ResultCache cache, GlobalConfig globalConfig, UserConfig userConfig, boolean inputLogging) {
        this.language = Objects.requireNonNull(language, "language cannot be null");
        this.altLanguages = Objects.requireNonNull(altLanguages, "altLanguages cannot be null (but empty)");
        this.motherTongue = motherTongue;
        this.userConfig = userConfig == null ? new UserConfig() : userConfig;
        this.globalConfig = globalConfig;
        ResourceBundle messages = ResourceBundleTools.getMessageBundle(language);
        this.builtinRules = this.getAllBuiltinRules(language, messages, userConfig, globalConfig);
        this.cleanOverlappingMatches = true;
        try {
            this.activateDefaultPatternRules();
            if (!language.hasNGramFalseFriendRule(motherTongue)) {
                this.activateDefaultFalseFriendRules();
            }
            this.updateOptionalLanguageModelRules(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not activate rules", e);
        }
        this.cache = cache;
        this.descProvider = new ShortDescriptionProvider();
        this.inputLogging = inputLogging;
    }

    public JLanguageTool(Language language, Language motherTongue, ResultCache cache, UserConfig userConfig) {
        this(language, Collections.emptyList(), motherTongue, cache, null, userConfig);
    }

    public static synchronized ResourceDataBroker getDataBroker() {
        if (dataBroker == null) {
            dataBroker = new DefaultResourceDataBroker();
        }
        return dataBroker;
    }

    public static synchronized void setDataBroker(ResourceDataBroker broker) {
        dataBroker = broker;
    }

    public static synchronized ClassBroker getClassBroker() {
        if (classBroker == null) {
            classBroker = new DefaultClassBroker();
        }
        return classBroker;
    }

    public static synchronized void setClassBrokerBroker(ClassBroker broker) {
        classBroker = broker;
    }

    public void setListUnknownWords(boolean listUnknownWords) {
        this.listUnknownWords = listUnknownWords;
    }

    public void setCleanOverlappingMatches(boolean cleanOverlappingMatches) {
        this.cleanOverlappingMatches = cleanOverlappingMatches;
    }

    public void setMaxErrorsPerWordRate(float maxErrorsPerWordRate) {
        this.maxErrorsPerWordRate = maxErrorsPerWordRate;
    }

    public void setCheckCancelledCallback(CheckCancelledCallback callback) {
        this.checkCancelledCallback = callback;
    }

    public static ResourceBundle getMessageBundle() {
        return ResourceBundleTools.getMessageBundle();
    }

    public static ResourceBundle getMessageBundle(Language lang) {
        return ResourceBundleTools.getMessageBundle(lang);
    }

    private List<Rule> getAllBuiltinRules(Language language, ResourceBundle messages, UserConfig userConfig, GlobalConfig globalConfig) {
        try {
            ArrayList<Rule> rules = new ArrayList<Rule>(language.getRelevantRules(messages, userConfig, this.motherTongue, this.altLanguages));
            rules.addAll(language.getRelevantRulesGlobalConfig(messages, globalConfig, userConfig, this.motherTongue, this.altLanguages));
            return rules;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get rules of language " + language, e);
        }
    }

    public void setOutput(PrintStream printStream) {
        this.printStream = printStream;
    }

    public List<AbstractPatternRule> loadPatternRules(String filename) throws IOException {
        PatternRuleLoader ruleLoader = new PatternRuleLoader();
        try (InputStream is = JLanguageTool.getDataBroker().getAsStream(filename);){
            if (is == null) {
                if (filename.contains("-test-")) {
                    List<AbstractPatternRule> list = Collections.emptyList();
                    return list;
                }
                List<AbstractPatternRule> list = ruleLoader.getRules(new File(filename));
                return list;
            }
            List<AbstractPatternRule> list = ruleLoader.getRules(is, filename);
            return list;
        }
    }

    public List<AbstractPatternRule> loadFalseFriendRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        if (this.motherTongue == null) {
            return Collections.emptyList();
        }
        FalseFriendRuleLoader ruleLoader = new FalseFriendRuleLoader(this.motherTongue);
        try (InputStream is = JLanguageTool.getDataBroker().getAsStream(filename);){
            if (is == null) {
                List<AbstractPatternRule> list = ruleLoader.getRules(new File(filename), this.language, this.motherTongue);
                return list;
            }
            List<AbstractPatternRule> list = ruleLoader.getRules(is, this.language, this.motherTongue);
            return list;
        }
    }

    private void updateOptionalLanguageModelRules(@Nullable LanguageModel lm) {
        ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
        try {
            List<Rule> rules = this.language.getRelevantLanguageModelCapableRules(messages, lm, this.globalConfig, this.userConfig, this.motherTongue, this.altLanguages);
            this.userRules.removeIf(rule -> this.optionalLanguageModelRules.contains(rule.getId()));
            this.optionalLanguageModelRules.clear();
            rules.stream().map(Rule::getId).forEach(this.optionalLanguageModelRules::add);
            this.userRules.addAll(rules);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load language model capable rules.", e);
        }
        this.ruleSetCache.clear();
    }

    public void activateNeuralNetworkRules(File modelDir) throws IOException {
        ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
        List<Rule> rules = this.language.getRelevantNeuralNetworkModels(messages, modelDir);
        this.userRules.addAll(rules);
        this.ruleSetCache.clear();
    }

    public void activateLanguageModelRules(File indexDir) throws IOException {
        LanguageModel languageModel = this.language.getLanguageModel(indexDir);
        if (languageModel != null) {
            ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
            List<Rule> rules = this.language.getRelevantLanguageModelRules(messages, languageModel, this.userConfig);
            this.userRules.addAll(rules);
            this.updateOptionalLanguageModelRules(languageModel);
        }
    }

    private void transformRules(Function<Rule, Rule> mapper, List<Rule> rules) {
        for (int i = 0; i < rules.size(); ++i) {
            Rule original = rules.get(i);
            Rule transformed = mapper.apply(original);
            if (transformed == original) continue;
            rules.set(i, transformed);
        }
    }

    public void activateRemoteRules(@Nullable File configFile) throws IOException {
        try {
            List<RemoteRuleConfig> configs = configFile != null ? RemoteRuleConfig.load(configFile) : Collections.emptyList();
            this.activateRemoteRules(configs);
        }
        catch (IOException e) {
            throw new IOException("Could not load remote rules.", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Could not load remote rules configuration at " + configFile.getAbsolutePath(), e);
        }
    }

    public void activateRemoteRules(List<RemoteRuleConfig> configs) throws IOException {
        List<Rule> rules = this.language.getRelevantRemoteRules(JLanguageTool.getMessageBundle(this.language), configs, this.globalConfig, this.userConfig, this.motherTongue, this.altLanguages, this.inputLogging);
        this.userRules.addAll(rules);
        Function<Rule, Rule> enhanced = this.language.getRemoteEnhancedRules(JLanguageTool.getMessageBundle(this.language), configs, this.userConfig, this.motherTongue, this.altLanguages, this.inputLogging);
        this.transformRules(enhanced, this.builtinRules);
        this.transformRules(enhanced, this.userRules);
        this.ruleSetCache.clear();
    }

    public void activateWord2VecModelRules(File indexDir) throws IOException {
        Word2VecModel word2vecModel = this.language.getWord2VecModel(indexDir);
        if (word2vecModel != null) {
            ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
            List<Rule> rules = this.language.getRelevantWord2VecModelRules(messages, word2vecModel);
            this.userRules.addAll(rules);
        }
    }

    private void activateDefaultPatternRules() throws IOException {
        List<AbstractPatternRule> patternRules = this.language.getPatternRules();
        List<String> enabledRules = this.language.getDefaultEnabledRulesForVariant();
        List<String> disabledRules = this.language.getDefaultDisabledRulesForVariant();
        if (!enabledRules.isEmpty() || !disabledRules.isEmpty()) {
            for (AbstractPatternRule patternRule : patternRules) {
                if (enabledRules.contains(patternRule.getId())) {
                    patternRule.setDefaultOn();
                }
                if (!disabledRules.contains(patternRule.getId())) continue;
                patternRule.setDefaultOff();
            }
        }
        this.userRules.addAll(patternRules);
    }

    private void activateDefaultFalseFriendRules() throws ParserConfigurationException, SAXException, IOException {
        String falseFriendRulesFilename = JLanguageTool.getDataBroker().getRulesDir() + "/" + FALSE_FRIEND_FILE;
        this.userRules.addAll(this.loadFalseFriendRules(falseFriendRulesFilename));
        this.ruleSetCache.clear();
    }

    public void addMatchFilter(@NotNull RuleMatchFilter filter) {
        this.matchFilters.add(Objects.requireNonNull(filter));
    }

    public void addRule(Rule rule) {
        this.userRules.add(rule);
        this.ruleSetCache.clear();
    }

    public void disableRule(String ruleId) {
        this.disabledRules.add(ruleId);
        this.enabledRules.remove(ruleId);
        this.ruleSetCache.clear();
    }

    public void disableRules(List<String> ruleIds) {
        this.disabledRules.addAll(ruleIds);
        this.enabledRules.removeAll(ruleIds);
        this.ruleSetCache.clear();
    }

    public void disableCategory(CategoryId id) {
        this.disabledRuleCategories.add(id);
        this.enabledRuleCategories.remove(id);
        this.ruleSetCache.clear();
    }

    public boolean isCategoryDisabled(CategoryId id) {
        return this.disabledRuleCategories.contains(id);
    }

    public Language getLanguage() {
        return this.language;
    }

    public Set<String> getDisabledRules() {
        return this.disabledRules;
    }

    public void enableRule(String ruleId) {
        this.disabledRules.remove(ruleId);
        this.enabledRules.add(ruleId);
        this.ruleSetCache.clear();
    }

    public void enableRuleCategory(CategoryId id) {
        this.disabledRuleCategories.remove(id);
        this.enabledRuleCategories.add(id);
        this.ruleSetCache.clear();
    }

    public List<String> sentenceTokenize(String text) {
        return this.language.getSentenceTokenizer().tokenize(text);
    }

    public List<RuleMatch> check(String text) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL);
    }

    public List<RuleMatch> check(String text, RuleMatchListener listener) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL, listener);
    }

    public List<RuleMatch> check(String text, boolean tokenizeText, ParagraphHandling paraMode) throws IOException {
        return this.check(new AnnotatedTextBuilder().addText(text).build(), tokenizeText, paraMode);
    }

    public List<RuleMatch> check(String text, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener) throws IOException {
        return this.check(new AnnotatedTextBuilder().addText(text).build(), tokenizeText, paraMode, listener);
    }

    public List<RuleMatch> check(AnnotatedText text) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL);
    }

    public List<RuleMatch> check(AnnotatedText text, RuleMatchListener listener) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL, listener);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode) throws IOException {
        return this.check(annotatedText, tokenizeText, paraMode, null);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener) throws IOException {
        Mode mode = paraMode == ParagraphHandling.ONLYNONPARA ? Mode.ALL_BUT_TEXTLEVEL_ONLY : (paraMode == ParagraphHandling.ONLYPARA ? Mode.TEXTLEVEL_ONLY : Mode.ALL);
        return this.check(annotatedText, tokenizeText, paraMode, listener, mode, Level.DEFAULT);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener, Mode mode, Level level) throws IOException {
        return this.check(annotatedText, tokenizeText, paraMode, listener, mode, level, null);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener, Mode mode, Level level, @Nullable ExecutorService remoteRulesThreadPool) throws IOException {
        return this.check(annotatedText, tokenizeText, paraMode, listener, mode, level, remoteRulesThreadPool, this.userConfig != null ? this.userConfig.getTextSessionId() : null);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener, Mode mode, Level level, @Nullable ExecutorService remoteRulesThreadPool, @Nullable Long textSessionID) throws IOException {
        annotatedText = this.cleanText(annotatedText);
        List<String> sentences = this.getSentences(annotatedText, tokenizeText);
        List<AnalyzedSentence> analyzedSentences = this.analyzeSentences(sentences);
        return this.checkInternal(annotatedText, paraMode, listener, mode, level, remoteRulesThreadPool, textSessionID, sentences, analyzedSentences).getRuleMatches();
    }

    public CheckResults check2(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener, Mode mode, Level level, @Nullable ExecutorService remoteRulesThreadPool, @Nullable Long textSessionID) throws IOException {
        annotatedText = this.cleanText(annotatedText);
        List<String> sentences = this.getSentences(annotatedText, tokenizeText);
        List<AnalyzedSentence> analyzedSentences = this.analyzeSentences(sentences);
        return this.checkInternal(annotatedText, paraMode, listener, mode, level, remoteRulesThreadPool, textSessionID, sentences, analyzedSentences);
    }

    private List<String> getSentences(AnnotatedText annotatedText, boolean tokenizeText) {
        ArrayList<String> sentences;
        if (tokenizeText) {
            sentences = this.sentenceTokenize(annotatedText.getPlainText());
        } else {
            sentences = new ArrayList();
            sentences.add(annotatedText.getPlainText());
        }
        return sentences;
    }

    private AnnotatedText cleanText(AnnotatedText annotatedText) {
        AnnotatedTextBuilder atb = new AnnotatedTextBuilder();
        annotatedText.getGlobalMetaData().forEach((key, value) -> atb.addGlobalMetaData((AnnotatedText.MetaDataKey)((Object)key), (String)value));
        annotatedText.getCustomMetaData().forEach((key, value) -> atb.addGlobalMetaData((String)key, (String)value));
        List<TextPart> parts = annotatedText.getParts();
        for (TextPart part : parts) {
            if (part.getType() == TextPart.Type.TEXT) {
                String byteOrderMark = "\ufeff";
                StringTokenizer st = new StringTokenizer(part.getPart(), byteOrderMark, true);
                while (st.hasMoreElements()) {
                    Object next = st.nextElement();
                    if (next.equals(byteOrderMark)) {
                        atb.addMarkup(byteOrderMark);
                        continue;
                    }
                    atb.addText(next.toString());
                }
                continue;
            }
            atb.add(part);
        }
        return atb.build();
    }

    private CheckResults checkInternal(AnnotatedText annotatedText, ParagraphHandling paraMode, RuleMatchListener listener, Mode mode, Level level, @Nullable ExecutorService remoteRulesThreadPool, @Nullable Long textSessionID, List<String> sentences, List<AnalyzedSentence> analyzedSentences) throws IOException {
        RuleSet rules = this.getActiveRulesForLevel(level);
        if (this.printStream != null) {
            this.printIfVerbose(rules.allRules().size() + " rules activated for language " + this.language);
        }
        LinkedList<RuleMatch> remoteMatches = new LinkedList<RuleMatch>();
        LinkedList<FutureTask<RemoteRuleResult>> remoteRuleTasks = null;
        LinkedList<RemoteRule> remoteRules = new LinkedList<RemoteRule>();
        long remoteRuleCheckStart = System.currentTimeMillis();
        HashMap<Integer, List<RuleMatch>> cachedResults = new HashMap<Integer, List<RuleMatch>>();
        HashMap<Integer, Integer> matchOffset = new HashMap<Integer, Integer>();
        if (remoteRulesThreadPool != null && mode != Mode.TEXTLEVEL_ONLY) {
            remoteRuleTasks = new LinkedList<FutureTask<RemoteRuleResult>>();
            this.checkRemoteRules(remoteRulesThreadPool, rules.allRules(), analyzedSentences, mode, level, remoteRuleTasks, remoteRules, cachedResults, matchOffset, textSessionID);
        }
        long textCheckStart = System.currentTimeMillis();
        CheckResults res = this.performCheck(analyzedSentences, sentences, rules, paraMode, annotatedText, listener, mode, level, remoteRulesThreadPool == null);
        long textCheckEnd = System.currentTimeMillis();
        this.fetchRemoteRuleResults(mode, level, analyzedSentences, remoteMatches, remoteRuleTasks, remoteRules, cachedResults, matchOffset, annotatedText, textSessionID);
        long remoteRuleCheckEnd = System.currentTimeMillis();
        if (remoteRules.size() > 0) {
            long wait = remoteRuleCheckEnd - textCheckEnd;
            logger.info("Local checks took {}ms, remote checks {}ms; waited {}ms on remote results", new Object[]{textCheckEnd - textCheckStart, remoteRuleCheckEnd - remoteRuleCheckStart, wait});
            RemoteRuleMetrics.wait(this.language.getShortCode(), wait);
        }
        List<RuleMatch> ruleMatches = res.getRuleMatches();
        ruleMatches.addAll(remoteMatches);
        ruleMatches = ruleMatches.stream().filter(match -> !this.ignoreRule(match.getRule())).collect(Collectors.toList());
        ruleMatches = new SameRuleGroupFilter().filter(ruleMatches);
        if (this.cleanOverlappingMatches) {
            ruleMatches = new CleanOverlappingFilter(this.language).filter(ruleMatches);
        }
        ruleMatches = new LanguageDependentFilter(this.language, this.enabledRules, this.disabledRuleCategories).filter(ruleMatches);
        ruleMatches = this.applyCustomFilters(ruleMatches, annotatedText);
        return new CheckResults(ruleMatches, res.getIgnoredRanges());
    }

    private RuleSet getActiveRulesForLevel(Level level) {
        return this.ruleSetCache.computeIfAbsent(level, l -> {
            List<Rule> allRules = this.getAllActiveRules();
            return RuleSet.textLemmaHinted(l == Level.DEFAULT ? allRules.stream().filter(rule -> !rule.hasTag(Tag.picky)).collect(Collectors.toList()) : allRules);
        });
    }

    protected void fetchRemoteRuleResults(Mode mode, Level level, List<AnalyzedSentence> analyzedSentences, List<RuleMatch> remoteMatches, List<FutureTask<RemoteRuleResult>> remoteRuleTasks, List<RemoteRule> remoteRules, Map<Integer, List<RuleMatch>> cachedResults, Map<Integer, Integer> matchOffset, AnnotatedText annotatedText, Long textSessionID) {
        if (remoteRuleTasks != null) {
            for (int taskIndex = 0; taskIndex < remoteRuleTasks.size(); ++taskIndex) {
                FutureTask<RemoteRuleResult> task = remoteRuleTasks.get(taskIndex);
                RemoteRule rule = remoteRules.get(taskIndex);
                String ruleKey = rule.getId();
                try {
                    RemoteRuleResult result = task.get();
                    for (int sentenceIndex = 0; sentenceIndex < analyzedSentences.size(); ++sentenceIndex) {
                        AnalyzedSentence sentence = analyzedSentences.get(sentenceIndex);
                        List<RuleMatch> matches = result.matchesForSentence(sentence);
                        if (matches == null) continue;
                        if (this.cache != null && result.isSuccess()) {
                            InputSentence cacheKey = new InputSentence(sentence.getText(), this.language, this.motherTongue, this.disabledRules, this.disabledRuleCategories, this.enabledRules, this.enabledRuleCategories, this.userConfig, this.altLanguages, mode, level, textSessionID);
                            Map cacheEntry = (Map)this.cache.getRemoteMatchesCache().get((Object)cacheKey, HashMap::new);
                            cacheEntry.put(ruleKey, matches);
                        } else if (this.cache != null) {
                            // empty if block
                        }
                        int offset = matchOffset.get(sentenceIndex);
                        List adjustedMatches = matches.stream().map(RuleMatch::new).collect(Collectors.toList());
                        for (RuleMatch match : adjustedMatches) {
                            this.adjustOffset(annotatedText, offset, match);
                        }
                        remoteMatches.addAll(adjustedMatches);
                    }
                    continue;
                }
                catch (InterruptedException | CancellationException e) {
                    logger.warn("Failed to fetch result from remote rule.", (Throwable)e);
                    continue;
                }
                catch (ExecutionException e) {
                    logger.error("Failed to fetch result from remote rule.", (Throwable)e);
                }
            }
            for (Integer cachedSentenceIndex : cachedResults.keySet()) {
                List<RuleMatch> cachedMatches = cachedResults.get(cachedSentenceIndex);
                int sentenceOffset = matchOffset.get(cachedSentenceIndex);
                for (RuleMatch cachedMatch : cachedMatches) {
                    RuleMatch match = new RuleMatch(cachedMatch);
                    this.adjustOffset(annotatedText, sentenceOffset, match);
                    remoteMatches.add(match);
                }
            }
            for (RuleMatch match : remoteMatches) {
                match.setSuggestedReplacementObjects(this.extendSuggestions(match.getSuggestedReplacementObjects()));
            }
        }
    }

    private void adjustOffset(AnnotatedText annotatedText, int offset, RuleMatch match) {
        int toPos;
        int fromPos;
        if (annotatedText != null) {
            fromPos = annotatedText.getOriginalTextPositionFor(match.getFromPos() + offset, false);
            toPos = annotatedText.getOriginalTextPositionFor(match.getToPos() + offset - 1, true) + 1;
        } else {
            fromPos = match.getFromPos() + offset;
            toPos = match.getToPos() + offset;
        }
        match.setOffsetPosition(fromPos, toPos);
    }

    protected void checkRemoteRules(@NotNull ExecutorService remoteRulesThreadPool, List<Rule> allRules, List<AnalyzedSentence> analyzedSentences, Mode mode, Level level, List<FutureTask<RemoteRuleResult>> remoteRuleTasks, List<RemoteRule> remoteRules, Map<Integer, List<RuleMatch>> cachedResults, Map<Integer, Integer> matchOffset, Long textSessionID) {
        LinkedList<InputSentence> cacheKeys = new LinkedList<InputSentence>();
        int offset = 0;
        for (int i = 0; i < analyzedSentences.size(); ++i) {
            AnalyzedSentence s = analyzedSentences.get(i);
            matchOffset.put(i, offset);
            offset += s.getText().length();
            InputSentence cacheKey = new InputSentence(s.getText(), this.language, this.motherTongue, this.disabledRules, this.disabledRuleCategories, this.enabledRules, this.enabledRuleCategories, this.userConfig, this.altLanguages, mode, level, textSessionID);
            cacheKeys.add(cacheKey);
        }
        for (Rule r : allRules) {
            FutureTask<RemoteRuleResult> task;
            if (!(r instanceof RemoteRule)) continue;
            RemoteRule rule = (RemoteRule)r;
            remoteRules.add(rule);
            if (this.cache != null) {
                ArrayList<AnalyzedSentence> nonCachedSentences = new ArrayList<AnalyzedSentence>();
                for (int sentenceIndex = 0; sentenceIndex < analyzedSentences.size(); ++sentenceIndex) {
                    Map cacheEntry;
                    InputSentence cacheKey = (InputSentence)cacheKeys.get(sentenceIndex);
                    String ruleKey = rule.getId();
                    AnalyzedSentence sentence = analyzedSentences.get(sentenceIndex);
                    try {
                        cacheEntry = (Map)this.cache.getRemoteMatchesCache().get((Object)cacheKey, HashMap::new);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    if (cacheEntry == null) {
                        throw new RuntimeException("Couldn't access remote matches cache.");
                    }
                    List cachedMatches = (List)cacheEntry.get(ruleKey);
                    if (cachedMatches == null) {
                        nonCachedSentences.add(sentence);
                        continue;
                    }
                    cachedResults.putIfAbsent(sentenceIndex, new LinkedList());
                    cachedResults.get(sentenceIndex).addAll(cachedMatches);
                }
                task = rule.run(nonCachedSentences, textSessionID);
            } else {
                task = rule.run(analyzedSentences, textSessionID);
            }
            remoteRuleTasks.add(task);
            remoteRulesThreadPool.submit(task);
        }
    }

    public List<AnalyzedSentence> analyzeText(String text) throws IOException {
        List<String> sentences = this.sentenceTokenize(text);
        return this.analyzeSentences(sentences);
    }

    protected List<AnalyzedSentence> analyzeSentences(List<String> sentences) throws IOException {
        this.unknownWords = new HashSet<String>();
        ArrayList<AnalyzedSentence> analyzedSentences = new ArrayList<AnalyzedSentence>();
        int j = 0;
        for (String sentence : sentences) {
            if (this.checkCancelledCallback != null && this.checkCancelledCallback.checkCancelled()) break;
            AnalyzedSentence analyzedSentence = this.getAnalyzedSentence(sentence);
            this.rememberUnknownWords(analyzedSentence);
            if (++j == sentences.size()) {
                analyzedSentence = JLanguageTool.markAsParagraphEnd(analyzedSentence);
            }
            analyzedSentences.add(analyzedSentence);
            this.printSentenceInfo(analyzedSentence);
        }
        return analyzedSentences;
    }

    @NotNull
    static AnalyzedSentence markAsParagraphEnd(AnalyzedSentence analyzedSentence) {
        AnalyzedTokenReadings[] anTokens = analyzedSentence.getTokens();
        anTokens[anTokens.length - 1].setParagraphEnd();
        AnalyzedTokenReadings[] preDisambigAnTokens = analyzedSentence.getPreDisambigTokens();
        preDisambigAnTokens[anTokens.length - 1].setParagraphEnd();
        return new AnalyzedSentence(anTokens, preDisambigAnTokens);
    }

    protected void printSentenceInfo(AnalyzedSentence analyzedSentence) {
        if (this.printStream != null) {
            this.printIfVerbose(analyzedSentence.toString());
            this.printIfVerbose(analyzedSentence.getAnnotations());
        }
    }

    @Deprecated
    protected CheckResults performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, ParagraphHandling paraMode, AnnotatedText annotatedText, Mode mode, Level level) throws IOException {
        List<Rule> nonIgnored = allRules.stream().filter(r -> !this.ignoreRule((Rule)r)).collect(Collectors.toList());
        return this.performCheck(analyzedSentences, sentences, nonIgnored, paraMode, annotatedText, null, mode, level, true);
    }

    protected CheckResults performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentenceTexts, List<Rule> allRules, ParagraphHandling paraMode, AnnotatedText annotatedText, RuleMatchListener listener, Mode mode, Level level, boolean checkRemoteRules) throws IOException {
        return this.performCheck(analyzedSentences, sentenceTexts, RuleSet.plain(allRules), paraMode, annotatedText, listener, mode, level, checkRemoteRules);
    }

    protected CheckResults performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentenceTexts, RuleSet ruleSet, ParagraphHandling paraMode, AnnotatedText annotatedText, RuleMatchListener listener, Mode mode, Level level, boolean checkRemoteRules) throws IOException {
        List<SentenceData> sentences = this.computeSentenceData(analyzedSentences, sentenceTexts);
        TextCheckCallable matcher = new TextCheckCallable(ruleSet, sentences, paraMode, annotatedText, listener, mode, level, checkRemoteRules);
        try {
            return (CheckResults)matcher.call();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final List<SentenceData> computeSentenceData(List<AnalyzedSentence> analyzedSentences, List<String> texts) {
        int charCount = 0;
        int lineCount = 0;
        int columnCount = 1;
        ArrayList<SentenceData> result = new ArrayList<SentenceData>(texts.size());
        for (int i = 0; i < texts.size(); ++i) {
            String sentence = texts.get(i);
            result.add(new SentenceData(analyzedSentences.get(i), sentence, charCount, lineCount, columnCount));
            charCount += sentence.length();
            lineCount += JLanguageTool.countLineBreaks(sentence);
            columnCount = this.processColumnChange(columnCount, sentence);
        }
        return result;
    }

    private int processColumnChange(int columnCount, String sentence) {
        int lineBreakPos = sentence.lastIndexOf(10);
        if (lineBreakPos == -1) {
            columnCount += sentence.length();
        } else {
            columnCount = sentence.length() - lineBreakPos;
            if (lineBreakPos == 0 && !this.language.getSentenceTokenizer().singleLineBreaksMarksPara()) {
                --columnCount;
            }
        }
        return columnCount;
    }

    @Deprecated
    public List<RuleMatch> checkAnalyzedSentence(ParagraphHandling paraMode, List<Rule> rules, AnalyzedSentence analyzedSentence) throws IOException {
        List<Rule> nonIgnored = rules.stream().filter(r -> !this.ignoreRule((Rule)r)).collect(Collectors.toList());
        return this.checkAnalyzedSentence(paraMode, nonIgnored, analyzedSentence, false);
    }

    public List<RuleMatch> checkAnalyzedSentence(ParagraphHandling paraMode, List<Rule> rules, AnalyzedSentence analyzedSentence, boolean checkRemoteRules) throws IOException {
        if (paraMode == ParagraphHandling.ONLYPARA) {
            return Collections.emptyList();
        }
        List<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
        for (Rule rule : rules) {
            if (rule instanceof TextLevelRule || !checkRemoteRules && rule instanceof RemoteRule) continue;
            if (this.checkCancelledCallback != null && this.checkCancelledCallback.checkCancelled()) break;
            RuleMatch[] thisMatches = rule.match(analyzedSentence);
            Collections.addAll(sentenceMatches, thisMatches);
        }
        if (sentenceMatches.isEmpty()) {
            return sentenceMatches;
        }
        AnnotatedText text = new AnnotatedTextBuilder().addText(analyzedSentence.getText()).build();
        sentenceMatches = sentenceMatches.stream().filter(match -> !this.ignoreRule(match.getRule())).collect(Collectors.toList());
        return this.applyCustomFilters(new SameRuleGroupFilter().filter(sentenceMatches), text);
    }

    private boolean ignoreRule(Rule rule) {
        boolean isRuleDisabled;
        Category ruleCategory = rule.getCategory();
        boolean isCategoryDisabled = (this.disabledRuleCategories.contains(ruleCategory.getId()) || rule.getCategory().isDefaultOff()) && !this.enabledRuleCategories.contains(ruleCategory.getId());
        boolean bl = isRuleDisabled = this.disabledRules.contains(rule.getFullId()) || this.disabledRules.contains(rule.getId()) || rule.isDefaultOff() && !this.enabledRules.contains(rule.getFullId()) && !this.enabledRules.contains(rule.getId());
        boolean isDisabled = isCategoryDisabled ? !this.enabledRules.contains(rule.getFullId()) && !this.enabledRules.contains(rule.getId()) : isRuleDisabled;
        return isDisabled;
    }

    public RuleMatch adjustRuleMatchPos(RuleMatch match, int charCount, int columnCount, int lineCount, String sentence, AnnotatedText annotatedText) {
        int fromPos = match.getFromPos() + charCount;
        int toPos = match.getToPos() + charCount;
        if (annotatedText != null) {
            fromPos = annotatedText.getOriginalTextPositionFor(fromPos, false);
            toPos = annotatedText.getOriginalTextPositionFor(toPos - 1, true) + 1;
        }
        RuleMatch thisMatch = new RuleMatch(match);
        thisMatch.setOffsetPosition(fromPos, toPos);
        int startPos = match.getPatternFromPos() + charCount;
        int endPos = match.getPatternToPos() + charCount;
        thisMatch.setPatternPosition(startPos, endPos);
        thisMatch.setLazySuggestedReplacements(() -> this.extendSuggestions(match.getSuggestedReplacementObjects()));
        String sentencePartToError = sentence.substring(0, match.getFromPos());
        String sentencePartToEndOfError = sentence.substring(0, match.getToPos());
        int lastLineBreakPos = sentencePartToError.lastIndexOf(10);
        int column = lastLineBreakPos == -1 ? sentencePartToError.length() + columnCount : sentencePartToError.length() - lastLineBreakPos;
        int lastLineBreakPosInError = sentencePartToEndOfError.lastIndexOf(10);
        int endColumn = lastLineBreakPosInError == -1 ? sentencePartToEndOfError.length() + columnCount : sentencePartToEndOfError.length() - lastLineBreakPosInError;
        int lineBreaksToError = JLanguageTool.countLineBreaks(sentencePartToError);
        int lineBreaksToEndOfError = JLanguageTool.countLineBreaks(sentencePartToEndOfError);
        thisMatch.setLine(lineCount + lineBreaksToError);
        thisMatch.setEndLine(lineCount + lineBreaksToEndOfError);
        thisMatch.setColumn(column);
        thisMatch.setEndColumn(endColumn);
        return thisMatch;
    }

    private List<SuggestedReplacement> extendSuggestions(List<SuggestedReplacement> replacements) {
        ArrayList<SuggestedReplacement> extended = new ArrayList<SuggestedReplacement>();
        for (SuggestedReplacement replacement : replacements) {
            SuggestedReplacement newReplacement = new SuggestedReplacement(replacement);
            if (replacement.getShortDescription() == null) {
                String descOrNull = this.descProvider.getShortDescription(replacement.getReplacement(), this.language);
                newReplacement.setShortDescription(descOrNull);
                newReplacement.setSuffix(replacement.getSuffix());
            }
            extended.add(newReplacement);
        }
        return extended;
    }

    protected void rememberUnknownWords(AnalyzedSentence analyzedText) {
        if (this.listUnknownWords) {
            AnalyzedTokenReadings[] atr;
            for (AnalyzedTokenReadings reading : atr = analyzedText.getTokensWithoutWhitespace()) {
                if (reading.isTagged()) continue;
                this.unknownWords.add(reading.getToken());
            }
        }
    }

    public List<String> getUnknownWords() {
        if (!this.listUnknownWords) {
            throw new IllegalStateException("listUnknownWords is set to false, unknown words not stored");
        }
        ArrayList<String> words = new ArrayList<String>(this.unknownWords);
        Collections.sort(words);
        return words;
    }

    static int countLineBreaks(String s) {
        int nextPos;
        int pos = -1;
        int count = 0;
        while ((nextPos = s.indexOf(10, pos + 1)) != -1) {
            pos = nextPos;
            ++count;
        }
        return count;
    }

    public AnalyzedSentence getAnalyzedSentence(String sentence) throws IOException {
        AnalyzedSentence cachedSentence;
        SimpleInputSentence cacheKey = new SimpleInputSentence(sentence, this.language);
        AnalyzedSentence analyzedSentence = cachedSentence = this.cache != null ? this.cache.getIfPresent(cacheKey) : null;
        if (cachedSentence != null) {
            return cachedSentence;
        }
        AnalyzedSentence raw = this.getRawAnalyzedSentence(sentence);
        AnalyzedSentence disambig = this.language.getDisambiguator().disambiguate(raw);
        AnalyzedSentence analyzedSentence2 = new AnalyzedSentence(disambig.getTokens(), raw.getTokens());
        if (this.language.getPostDisambiguationChunker() != null) {
            this.language.getPostDisambiguationChunker().addChunkTags(Arrays.asList(analyzedSentence2.getTokens()));
        }
        if (this.cache != null) {
            this.cache.put(cacheKey, analyzedSentence2);
        }
        return analyzedSentence2;
    }

    public AnalyzedSentence getRawAnalyzedSentence(String sentence) throws IOException {
        AnalyzedToken sentenceStartToken;
        List<String> tokens = this.language.getWordTokenizer().tokenize(sentence);
        Map<Integer, CleanToken> softHyphenTokens = this.replaceSoftHyphens(tokens);
        List<AnalyzedTokenReadings> aTokens = this.language.getTagger().tag(tokens);
        if (this.language.getChunker() != null) {
            this.language.getChunker().addChunkTags(aTokens);
        }
        AnalyzedTokenReadings[] tokenArray = new AnalyzedTokenReadings[tokens.size() + 1];
        AnalyzedToken[] startTokenArray = new AnalyzedToken[1];
        int toArrayCount = 0;
        startTokenArray[0] = sentenceStartToken = new AnalyzedToken("", SENTENCE_START_TAGNAME, null);
        tokenArray[toArrayCount++] = new AnalyzedTokenReadings(startTokenArray, 0);
        int startPos = 0;
        for (AnalyzedTokenReadings posTag : aTokens) {
            posTag.setStartPos(startPos);
            tokenArray[toArrayCount++] = posTag;
            startPos += posTag.getToken().length();
        }
        int numTokens = aTokens.size();
        int posFix = 0;
        for (int i = 0; i < numTokens; ++i) {
            if (i > 0) {
                aTokens.get(i).setWhitespaceBefore(aTokens.get(i - 1).getToken());
                aTokens.get(i).setStartPos(aTokens.get(i).getStartPos() + posFix);
                aTokens.get(i).setPosFix(posFix);
            }
            if (softHyphenTokens.isEmpty() || softHyphenTokens.get(i) == null) continue;
            posFix += softHyphenTokens.get(i).origToken.length() - aTokens.get(i).getToken().length();
            AnalyzedToken newToken = this.language.getTagger().createToken(softHyphenTokens.get(i).origToken, null);
            aTokens.get(i).addReading(newToken, "softHyphenTokens");
            aTokens.get(i).setCleanToken(softHyphenTokens.get(i).cleanToken);
        }
        int lastToken = toArrayCount - 1;
        for (int i = 0; i < toArrayCount - 1; ++i) {
            if (tokenArray[lastToken - i].isWhitespace()) continue;
            lastToken -= i;
            break;
        }
        tokenArray[lastToken].setSentEnd();
        if (tokenArray.length == lastToken + 1 && tokenArray[lastToken].isLinebreak()) {
            tokenArray[lastToken].setParagraphEnd();
        }
        return new AnalyzedSentence(tokenArray);
    }

    private Map<Integer, CleanToken> replaceSoftHyphens(List<String> tokens) {
        Pattern ignoredCharacterRegex = this.language.getIgnoredCharactersRegex();
        HashMap<Integer, CleanToken> ignoredCharsTokens = new HashMap<Integer, CleanToken>();
        if (ignoredCharacterRegex == null) {
            return ignoredCharsTokens;
        }
        for (int i = 0; i < tokens.size(); ++i) {
            Matcher matcher = ignoredCharacterRegex.matcher(tokens.get(i));
            if (!matcher.find()) continue;
            String cleaned = matcher.replaceAll("");
            ignoredCharsTokens.put(i, new CleanToken(tokens.get(i), cleaned));
            tokens.set(i, matcher.replaceAll(""));
        }
        return ignoredCharsTokens;
    }

    public Map<CategoryId, Category> getCategories() {
        HashMap<CategoryId, Category> map = new HashMap<CategoryId, Category>();
        for (Rule rule : this.getAllRules()) {
            map.put(rule.getCategory().getId(), rule.getCategory());
        }
        return map;
    }

    public List<Rule> getAllRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        return rules;
    }

    public List<Rule> getAllActiveRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Rule> rulesActive = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        for (Rule rule : rules) {
            if (this.ignoreRule(rule)) continue;
            rulesActive.add(rule);
        }
        return rulesActive;
    }

    public List<SpellingCheckRule> getAllSpellingCheckRules() {
        ArrayList<SpellingCheckRule> rules = new ArrayList<SpellingCheckRule>();
        for (Rule rule : this.builtinRules) {
            if (!(rule instanceof SpellingCheckRule)) continue;
            rules.add((SpellingCheckRule)rule);
        }
        for (Rule rule : this.userRules) {
            if (!(rule instanceof SpellingCheckRule)) continue;
            rules.add((SpellingCheckRule)rule);
        }
        return rules;
    }

    public List<Rule> getAllActiveOfficeRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Rule> rulesActive = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        for (Rule rule : rules) {
            if (!this.ignoreRule(rule) && !rule.isOfficeDefaultOff()) {
                rulesActive.add(rule);
                continue;
            }
            if (rule.isOfficeDefaultOn() && !this.disabledRules.contains(rule.getId())) {
                rulesActive.add(rule);
                this.enableRule(rule.getId());
                continue;
            }
            if (this.ignoreRule(rule) || !rule.isOfficeDefaultOff() || this.enabledRules.contains(rule.getId())) continue;
            this.disableRule(rule.getId());
        }
        return rulesActive;
    }

    public List<AbstractPatternRule> getPatternRulesByIdAndSubId(String id, String subId) {
        List<Rule> rules = this.getAllRules();
        ArrayList<AbstractPatternRule> rulesById = new ArrayList<AbstractPatternRule>();
        for (Rule rule : rules) {
            if (!(rule instanceof AbstractPatternRule) || !rule.getId().equals(id) || !((AbstractPatternRule)rule).getSubId().equals(subId)) continue;
            rulesById.add((AbstractPatternRule)rule);
        }
        return rulesById;
    }

    protected void printIfVerbose(String s) {
        if (this.printStream != null) {
            this.printStream.println(s);
        }
    }

    public static void addTemporaryFile(File file) {
        temporaryFiles.add(file);
    }

    public static void removeTemporaryFiles() {
        for (File file : temporaryFiles) {
            file.delete();
        }
    }

    protected List<RuleMatch> applyCustomFilters(List<RuleMatch> matches, AnnotatedText text) {
        List<RuleMatch> transformed = matches;
        for (RuleMatchFilter filter : this.matchFilters) {
            transformed = filter.filter(transformed, text);
        }
        return transformed;
    }

    public void setConfigValues(Map<String, Integer> v) {
        this.userConfig.insertConfigValues(v);
    }

    class TextCheckCallable
    implements Callable<CheckResults> {
        private final RuleSet rules;
        private final boolean checkRemoteRules;
        private final ParagraphHandling paraMode;
        private final AnnotatedText annotatedText;
        private final List<SentenceData> sentences;
        private final RuleMatchListener listener;
        private final Mode mode;
        private final Level level;

        TextCheckCallable(RuleSet rules, List<SentenceData> sentences, ParagraphHandling paraMode, AnnotatedText annotatedText, RuleMatchListener listener, Mode mode, Level level, boolean checkRemoteRules) {
            this.rules = rules;
            this.checkRemoteRules = checkRemoteRules;
            this.sentences = Objects.requireNonNull(sentences);
            this.paraMode = Objects.requireNonNull(paraMode);
            this.annotatedText = Objects.requireNonNull(annotatedText);
            this.listener = listener;
            this.mode = Objects.requireNonNull(mode);
            this.level = Objects.requireNonNull(level);
        }

        @Override
        public CheckResults call() throws Exception {
            ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
            ArrayList<Range> ignoreRanges = new ArrayList<Range>();
            if (this.mode == Mode.ALL) {
                ruleMatches.addAll(this.getTextLevelRuleMatches());
                CheckResults otherRuleMatches = this.getOtherRuleMatches();
                ruleMatches.addAll(otherRuleMatches.getRuleMatches());
                ignoreRanges.addAll(otherRuleMatches.getIgnoredRanges());
            } else if (this.mode == Mode.ALL_BUT_TEXTLEVEL_ONLY) {
                CheckResults otherRuleMatches = this.getOtherRuleMatches();
                ruleMatches.addAll(otherRuleMatches.getRuleMatches());
                ignoreRanges.addAll(otherRuleMatches.getIgnoredRanges());
            } else if (this.mode == Mode.TEXTLEVEL_ONLY) {
                ruleMatches.addAll(this.getTextLevelRuleMatches());
            } else {
                throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)this.mode));
            }
            return new CheckResults(ruleMatches, ignoreRanges);
        }

        private List<RuleMatch> getTextLevelRuleMatches() throws IOException {
            ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
            List analyzedSentences = null;
            for (Rule rule : this.rules.allRules()) {
                if (!(rule instanceof TextLevelRule) || this.paraMode == ParagraphHandling.ONLYNONPARA) continue;
                if (JLanguageTool.this.checkCancelledCallback != null && JLanguageTool.this.checkCancelledCallback.checkCancelled()) break;
                if (analyzedSentences == null) {
                    analyzedSentences = this.sentences.stream().map(s -> s.analyzed).collect(Collectors.toList());
                }
                RuleMatch[] matches = ((TextLevelRule)rule).match(analyzedSentences, this.annotatedText);
                ArrayList<RuleMatch> adaptedMatches = new ArrayList<RuleMatch>();
                for (RuleMatch match : matches) {
                    int newToPos;
                    int newFromPos;
                    LineColumnPosition from = this.findLineColumn(match.getFromPos());
                    LineColumnPosition to = this.findLineColumn(match.getToPos());
                    try {
                        newFromPos = this.annotatedText.getOriginalTextPositionFor(match.getFromPos(), false);
                        newToPos = this.annotatedText.getOriginalTextPositionFor(match.getToPos() - 1, true) + 1;
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Getting positions failed for match " + match, e);
                    }
                    RuleMatch newMatch = new RuleMatch(match);
                    newMatch.setOffsetPosition(newFromPos, newToPos);
                    newMatch.setLine(from.line);
                    newMatch.setEndLine(to.line);
                    newMatch.setColumn(from.column - (from.line == 0 ? 1 : 0));
                    newMatch.setEndColumn(to.column - (to.line == 0 ? 1 : 0));
                    newMatch.setSuggestedReplacementObjects(JLanguageTool.this.extendSuggestions(match.getSuggestedReplacementObjects()));
                    adaptedMatches.add(newMatch);
                }
                ruleMatches.addAll(adaptedMatches);
                if (this.listener == null) continue;
                for (RuleMatch adaptedMatch : adaptedMatches) {
                    this.listener.matchFound(adaptedMatch);
                }
            }
            return ruleMatches;
        }

        private CheckResults getOtherRuleMatches() {
            ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
            ArrayList<Range> ignoreRanges = new ArrayList<Range>();
            int wordCounter = 0;
            for (SentenceData sentence : this.sentences) {
                wordCounter += sentence.wordCount;
                try {
                    List<RuleMatch> sentenceMatches = null;
                    InputSentence cacheKey = null;
                    if (JLanguageTool.this.cache != null) {
                        cacheKey = new InputSentence(sentence.text, JLanguageTool.this.language, JLanguageTool.this.motherTongue, JLanguageTool.this.disabledRules, JLanguageTool.this.disabledRuleCategories, JLanguageTool.this.enabledRules, JLanguageTool.this.enabledRuleCategories, JLanguageTool.this.userConfig, JLanguageTool.this.altLanguages, this.mode, this.level);
                        sentenceMatches = JLanguageTool.this.cache.getIfPresent(cacheKey);
                    }
                    if (sentenceMatches == null) {
                        sentenceMatches = JLanguageTool.this.checkAnalyzedSentence(this.paraMode, this.rules.rulesForSentence(sentence.analyzed), sentence.analyzed, this.checkRemoteRules);
                    }
                    if (JLanguageTool.this.cache != null) {
                        JLanguageTool.this.cache.put(cacheKey, sentenceMatches);
                    }
                    if (!sentenceMatches.isEmpty()) {
                        if (JLanguageTool.this.checkCancelledCallback == null || !JLanguageTool.this.checkCancelledCallback.checkCancelled()) {
                            for (RuleMatch elem : sentenceMatches) {
                                RuleMatch thisMatch = JLanguageTool.this.adjustRuleMatchPos(elem, sentence.startOffset, sentence.startColumn, sentence.startLine, sentence.text, this.annotatedText);
                                if (elem.getErrorLimitLang() != null) {
                                    ignoreRanges.add(new Range(sentence.startOffset, sentence.startOffset + sentence.text.length(), elem.getErrorLimitLang()));
                                }
                                ruleMatches.add(thisMatch);
                                if (this.listener == null) continue;
                                this.listener.matchFound(thisMatch);
                            }
                        }
                        break;
                    }
                    float errorsPerWord = (float)ruleMatches.size() / (float)wordCounter;
                    if (!(JLanguageTool.this.maxErrorsPerWordRate > 0.0f) || !(errorsPerWord > JLanguageTool.this.maxErrorsPerWordRate) || wordCounter <= 25) continue;
                    throw new ErrorRateTooHighException("Text checking was stopped due to too many errors (more than " + String.format("%.0f", Float.valueOf(JLanguageTool.this.maxErrorsPerWordRate * 100.0f)) + "% of words seem to have an error). Are you sure you have set the correct text language? Language set: " + JLanguageTool.this.language.getName() + ", text length: " + this.annotatedText.getPlainText().length());
                }
                catch (ErrorRateTooHighException e) {
                    throw e;
                }
                catch (StackOverflowError e) {
                    System.out.println("Could not check sentence due to StackOverflowError (language: " + JLanguageTool.this.language + "): <sentcontent>" + StringUtils.abbreviate((String)sentence.analyzed.toTextString(), (int)10000) + "</sentcontent>");
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not check sentence (language: " + JLanguageTool.this.language + "): <sentcontent>" + StringUtils.abbreviate((String)sentence.analyzed.toTextString(), (int)500) + "</sentcontent>", e);
                }
            }
            return new CheckResults(ruleMatches, ignoreRanges);
        }

        private LineColumnPosition findLineColumn(int offset) {
            if (this.sentences.isEmpty()) {
                return new LineColumnPosition(0, 0);
            }
            SentenceData sentence = this.findSentenceContaining(offset);
            String prefix = sentence.text.substring(0, offset - sentence.startOffset);
            return new LineColumnPosition(sentence.startLine + JLanguageTool.countLineBreaks(prefix), JLanguageTool.this.processColumnChange(sentence.startColumn, prefix));
        }

        private SentenceData findSentenceContaining(int offset) {
            int low = 0;
            int high = this.sentences.size() - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                SentenceData sentence = this.sentences.get(mid);
                if (sentence.startOffset < offset) {
                    low = mid + 1;
                    continue;
                }
                if (sentence.startOffset > offset) {
                    high = mid - 1;
                    continue;
                }
                return sentence;
            }
            return this.sentences.get(low - 1);
        }

        private class LineColumnPosition {
            int line;
            int column;

            private LineColumnPosition(int line, int column) {
                this.line = line;
                this.column = column;
            }
        }
    }

    static class SentenceData {
        final AnalyzedSentence analyzed;
        private final String text;
        private final int startOffset;
        private final int startLine;
        private final int startColumn;
        private final int wordCount;

        SentenceData(AnalyzedSentence analyzed, String text, int startOffset, int startLine, int startColumn) {
            this.analyzed = analyzed;
            this.text = text;
            this.startOffset = startOffset;
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.wordCount = analyzed.getTokensWithoutWhitespace().length;
        }
    }

    public static interface CheckCancelledCallback {
        public boolean checkCancelled();
    }

    static class CleanToken {
        private final String origToken;
        private final String cleanToken;

        CleanToken(String origToken, String cleanToken) {
            this.origToken = origToken;
            this.cleanToken = cleanToken;
        }
    }

    public static enum Level {
        DEFAULT,
        PICKY;

    }

    public static enum Mode {
        ALL,
        TEXTLEVEL_ONLY,
        ALL_BUT_TEXTLEVEL_ONLY;

    }

    public static enum ParagraphHandling {
        NORMAL,
        ONLYPARA,
        ONLYNONPARA;

    }
}

