/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.languagetool.Language;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;

public class LanguageDependentFilter
implements RuleMatchFilter {
    protected Language language;
    protected Set<String> enabledRules;
    protected Set<CategoryId> disabledCategories;

    public LanguageDependentFilter(Language lang, Set<String> enabledRules, Set<CategoryId> disabledRuleCategories) {
        this.language = lang;
        this.enabledRules = enabledRules;
        this.disabledCategories = disabledRuleCategories;
    }

    @Override
    public List<RuleMatch> filter(List<RuleMatch> ruleMatches) {
        if (this.language.getShortCode().equals("ca")) {
            CategoryId catID = new CategoryId("DIACRITICS_TRADITIONAL");
            if (this.enabledRules.contains("APOSTROF_TIPOGRAFIC") || this.disabledCategories.contains(catID)) {
                ArrayList<RuleMatch> newRuleMatches = new ArrayList<RuleMatch>();
                for (RuleMatch rm : ruleMatches) {
                    List<String> replacements = rm.getSuggestedReplacements();
                    ArrayList<String> newReplacements = new ArrayList<String>();
                    for (String s : replacements) {
                        if (this.enabledRules.contains("APOSTROF_TIPOGRAFIC") && s.length() > 1) {
                            s = s.replace("'", "\u2019");
                        }
                        if (this.disabledCategories.contains(catID) && s.matches(".*\\b([Dd]\u00f3na|[Vv]\u00e9nen|[Vv]\u00e9ns|[Ff]\u00f3ra)\\b.*")) continue;
                        newReplacements.add(s);
                    }
                    RuleMatch newMatch = new RuleMatch(rm, newReplacements);
                    newRuleMatches.add(newMatch);
                }
                return newRuleMatches;
            }
        }
        return ruleMatches;
    }
}

