/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.symspell.implementation;

import java.util.Arrays;
import org.languagetool.rules.spelling.symspell.implementation.SuggestionStage;

public class ChunkArray<T> {
    private static int chunkSize = 4096;
    private static int divShift = 12;
    public SuggestionStage.Node[][] values;
    public int count;

    ChunkArray(int initialCapacity) {
        int chunks = (initialCapacity + chunkSize - 1) / chunkSize;
        this.values = new SuggestionStage.Node[chunks][];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new SuggestionStage.Node[chunkSize];
        }
    }

    public int add(SuggestionStage.Node value) {
        if (this.count == this.capacity()) {
            SuggestionStage.Node[][] newValues = (SuggestionStage.Node[][])Arrays.copyOf(this.values, this.values.length + 1);
            newValues[this.values.length] = new SuggestionStage.Node[chunkSize];
            this.values = newValues;
        }
        this.values[this.row((int)this.count)][this.col((int)this.count)] = value;
        ++this.count;
        return this.count - 1;
    }

    public void clear() {
        this.count = 0;
    }

    public SuggestionStage.Node getValues(int index) {
        return this.values[this.row(index)][this.col(index)];
    }

    public void setValues(int index, SuggestionStage.Node value) {
        this.values[this.row((int)index)][this.col((int)index)] = value;
    }

    public void setValues(int index, SuggestionStage.Node value, SuggestionStage.Node[][] list) {
        list[this.row((int)index)][this.col((int)index)] = value;
    }

    private int row(int index) {
        return index >> divShift;
    }

    private int col(int index) {
        return index & chunkSize - 1;
    }

    private int capacity() {
        return this.values.length * chunkSize;
    }
}

