/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.server.BadRequestException;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.PathNotFoundException;
import org.languagetool.server.ServerMetricsCollector;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.server.UserDictEntry;
import org.languagetool.server.UserLimits;

class ApiV2 {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String TEXT_CONTENT_TYPE = "text/plain";
    private static final String ENCODING = "UTF-8";
    private final TextChecker textChecker;
    private final String allowOriginUrl;
    private final JsonFactory factory = new JsonFactory();

    ApiV2(TextChecker textChecker, String allowOriginUrl) {
        this.textChecker = textChecker;
        this.allowOriginUrl = allowOriginUrl;
    }

    void handleRequest(String path, HttpExchange httpExchange, Map<String, String> parameters, ErrorRequestLimiter errorRequestLimiter, String remoteAddress, HTTPServerConfig config) throws Exception {
        if (path.equals("languages")) {
            this.handleLanguagesRequest(httpExchange);
        } else if (path.equals("maxtextlength")) {
            this.handleMaxTextLengthRequest(httpExchange, config);
        } else if (path.equals("configinfo")) {
            this.handleGetConfigurationInfoRequest(httpExchange, parameters, config);
        } else if (path.equals("info")) {
            this.handleSoftwareInfoRequest(httpExchange);
        } else if (path.equals("check")) {
            this.handleCheckRequest(httpExchange, parameters, errorRequestLimiter, remoteAddress);
        } else if (path.equals("words")) {
            this.handleWordsRequest(httpExchange, parameters, config);
        } else if (path.equals("words/add")) {
            this.handleWordAddRequest(httpExchange, parameters, config);
        } else if (path.equals("words/delete")) {
            this.handleWordDeleteRequest(httpExchange, parameters, config);
        } else {
            throw new PathNotFoundException("Unsupported action: '" + path + "'. Please see " + "https://languagetool.org/http-api/swagger-ui/#/default");
        }
    }

    private void handleLanguagesRequest(HttpExchange httpExchange) throws IOException {
        String response = this.getLanguages();
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    private void handleMaxTextLengthRequest(HttpExchange httpExchange, HTTPServerConfig config) throws IOException {
        String response = Integer.toString(config.maxTextLength);
        ServerTools.setCommonHeaders(httpExchange, TEXT_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    private void handleGetConfigurationInfoRequest(HttpExchange httpExchange, Map<String, String> parameters, HTTPServerConfig config) throws IOException {
        if (JLanguageTool.isPremiumVersion()) {
            throw new BadRequestException("Not supported in premium mode");
        }
        if (parameters.get("language") == null) {
            throw new BadRequestException("'language' parameter missing");
        }
        Language lang = Languages.getLanguageForShortCode(parameters.get("language"));
        String response = this.getConfigurationInfo(lang, config);
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    private void handleSoftwareInfoRequest(HttpExchange httpExchange) throws IOException {
        String response = this.getSoftwareInfo();
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCheckRequest(HttpExchange httpExchange, Map<String, String> parameters, ErrorRequestLimiter errorRequestLimiter, String remoteAddress) throws Exception {
        AnnotatedText aText;
        if (parameters.containsKey("text") && parameters.containsKey("data")) {
            throw new BadRequestException("Set only 'text' or 'data' parameter, not both");
        }
        if (parameters.containsKey("text")) {
            aText = new AnnotatedTextBuilder().addText(parameters.get("text")).build();
        } else {
            JsonNode data;
            if (!parameters.containsKey("data")) throw new BadRequestException("Missing 'text' or 'data' parameter");
            ObjectMapper mapper = new ObjectMapper();
            try {
                data = mapper.readTree(parameters.get("data"));
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException("Could not parse JSON from 'data' parameter", e);
            }
            if (data.get("text") != null && data.get("annotation") != null) {
                throw new BadRequestException("'data' key in JSON requires either 'text' or 'annotation' key, not both");
            }
            if (data.get("text") != null) {
                aText = this.getAnnotatedTextFromString(data, data.get("text").asText());
            } else {
                if (data.get("annotation") == null) throw new BadRequestException("'data' key in JSON requires 'text' or 'annotation' key");
                aText = this.getAnnotatedTextFromJson(data);
            }
        }
        this.textChecker.checkText(aText, httpExchange, parameters, errorRequestLimiter, remoteAddress);
    }

    private void handleWordsRequest(HttpExchange httpExchange, Map<String, String> params, HTTPServerConfig config) throws Exception {
        this.ensureGetMethod(httpExchange, "/words");
        UserLimits limits = this.getUserLimits(params, config);
        DatabaseAccess db = DatabaseAccess.getInstance();
        int offset = params.get("offset") != null ? Integer.parseInt(params.get("offset")) : 0;
        int limit = params.get("limit") != null ? Integer.parseInt(params.get("limit")) : 10;
        List<UserDictEntry> words = db.getWords(limits.getPremiumUid(), offset, limit);
        this.writeListResponse("words", words, httpExchange);
    }

    private void handleWordAddRequest(HttpExchange httpExchange, Map<String, String> parameters, HTTPServerConfig config) throws Exception {
        this.ensurePostMethod(httpExchange, "/words/add");
        UserLimits limits = this.getUserLimits(parameters, config);
        DatabaseAccess db = DatabaseAccess.getInstance();
        boolean added = db.addWord(parameters.get("word"), limits.getPremiumUid());
        this.writeResponse("added", added, httpExchange);
    }

    private void handleWordDeleteRequest(HttpExchange httpExchange, Map<String, String> parameters, HTTPServerConfig config) throws Exception {
        this.ensurePostMethod(httpExchange, "/words/delete");
        UserLimits limits = this.getUserLimits(parameters, config);
        DatabaseAccess db = DatabaseAccess.getInstance();
        boolean deleted = db.deleteWord(parameters.get("word"), limits.getPremiumUid());
        this.writeResponse("deleted", deleted, httpExchange);
    }

    private void handleRuleExamplesRequest(HttpExchange httpExchange, Map<String, String> params) throws Exception {
        this.ensureGetMethod(httpExchange, "/rule/examples");
        if (params.get("lang") == null) {
            throw new BadRequestException("'lang' parameter missing");
        }
        if (params.get("ruleId") == null) {
            throw new BadRequestException("'ruleId' parameter missing");
        }
        Language lang = Languages.getLanguageForShortCode(params.get("lang"));
        JLanguageTool lt = new JLanguageTool(lang);
        if (this.textChecker.config.languageModelDir != null) {
            lt.activateLanguageModelRules(this.textChecker.config.languageModelDir);
        }
        List<Rule> rules = lt.getAllRules();
        ArrayList<Rule> foundRules = new ArrayList<Rule>();
        for (Rule rule : rules) {
            if (!rule.getId().equals(params.get("ruleId"))) continue;
            foundRules.add(rule);
        }
        if (foundRules.isEmpty()) {
            throw new PathNotFoundException("Rule '" + params.get("ruleId") + "' not found for language " + lang + " (LanguageTool version/date: " + "5.4" + "/" + JLanguageTool.BUILD_DATE + ", total rules of language: " + rules.size() + ")");
        }
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator(sw);){
            g.writeStartObject();
            g.writeArrayFieldStart("results");
            g.writeStartObject();
            g.writeStringField("warning", "*** This is not a public API - it may change anytime ***");
            g.writeEndObject();
            for (Rule foundRule : foundRules) {
                for (CorrectExample correctExample : foundRule.getCorrectExamples()) {
                    g.writeStartObject();
                    g.writeStringField("status", "correct");
                    g.writeStringField("sentence", correctExample.getExample());
                    g.writeEndObject();
                }
                for (IncorrectExample incorrectExample : foundRule.getIncorrectExamples()) {
                    g.writeStartObject();
                    g.writeStringField("status", "incorrect");
                    g.writeStringField("sentence", incorrectExample.getExample());
                    g.writeArrayFieldStart("corrections");
                    for (String s : incorrectExample.getCorrections()) {
                        g.writeString(s);
                    }
                    g.writeEndArray();
                    g.writeEndObject();
                }
            }
            g.writeEndArray();
            g.writeEndObject();
        }
        this.sendJson(httpExchange, sw);
    }

    private void ensureGetMethod(HttpExchange httpExchange, String url) {
        if (!httpExchange.getRequestMethod().equalsIgnoreCase("get")) {
            throw new BadRequestException(url + " needs to be called with GET");
        }
    }

    private void ensurePostMethod(HttpExchange httpExchange, String url) {
        if (!httpExchange.getRequestMethod().equalsIgnoreCase("post")) {
            throw new BadRequestException(url + " needs to be called with POST");
        }
    }

    @NotNull
    private UserLimits getUserLimits(Map<String, String> parameters, HTTPServerConfig config) {
        UserLimits limits = ServerTools.getUserLimits(parameters, config);
        if (limits.getPremiumUid() == null) {
            throw new BadRequestException("This end point needs a user id");
        }
        return limits;
    }

    private void writeResponse(String fieldName, boolean added, HttpExchange httpExchange) throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator(sw);){
            g.writeStartObject();
            g.writeBooleanField(fieldName, added);
            g.writeEndObject();
        }
        this.sendJson(httpExchange, sw);
    }

    private void writeListResponse(String fieldName, List<UserDictEntry> words, HttpExchange httpExchange) throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator(sw);){
            g.writeStartObject();
            g.writeArrayFieldStart(fieldName);
            for (UserDictEntry word : words) {
                g.writeString(word.getWord());
            }
            g.writeEndArray();
            g.writeEndObject();
        }
        this.sendJson(httpExchange, sw);
    }

    private void sendJson(HttpExchange httpExchange, StringWriter sw) throws IOException {
        String response = sw.toString();
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    private AnnotatedText getAnnotatedTextFromString(JsonNode data, String text) {
        AnnotatedTextBuilder textBuilder = new AnnotatedTextBuilder().addText(text);
        if (data.has("metaData")) {
            JsonNode metaData = data.get("metaData");
            Iterator<String> it = metaData.fieldNames();
            while (it.hasNext()) {
                String key = it.next();
                String val = metaData.get(key).asText();
                try {
                    AnnotatedText.MetaDataKey metaDataKey = AnnotatedText.MetaDataKey.valueOf(key);
                    textBuilder.addGlobalMetaData(metaDataKey, val);
                }
                catch (IllegalArgumentException e) {
                    textBuilder.addGlobalMetaData(key, val);
                }
            }
        }
        return textBuilder.build();
    }

    private AnnotatedText getAnnotatedTextFromJson(JsonNode data) {
        AnnotatedTextBuilder atb = new AnnotatedTextBuilder();
        for (JsonNode node : data.get("annotation")) {
            if (node.get("text") != null && node.get("markup") != null) {
                throw new BadRequestException("Only either 'text' or 'markup' are supported in an object in 'annotation' list, not both: " + node);
            }
            if (node.get("text") != null && node.get("interpretAs") != null) {
                throw new BadRequestException("'text' cannot be used with 'interpretAs' (only 'markup' can): " + node);
            }
            if (node.get("text") != null) {
                atb.addText(node.get("text").asText());
                continue;
            }
            if (node.get("markup") != null) {
                if (node.get("interpretAs") != null) {
                    atb.addMarkup(node.get("markup").asText(), node.get("interpretAs").asText());
                    continue;
                }
                atb.addMarkup(node.get("markup").asText());
                continue;
            }
            throw new BadRequestException("Only 'text' and 'markup' are supported in 'annotation' list: " + node);
        }
        return atb.build();
    }

    String getLanguages() throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator(sw);){
            g.writeStartArray();
            ArrayList<Language> languages = new ArrayList<Language>(Languages.get());
            languages.sort(Comparator.comparing(Language::getName));
            for (Language lang : languages) {
                g.writeStartObject();
                g.writeStringField("name", lang.getName());
                g.writeStringField("code", lang.getShortCode());
                g.writeStringField("longCode", lang.getShortCodeWithCountryAndVariant());
                g.writeEndObject();
            }
            g.writeEndArray();
        }
        return sw.toString();
    }

    String getSoftwareInfo() throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator(sw);){
            g.writeStartObject();
            g.writeObjectFieldStart("software");
            g.writeStringField("name", "LanguageTool");
            g.writeStringField("version", "5.4");
            g.writeStringField("buildDate", JLanguageTool.BUILD_DATE);
            g.writeStringField("commit", JLanguageTool.GIT_SHORT_ID);
            g.writeBooleanField("premium", JLanguageTool.isPremiumVersion());
            g.writeEndObject();
            g.writeEndObject();
        }
        return sw.toString();
    }

    String getConfigurationInfo(Language lang, HTTPServerConfig config) throws IOException {
        StringWriter sw = new StringWriter();
        JLanguageTool lt = new JLanguageTool(lang);
        if (this.textChecker.config.languageModelDir != null) {
            lt.activateLanguageModelRules(this.textChecker.config.languageModelDir);
        }
        if (this.textChecker.config.word2vecModelDir != null) {
            lt.activateWord2VecModelRules(this.textChecker.config.word2vecModelDir);
        }
        List<Rule> rules = lt.getAllRules();
        try (JsonGenerator g = this.factory.createGenerator(sw);){
            g.writeStartObject();
            g.writeObjectFieldStart("software");
            g.writeStringField("name", "LanguageTool");
            g.writeStringField("version", "5.4");
            g.writeStringField("buildDate", JLanguageTool.BUILD_DATE);
            g.writeBooleanField("premium", JLanguageTool.isPremiumVersion());
            g.writeEndObject();
            g.writeObjectFieldStart("parameter");
            g.writeNumberField("maxTextLength", config.maxTextLength);
            g.writeEndObject();
            g.writeArrayFieldStart("rules");
            for (Rule rule : rules) {
                g.writeStartObject();
                g.writeStringField("ruleId", rule.getId());
                g.writeStringField("description", rule.getDescription());
                if (rule.isDictionaryBasedSpellingRule()) {
                    g.writeStringField("isDictionaryBasedSpellingRule", "yes");
                }
                if (rule.isDefaultOff()) {
                    g.writeStringField("isDefaultOff", "yes");
                }
                if (rule.isOfficeDefaultOff()) {
                    g.writeStringField("isOfficeDefaultOff", "yes");
                }
                if (rule.isOfficeDefaultOn()) {
                    g.writeStringField("isOfficeDefaultOn", "yes");
                }
                if (rule.hasConfigurableValue()) {
                    g.writeStringField("hasConfigurableValue", "yes");
                    g.writeStringField("configureText", rule.getConfigureText());
                    g.writeStringField("maxConfigurableValue", Integer.toString(rule.getMaxConfigurableValue()));
                    g.writeStringField("minConfigurableValue", Integer.toString(rule.getMinConfigurableValue()));
                    g.writeStringField("defaultValue", Integer.toString(rule.getDefaultValue()));
                }
                g.writeStringField("categoryId", rule.getCategory().getId().toString());
                g.writeStringField("categoryName", rule.getCategory().getName());
                g.writeStringField("locQualityIssueType", rule.getLocQualityIssueType().toString());
                if (rule instanceof TextLevelRule) {
                    g.writeStringField("isTextLevelRule", "yes");
                    g.writeStringField("minToCheckParagraph", Integer.toString(((TextLevelRule)rule).minToCheckParagraph()));
                }
                g.writeEndObject();
            }
            g.writeEndArray();
            g.writeEndObject();
        }
        return sw.toString();
    }
}

