/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.Array;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.EngineConnection40;
import org.apache.derby.iapi.jdbc.FailedProperties40;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedConnection30;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public class EmbedConnection40
extends EmbedConnection30
implements EngineConnection40 {
    public EmbedConnection40(EmbedConnection embedConnection) {
        super(embedConnection);
    }

    public EmbedConnection40(InternalDriver internalDriver, String string, Properties properties) throws SQLException {
        super(internalDriver, string, properties);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw Util.generateCsSQLException("XJ081.S", new Integer(n), "timeout", "java.sql.Connection.isValid");
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        Properties properties = FailedProperties40.makeProperties(string, string2);
        try {
            this.checkIfClosed();
        }
        catch (SQLException sQLException) {
            FailedProperties40 failedProperties40 = new FailedProperties40(properties);
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), failedProperties40.getProperties());
        }
        if (string == null && string2 == null) {
            return;
        }
        this.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        FailedProperties40 failedProperties40 = new FailedProperties40(properties);
        try {
            this.checkIfClosed();
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), failedProperties40.getProperties());
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        StandardException standardException = StandardException.newException("XCY02.S", (Object)failedProperties40.getFirstKey(), (Object)failedProperties40.getFirstValue());
        throw new SQLClientInfoException(standardException.getMessage(), standardException.getSQLState(), standardException.getErrorCode(), failedProperties40.getProperties());
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkIfClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfClosed();
        return new Properties();
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        return super.getTypeMap();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkIfClosed();
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkIfClosed();
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw this.newSQLException("XJ128.S", clazz);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (executor == null) {
            throw this.newSQLException("XCZ02.S", "executor", "null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SQLPermission("callAbort"));
        }
        this.beginAborting();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EmbedConnection40.this.rollback();
                    EmbedConnection40.this.close(EmbedConnection.exceptionClose);
                }
                catch (SQLException sQLException) {
                    Util.logSQLException(sQLException);
                }
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw Util.notImplemented();
    }
}

