/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerNode;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.table.EnhancedTableCellRenderer;

final class FieldTableCellRenderer
extends EnhancedTableCellRenderer {
    private final JLabel label1;
    private final JLabel label2;

    public FieldTableCellRenderer() {
        this.setHorizontalAlignment(11);
        this.label1 = new JLabel("");
        this.label2 = new JLabel("");
        this.setLayout(null);
        this.add(this.label1);
        this.add(this.label2);
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
    }

    public Dimension getPreferredSize() {
        Dimension d1 = this.label1.getPreferredSize();
        Dimension d2 = this.label2.getPreferredSize();
        d1.width += d2.width;
        d1.height = Math.max(d1.height, d2.height);
        Insets i = this.getInsets();
        d1.width += i.left + i.right;
        d1.height += i.top + i.bottom;
        return d1;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        Insets i = this.getInsets();
        int w = this.getWidth() - i.left - i.right;
        int h = this.getHeight() - i.top - i.bottom;
        Dimension d1 = this.label1.getPreferredSize();
        Dimension d2 = this.label2.getPreferredSize();
        if (d1.width >= w) {
            this.label1.setBounds(i.left, i.top, w, h);
            this.label2.setBounds(0, 0, 0, 0);
        } else if (d1.width + d2.width <= w) {
            this.label1.setBounds(this.getWidth() - i.right - d1.width - d2.width, i.top, d1.width, h);
            this.label2.setBounds(this.getWidth() - i.right - d2.width, i.top, d2.width, h);
        } else {
            this.label1.setBounds(i.left, i.top, d1.width, h);
            this.label2.setBounds(i.left + d1.width, i.top, w - d1.width, h);
        }
    }

    public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return new FieldTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    protected void setRowForeground(Color c) {
        super.setRowForeground(c);
        this.label1.setForeground(c);
        this.label2.setForeground(UIUtils.getDisabledForeground((Color)c));
    }

    protected void setValue(JTable table, Object value, int row, int column) {
        if (value instanceof HeapWalkerNode) {
            HeapWalkerNode node = (HeapWalkerNode)((Object)value);
            this.label1.setText(node.getValue());
            String details = node.getDetails();
            this.label2.setText(details == null || details.isEmpty() ? "" : "  " + details);
        } else {
            this.label1.setText("");
            this.label2.setText("");
        }
    }
}

