<!--
title: Serverless Framework Documentation
menuText: Docs
layout: Doc
menuItems:
  - {menuText: "Get Started", path: /framework/docs/getting-started/}
  - {menuText: "User Guides", path: /framework/docs/guides/}
  - {menuText: "- Insights", path: /framework/docs/guides/insights/}
  - {menuText: "- Notifications", path: /framework/docs/guides/notifications/}
  - {menuText: "- Output Variables", path: /framework/docs/guides/output-variables/}
  - {menuText: "- Secrets", path: /framework/docs/guides/secrets/}
  - {menuText: "- Safeguards", path: /framework/docs/guides/safeguards/}
  - {menuText: "- Access Roles", path: /framework/docs/guides/access-roles/}
  - {menuText: "- Profiles", path: /framework/docs/guides/profiles/}
  - {menuText: "- Pipelines", path: /framework/docs/guides/pipelines/}
  - {menuText: "Provider CLI References", path: /framework/docs/providers}
  - {menuText: "- AWS", path: /framework/docs/providers/aws/}
  - {menuText: "- Azure", path: /framework/docs/providers/azure/}
  - {menuText: "- fn", path: /framework/docs/providers/fn/}
  - {menuText: "- Google", path: /framework/docs/providers/google/}
  - {menuText: "- OpenWhisk", path: /framework/docs/providers/openwhisk/}
  - {menuText: "- Kubeless" , path: /framework/docs/providers/kubeless/}
  - {menuText: "- Knative" , path: /framework/docs/providers/knative/}
  - {menuText: "- Spotinst" , path: /framework/docs/providers/spotinst/}
  - {menuText: "- Cloudflare" , path: /framework/docs/providers/cloudflare/}
  - {menuText: "- Alibaba Cloud" , path: /framework/docs/providers/aliyun/}
  - {menuText: "- Tencent Cloud" , path: /framework/docs/providers/tencent/}
  - {menuText: "Examples", path: https://serverless.com/examples/}
  - {menuText: "Tutorials", path: https://serverless.com/blog/category/guides-and-tutorials/}
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/)

<!-- DOCS-SITE-LINK:END -->

# Serverless Framework Documentation

Develop, deploy, troubleshoot and secure your serverless applications with radically less overhead and cost by using the Serverless Framework. The Serverless Framework consists of an open source CLI and a hosted dashboard. Together, they provide you with full serverless application lifecycle management.

**Are you new to serverless application development?**

Sign up for our [hosted dashboard](https://app.serverless.com) (it’s free) and we’ll help deploy your first serverless app in minutes.

If you prefer to start on the CLI, use our [get started](https://serverless.com/framework/docs/getting-started/) guide.

**If you are an experienced user of the Serverless Framework**

Our [Pro dashboard](https://serverless.com/pro/) allows you to import existing projects. Track performance, troubleshoot, configure CI/CD and deployment policies, and get end-to-end serverless application lifecycle management.
[Get started](https://app.serverless.com) for free.

Have questions? Visit our [Forum](https://forum.serverless.com/).

For inspiration, check out [example code](https://serverless.com/examples/), [guides](https://serverless.com/blog/category/guides-and-tutorials/) and [use cases](https://serverless.com/learn/use-cases/).
